@chcp 65001>nul& powershell -NoProfile -ExecutionPolicy Unrestricted "$s=[scriptblock]::create((gc \"%~f0\"|?{$_.readcount -gt 1})-join\"`n\");&$s" %*&goto:eof

$eda = "C:\ibi\srv82\wfs\bin\edastart";
$result_eda = cmd /c $eda -showagents;

$flg1 = 0; $flg2 = 0; $flg3 = 0;
$stnum = 1; $pinum = 1; $tinum = 1;
$header = "`"DateTime`""; $body = "";

foreach ($line in $result_eda) {
  $arrline = $line.Split(" ");
  if($arrline.Length -gt 4) {
    $datetime = $arrline[0].Substring(6, 4) + "/" + `
                $arrline[0].Substring(1, 5) + " " + `
                $arrline[1];
    $values = "";
    for($i = 0; $i -lt $arrline.Length; $i++) {
      if($i -ge 5) {
        $values += " " + $arrline[$i];
      }
    }
    $arrval = $values.Split(":");
    $name = $arrval[0].Trim();
    $value = "";
    if($arrval[1].Length -ne 0) {
      for($i = 1; $i -lt $arrval.Length; $i++) {
        if($i -eq 1) {
          $value += $arrval[$i].Trim();
        } else {
          $value += ":" + $arrval[$i].Trim();
        }
      }
    }
    if(($name -eq "Tscomid") -And ($flg1 -eq 0)) {
      $flg1 = 1;
      $body += "`"" + $datetime + "`"";
    } elseif(($name -eq "Tscomid") -And ($flg1 -eq 1)) {
      $flg2 = 1;
    }
    if(($name -eq "Tscomid") -And ($flg2 -eq 1)) {
      $body += "`r`n" + "`"" + $datetime + "`"";
      $flg3 = 1;
    }
    if(($flg1 -eq 1) -And ($flg2 -eq 0)) {
      if($name -eq "Status") {
        $name = $name + $stnum;
        $stnum++;
      }
      if($name -eq "Polling Interval") {
        $name = $name + $pinum;
        $pinum++;
      }
      if($name -eq "Timeout Interval") {
        $name = $name + $tinum;
        $tinum++;
      }
      $header += ",`"" + $name + "`"";
    }
    if(($value -eq "---") -Or ($value -eq "--")) { $value = ""; }
    if($flg1 -eq 1) { $body += ",`"" + $value + "`""; }
  }
}
$csvdata = $header + "`r`n" + $body;
$csvobj = convertfrom-csv -inputobject $csvdata;


### コマンド実行結果の整形後に期待する動作を追加 ###

# 結果をテンポラリファイルへ出力
$TmpFile = New-TemporaryFile;
$header >$TmpFile; # ヘッダ書き込み
$body >>$TmpFile; # ボディ追記

$TmpFile = New-TemporaryFile;
$csvdata >$TmpFile; # すべて書き込み

# 条件に一致するエージェント情報をイベントログへ書き込み
$dbmsio = 1000000;
$csvobj | Where-Object { $_."Service" -eq "DEFAULT" -and `
                         $_."state" -ne "idle" -and `
                         [int]$_."DBMS I/O" -gt $dbmsio `
                       } | ForEach-Object{
  $msg = "Tscomid: " + $_."Tscomid" + "`r`n" + `
         "Service: " + $_."Service" + "`r`n" + `
         "state: " + $_."state" + "`r`n" + `
         "DBMS I/O: " + $_."DBMS I/O" + "`r`n" + `
         "Process ID: " + $_."Process ID" + "`r`n";
  Write-EventLog -LogName Application -Source WebFOCUS -EntryType Information -EventId 1 -Message $msg;

  # 条件に一致するエージェントを終了するコマンドを発行
  $result_cmd = cmd /c $eda -kill $_."Tscomid"
}
