﻿(function() {

	// All extension callback functions are passed a standard 'renderConfig' argument:
	// すべての拡張機能のコールバック関数は「renderConfig」へ引数を渡します。


	// Properties that are always available:
	// 常に有効なプロパティ

	//   moonbeamInstance: the chart instance currently being rendered
	//   moonbeamInstance: 現在レンダリングしているインスタンス

	//   data: the data set being rendered
	//   data: レンダリングされるデータセット

	//   properties: the block of your extension's properties, as they've been set by the user
	//   properties: ユーザーが設定した拡張機能のプロパティをブロック

	//   modules: the 'modules' object from your extension's config, along with additional API methods
	//   modules: 拡張機能設定の「modules」オブジェクトの追加APIメソッド


	// Properties available during render callback:
	// レンダーコールバックに利用できるプロパティ

	//   width: width of the container your extension renders into, in px
	//   width: 拡張機能がレンダリングするコンテナの幅（px）


	//   height: height of the container your extension renders into, in px
	//   height: 拡張機能がレンダリングするコンテナの高さ（px）

	//   containerIDPrefix:  the ID of the DOM container your extension renders into.  Prepend this to *all* IDs your extension generates, to ensure multiple copies of your extension work on one page.
	//   containerIDPrefix:  拡張機能がレンダリングするDOMコンテナのID。  拡張機能が生成する「*all*」より前へ指定することで、複数のコピーが1ページで動作します

	//   container: DOM node for your extension to render into;
	//   container: 拡張機能をレンダリングするDOMノード

	//   rootContainer: DOM node containing the specific chart engine instance being rendered.
	//   rootContainer: レンダリングする特定のチャートエンジンのインスタンスが含まれるDOMノード


	// Optional: if defined, is called exactly *once* during chart engine initialization
	// Optional: 定義している場合は、チャートエンジンの初期化中に「*once*」が呼ばれます

	// Arguments:
	// 引数:

	//  - successCallback: a function that you must call when your extension is fully
	//  - successCallback: 拡張機能が正常に動作した場合に呼び出す関数

	//     initialized - pass in true if init is successful, false otherwise.
	//     initialized - 初期化が成功した場合は「true」、その他は「false」を渡す

	// - initConfig: the standard callback argument object (moonbeamInstance, data, properties, etc)
	// - initConfig: 標準コールバックの引数オブジェクト（moonbeamInstance, data, properties, など）

	function initCallback(successCallback, initConfig) {
		successCallback(true);
	}

	// Optional: if defined, is called once before each draw that does not include any data
	// 定義している場合は、データが含まれない描画処理の前に一度だけ呼び出される

	// Arguments:
	// 引数:

	//  - preRenderConfig: the standard callback argument object (moonbeamInstance, data, properties, etc)
	//  - preRenderConfig: 標準コールバックの引数オブジェクト (moonbeamInstance, data, properties, など)

	function noDataPreRenderCallback(preRenderConfig) {
		var chart = preRenderConfig.moonbeamInstance;
		chart.legend.visible = false;
		chart.dataArrayMap = undefined;
		chart.dataSelection.enabled = false;
		preRenderConfig.properties.dataFormat = '%Y%m%d';
		preRenderConfig.properties.xAxisFormat = '%Y-%m';
	}

	// Optional: if defined, is called whenever this extension must be drawn but doesn't yet have any data.
	// Optional: 定義している場合は、拡張機能が描画する必要があるが、データを持っていない場合に呼び出す

	// Use this to define the extensions' initial 'grey state' appearance.
	// この定義を使用して、拡張機能の初期時に'grey state'の外観を表示する

	// Arguments:
	// 引数:

	//  - renderConfig: the standard callback argument object (moonbeamInstance, data, properties, etc)
	//  - renderConfig: 標準コールバックの引数オブジェクト (moonbeamInstance, data, properties, など)

	function noDataRenderCallback(renderConfig) {
		var grey = renderConfig.baseColor;
		renderConfig.data = [
					{ "name": "AAPL", "date": "20130513", "value": 64.96286 },
					{ "name": "AAPL", "date": "20130514", "value": 63.408573 },
					{ "name": "AAPL", "date": "20130515", "value": 61.264286 },
					{ "name": "AAPL", "date": "20130516", "value": 62.082859 },
					{ "name": "AAPL", "date": "20130517", "value": 61.894287 },
					{ "name": "AAPL", "date": "20130520", "value": 63.275715 },
					{ "name": "AAPL", "date": "20130521", "value": 62.808571 },
					{ "name": "AAPL", "date": "20130522", "value": 63.049999 },
					{ "name": "AAPL", "date": "20130523", "value": 63.162857 },
					{ "name": "AAPL", "date": "20130524", "value": 63.592857 },
					{ "name": "AAPL", "date": "20130528", "value": 63.062859 },
					{ "name": "AAPL", "date": "20130529", "value": 63.564285 },
					{ "name": "AAPL", "date": "20130530", "value": 64.511429 },
					{ "name": "AAPL", "date": "20130531", "value": 64.247147 },
					{ "name": "AAPL", "date": "20130603", "value": 64.388573 },
					{ "name": "AAPL", "date": "20130604", "value": 64.187141 },
					{ "name": "AAPL", "date": "20130605", "value": 63.587143 },
					{ "name": "AAPL", "date": "20130606", "value": 62.637142 },
					{ "name": "AAPL", "date": "20130607", "value": 63.115715 },
					{ "name": "AAPL", "date": "20130610", "value": 62.69857 },
					{ "name": "AAPL", "date": "20130611", "value": 62.514286 },
					{ "name": "AAPL", "date": "20130612", "value": 61.741428 },
					{ "name": "AAPL", "date": "20130613", "value": 62.279999 },
					{ "name": "AAPL", "date": "20130614", "value": 61.435715 },
					{ "name": "AAPL", "date": "20130617", "value": 61.714287 },
					{ "name": "AAPL", "date": "20130618", "value": 61.681427 },
					{ "name": "AAPL", "date": "20130619", "value": 60.42857 },
					{ "name": "AAPL", "date": "20130620", "value": 59.548573 },
					{ "name": "AAPL", "date": "20130621", "value": 59.07143 },
					{ "name": "AAPL", "date": "20130624", "value": 57.505714 },
					{ "name": "AAPL", "date": "20130625", "value": 57.51857 },
					{ "name": "AAPL", "date": "20130626", "value": 56.867142 },
					{ "name": "AAPL", "date": "20130627", "value": 56.254284 },
					{ "name": "AAPL", "date": "20130628", "value": 56.647144 },
					{ "name": "AAPL", "date": "20130701", "value": 58.459999 },
					{ "name": "AAPL", "date": "20130702", "value": 59.784286 },
					{ "name": "AAPL", "date": "20130703", "value": 60.114285 },
					{ "name": "AAPL", "date": "20130705", "value": 59.631428 },
					{ "name": "AAPL", "date": "20130708", "value": 59.292858 },
					{ "name": "AAPL", "date": "20130709", "value": 60.335712 },
					{ "name": "AAPL", "date": "20130710", "value": 60.104286 },
					{ "name": "AAPL", "date": "20130711", "value": 61.041428 },
					{ "name": "AAPL", "date": "20130712", "value": 60.93 },
					{ "name": "AAPL", "date": "20130715", "value": 61.062859 },
					{ "name": "AAPL", "date": "20130716", "value": 61.457142 },
					{ "name": "AAPL", "date": "20130717", "value": 61.472858 },
					{ "name": "AAPL", "date": "20130718", "value": 61.68 },
					{ "name": "AAPL", "date": "20130719", "value": 60.707142 },
					{ "name": "AAPL", "date": "20130722", "value": 60.901428 },
					{ "name": "AAPL", "date": "20130723", "value": 59.855713 },
					{ "name": "AAPL", "date": "20130724", "value": 62.93 },
					{ "name": "AAPL", "date": "20130725", "value": 62.642857 },
					{ "name": "AAPL", "date": "20130726", "value": 62.998573 },
					{ "name": "AAPL", "date": "20130729", "value": 63.970001 },
					{ "name": "AAPL", "date": "20130730", "value": 64.760002 },
					{ "name": "AAPL", "date": "20130731", "value": 64.647141 },
					{ "name": "AAPL", "date": "20130801", "value": 65.239998 },
					{ "name": "AAPL", "date": "20130802", "value": 66.077141 },
					{ "name": "AAPL", "date": "20130805", "value": 67.064285 },
					{ "name": "AAPL", "date": "20130806", "value": 66.464287 },
					{ "name": "AAPL", "date": "20130807", "value": 66.425713 },
					{ "name": "AAPL", "date": "20130808", "value": 65.858574 },
					{ "name": "AAPL", "date": "20130809", "value": 64.921425 },
					{ "name": "AAPL", "date": "20130812", "value": 66.765717 },
					{ "name": "AAPL", "date": "20130813", "value": 69.938568 },
					{ "name": "AAPL", "date": "20130814", "value": 71.214287 },
					{ "name": "AAPL", "date": "20130815", "value": 71.129997 },
					{ "name": "AAPL", "date": "20130816", "value": 71.761429 },
					{ "name": "AAPL", "date": "20130819", "value": 72.534286 },
					{ "name": "AAPL", "date": "20130820", "value": 71.581429 },
					{ "name": "AAPL", "date": "20130821", "value": 71.765717 },
					{ "name": "AAPL", "date": "20130822", "value": 71.851425 },
					{ "name": "AAPL", "date": "20130823", "value": 71.574287 },
					{ "name": "AAPL", "date": "20130826", "value": 71.852859 },
					{ "name": "AAPL", "date": "20130827", "value": 69.798569 },
					{ "name": "AAPL", "date": "20130828", "value": 70.128571 },
					{ "name": "AAPL", "date": "20130829", "value": 70.242859 },
					{ "name": "AAPL", "date": "20130830", "value": 69.602859 },
					{ "name": "AAPL", "date": "20130903", "value": 69.797142 },
					{ "name": "AAPL", "date": "20130904", "value": 71.241432 },
					{ "name": "AAPL", "date": "20130905", "value": 70.752853 },
					{ "name": "AAPL", "date": "20130906", "value": 71.174286 },
					{ "name": "AAPL", "date": "20130909", "value": 72.309998 },
					{ "name": "AAPL", "date": "20130910", "value": 70.662857 },
					{ "name": "AAPL", "date": "20130911", "value": 66.815712 },
					{ "name": "AAPL", "date": "20130912", "value": 67.527145 },
					{ "name": "AAPL", "date": "20130913", "value": 66.414284 },
					{ "name": "AAPL", "date": "20130916", "value": 64.302856 },
					{ "name": "AAPL", "date": "20130917", "value": 65.045715 },
					{ "name": "AAPL", "date": "20130918", "value": 66.382858 },
					{ "name": "AAPL", "date": "20130919", "value": 67.471428 },
					{ "name": "AAPL", "date": "20130920", "value": 66.772858 },
					{ "name": "AAPL", "date": "20130923", "value": 70.091431 },
					{ "name": "AAPL", "date": "20130924", "value": 69.871429 },
					{ "name": "AAPL", "date": "20130925", "value": 68.790001 },
					{ "name": "AAPL", "date": "20130926", "value": 69.459999 },
					{ "name": "AAPL", "date": "20130927", "value": 68.964287 },
					{ "name": "AAPL", "date": "20130930", "value": 68.10714 },
					{ "name": "AAPL", "date": "20131001", "value": 69.708572 },
					{ "name": "AAPL", "date": "20131002", "value": 69.937141 },
					{ "name": "AAPL", "date": "20131003", "value": 69.058571 },
					{ "name": "AAPL", "date": "20131004", "value": 69.004288 },
					{ "name": "AAPL", "date": "20131007", "value": 69.678574 },
					{ "name": "AAPL", "date": "20131008", "value": 68.705711 },
					{ "name": "AAPL", "date": "20131009", "value": 69.512856 },
					{ "name": "AAPL", "date": "20131010", "value": 69.94857 },
					{ "name": "AAPL", "date": "20131011", "value": 70.401428 },
					{ "name": "AAPL", "date": "20131014", "value": 70.862854 },
					{ "name": "AAPL", "date": "20131015", "value": 71.239998 },
					{ "name": "AAPL", "date": "20131016", "value": 71.587143 },
					{ "name": "AAPL", "date": "20131017", "value": 72.071426 },
					{ "name": "AAPL", "date": "20131018", "value": 72.69857 },
					{ "name": "AAPL", "date": "20131021", "value": 74.480003 },
					{ "name": "AAPL", "date": "20131022", "value": 74.267143 },
					{ "name": "AAPL", "date": "20131023", "value": 74.994286 },
					{ "name": "AAPL", "date": "20131024", "value": 75.987144 },
					{ "name": "AAPL", "date": "20131025", "value": 75.137146 },
					{ "name": "AAPL", "date": "20131028", "value": 75.697144 },
					{ "name": "AAPL", "date": "20131029", "value": 73.811432 },
					{ "name": "AAPL", "date": "20131030", "value": 74.985718 },
					{ "name": "AAPL", "date": "20131031", "value": 74.671425 },
					{ "name": "AAPL", "date": "20131101", "value": 74.290001 },
					{ "name": "AAPL", "date": "20131104", "value": 75.25 },
					{ "name": "AAPL", "date": "20131105", "value": 75.064285 },
					{ "name": "AAPL", "date": "20131106", "value": 74.417145 },
					{ "name": "AAPL", "date": "20131107", "value": 73.21286 },
					{ "name": "AAPL", "date": "20131108", "value": 74.365715 },
					{ "name": "AAPL", "date": "20131111", "value": 74.150002 },
					{ "name": "AAPL", "date": "20131112", "value": 74.28714 },
					{ "name": "AAPL", "date": "20131113", "value": 74.375717 },
					{ "name": "AAPL", "date": "20131114", "value": 75.451431 },
					{ "name": "AAPL", "date": "20131115", "value": 74.998573 },
					{ "name": "AAPL", "date": "20131118", "value": 74.089996 },
					{ "name": "AAPL", "date": "20131119", "value": 74.221428 },
					{ "name": "AAPL", "date": "20131120", "value": 73.571426 },
					{ "name": "AAPL", "date": "20131121", "value": 74.44857 },
					{ "name": "AAPL", "date": "20131122", "value": 74.257141 },
					{ "name": "AAPL", "date": "20131125", "value": 74.82 },
					{ "name": "AAPL", "date": "20131126", "value": 76.199997 },
					{ "name": "AAPL", "date": "20131127", "value": 77.994286 },
					{ "name": "AAPL", "date": "20131129", "value": 79.438568 },
					{ "name": "AAPL", "date": "20131202", "value": 78.747147 },
					{ "name": "AAPL", "date": "20131203", "value": 80.902855 },
					{ "name": "AAPL", "date": "20131204", "value": 80.714287 },
					{ "name": "AAPL", "date": "20131205", "value": 81.128571 },
					{ "name": "AAPL", "date": "20131206", "value": 80.002853 },
					{ "name": "AAPL", "date": "20131209", "value": 80.918571 },
					{ "name": "AAPL", "date": "20131210", "value": 80.792854 },
					{ "name": "AAPL", "date": "20131211", "value": 80.194283 },
					{ "name": "AAPL", "date": "20131212", "value": 80.077141 },
					{ "name": "AAPL", "date": "20131213", "value": 79.204285 },
					{ "name": "AAPL", "date": "20131216", "value": 79.64286 },
					{ "name": "AAPL", "date": "20131217", "value": 79.284286 },
					{ "name": "AAPL", "date": "20131218", "value": 78.681427 },
					{ "name": "AAPL", "date": "20131219", "value": 77.779999 },
					{ "name": "AAPL", "date": "20131220", "value": 78.431427 },
					{ "name": "AAPL", "date": "20131223", "value": 81.441429 },
					{ "name": "AAPL", "date": "20131224", "value": 81.095711 },
					{ "name": "AAPL", "date": "20131226", "value": 80.557144 },
					{ "name": "AAPL", "date": "20131227", "value": 80.012856 },
					{ "name": "AAPL", "date": "20131230", "value": 79.21714 },
					{ "name": "AAPL", "date": "20131231", "value": 80.145714 },
					{ "name": "AAPL", "date": "20140102", "value": 79.01857 },
					{ "name": "AAPL", "date": "20140103", "value": 77.28286 },
					{ "name": "AAPL", "date": "20140106", "value": 77.704285 },
					{ "name": "AAPL", "date": "20140107", "value": 77.148575 },
					{ "name": "AAPL", "date": "20140108", "value": 77.637146 },
					{ "name": "AAPL", "date": "20140109", "value": 76.645714 },
					{ "name": "AAPL", "date": "20140110", "value": 76.134285 },
					{ "name": "AAPL", "date": "20140113", "value": 76.53286 },
					{ "name": "AAPL", "date": "20140114", "value": 78.055717 },
					{ "name": "AAPL", "date": "20140115", "value": 79.622856 },
					{ "name": "AAPL", "date": "20140116", "value": 79.178574 },
					{ "name": "AAPL", "date": "20140117", "value": 77.238571 },
					{ "name": "AAPL", "date": "20140121", "value": 78.438568 },
					{ "name": "AAPL", "date": "20140122", "value": 78.78714 },
					{ "name": "AAPL", "date": "20140123", "value": 79.454285 },
					{ "name": "AAPL", "date": "20140124", "value": 78.010002 },
					{ "name": "AAPL", "date": "20140127", "value": 78.64286 },
					{ "name": "AAPL", "date": "20140128", "value": 72.35714 },
					{ "name": "AAPL", "date": "20140129", "value": 71.535713 },
					{ "name": "AAPL", "date": "20140130", "value": 71.397141 },
					{ "name": "AAPL", "date": "20140131", "value": 71.514282 },
					{ "name": "AAPL", "date": "20140203", "value": 71.647141 },
					{ "name": "AAPL", "date": "20140204", "value": 72.684288 },
					{ "name": "AAPL", "date": "20140205", "value": 73.227142 },
					{ "name": "AAPL", "date": "20140206", "value": 73.215714 },
					{ "name": "AAPL", "date": "20140207", "value": 74.239998 },
					{ "name": "AAPL", "date": "20140210", "value": 75.57 },
					{ "name": "AAPL", "date": "20140211", "value": 76.565712 },
					{ "name": "AAPL", "date": "20140212", "value": 76.559998 },
					{ "name": "AAPL", "date": "20140213", "value": 77.775711 },
					{ "name": "AAPL", "date": "20140214", "value": 77.71286 },
					{ "name": "AAPL", "date": "20140218", "value": 77.998573 },
					{ "name": "AAPL", "date": "20140219", "value": 76.767143 },
					{ "name": "AAPL", "date": "20140220", "value": 75.878571 },
					{ "name": "AAPL", "date": "20140221", "value": 75.035713 },
					{ "name": "AAPL", "date": "20140224", "value": 75.364288 },
					{ "name": "AAPL", "date": "20140225", "value": 74.580002 },
					{ "name": "AAPL", "date": "20140226", "value": 73.907143 },
					{ "name": "AAPL", "date": "20140227", "value": 75.381432 },
					{ "name": "AAPL", "date": "20140228", "value": 75.177139 },
					{ "name": "AAPL", "date": "20140303", "value": 75.394287 },
					{ "name": "AAPL", "date": "20140304", "value": 75.891426 },
					{ "name": "AAPL", "date": "20140305", "value": 76.05143 },
					{ "name": "AAPL", "date": "20140306", "value": 75.821426 },
					{ "name": "AAPL", "date": "20140307", "value": 75.777145 },
					{ "name": "AAPL", "date": "20140310", "value": 75.845711 },
					{ "name": "AAPL", "date": "20140311", "value": 76.584282 },
					{ "name": "AAPL", "date": "20140312", "value": 76.658569 },
					{ "name": "AAPL", "date": "20140313", "value": 75.807144 },
					{ "name": "AAPL", "date": "20140314", "value": 74.955711 },
					{ "name": "AAPL", "date": "20140317", "value": 75.248573 },
					{ "name": "AAPL", "date": "20140318", "value": 75.914284 },
					{ "name": "AAPL", "date": "20140319", "value": 75.894287 },
					{ "name": "AAPL", "date": "20140320", "value": 75.528572 },
					{ "name": "AAPL", "date": "20140321", "value": 76.124283 },
					{ "name": "AAPL", "date": "20140324", "value": 77.027145 },
					{ "name": "AAPL", "date": "20140325", "value": 77.855713 },
					{ "name": "AAPL", "date": "20140326", "value": 77.111427 },
					{ "name": "AAPL", "date": "20140327", "value": 76.779999 },
					{ "name": "AAPL", "date": "20140328", "value": 76.694283 },
					{ "name": "AAPL", "date": "20140331", "value": 76.677139 },
					{ "name": "AAPL", "date": "20140401", "value": 77.378571 },
					{ "name": "AAPL", "date": "20140402", "value": 77.507141 },
					{ "name": "AAPL", "date": "20140403", "value": 76.970001 },
					{ "name": "AAPL", "date": "20140404", "value": 75.974289 },
					{ "name": "AAPL", "date": "20140407", "value": 74.781425 },
					{ "name": "AAPL", "date": "20140408", "value": 74.777145 },
					{ "name": "AAPL", "date": "20140409", "value": 75.760002 },
					{ "name": "AAPL", "date": "20140410", "value": 74.78286 },
					{ "name": "AAPL", "date": "20140411", "value": 74.230003 },
					{ "name": "AAPL", "date": "20140414", "value": 74.525711 },
					{ "name": "AAPL", "date": "20140415", "value": 73.994286 },
					{ "name": "AAPL", "date": "20140416", "value": 74.144287 },
					{ "name": "AAPL", "date": "20140417", "value": 74.991432 },
					{ "name": "AAPL", "date": "20140421", "value": 75.881432 },
					{ "name": "AAPL", "date": "20140422", "value": 75.957146 },
					{ "name": "AAPL", "date": "20140423", "value": 74.964287 },
					{ "name": "AAPL", "date": "20140424", "value": 81.110001 },
					{ "name": "AAPL", "date": "20140425", "value": 81.705711 },
					{ "name": "AAPL", "date": "20140428", "value": 84.870003 },
					{ "name": "AAPL", "date": "20140429", "value": 84.618568 },
					{ "name": "AAPL", "date": "20140430", "value": 84.298569 },
					{ "name": "AAPL", "date": "20140501", "value": 84.497147 },
					{ "name": "AAPL", "date": "20140502", "value": 84.654289 },
					{ "name": "AAPL", "date": "20140505", "value": 85.851425 },
					{ "name": "AAPL", "date": "20140506", "value": 84.915718 },
					{ "name": "AAPL", "date": "20140507", "value": 84.618568 },
					{ "name": "AAPL", "date": "20140508", "value": 83.998573 },
					{ "name": "AAPL", "date": "20140509", "value": 83.648575 },
					{ "name": "AAPL", "date": "20140512", "value": 84.690002 },
					{ "name": "AAPL", "date": "20140513", "value": 84.822861 },
					{ "name": "AAPL", "date": "20140514", "value": 84.83857 },
					{ "name": "AAPL", "date": "20140515", "value": 84.117142 },
					{ "name": "AAPL", "date": "20140516", "value": 85.358574 },
					{ "name": "AAPL", "date": "20140519", "value": 86.370003 },
					{ "name": "AAPL", "date": "20140520", "value": 86.387146 },
					{ "name": "AAPL", "date": "20140521", "value": 86.615715 },
					{ "name": "AAPL", "date": "20140522", "value": 86.752853 },
					{ "name": "AAPL", "date": "20140523", "value": 87.732857 },
					{ "name": "AAPL", "date": "20140527", "value": 89.375717 },
					{ "name": "AAPL", "date": "20140528", "value": 89.144287 },
					{ "name": "AAPL", "date": "20140529", "value": 90.76857 },
					{ "name": "AAPL", "date": "20140530", "value": 90.428574 },
					{ "name": "AAPL", "date": "20140602", "value": 89.807144 },
					{ "name": "AAPL", "date": "20140603", "value": 91.077141 },
					{ "name": "AAPL", "date": "20140604", "value": 92.117142 },
					{ "name": "AAPL", "date": "20140605", "value": 92.478569 },
					{ "name": "AAPL", "date": "20140606", "value": 92.224289 },
					{ "name": "AAPL", "date": "20140609", "value": 93.699997 },
					{ "name": "AAPL", "date": "20140610", "value": 94.25 },
					{ "name": "AAPL", "date": "20140611", "value": 93.860001 },
					{ "name": "AAPL", "date": "20140612", "value": 92.290001 },
					{ "name": "AAPL", "date": "20140613", "value": 91.279999 },
					{ "name": "AAPL", "date": "20140616", "value": 92.199997 },
					{ "name": "AAPL", "date": "20140617", "value": 92.080002 },
					{ "name": "AAPL", "date": "20140618", "value": 92.18 },
					{ "name": "AAPL", "date": "20140619", "value": 91.860001 },
					{ "name": "AAPL", "date": "20140620", "value": 90.910004 },
					{ "name": "AAPL", "date": "20140623", "value": 90.830002 },
					{ "name": "AAPL", "date": "20140624", "value": 90.279999 },
					{ "name": "AAPL", "date": "20140625", "value": 90.360001 },
					{ "name": "AAPL", "date": "20140626", "value": 90.900002 },
					{ "name": "AAPL", "date": "20140627", "value": 91.980003 },
					{ "name": "AAPL", "date": "20140630", "value": 92.93 },
					{ "name": "AAPL", "date": "20140701", "value": 93.519997 },
					{ "name": "AAPL", "date": "20140702", "value": 93.480003 },
					{ "name": "AAPL", "date": "20140703", "value": 94.029999 },
					{ "name": "AAPL", "date": "20140707", "value": 95.970001 },
					{ "name": "AAPL", "date": "20140708", "value": 95.349998 },
					{ "name": "AAPL", "date": "20140709", "value": 95.389999 },
					{ "name": "AAPL", "date": "20140710", "value": 95.040001 },
					{ "name": "AAPL", "date": "20140711", "value": 95.220001 },
					{ "name": "AAPL", "date": "20140714", "value": 96.449997 },
					{ "name": "AAPL", "date": "20140715", "value": 95.32 },
					{ "name": "AAPL", "date": "20140716", "value": 94.779999 },
					{ "name": "AAPL", "date": "20140717", "value": 93.089996 },
					{ "name": "AAPL", "date": "20140718", "value": 94.43 },
					{ "name": "AAPL", "date": "20140721", "value": 93.940002 },
					{ "name": "AAPL", "date": "20140722", "value": 94.720001 },
					{ "name": "AAPL", "date": "20140723", "value": 97.190002 },
					{ "name": "AAPL", "date": "20140724", "value": 97.029999 },
					{ "name": "AAPL", "date": "20140725", "value": 97.669998 },
					{ "name": "AAPL", "date": "20140728", "value": 99.019997 },
					{ "name": "AAPL", "date": "20140729", "value": 98.379997 },
					{ "name": "AAPL", "date": "20140730", "value": 98.150002 },
					{ "name": "AAPL", "date": "20140731", "value": 95.599998 },
					{ "name": "AAPL", "date": "20140801", "value": 96.129997 },
					{ "name": "AAPL", "date": "20140804", "value": 95.589996 },
					{ "name": "AAPL", "date": "20140805", "value": 95.120003 },
					{ "name": "AAPL", "date": "20140806", "value": 94.959999},
					{ "name": "AAPL", "date": "20140807", "value": 94.480003 },
					{ "name": "AAPL", "date": "20140808", "value": 94.739998 },
					{ "name": "AAPL", "date": "20140811", "value": 95.989998 },
					{ "name": "AAPL", "date": "20140812", "value": 95.970001 },
					{ "name": "AAPL", "date": "20140813", "value": 97.239998 },
					{ "name": "AAPL", "date": "20140814", "value": 97.5 },
					{ "name": "AAPL", "date": "20140815", "value": 97.980003 },
					{ "name": "AAPL", "date": "20140818", "value": 99.160004 },
					{ "name": "AAPL", "date": "20140819", "value": 100.529999 },
					{ "name": "AAPL", "date": "20140820", "value": 100.57 },
					{ "name": "AAPL", "date": "20140821", "value": 100.580002 },
					{ "name": "AAPL", "date": "20140822", "value": 101.32 },
					{ "name": "AAPL", "date": "20140825", "value": 101.540001 },
					{ "name": "AAPL", "date": "20140826", "value": 100.889999 },
					{ "name": "AAPL", "date": "20140827", "value": 102.129997 },
					{ "name": "AAPL", "date": "20140828", "value": 102.25 },
					{ "name": "AAPL", "date": "20140829", "value": 102.5 },
					{ "name": "AAPL", "date": "20140902", "value": 103.300003 },
					{ "name": "AAPL", "date": "20140903", "value": 98.940002 },
					{ "name": "AAPL", "date": "20140904", "value": 98.120003 },
					{ "name": "AAPL", "date": "20140905", "value": 98.970001 },
					{ "name": "AAPL", "date": "20140908", "value": 98.360001 },
					{ "name": "AAPL", "date": "20140909", "value": 97.989998 },
					{ "name": "AAPL", "date": "20140910", "value": 101 },
					{ "name": "AAPL", "date": "20140911", "value": 101.43 },
					{ "name": "AAPL", "date": "20140912", "value": 101.660004 },
					{ "name": "AAPL", "date": "20140915", "value": 101.629997 },
					{ "name": "AAPL", "date": "20140916", "value": 100.860001 },
					{ "name": "AAPL", "date": "20140917", "value": 101.580002 },
					{ "name": "AAPL", "date": "20140918", "value": 101.790001 },
					{ "name": "AAPL", "date": "20140919", "value": 100.959999 },
					{ "name": "AAPL", "date": "20140922", "value": 101.059998 },
					{ "name": "AAPL", "date": "20140923", "value": 102.639999 },
					{ "name": "AAPL", "date": "20140924", "value": 101.75 },
					{ "name": "AAPL", "date": "20140925", "value": 97.870003 },
					{ "name": "AAPL", "date": "20140926", "value": 100.75 },
					{ "name": "AAPL", "date": "20140929", "value": 100.110001 },
					{ "name": "AAPL", "date": "20140930", "value": 100.75 },
					{ "name": "AAPL", "date": "20141001", "value": 99.18 },
					{ "name": "AAPL", "date": "20141002", "value": 99.900002 },
					{ "name": "AAPL", "date": "20141003", "value": 99.620003 },
					{ "name": "AAPL", "date": "20141006", "value": 99.620003 },
					{ "name": "AAPL", "date": "20141007", "value": 98.75 },
					{ "name": "AAPL", "date": "20141008", "value": 100.800003 },
					{ "name": "AAPL", "date": "20141009", "value": 101.019997 },
					{ "name": "AAPL", "date": "20141010", "value": 100.730003 },
					{ "name": "AAPL", "date": "20141013", "value": 99.809998 },
					{ "name": "AAPL", "date": "20141014", "value": 98.75 },
					{ "name": "AAPL", "date": "20141015", "value": 97.540001 },
					{ "name": "AAPL", "date": "20141016", "value": 96.260002 },
					{ "name": "AAPL", "date": "20141017", "value": 97.669998 },
					{ "name": "AAPL", "date": "20141020", "value": 99.760002 },
					{ "name": "AAPL", "date": "20141021", "value": 102.470001 },
					{ "name": "AAPL", "date": "20141022", "value": 102.989998 },
					{ "name": "AAPL", "date": "20141023", "value": 104.830002 },
					{ "name": "AAPL", "date": "20141024", "value": 105.220001 },
					{ "name": "AAPL", "date": "20141027", "value": 105.110001 },
					{ "name": "AAPL", "date": "20141028", "value": 106.739998 },
					{ "name": "AAPL", "date": "20141029", "value": 107.339996 },
					{ "name": "AAPL", "date": "20141030", "value": 106.980003 },
					{ "name": "AAPL", "date": "20141031", "value": 108 },
					{ "name": "AAPL", "date": "20141103", "value": 109.400002 },
					{ "name": "AAPL", "date": "20141104", "value": 108.599998 },
					{ "name": "AAPL", "date": "20141105", "value": 108.860001 },
					{ "name": "AAPL", "date": "20141106", "value": 108.699997 },
					{ "name": "AAPL", "date": "20141107", "value": 109.010002 },
					{ "name": "AAPL", "date": "20141110", "value": 108.830002 },
					{ "name": "AAPL", "date": "20141111", "value": 109.699997 },
					{ "name": "AAPL", "date": "20141112", "value": 111.25 },
					{ "name": "AAPL", "date": "20141113", "value": 112.82 },
					{ "name": "AAPL", "date": "20141114", "value": 114.18 },
					{ "name": "AAPL", "date": "20141117", "value": 113.989998 },
					{ "name": "AAPL", "date": "20141118", "value": 115.470001 },
					{ "name": "AAPL", "date": "20141119", "value": 114.669998 },
					{ "name": "AAPL", "date": "20141120", "value": 116.309998 },
					{ "name": "AAPL", "date": "20141121", "value": 116.470001 },
					{ "name": "AAPL", "date": "20141124", "value": 118.629997 },
					{ "name": "AAPL", "date": "20141125", "value": 117.599998 },
					{ "name": "AAPL", "date": "20141126", "value": 119 },
					{ "name": "AAPL", "date": "20141128", "value": 118.93 },
					{ "name": "AAPL", "date": "20141201", "value": 115.07 },
					{ "name": "AAPL", "date": "20141202", "value": 114.629997 },
					{ "name": "AAPL", "date": "20141203", "value": 115.93 },
					{ "name": "AAPL", "date": "20141204", "value": 115.489998 },
					{ "name": "AAPL", "date": "20141205", "value": 115 },
					{ "name": "AAPL", "date": "20141208", "value": 112.400002 },
					{ "name": "AAPL", "date": "20141209", "value": 114.120003 },
					{ "name": "AAPL", "date": "20141210", "value": 111.949997 },
					{ "name": "AAPL", "date": "20141211", "value": 111.620003 },
					{ "name": "AAPL", "date": "20141212", "value": 109.730003 },
					{ "name": "AAPL", "date": "20141215", "value": 108.230003 },
					{ "name": "AAPL", "date": "20141216", "value": 106.75 },
					{ "name": "AAPL", "date": "20141217", "value": 109.410004 },
					{ "name": "AAPL", "date": "20141218", "value": 112.650002 },
					{ "name": "AAPL", "date": "20141219", "value": 111.779999 },
					{ "name": "AAPL", "date": "20141222", "value": 112.940002 },
					{ "name": "AAPL", "date": "20141223", "value": 112.540001 },
					{ "name": "AAPL", "date": "20141224", "value": 112.010002 },
					{ "name": "AAPL", "date": "20141226", "value": 113.989998 },
					{ "name": "AAPL", "date": "20141229", "value": 113.910004 },
					{ "name": "AAPL", "date": "20141230", "value": 112.519997 },
					{ "name": "AAPL", "date": "20141231", "value": 110.379997 },
					{ "name": "AAPL", "date": "20150102", "value": 109.330002 },
					{ "name": "AAPL", "date": "20150105", "value": 106.25 },
					{ "name": "AAPL", "date": "20150106", "value": 106.260002 },
					{ "name": "AAPL", "date": "20150107", "value": 107.75 },
					{ "name": "AAPL", "date": "20150108", "value": 111.889999 },
					{ "name": "AAPL", "date": "20150109", "value": 112.010002 },
					{ "name": "AAPL", "date": "20150112", "value": 109.25 },
					{ "name": "AAPL", "date": "20150113", "value": 110.220001 },
					{ "name": "AAPL", "date": "20150114", "value": 109.800003 },
					{ "name": "AAPL", "date": "20150115", "value": 106.82 },
					{ "name": "AAPL", "date": "20150116", "value": 105.989998 },
					{ "name": "AAPL", "date": "20150120", "value": 108.720001 },
					{ "name": "AAPL", "date": "20150121", "value": 109.550003 },
					{ "name": "AAPL", "date": "20150122", "value": 112.400002 },
					{ "name": "AAPL", "date": "20150123", "value": 112.980003 },
					{ "name": "AAPL", "date": "20150126", "value": 113.099998 },
					{ "name": "AAPL", "date": "20150127", "value": 109.139999 },
					{ "name": "AAPL", "date": "20150128", "value": 115.309998 },
					{ "name": "AAPL", "date": "20150129", "value": 118.900002 },
					{ "name": "AAPL", "date": "20150130", "value": 117.160004 },
					{ "name": "AAPL", "date": "20150202", "value": 118.629997 },
					{ "name": "AAPL", "date": "20150203", "value": 118.650002 },
					{ "name": "AAPL", "date": "20150204", "value": 119.559998 },
					{ "name": "AAPL", "date": "20150205", "value": 119.940002 },
					{ "name": "AAPL", "date": "20150206", "value": 118.93 },
					{ "name": "AAPL", "date": "20150209", "value": 119.720001 },
					{ "name": "AAPL", "date": "20150210", "value": 122.019997 },
					{ "name": "AAPL", "date": "20150211", "value": 124.879997 },
					{ "name": "AAPL", "date": "20150212", "value": 126.459999 },
					{ "name": "AAPL", "date": "20150213", "value": 127.080002 },
					{ "name": "AAPL", "date": "20150217", "value": 127.830002 },
					{ "name": "AAPL", "date": "20150218", "value": 128.720001 },
					{ "name": "AAPL", "date": "20150219", "value": 128.449997 },
					{ "name": "AAPL", "date": "20150220", "value": 129.5 },
					{ "name": "AAPL", "date": "20150223", "value": 133 },
					{ "name": "AAPL", "date": "20150224", "value": 132.169998 },
					{ "name": "AAPL", "date": "20150225", "value": 128.789993 },
					{ "name": "AAPL", "date": "20150226", "value": 130.419998 },
					{ "name": "AAPL", "date": "20150227", "value": 128.460007 },
					{ "name": "AAPL", "date": "20150302", "value": 129.089996 },
					{ "name": "AAPL", "date": "20150303", "value": 129.360001 },
					{ "name": "AAPL", "date": "20150304", "value": 128.539993 },
					{ "name": "AAPL", "date": "20150305", "value": 126.410004 },
					{ "name": "AAPL", "date": "20150306", "value": 126.599998 },
					{ "name": "AAPL", "date": "20150309", "value": 127.139999 },
					{ "name": "AAPL", "date": "20150310", "value": 124.510002 },
					{ "name": "AAPL", "date": "20150311", "value": 122.239998 },
					{ "name": "AAPL", "date": "20150312", "value": 124.449997 },
					{ "name": "AAPL", "date": "20150313", "value": 123.589996 },
					{ "name": "AAPL", "date": "20150316", "value": 124.949997 },
					{ "name": "AAPL", "date": "20150317", "value": 127.040001 },
					{ "name": "AAPL", "date": "20150318", "value": 128.470001 },
					{ "name": "AAPL", "date": "20150319", "value": 127.5 },
					{ "name": "AAPL", "date": "20150320", "value": 125.900002 },
					{ "name": "AAPL", "date": "20150323", "value": 127.209999 },
					{ "name": "AAPL", "date": "20150324", "value": 126.690002 },
					{ "name": "AAPL", "date": "20150325", "value": 123.379997 },
					{ "name": "AAPL", "date": "20150326", "value": 124.239998 },
					{ "name": "AAPL", "date": "20150327", "value": 123.25 },
					{ "name": "AAPL", "date": "20150330", "value": 126.370003 },
					{ "name": "AAPL", "date": "20150331", "value": 124.43 },
					{ "name": "AAPL", "date": "20150401", "value": 124.25 },
					{ "name": "AAPL", "date": "20150402", "value": 125.32 },
					{ "name": "AAPL", "date": "20150406", "value": 127.349998 },
					{ "name": "AAPL", "date": "20150407", "value": 126.010002 },
					{ "name": "AAPL", "date": "20150408", "value": 125.599998 },
					{ "name": "AAPL", "date": "20150409", "value": 126.559998 },
					{ "name": "AAPL", "date": "20150410", "value": 127.099998 },
					{ "name": "AAPL", "date": "20150413", "value": 126.849998 },
					{ "name": "AAPL", "date": "20150414", "value": 126.300003 },
					{ "name": "AAPL", "date": "20150415", "value": 126.779999 },
					{ "name": "AAPL", "date": "20150416", "value": 126.169998 },
					{ "name": "AAPL", "date": "20150417", "value": 124.75 },
					{ "name": "AAPL", "date": "20150420", "value": 127.599998 },
					{ "name": "AAPL", "date": "20150421", "value": 126.910004 },
					{ "name": "AAPL", "date": "20150422", "value": 128.619995 },
					{ "name": "AAPL", "date": "20150423", "value": 129.669998 },
					{ "name": "AAPL", "date": "20150424", "value": 130.279999 },
					{ "name": "AAPL", "date": "20150427", "value": 132.649994 },
					{ "name": "AAPL", "date": "20150428", "value": 130.559998 },
					{ "name": "AAPL", "date": "20150429", "value": 128.639999 },
					{ "name": "AAPL", "date": "20150430", "value": 125.150002 },
					{ "name": "AAPL", "date": "20150501", "value": 128.949997 },
					{ "name": "AAPL", "date": "20150504", "value": 128.699997 },
					{ "name": "AAPL", "date": "20150505", "value": 125.800003 },
					{ "name": "AAPL", "date": "20150506", "value": 125.010002 },
					{ "name": "AAPL", "date": "20150507", "value": 125.260002 },
					{ "name": "AAPL", "date": "20150508", "value": 127.620003 },
					{ "name": "AAPL", "date": "20150511", "value": 126.32 },
					{ "name": "AAPL", "date": "20150512", "value": 125.870003 },
					{ "name": "AAPL", "date": "20150513", "value": 126.010002 },
					{ "name": "AAPL", "date": "20150514", "value": 128.949997 },
					{ "name": "AAPL", "date": "20150515", "value": 128.770004 },
					{ "name": "AAPL", "date": "20150518", "value": 130.190002 },
					{ "name": "AAPL", "date": "20150519", "value": 130.070007 },
					{ "name": "AAPL", "date": "20150520", "value": 130.059998 },
					{ "name": "AAPL", "date": "20150521", "value": 131.389999 },
					{ "name": "AAPL", "date": "20150522", "value": 132.539993 },
					{ "name": "AAPL", "date": "20150526", "value": 129.619995 },
					{ "name": "AAPL", "date": "20150527", "value": 132.039993 },
					{ "name": "AAPL", "date": "20150528", "value": 131.779999 },
					{ "name": "AAPL", "date": "20150529", "value": 130.279999 },
					{ "name": "AAPL", "date": "20150601", "value": 130.539993 },
					{ "name": "AAPL", "date": "20150602", "value": 129.960007 },
					{ "name": "AAPL", "date": "20150603", "value": 130.119995 },
					{ "name": "AAPL", "date": "20150604", "value": 129.360001 },
					{ "name": "AAPL", "date": "20150605", "value": 128.649994 },
					{ "name": "AAPL", "date": "20150608", "value": 127.800003 },
					{ "name": "AAPL", "date": "20150609", "value": 127.419998 },
					{ "name": "AAPL", "date": "20150610", "value": 128.880005 },
					{ "name": "AAPL", "date": "20150611", "value": 128.589996 },
					{ "name": "AAPL", "date": "20150612", "value": 127.169998 },
					{ "name": "AAPL", "date": "20150615", "value": 126.919998 },
					{ "name": "AAPL", "date": "20150616", "value": 127.599998 },
					{ "name": "AAPL", "date": "20150617", "value": 127.300003 },
					{ "name": "AAPL", "date": "20150618", "value": 127.879997 },
					{ "name": "AAPL", "date": "20150619", "value": 126.599998 },
					{ "name": "AAPL", "date": "20150622", "value": 127.610001 },
					{ "name": "AAPL", "date": "20150623", "value": 127.029999 },
					{ "name": "AAPL", "date": "20150624", "value": 128.110001 },
					{ "name": "AAPL", "date": "20150625", "value": 127.5 },
					{ "name": "AAPL", "date": "20150626", "value": 126.75 },
					{ "name": "AAPL", "date": "20150629", "value": 124.529999 },
					{ "name": "AAPL", "date": "20150630", "value": 125.43 },
					{ "name": "AAPL", "date": "20150701", "value": 126.599998 },
					{ "name": "AAPL", "date": "20150702", "value": 126.440002 },
					{ "name": "AAPL", "date": "20150706", "value": 126 },
					{ "name": "AAPL", "date": "20150707", "value": 125.690002 },
					{ "name": "AAPL", "date": "20150708", "value": 122.57 },
					{ "name": "AAPL", "date": "20150709", "value": 120.07 },
					{ "name": "AAPL", "date": "20150710", "value": 123.279999 },
					{ "name": "AAPL", "date": "20150713", "value": 125.660004 },
					{ "name": "AAPL", "date": "20150714", "value": 125.610001 },
					{ "name": "AAPL", "date": "20150715", "value": 126.82 },
					{ "name": "AAPL", "date": "20150716", "value": 128.509995 },
					{ "name": "AAPL", "date": "20150717", "value": 129.619995 },
					{ "name": "AAPL", "date": "20150720", "value": 132.070007 },
					{ "name": "AAPL", "date": "20150721", "value": 130.75 },
					{ "name": "AAPL", "date": "20150722", "value": 125.220001 },
					{ "name": "AAPL", "date": "20150723", "value": 125.160004 },
					{ "name": "AAPL", "date": "20150724", "value": 124.5 },
					{ "name": "AAPL", "date": "20150727", "value": 122.769997 },
					{ "name": "AAPL", "date": "20150728", "value": 123.379997 },
					{ "name": "AAPL", "date": "20150729", "value": 122.989998 },
					{ "name": "AAPL", "date": "20150730", "value": 122.370003 },
					{ "name": "AAPL", "date": "20150731", "value": 121.300003 },
					{ "name": "AAPL", "date": "20150803", "value": 118.440002 },
					{ "name": "AAPL", "date": "20150804", "value": 114.639999 },
					{ "name": "AAPL", "date": "20150805", "value": 115.400002 },
					{ "name": "AAPL", "date": "20150806", "value": 115.129997 },
					{ "name": "AAPL", "date": "20150807", "value": 115.519997 },
					{ "name": "AAPL", "date": "20150810", "value": 119.720001 },
					{ "name": "AAPL", "date": "20150811", "value": 113.489998 },
					{ "name": "AAPL", "date": "20150812", "value": 115.239998 },
					{ "name": "AAPL", "date": "20150813", "value": 115.150002 },
					{ "name": "AAPL", "date": "20150814", "value": 115.959999 },
					{ "name": "AAPL", "date": "20150817", "value": 117.160004 },
					{ "name": "AAPL", "date": "20150818", "value": 116.5 },
					{ "name": "AAPL", "date": "20150819", "value": 115.010002 },
					{ "name": "AAPL", "date": "20150820", "value": 112.650002 },
					{ "name": "AAPL", "date": "20150821", "value": 105.760002 },
					{ "name": "AAPL", "date": "20150824", "value": 103.120003 },
					{ "name": "AAPL", "date": "20150825", "value": 103.739998 },
					{ "name": "AAPL", "date": "20150826", "value": 109.690002 },
					{ "name": "AAPL", "date": "20150827", "value": 112.919998 },
					{ "name": "AAPL", "date": "20150828", "value": 113.290001 },
					{ "name": "AAPL", "date": "20150831", "value": 112.760002 },
					{ "name": "AAPL", "date": "20150901", "value": 107.720001 },
					{ "name": "AAPL", "date": "20150902", "value": 112.339996 },
					{ "name": "AAPL", "date": "20150903", "value": 110.370003 },
					{ "name": "AAPL", "date": "20150904", "value": 109.269997 },
					{ "name": "AAPL", "date": "20150908", "value": 112.309998 },
					{ "name": "AAPL", "date": "20150909", "value": 110.150002 },
					{ "name": "AAPL", "date": "20150910", "value": 112.57 },
					{ "name": "AAPL", "date": "20150911", "value": 114.209999 },
					{ "name": "AAPL", "date": "20150914", "value": 115.309998 },
					{ "name": "AAPL", "date": "20150915", "value": 116.279999 },
					{ "name": "AAPL", "date": "20150916", "value": 116.410004 },
					{ "name": "AAPL", "date": "20150917", "value": 113.919998 },
					{ "name": "AAPL", "date": "20150918", "value": 113.449997 },
					{ "name": "AAPL", "date": "20150921", "value": 115.209999 },
					{ "name": "AAPL", "date": "20150922", "value": 113.400002 },
					{ "name": "AAPL", "date": "20150923", "value": 114.32 },
					{ "name": "AAPL", "date": "20150924", "value": 115 },
					{ "name": "AAPL", "date": "20150925", "value": 114.709999 },
					{ "name": "AAPL", "date": "20150928", "value": 112.440002 },
					{ "name": "AAPL", "date": "20150929", "value": 109.059998 },
					{ "name": "AAPL", "date": "20150930", "value": 110.300003 },
					{ "name": "AAPL", "date": "20151001", "value": 109.580002 },
					{ "name": "AAPL", "date": "20151002", "value": 110.379997 },
					{ "name": "AAPL", "date": "20151005", "value": 110.779999 },
					{ "name": "AAPL", "date": "20151006", "value": 111.309998 },
					{ "name": "AAPL", "date": "20151007", "value": 110.779999 },
					{ "name": "AAPL", "date": "20151008", "value": 109.5 },
					{ "name": "AAPL", "date": "20151009", "value": 112.120003 },
					{ "name": "AAPL", "date": "20151012", "value": 111.599998 },
					{ "name": "AAPL", "date": "20151013", "value": 111.790001 },
					{ "name": "AAPL", "date": "20151014", "value": 110.209999 },
					{ "name": "AAPL", "date": "20151015", "value": 111.860001 },
					{ "name": "AAPL", "date": "20151016", "value": 111.040001 },
					{ "name": "AAPL", "date": "20151019", "value": 111.730003 },
					{ "name": "AAPL", "date": "20151020", "value": 113.769997 },
					{ "name": "AAPL", "date": "20151021", "value": 113.760002 },
					{ "name": "AAPL", "date": "20151022", "value": 115.5 },
					{ "name": "AAPL", "date": "20151023", "value": 119.080002 },
					{ "name": "AAPL", "date": "20151026", "value": 115.279999 },
					{ "name": "AAPL", "date": "20151027", "value": 114.550003 },
					{ "name": "AAPL", "date": "20151028", "value": 119.269997 },
					{ "name": "AAPL", "date": "20151029", "value": 120.529999 },
					{ "name": "AAPL", "date": "20151030", "value": 119.5 },
					{ "name": "AAPL", "date": "20151102", "value": 121.18},
					{ "name": "AAPL", "date": "20151103", "value": 122.57},
					{ "name": "AAPL", "date": "20151104", "value": 122 },
					{ "name": "AAPL", "date": "20151105", "value": 120.919998 },
					{ "name": "AAPL", "date": "20151106", "value": 121.059998 },
					{ "name": "AAPL", "date": "20151109", "value": 120.57 },
					{ "name": "AAPL", "date": "20151110", "value": 116.769997},
					{ "name": "AAPL", "date": "20151111", "value": 116.110001 },
					{ "name": "AAPL", "date": "20151112", "value": 115.720001 },
					{ "name": "AAPL", "date": "20151113", "value": 112.339996 },
					{ "name": "AAPL", "date": "20151116", "value": 114.18 },
					{ "name": "AAPL", "date": "20151117", "value": 113.690002 },
					{ "name": "AAPL", "date": "20151118", "value": 117.290001 },
					{ "name": "AAPL", "date": "20151119", "value": 118.779999 },
					{ "name": "AAPL", "date": "20151120", "value": 119.300003 },
					{ "name": "AAPL", "date": "20151123", "value": 117.75 },
					{ "name": "AAPL", "date": "20151124", "value": 118.879997 },
					{ "name": "AAPL", "date": "20151125", "value": 118.029999 },
					{ "name": "AAPL", "date": "20151127", "value": 117.809998 },
					{ "name": "AAPL", "date": "20151130", "value": 118.300003 },
					{ "name": "AAPL", "date": "20151201", "value": 117.339996 },
					{ "name": "AAPL", "date": "20151202", "value": 116.279999 },
					{ "name": "AAPL", "date": "20151203", "value": 115.199997 },
					{ "name": "AAPL", "date": "20151204", "value": 119.029999 },
					{ "name": "AAPL", "date": "20151207", "value": 118.279999 },
					{ "name": "AAPL", "date": "20151208", "value": 118.230003 },
					{ "name": "AAPL", "date": "20151209", "value": 115.620003 },
					{ "name": "AAPL", "date": "20151210", "value": 116.169998},
					{ "name": "AAPL", "date": "20151211", "value": 113.18 },
					{ "name": "AAPL", "date": "20151214", "value": 112.480003 },
					{ "name": "AAPL", "date": "20151215", "value": 110.489998 },
					{ "name": "AAPL", "date": "20151216", "value": 111.339996 },
					{ "name": "AAPL", "date": "20151217", "value": 108.980003 },
					{ "name": "AAPL", "date": "20151218", "value": 106.029999 },
					{ "name": "AAPL", "date": "20151221", "value": 107.330002 },
					{ "name": "AAPL", "date": "20151222", "value": 107.230003 },
					{ "name": "AAPL", "date": "20151223", "value": 108.610001 },
					{ "name": "AAPL", "date": "20151224", "value": 108.029999 },
					{ "name": "AAPL", "date": "20151228", "value": 106.82 },
					{ "name": "AAPL", "date": "20151229", "value": 108.739998 },
					{ "name": "AAPL", "date": "20151230", "value": 107.32 },
					{ "name": "AAPL", "date": "20151231", "value": 105.260002 },
					{ "name": "AAPL", "date": "20160104", "value": 105.349998 },
					{ "name": "AAPL", "date": "20160105", "value": 102.709999 },
					{ "name": "AAPL", "date": "20160106", "value": 100.699997 },
					{ "name": "AAPL", "date": "20160107", "value": 96.449997 },
					{ "name": "AAPL", "date": "20160108", "value": 96.959999 },
					{ "name": "AAPL", "date": "20160111", "value": 98.529999 },
					{ "name": "AAPL", "date": "20160112", "value": 99.959999 },
					{ "name": "AAPL", "date": "20160113", "value": 97.389999 },
					{ "name": "AAPL", "date": "20160114", "value": 99.519997 },
					{ "name": "AAPL", "date": "20160115", "value": 97.129997 },
					{ "name": "AAPL", "date": "20160119", "value": 96.660004 },
					{ "name": "AAPL", "date": "20160120", "value": 96.790001 },
					{ "name": "AAPL", "date": "20160121", "value": 96.300003 },
					{ "name": "AAPL", "date": "20160122", "value": 101.419998 },
					{ "name": "AAPL", "date": "20160125", "value": 99.440002 },
					{ "name": "AAPL", "date": "20160126", "value": 99.989998 },
					{ "name": "AAPL", "date": "20160127", "value": 93.419998 },
					{ "name": "AAPL", "date": "20160128", "value": 94.089996 },
					{ "name": "AAPL", "date": "20160129", "value": 97.339996 },
					{ "name": "AAPL", "date": "20160201", "value": 96.43 },
					{ "name": "AAPL", "date": "20160202", "value": 94.480003 },
					{ "name": "AAPL", "date": "20160203", "value": 96.349998 },
					{ "name": "AAPL", "date": "20160204", "value": 96.599998 },
					{ "name": "AAPL", "date": "20160205", "value": 94.019997 },
					{ "name": "AAPL", "date": "20160208", "value": 95.010002 },
					{ "name": "AAPL", "date": "20160209", "value": 94.989998 },
					{ "name": "AAPL", "date": "20160210", "value": 94.269997 },
					{ "name": "AAPL", "date": "20160211", "value": 93.699997 },
					{ "name": "AAPL", "date": "20160212", "value": 93.989998 },
					{ "name": "AAPL", "date": "20160216", "value": 96.639999 },
					{ "name": "AAPL", "date": "20160217", "value": 98.120003 },
					{ "name": "AAPL", "date": "20160218", "value": 96.260002 },
					{ "name": "AAPL", "date": "20160219", "value": 96.040001 },
					{ "name": "AAPL", "date": "20160222", "value": 96.879997 },
					{ "name": "AAPL", "date": "20160223", "value": 94.690002 },
					{ "name": "AAPL", "date": "20160224", "value": 96.099998 },
					{ "name": "AAPL", "date": "20160225", "value": 96.760002 },
					{ "name": "AAPL", "date": "20160226", "value": 96.910004 },
					{ "name": "AAPL", "date": "20160229", "value": 96.690002 },
					{ "name": "AAPL", "date": "20160301", "value": 100.529999 },
					{ "name": "AAPL", "date": "20160302", "value": 100.75 },
					{ "name": "AAPL", "date": "20160303", "value": 101.5 },
					{ "name": "AAPL", "date": "20160304", "value": 103.010002 },
					{ "name": "AAPL", "date": "20160307", "value": 101.870003 },
					{ "name": "AAPL", "date": "20160308", "value": 101.029999 },
					{ "name": "AAPL", "date": "20160309", "value": 101.120003 },
					{ "name": "AAPL", "date": "20160310", "value": 101.169998 },
					{ "name": "AAPL", "date": "20160311", "value": 102.260002 },
					{ "name": "AAPL", "date": "20160314", "value": 102.519997 },
					{ "name": "AAPL", "date": "20160315", "value": 104.580002 },
					{ "name": "AAPL", "date": "20160316", "value": 105.970001 },
					{ "name": "AAPL", "date": "20160317", "value": 105.800003 },
					{ "name": "AAPL", "date": "20160318", "value": 105.919998 },
					{ "name": "AAPL", "date": "20160321", "value": 105.910004 },
					{ "name": "AAPL", "date": "20160322", "value": 106.720001 },
					{ "name": "AAPL", "date": "20160323", "value": 106.129997 },
					{ "name": "AAPL", "date": "20160324", "value": 105.669998 },
					{ "name": "AAPL", "date": "20160328", "value": 105.190002 },
					{ "name": "AAPL", "date": "20160329", "value": 107.68 },
					{ "name": "AAPL", "date": "20160330", "value": 109.559998 },
					{ "name": "AAPL", "date": "20160331", "value": 108.989998 },
					{ "name": "AAPL", "date": "20160401", "value": 109.989998 },
					{ "name": "AAPL", "date": "20160404", "value": 111.120003 },
					{ "name": "AAPL", "date": "20160405", "value": 109.809998 },
					{ "name": "AAPL", "date": "20160406", "value": 110.959999 },
					{ "name": "AAPL", "date": "20160407", "value": 108.540001 },
					{ "name": "AAPL", "date": "20160408", "value": 108.660004 },
					{ "name": "AAPL", "date": "20160411", "value": 109.019997 },
					{ "name": "AAPL", "date": "20160412", "value": 110.440002 },
					{ "name": "AAPL", "date": "20160413", "value": 112.040001 },
					{ "name": "AAPL", "date": "20160414", "value": 112.099998 },
					{ "name": "AAPL", "date": "20160415", "value": 109.849998 },
					{ "name": "AAPL", "date": "20160418", "value": 107.480003 },
					{ "name": "AAPL", "date": "20160419", "value": 106.910004 },
					{ "name": "AAPL", "date": "20160420", "value": 107.129997 },
					{ "name": "AAPL", "date": "20160421", "value": 105.970001 },
					{ "name": "AAPL", "date": "20160422", "value": 105.68 },
					{ "name": "AAPL", "date": "20160425", "value": 105.080002 },
					{ "name": "AAPL", "date": "20160426", "value": 104.349998 },
					{ "name": "AAPL", "date": "20160427", "value": 97.82 },
					{ "name": "AAPL", "date": "20160428", "value": 94.830002 },
					{ "name": "AAPL", "date": "20160429", "value": 93.739998 },
					{ "name": "AAPL", "date": "20160502", "value": 93.639999 },
					{ "name": "AAPL", "date": "20160503", "value": 95.18 },
					{ "name": "AAPL", "date": "20160504", "value": 94.190002 },
					{ "name": "AAPL", "date": "20160505", "value": 93.239998 },
					{ "name": "AAPL", "date": "20160506", "value": 92.720001 },
					{ "name": "AAPL", "date": "20160509", "value": 92.790001 },
					{ "name": "AAPL", "date": "20160510", "value": 93.419998 },
					{ "name": "AAPL", "date": "20160511", "value": 92.510002 },
					{ "name": "AAPL", "date": "20160512", "value": 90.339996 },
					{ "name": "AAPL", "date": "20160513", "value": 90.519997 },
					{ "name": "AAPL", "date": "20160516", "value": 93.879997 },
					{ "name": "AAPL", "date": "20160517", "value": 93.489998 },
					{ "name": "AAPL", "date": "20160518", "value": 94.559998 },
					{ "name": "AAPL", "date": "20160519", "value": 94.199997 },
					{ "name": "AAPL", "date": "20160520", "value": 95.220001 },
					{ "name": "AAPL", "date": "20160523", "value": 96.43 },
					{ "name": "AAPL", "date": "20160524", "value": 97.900002 },
					{ "name": "AAPL", "date": "20160525", "value": 99.620003 },
					{ "name": "AAPL", "date": "20160526", "value": 100.410004 },
					{ "name": "AAPL", "date": "20160527", "value": 100.349998 },
					{ "name": "AAPL", "date": "20160531", "value": 99.860001 },
					{ "name": "AAPL", "date": "20160601", "value": 98.459999 },
					{ "name": "AAPL", "date": "20160602", "value": 97.720001 },
					{ "name": "AAPL", "date": "20160603", "value": 97.919998 },
					{ "name": "AAPL", "date": "20160606", "value": 98.629997 },
					{ "name": "AAPL", "date": "20160607", "value": 99.029999 },
					{ "name": "AAPL", "date": "20160608", "value": 98.940002 },
					{ "name": "AAPL", "date": "20160609", "value": 99.650002 },
					{ "name": "AAPL", "date": "20160610", "value": 98.830002 },
					{ "name": "AAPL", "date": "20160613", "value": 97.339996 },
					{ "name": "AAPL", "date": "20160614", "value": 97.459999 },
					{ "name": "AAPL", "date": "20160615", "value": 97.139999 },
					{ "name": "AAPL", "date": "20160616", "value": 97.550003 },
					{ "name": "AAPL", "date": "20160617", "value": 95.330002 },
					{ "name": "AAPL", "date": "20160620", "value": 95.099998 },
					{ "name": "AAPL", "date": "20160621", "value": 95.910004 },
					{ "name": "AAPL", "date": "20160622", "value": 95.550003 },
					{ "name": "AAPL", "date": "20160623", "value": 96.099998 },
					{ "name": "AAPL", "date": "20160624", "value": 93.400002 },
					{ "name": "AAPL", "date": "20160627", "value": 92.040001 },
					{ "name": "AAPL", "date": "20160628", "value": 93.589996 },
					{ "name": "AAPL", "date": "20160629", "value": 94.400002 },
					{ "name": "AAPL", "date": "20160630", "value": 95.599998 },
					{ "name": "AAPL", "date": "20160701", "value": 95.889999 },
					{ "name": "AAPL", "date": "20160705", "value": 94.989998 },
					{ "name": "AAPL", "date": "20160706", "value": 95.529999 },
					{ "name": "AAPL", "date": "20160707", "value": 95.940002 },
					{ "name": "AAPL", "date": "20160708", "value": 96.68 },
					{ "name": "AAPL", "date": "20160711", "value": 96.980003 },
					{ "name": "AAPL", "date": "20160712", "value": 97.419998 },
					{ "name": "AAPL", "date": "20160713", "value": 96.870003 },
					{ "name": "AAPL", "date": "20160714", "value": 98.790001 },
					{ "name": "AAPL", "date": "20160715", "value": 98.779999 },
					{ "name": "AAPL", "date": "20160718", "value": 99.830002 },
					{ "name": "AAPL", "date": "20160719", "value": 99.870003 },
					{ "name": "AAPL", "date": "20160720", "value": 99.959999 },
					{ "name": "AAPL", "date": "20160721", "value": 99.43 },
					{ "name": "AAPL", "date": "20160722", "value": 98.660004 },
					{ "name": "AAPL", "date": "20160725", "value": 97.339996 },
					{ "name": "AAPL", "date": "20160726", "value": 96.669998 },
					{ "name": "AAPL", "date": "20160727", "value": 102.949997 },
					{ "name": "AAPL", "date": "20160728", "value": 104.339996 },
					{ "name": "AAPL", "date": "20160729", "value": 104.209999 },
					{ "name": "AAPL", "date": "20160801", "value": 106.050003 },
					{ "name": "AAPL", "date": "20160802", "value": 104.480003 },
					{ "name": "AAPL", "date": "20160803", "value": 105.790001 },
					{ "name": "AAPL", "date": "20160804", "value": 105.870003 },
					{ "name": "AAPL", "date": "20160805", "value": 107.480003 },
					{ "name": "AAPL", "date": "20160808", "value": 108.370003 },
					{ "name": "AAPL", "date": "20160809", "value": 108.809998 },
					{ "name": "AAPL", "date": "20160810", "value": 108 },
					{ "name": "AAPL", "date": "20160811", "value": 107.93 },
					{ "name": "AAPL", "date": "20160812", "value": 108.18 },
					{ "name": "AAPL", "date": "20160815", "value": 109.480003 },
					{ "name": "AAPL", "date": "20160816", "value": 109.379997 },
					{ "name": "AAPL", "date": "20160817", "value": 109.220001 },
					{ "name": "AAPL", "date": "20160818", "value": 109.080002 },
					{ "name": "AAPL", "date": "20160819", "value": 109.360001 },
					{ "name": "AAPL", "date": "20160822", "value": 108.510002 },
					{ "name": "AAPL", "date": "20160823", "value": 108.849998 },
					{ "name": "AAPL", "date": "20160824", "value": 108.029999 },
					{ "name": "AAPL", "date": "20160825", "value": 107.57 },
					{ "name": "AAPL", "date": "20160826", "value": 106.940002 },
					{ "name": "AAPL", "date": "20160829", "value": 106.82 },
					{ "name": "AAPL", "date": "20160830", "value": 106 },
					{ "name": "AAPL", "date": "20160831", "value": 106.099998 },
					{ "name": "AAPL", "date": "20160901", "value": 106.730003 },
					{ "name": "AAPL", "date": "20160902", "value": 107.730003 },
					{ "name": "AAPL", "date": "20160906", "value": 107.699997 },
					{ "name": "AAPL", "date": "20160907", "value": 108.360001 },
					{ "name": "AAPL", "date": "20160908", "value": 105.519997 },
					{ "name": "AAPL", "date": "20160909", "value": 103.129997 },
					{ "name": "AAPL", "date": "20160912", "value": 105.440002 },
					{ "name": "AAPL", "date": "20160913", "value": 107.949997 },
					{ "name": "AAPL", "date": "20160914", "value": 111.769997 },
					{ "name": "AAPL", "date": "20160915", "value": 115.57 },
					{ "name": "AAPL", "date": "20160916", "value": 114.919998 },
					{ "name": "AAPL", "date": "20160919", "value": 113.580002 },
					{ "name": "AAPL", "date": "20160920", "value": 113.57 },
					{ "name": "AAPL", "date": "20160921", "value": 113.550003 },
					{ "name": "AAPL", "date": "20160922", "value": 114.620003 },
					{ "name": "AAPL", "date": "20160923", "value": 112.709999 },
					{ "name": "AAPL", "date": "20160926", "value": 112.879997 },
					{ "name": "AAPL", "date": "20160927", "value": 113.089996 },
					{ "name": "AAPL", "date": "20160928", "value": 113.949997 },
					{ "name": "AAPL", "date": "20160929", "value": 112.18 },
					{ "name": "AAPL", "date": "20160930", "value": 113.050003 },
					{ "name": "AAPL", "date": "20161003", "value": 112.519997 },
					{ "name": "AAPL", "date": "20161004", "value": 113 },
					{ "name": "AAPL", "date": "20161005", "value": 113.050003 },
					{ "name": "AAPL", "date": "20161006", "value": 113.889999 },
					{ "name": "AAPL", "date": "20161007", "value": 114.059998 },
					{ "name": "AAPL", "date": "20161010", "value": 116.050003 },
					{ "name": "AAPL", "date": "20161011", "value": 116.300003 },
					{ "name": "AAPL", "date": "20161012", "value": 117.339996 },
					{ "name": "AAPL", "date": "20161013", "value": 116.980003 },
					{ "name": "AAPL", "date": "20161014", "value": 117.629997 },
					{ "name": "AAPL", "date": "20161017", "value": 117.550003 },
					{ "name": "AAPL", "date": "20161018", "value": 117.470001 },
					{ "name": "AAPL", "date": "20161019", "value": 117.120003 },
					{ "name": "AAPL", "date": "20161020", "value": 117.059998 },
					{ "name": "AAPL", "date": "20161021", "value": 116.599998 },
					{ "name": "AAPL", "date": "20161024", "value": 117.650002 },
					{ "name": "AAPL", "date": "20161025", "value": 118.25 },
					{ "name": "AAPL", "date": "20161026", "value": 115.589996 },
					{ "name": "AAPL", "date": "20161027", "value": 114.480003 },
					{ "name": "AAPL", "date": "20161028", "value": 113.720001 },
					{ "name": "AAPL", "date": "20161031", "value": 113.540001 },
					{ "name": "AAPL", "date": "20161101", "value": 111.489998 },
					{ "name": "AAPL", "date": "20161102", "value": 111.589996 },
					{ "name": "AAPL", "date": "20161103", "value": 109.830002 },
					{ "name": "AAPL", "date": "20161104", "value": 108.839996 },
					{ "name": "AAPL", "date": "20161107", "value": 110.410004 },
					{ "name": "AAPL", "date": "20161108", "value": 111.059998 },
					{ "name": "AAPL", "date": "20161109", "value": 110.879997 },
					{ "name": "AAPL", "date": "20161110", "value": 107.790001 },
					{ "name": "AAPL", "date": "20161111", "value": 108.43 },
					{ "name": "AAPL", "date": "20161114", "value": 105.709999 },
					{ "name": "AAPL", "date": "20161115", "value": 107.110001 },
					{ "name": "AAPL", "date": "20161116", "value": 109.989998 },
					{ "name": "AAPL", "date": "20161117", "value": 109.949997 },
					{ "name": "AAPL", "date": "20161118", "value": 110.059998 },
					{ "name": "AAPL", "date": "20161121", "value": 111.730003 },
					{ "name": "AAPL", "date": "20161122", "value": 111.800003 },
					{ "name": "AAPL", "date": "20161123", "value": 111.230003 },
					{ "name": "AAPL", "date": "20161125", "value": 111.790001 },
					{ "name": "AAPL", "date": "20161128", "value": 111.57 },
					{ "name": "AAPL", "date": "20161129", "value": 111.459999 },
					{ "name": "AAPL", "date": "20161130", "value": 110.519997 },
					{ "name": "AAPL", "date": "20161201", "value": 109.489998 },
					{ "name": "AAPL", "date": "20161202", "value": 109.900002 },
					{ "name": "AAPL", "date": "20161205", "value": 109.110001 },
					{ "name": "AAPL", "date": "20161206", "value": 109.949997 },
					{ "name": "AAPL", "date": "20161207", "value": 111.029999 },
					{ "name": "AAPL", "date": "20161208", "value": 112.120003 },
					{ "name": "AAPL", "date": "20161209", "value": 113.949997 },
					{ "name": "AAPL", "date": "20161212", "value": 113.300003 },
					{ "name": "AAPL", "date": "20161213", "value": 115.190002 },
					{ "name": "AAPL", "date": "20161214", "value": 115.190002 },
					{ "name": "AAPL", "date": "20161215", "value": 115.82 },
					{ "name": "AAPL", "date": "20161216", "value": 115.970001 },
					{ "name": "AAPL", "date": "20161219", "value": 116.639999 },
					{ "name": "AAPL", "date": "20161220", "value": 116.949997 },
					{ "name": "AAPL", "date": "20161221", "value": 117.059998 },
					{ "name": "AAPL", "date": "20161222", "value": 116.290001 },
					{ "name": "AAPL", "date": "20161223", "value": 116.519997 },
					{ "name": "AAPL", "date": "20161227", "value": 117.260002 },
					{ "name": "AAPL", "date": "20161228", "value": 116.760002 },
					{ "name": "AAPL", "date": "20161229", "value": 116.730003 },
					{ "name": "AAPL", "date": "20161230", "value": 115.82 },
					{ "name": "AAPL", "date": "20170103", "value": 116.150002 },
					{ "name": "AAPL", "date": "20170104", "value": 116.019997 },
					{ "name": "AAPL", "date": "20170105", "value": 116.610001 },
					{ "name": "AAPL", "date": "20170106", "value": 117.910004 },
					{ "name": "AAPL", "date": "20170109", "value": 118.989998 },
					{ "name": "AAPL", "date": "20170110", "value": 119.110001 },
					{ "name": "AAPL", "date": "20170111", "value": 119.75 },
					{ "name": "AAPL", "date": "20170112", "value": 119.25 },
					{ "name": "AAPL", "date": "20170113", "value": 119.040001 },
					{ "name": "AAPL", "date": "20170117", "value": 120 },
					{ "name": "AAPL", "date": "20170118", "value": 119.989998 },
					{ "name": "AAPL", "date": "20170119", "value": 119.779999 },
					{ "name": "AAPL", "date": "20170120", "value": 120 },
					{ "name": "AAPL", "date": "20170123", "value": 120.080002 },
					{ "name": "AAPL", "date": "20170124", "value": 119.970001 },
					{ "name": "AAPL", "date": "20170125", "value": 121.879997 },
					{ "name": "AAPL", "date": "20170126", "value": 121.940002 },
					{ "name": "AAPL", "date": "20170127", "value": 121.949997 },
					{ "name": "AAPL", "date": "20170130", "value": 121.629997 },
					{ "name": "AAPL", "date": "20170131", "value": 121.349998 },
					{ "name": "AAPL", "date": "20170201", "value": 128.75 },
					{ "name": "AAPL", "date": "20170202", "value": 128.529999 },
					{ "name": "AAPL", "date": "20170203", "value": 129.080002 },
					{ "name": "AAPL", "date": "20170206", "value": 130.289993 },
					{ "name": "AAPL", "date": "20170207", "value": 131.529999 },
					{ "name": "AAPL", "date": "20170208", "value": 132.039993 },
					{ "name": "AAPL", "date": "20170209", "value": 132.419998 },
					{ "name": "AAPL", "date": "20170210", "value": 132.119995 },
					{ "name": "AAPL", "date": "20170213", "value": 133.289993 },
					{ "name": "AAPL", "date": "20170214", "value": 135.020004 },
					{ "name": "AAPL", "date": "20170215", "value": 135.509995 },
					{ "name": "AAPL", "date": "20170216", "value": 135.350006 },
					{ "name": "AAPL", "date": "20170217", "value": 135.720001 },
					{ "name": "AAPL", "date": "20170221", "value": 136.699997 },
					{ "name": "AAPL", "date": "20170222", "value": 137.110001 },
					{ "name": "AAPL", "date": "20170223", "value": 136.529999 },
					{ "name": "AAPL", "date": "20170224", "value": 136.660004 },
					{ "name": "AAPL", "date": "20170227", "value": 136.929993 },
					{ "name": "AAPL", "date": "20170228", "value": 136.990005 },
					{ "name": "AAPL", "date": "20170301", "value": 139.789993 },
					{ "name": "AAPL", "date": "20170302", "value": 138.960007 },
					{ "name": "AAPL", "date": "20170303", "value": 139.779999 },
					{ "name": "AAPL", "date": "20170306", "value": 139.339996 },
					{ "name": "AAPL", "date": "20170307", "value": 139.520004 },
					{ "name": "AAPL", "date": "20170308", "value": 139 },
					{ "name": "AAPL", "date": "20170309", "value": 138.679993 },
					{ "name": "AAPL", "date": "20170310", "value": 139.139999 },
					{ "name": "AAPL", "date": "20170313", "value": 139.199997 },
					{ "name": "AAPL", "date": "20170314", "value": 138.990005 },
					{ "name": "AAPL", "date": "20170315", "value": 140.460007 },
					{ "name": "AAPL", "date": "20170316", "value": 140.690002 },
					{ "name": "AAPL", "date": "20170317", "value": 139.990005 },
					{ "name": "AAPL", "date": "20170320", "value": 141.460007 },
					{ "name": "AAPL", "date": "20170321", "value": 139.839996 },
					{ "name": "AAPL", "date": "20170322", "value": 141.419998 },
					{ "name": "AAPL", "date": "20170323", "value": 140.919998 },
					{ "name": "AAPL", "date": "20170324", "value": 140.639999 },
					{ "name": "AAPL", "date": "20170327", "value": 140.880005 },
					{ "name": "AAPL", "date": "20170328", "value": 143.800003 },
					{ "name": "AAPL", "date": "20170329", "value": 144.119995 },
					{ "name": "AAPL", "date": "20170330", "value": 143.929993 },
					{ "name": "AAPL", "date": "20170331", "value": 143.660004 },
					{ "name": "AAPL", "date": "20170403", "value": 143.699997 },
					{ "name": "AAPL", "date": "20170404", "value": 144.770004 },
					{ "name": "AAPL", "date": "20170405", "value": 144.020004 },
					{ "name": "AAPL", "date": "20170406", "value": 143.660004 },
					{ "name": "AAPL", "date": "20170407", "value": 143.339996 },
					{ "name": "AAPL", "date": "20170410", "value": 143.169998 },
					{ "name": "AAPL", "date": "20170411", "value": 141.630005 },
					{ "name": "AAPL", "date": "20170412", "value": 141.800003 },
					{ "name": "AAPL", "date": "20170413", "value": 141.050003 },
					{ "name": "AAPL", "date": "20170417", "value": 141.830002 },
					{ "name": "AAPL", "date": "20170418", "value": 141.199997 },
					{ "name": "AAPL", "date": "20170419", "value": 140.679993 },
					{ "name": "AAPL", "date": "20170420", "value": 142.440002 },
					{ "name": "AAPL", "date": "20170421", "value": 142.270004 },
					{ "name": "AAPL", "date": "20170424", "value": 143.639999 },
					{ "name": "AAPL", "date": "20170425", "value": 144.529999 },
					{ "name": "AAPL", "date": "20170426", "value": 143.679993 },
					{ "name": "AAPL", "date": "20170427", "value": 143.789993 },
					{ "name": "AAPL", "date": "20170428", "value": 143.649994 },
					{ "name": "AAPL", "date": "20170501", "value": 146.580002 },
					{ "name": "AAPL", "date": "20170502", "value": 147.509995 },
					{ "name": "AAPL", "date": "20170503", "value": 147.059998 },
					{ "name": "AAPL", "date": "20170504", "value": 146.529999 },
					{ "name": "AAPL", "date": "20170505", "value": 148.960007 },
					{ "name": "AAPL", "date": "20170508", "value": 153.009995 },
					{ "name": "AAPL", "date": "20170509", "value": 153.990005 },
					{ "name": "AAPL", "date": "20170510", "value": 153.259995 },
					{ "name": "AAPL", "date": "20170511", "value": 153.949997 },
					{ "name": "AAPL", "date": "20170512", "value": 156.100006 },
					{ "name": "AAPL", "date": "20170515", "value": 155.699997 },
					{ "name": "AAPL", "date": "20170516", "value": 155.470001 },
					{ "name": "AAPL", "date": "20170517", "value": 150.25 },
					{ "name": "AAPL", "date": "20170518", "value": 152.539993 },
					{ "name": "AAPL", "date": "20170519", "value": 153.059998 },
					{ "name": "AAPL", "date": "20170522", "value": 153.990005 },
					{ "name": "AAPL", "date": "20170523", "value": 153.800003 },
					{ "name": "AAPL", "date": "20170524", "value": 153.339996 },
					{ "name": "AAPL", "date": "20170525", "value": 153.869995 },
					{ "name": "AAPL", "date": "20170526", "value": 153.610001 },
					{ "name": "AAPL", "date": "20170530", "value": 153.669998 },
					{ "name": "AAPL", "date": "20170531", "value": 152.759995 },
					{ "name": "AAPL", "date": "20170601", "value": 153.179993 },
					{ "name": "AAPL", "date": "20170602", "value": 155.449997 },
					{ "name": "AAPL", "date": "20170605", "value": 153.929993 },
					{ "name": "AAPL", "date": "20170606", "value": 154.449997 },
					{ "name": "AAPL", "date": "20170607", "value": 155.369995 },
					{ "name": "AAPL", "date": "20170608", "value": 154.990005 },
					{ "name": "AAPL", "date": "20170609", "value": 148.979996 },
					{ "name": "AAPL", "date": "20170612", "value": 145.419998 },
					{ "name": "AAPL", "date": "20170613", "value": 146.589996 },
					{ "name": "AAPL", "date": "20170614", "value": 145.160004 },
					{ "name": "AAPL", "date": "20170615", "value": 144.289993 },
					{ "name": "AAPL", "date": "20170616", "value": 142.270004 },
					{ "name": "AAPL", "date": "20170619", "value": 146.339996 },
					{ "name": "AAPL", "date": "20170620", "value": 145.009995 },
					{ "name": "AAPL", "date": "20170621", "value": 145.869995 },
					{ "name": "AAPL", "date": "20170622", "value": 145.630005 },
					{ "name": "AAPL", "date": "20170623", "value": 146.279999 },
					{ "name": "AAPL", "date": "20170626", "value": 145.820007 },
					{ "name": "AAPL", "date": "20170627", "value": 143.729996 },
					{ "name": "AAPL", "date": "20170628", "value": 145.830002 },
					{ "name": "AAPL", "date": "20170629", "value": 143.679993 },
					{ "name": "AAPL", "date": "20170630", "value": 144.020004 },
					{ "name": "AAPL", "date": "20170703", "value": 143.5 },
					{ "name": "AAPL", "date": "20170705", "value": 144.089996 },
					{ "name": "AAPL", "date": "20170706", "value": 142.729996 },
					{ "name": "AAPL", "date": "20170707", "value": 144.179993 },
					{ "name": "AAPL", "date": "20170710", "value": 145.059998 },
					{ "name": "AAPL", "date": "20170711", "value": 145.529999 },
					{ "name": "AAPL", "date": "20170712", "value": 145.740005 },
					{ "name": "AAPL", "date": "20170713", "value": 147.770004 },
					{ "name": "AAPL", "date": "20170714", "value": 149.039993 },
					{ "name": "AAPL", "date": "20170717", "value": 149.559998 },
					{ "name": "AAPL", "date": "20170718", "value": 150.080002 },
					{ "name": "AAPL", "date": "20170719", "value": 151.020004 },
					{ "name": "AAPL", "date": "20170720", "value": 150.339996 },
					{ "name": "AAPL", "date": "20170721", "value": 150.270004 },
					{ "name": "AAPL", "date": "20170724", "value": 152.089996 },
					{ "name": "AAPL", "date": "20170725", "value": 152.740005 },
					{ "name": "AAPL", "date": "20170726", "value": 153.460007 },
					{ "name": "AAPL", "date": "20170727", "value": 150.559998 },
					{ "name": "AAPL", "date": "20170728", "value": 149.5 },
					{ "name": "AAPL", "date": "20170731", "value": 148.729996 },
					{ "name": "AAPL", "date": "20170801", "value": 150.050003 },
					{ "name": "AAPL", "date": "20170802", "value": 157.139999 },
					{ "name": "AAPL", "date": "20170803", "value": 155.570007 },
					{ "name": "AAPL", "date": "20170804", "value": 156.389999 },
					{ "name": "AAPL", "date": "20170807", "value": 158.809998 },
					{ "name": "AAPL", "date": "20170808", "value": 160.080002 },
					{ "name": "AAPL", "date": "20170809", "value": 161.059998 },
					{ "name": "AAPL", "date": "20170810", "value": 155.320007 },
					{ "name": "AAPL", "date": "20170811", "value": 157.479996 },
					{ "name": "AAPL", "date": "20170814", "value": 159.850006 },
					{ "name": "AAPL", "date": "20170815", "value": 161.600006 },
					{ "name": "AAPL", "date": "20170816", "value": 160.949997 },
					{ "name": "AAPL", "date": "20170817", "value": 157.860001 },
					{ "name": "AAPL", "date": "20170818", "value": 157.5 },
					{ "name": "AAPL", "date": "20170821", "value": 157.210007 },
					{ "name": "AAPL", "date": "20170822", "value": 159.779999 },
					{ "name": "AAPL", "date": "20170823", "value": 159.979996 },
					{ "name": "AAPL", "date": "20170824", "value": 159.270004 },
					{ "name": "AAPL", "date": "20170825", "value": 159.860001 },
					{ "name": "AAPL", "date": "20170828", "value": 161.470001 },
					{ "name": "AAPL", "date": "20170829", "value": 162.910004 },
					{ "name": "AAPL", "date": "20170830", "value": 163.350006 },
					{ "name": "AAPL", "date": "20170831", "value": 164 },
					{ "name": "AAPL", "date": "20170901", "value": 164.050003 },
					{ "name": "AAPL", "date": "20170905", "value": 162.080002 },
					{ "name": "AAPL", "date": "20170906", "value": 161.910004 },
					{ "name": "AAPL", "date": "20170907", "value": 161.259995 },
					{ "name": "AAPL", "date": "20170908", "value": 158.630005 },
					{ "name": "AAPL", "date": "20170911", "value": 161.5 },
					{ "name": "AAPL", "date": "20170912", "value": 160.860001 },
					{ "name": "AAPL", "date": "20170913", "value": 159.649994 },
					{ "name": "AAPL", "date": "20170914", "value": 158.279999 },
					{ "name": "AAPL", "date": "20170915", "value": 159.880005 },
					{ "name": "AAPL", "date": "20170918", "value": 158.669998 },
					{ "name": "AAPL", "date": "20170919", "value": 158.729996 },
					{ "name": "AAPL", "date": "20170920", "value": 156.070007 },
					{ "name": "AAPL", "date": "20170921", "value": 153.389999 },
					{ "name": "AAPL", "date": "20170922", "value": 151.889999 },
					{ "name": "AAPL", "date": "20170925", "value": 150.550003 },
					{ "name": "AAPL", "date": "20170926", "value": 153.139999 },
					{ "name": "AAPL", "date": "20170927", "value": 154.229996 },
					{ "name": "AAPL", "date": "20170928", "value": 153.279999 },
					{ "name": "AAPL", "date": "20170929", "value": 154.119995 },
					{ "name": "AAPL", "date": "20171002", "value": 153.809998 },
					{ "name": "AAPL", "date": "20171003", "value": 154.479996 },
					{ "name": "AAPL", "date": "20171004", "value": 153.479996 },
					{ "name": "AAPL", "date": "20171005", "value": 155.389999 },
					{ "name": "AAPL", "date": "20171006", "value": 155.300003 },
					{ "name": "AAPL", "date": "20171009", "value": 155.839996 },
					{ "name": "AAPL", "date": "20171010", "value": 155.899994 },
					{ "name": "AAPL", "date": "20171011", "value": 156.550003 },
					{ "name": "AAPL", "date": "20171012", "value": 156 },
					{ "name": "AAPL", "date": "20171013", "value": 156.990005 },
					{ "name": "AAPL", "date": "20171016", "value": 159.880005 },
					{ "name": "AAPL", "date": "20171017", "value": 160.470001 },
					{ "name": "AAPL", "date": "20171018", "value": 159.759995 },
					{ "name": "AAPL", "date": "20171019", "value": 155.979996 },
					{ "name": "AAPL", "date": "20171020", "value": 156.25 },
					{ "name": "AAPL", "date": "20171023", "value": 156.169998 },
					{ "name": "AAPL", "date": "20171024", "value": 157.100006 },
					{ "name": "AAPL", "date": "20171025", "value": 156.410004 },
					{ "name": "AAPL", "date": "20171026", "value": 157.410004 },
					{ "name": "AAPL", "date": "20171027", "value": 163.050003 },
					{ "name": "AAPL", "date": "20171030", "value": 166.720001 },
					{ "name": "AAPL", "date": "20171031", "value": 169.039993 },
					{ "name": "AAPL", "date": "20171101", "value": 166.889999 },
					{ "name": "AAPL", "date": "20171102", "value": 168.110001 },
					{ "name": "AAPL", "date": "20171103", "value": 172.5 },
					{ "name": "AAPL", "date": "20171106", "value": 174.25 },
					{ "name": "AAPL", "date": "20171107", "value": 174.809998 },
					{ "name": "AAPL", "date": "20171108", "value": 176.240005 },
					{ "name": "AAPL", "date": "20171109", "value": 175.880005 },
					{ "name": "AAPL", "date": "20171110", "value": 174.669998 },
					{ "name": "AAPL", "date": "20171113", "value": 173.970001 },
					{ "name": "AAPL", "date": "20171114", "value": 171.339996 },
					{ "name": "AAPL", "date": "20171115", "value": 169.080002 },
					{ "name": "AAPL", "date": "20171116", "value": 171.100006 },
					{ "name": "AAPL", "date": "20171117", "value": 170.149994 },
					{ "name": "AAPL", "date": "20171120", "value": 169.979996 },
					{ "name": "AAPL", "date": "20171121", "value": 173.139999 },
					{ "name": "AAPL", "date": "20171122", "value": 174.960007 },
					{ "name": "AAPL", "date": "20171124", "value": 174.970001 },
					{ "name": "AAPL", "date": "20171127", "value": 174.089996 },
					{ "name": "AAPL", "date": "20171128", "value": 173.070007 },
					{ "name": "AAPL", "date": "20171129", "value": 169.479996 },
					{ "name": "AAPL", "date": "20171130", "value": 171.850006 },
					{ "name": "AAPL", "date": "20171201", "value": 171.050003 },
					{ "name": "AAPL", "date": "20171204", "value": 169.800003 },
					{ "name": "AAPL", "date": "20171205", "value": 169.639999 },
					{ "name": "AAPL", "date": "20171206", "value": 169.009995 },
					{ "name": "AAPL", "date": "20171207", "value": 169.320007 },
					{ "name": "AAPL", "date": "20171208", "value": 169.369995 },
					{ "name": "AAPL", "date": "20171211", "value": 172.669998 },
					{ "name": "AAPL", "date": "20171212", "value": 171.699997 },
					{ "name": "AAPL", "date": "20171213", "value": 172.270004 },
					{ "name": "AAPL", "date": "20171214", "value": 172.220001 },
					{ "name": "AAPL", "date": "20171215", "value": 173.970001 },
					{ "name": "AAPL", "date": "20171218", "value": 176.419998 },
					{ "name": "AAPL", "date": "20171219", "value": 174.539993 },
					{ "name": "AAPL", "date": "20171220", "value": 174.350006 },
					{ "name": "AAPL", "date": "20171221", "value": 175.009995 },
					{ "name": "AAPL", "date": "20171222", "value": 175.009995 },
					{ "name": "AAPL", "date": "20171226", "value": 170.570007 },
					{ "name": "AAPL", "date": "20171227", "value": 170.600006 },
					{ "name": "AAPL", "date": "20171228", "value": 171.080002 },
					{ "name": "AAPL", "date": "20171229", "value": 169.229996 },
					{ "name": "AAPL", "date": "20180102", "value": 172.259995 },
					{ "name": "AAPL", "date": "20180103", "value": 172.229996 },
					{ "name": "AAPL", "date": "20180104", "value": 173.029999 },
					{ "name": "AAPL", "date": "20180105", "value": 175 },
					{ "name": "AAPL", "date": "20180108", "value": 174.350006 },
					{ "name": "AAPL", "date": "20180109", "value": 174.330002 },
					{ "name": "AAPL", "date": "20180110", "value": 174.289993 },
					{ "name": "AAPL", "date": "20180111", "value": 175.279999 },
					{ "name": "AAPL", "date": "20180112", "value": 177.089996 },
					{ "name": "AAPL", "date": "20180116", "value": 176.190002 },
					{ "name": "AAPL", "date": "20180117", "value": 179.100006 },
					{ "name": "AAPL", "date": "20180118", "value": 179.259995 },
					{ "name": "AAPL", "date": "20180119", "value": 178.460007 },
					{ "name": "AAPL", "date": "20180122", "value": 177 },
					{ "name": "AAPL", "date": "20180123", "value": 177.039993 },
					{ "name": "AAPL", "date": "20180124", "value": 174.220001 },
					{ "name": "AAPL", "date": "20180125", "value": 171.110001 },
					{ "name": "AAPL", "date": "20180126", "value": 171.509995 },
					{ "name": "AAPL", "date": "20180129", "value": 167.960007 },
					{ "name": "AAPL", "date": "20180130", "value": 166.970001 },
					{ "name": "AAPL", "date": "20180131", "value": 167.429993 },
					{ "name": "AAPL", "date": "20180201", "value": 167.779999 },
					{ "name": "AAPL", "date": "20180202", "value": 160.5 },
					{ "name": "AAPL", "date": "20180205", "value": 156.490005 },
					{ "name": "AAPL", "date": "20180206", "value": 163.029999 },
					{ "name": "AAPL", "date": "20180207", "value": 159.539993 },
					{ "name": "AAPL", "date": "20180208", "value": 155.149994 },
					{ "name": "AAPL", "date": "20180209", "value": 156.410004 },
					{ "name": "AAPL", "date": "20180212", "value": 162.710007 },
					{ "name": "AAPL", "date": "20180213", "value": 164.339996 },
					{ "name": "AAPL", "date": "20180214", "value": 167.369995 },
					{ "name": "AAPL", "date": "20180215", "value": 172.990005 },
					{ "name": "AAPL", "date": "20180216", "value": 172.429993 },
					{ "name": "AAPL", "date": "20180220", "value": 171.850006 },
					{ "name": "AAPL", "date": "20180221", "value": 171.070007 },
					{ "name": "AAPL", "date": "20180222", "value": 172.5 },
					{ "name": "AAPL", "date": "20180223", "value": 175.5 },
					{ "name": "AAPL", "date": "20180226", "value": 178.970001 },
					{ "name": "AAPL", "date": "20180227", "value": 178.389999 },
					{ "name": "AAPL", "date": "20180228", "value": 178.119995 },
					{ "name": "AAPL", "date": "20180301", "value": 175 },
					{ "name": "AAPL", "date": "20180302", "value": 176.210007 },
					{ "name": "AAPL", "date": "20180305", "value": 176.820007 },
					{ "name": "AAPL", "date": "20180306", "value": 176.669998 },
					{ "name": "AAPL", "date": "20180307", "value": 175.029999 },
					{ "name": "AAPL", "date": "20180308", "value": 176.940002 },
					{ "name": "AAPL", "date": "20180309", "value": 179.979996 },
					{ "name": "AAPL", "date": "20180312", "value": 181.720001 },
					{ "name": "AAPL", "date": "20180313", "value": 179.970001 },
					{ "name": "AAPL", "date": "20180314", "value": 178.440002 },
					{ "name": "AAPL", "date": "20180315", "value": 178.649994 },
					{ "name": "AAPL", "date": "20180316", "value": 178.020004 },
					{ "name": "AAPL", "date": "20180319", "value": 175.300003 },
					{ "name": "AAPL", "date": "20180320", "value": 175.240005 },
					{ "name": "AAPL", "date": "20180321", "value": 171.270004 },
					{ "name": "AAPL", "date": "20180322", "value": 168.850006 },
					{ "name": "AAPL", "date": "20180323", "value": 164.940002 },
					{ "name": "AAPL", "date": "20180326", "value": 172.770004 },
					{ "name": "AAPL", "date": "20180327", "value": 168.339996 },
					{ "name": "AAPL", "date": "20180328", "value": 166.479996 },
					{ "name": "AAPL", "date": "20180329", "value": 167.779999 },
					{ "name": "AAPL", "date": "20180402", "value": 166.679993 },
					{ "name": "AAPL", "date": "20180403", "value": 168.389999 },
					{ "name": "AAPL", "date": "20180404", "value": 171.610001 },
					{ "name": "AAPL", "date": "20180405", "value": 172.800003 },
					{ "name": "AAPL", "date": "20180406", "value": 168.380005 },
					{ "name": "AAPL", "date": "20180409", "value": 170.050003 },
					{ "name": "AAPL", "date": "20180410", "value": 173.25 },
					{ "name": "AAPL", "date": "20180411", "value": 172.440002 },
					{ "name": "AAPL", "date": "20180412", "value": 174.139999 },
					{ "name": "AAPL", "date": "20180413", "value": 174.729996 },
					{ "name": "AAPL", "date": "20180416", "value": 175.820007 },
					{ "name": "AAPL", "date": "20180417", "value": 178.240005 },
					{ "name": "AAPL", "date": "20180418", "value": 177.839996 },
					{ "name": "AAPL", "date": "20180419", "value": 172.800003 },
					{ "name": "AAPL", "date": "20180420", "value": 165.720001 },
					{ "name": "AAPL", "date": "20180423", "value": 165.240005 },
					{ "name": "AAPL", "date": "20180424", "value": 162.940002 },
					{ "name": "AAPL", "date": "20180425", "value": 163.649994 },
					{ "name": "AAPL", "date": "20180426", "value": 164.220001 },
					{ "name": "AAPL", "date": "20180427", "value": 162.320007 },
					{ "name": "AAPL", "date": "20180430", "value": 165.259995 },
					{ "name": "AAPL", "date": "20180501", "value": 169.100006 },
					{ "name": "AAPL", "date": "20180502", "value": 176.570007 },
					{ "name": "AAPL", "date": "20180503", "value": 176.889999 },
					{ "name": "AAPL", "date": "20180504", "value": 183.830002 },
					{ "name": "AAPL", "date": "20180507", "value": 185.160004 },
					{ "name": "AAPL", "date": "20180508", "value": 186.050003 },
					{ "name": "AAPL", "date": "20180509", "value": 187.360001 },
					{ "name": "AAPL", "date": "20180510", "value": 190.039993 },
					{ "name": "AAPL", "date": "20180511", "value": 188.589996 },
					{ "name": "AMZN", "date": "20130513", "value": 264.51001 },
					{ "name": "AMZN", "date": "20130514", "value": 268.329987 },
					{ "name": "AMZN", "date": "20130515", "value": 266.559998 },
					{ "name": "AMZN", "date": "20130516", "value": 264.119995 },
					{ "name": "AMZN", "date": "20130517", "value": 269.899994 },
					{ "name": "AMZN", "date": "20130520", "value": 267.630005 },
					{ "name": "AMZN", "date": "20130521", "value": 268.859985 },
					{ "name": "AMZN", "date": "20130522", "value": 262.959991 },
					{ "name": "AMZN", "date": "20130523", "value": 261.799988 },
					{ "name": "AMZN", "date": "20130524", "value": 261.73999 },
					{ "name": "AMZN", "date": "20130528", "value": 267.290009 },
					{ "name": "AMZN", "date": "20130529", "value": 265.529999 },
					{ "name": "AMZN", "date": "20130530", "value": 266.829987 },
					{ "name": "AMZN", "date": "20130531", "value": 269.200012 },
					{ "name": "AMZN", "date": "20130603", "value": 266.880005 },
					{ "name": "AMZN", "date": "20130604", "value": 265.700012 },
					{ "name": "AMZN", "date": "20130605", "value": 267.170013 },
					{ "name": "AMZN", "date": "20130606", "value": 267.829987 },
					{ "name": "AMZN", "date": "20130607", "value": 276.869995 },
					{ "name": "AMZN", "date": "20130610", "value": 281.070007 },
					{ "name": "AMZN", "date": "20130611", "value": 274.779999 },
					{ "name": "AMZN", "date": "20130612", "value": 271.670013 },
					{ "name": "AMZN", "date": "20130613", "value": 275.790009 },
					{ "name": "AMZN", "date": "20130614", "value": 273.98999 },
					{ "name": "AMZN", "date": "20130617", "value": 278.059998 },
					{ "name": "AMZN", "date": "20130618", "value": 281.76001 },
					{ "name": "AMZN", "date": "20130619", "value": 278.160004 },
					{ "name": "AMZN", "date": "20130620", "value": 273.440002 },
					{ "name": "AMZN", "date": "20130621", "value": 273.359985 },
					{ "name": "AMZN", "date": "20130624", "value": 270.609985 },
					{ "name": "AMZN", "date": "20130625", "value": 272.089996 },
					{ "name": "AMZN", "date": "20130626", "value": 277.570007 },
					{ "name": "AMZN", "date": "20130627", "value": 277.549988 },
					{ "name": "AMZN", "date": "20130628", "value": 277.690002 },
					{ "name": "AMZN", "date": "20130701", "value": 282.100006 },
					{ "name": "AMZN", "date": "20130702", "value": 283.730011 },
					{ "name": "AMZN", "date": "20130703", "value": 284.029999 },
					{ "name": "AMZN", "date": "20130705", "value": 285.880005 },
					{ "name": "AMZN", "date": "20130708", "value": 290.589996 },
					{ "name": "AMZN", "date": "20130709", "value": 291.529999 },
					{ "name": "AMZN", "date": "20130710", "value": 292.329987 },
					{ "name": "AMZN", "date": "20130711", "value": 299.660004 },
					{ "name": "AMZN", "date": "20130712", "value": 307.549988 },
					{ "name": "AMZN", "date": "20130715", "value": 306.570007 },
					{ "name": "AMZN", "date": "20130716", "value": 306.869995 },
					{ "name": "AMZN", "date": "20130717", "value": 308.690002 },
					{ "name": "AMZN", "date": "20130718", "value": 304.109985 },
					{ "name": "AMZN", "date": "20130719", "value": 305.230011 },
					{ "name": "AMZN", "date": "20130722", "value": 303.480011 },
					{ "name": "AMZN", "date": "20130723", "value": 301.059998 },
					{ "name": "AMZN", "date": "20130724", "value": 298.940002 },
					{ "name": "AMZN", "date": "20130725", "value": 303.399994 },
					{ "name": "AMZN", "date": "20130726", "value": 312.01001 },
					{ "name": "AMZN", "date": "20130729", "value": 306.100006 },
					{ "name": "AMZN", "date": "20130730", "value": 302.410004 },
					{ "name": "AMZN", "date": "20130731", "value": 301.220001 },
					{ "name": "AMZN", "date": "20130801", "value": 305.570007 },
					{ "name": "AMZN", "date": "20130802", "value": 304.209991 },
					{ "name": "AMZN", "date": "20130805", "value": 300.98999 },
					{ "name": "AMZN", "date": "20130806", "value": 300.75 },
					{ "name": "AMZN", "date": "20130807", "value": 296.910004 },
					{ "name": "AMZN", "date": "20130808", "value": 295.73999 },
					{ "name": "AMZN", "date": "20130809", "value": 297.26001 },
					{ "name": "AMZN", "date": "20130812", "value": 296.690002 },
					{ "name": "AMZN", "date": "20130813", "value": 293.970001 },
					{ "name": "AMZN", "date": "20130814", "value": 291.339996 },
					{ "name": "AMZN", "date": "20130815", "value": 286.470001 },
					{ "name": "AMZN", "date": "20130816", "value": 284.820007 },
					{ "name": "AMZN", "date": "20130819", "value": 285.570007 },
					{ "name": "AMZN", "date": "20130820", "value": 287.089996 },
					{ "name": "AMZN", "date": "20130821", "value": 284.570007 },
					{ "name": "AMZN", "date": "20130822", "value": 289.730011 },
					{ "name": "AMZN", "date": "20130823", "value": 290.01001 },
					{ "name": "AMZN", "date": "20130826", "value": 286.209991 },
					{ "name": "AMZN", "date": "20130827", "value": 280.929993 },
					{ "name": "AMZN", "date": "20130828", "value": 281.579987 },
					{ "name": "AMZN", "date": "20130829", "value": 283.980011 },
					{ "name": "AMZN", "date": "20130830", "value": 280.980011 },
					{ "name": "AMZN", "date": "20130903", "value": 288.799988 },
					{ "name": "AMZN", "date": "20130904", "value": 293.640015 },
					{ "name": "AMZN", "date": "20130905", "value": 294.100006 },
					{ "name": "AMZN", "date": "20130906", "value": 295.859985 },
					{ "name": "AMZN", "date": "20130909", "value": 299.709991 },
					{ "name": "AMZN", "date": "20130910", "value": 300.359985 },
					{ "name": "AMZN", "date": "20130911", "value": 299.640015 },
					{ "name": "AMZN", "date": "20130912", "value": 298.859985 },
					{ "name": "AMZN", "date": "20130913", "value": 297.920013 },
					{ "name": "AMZN", "date": "20130916", "value": 296.059998 },
					{ "name": "AMZN", "date": "20130917", "value": 304.170013 },
					{ "name": "AMZN", "date": "20130918", "value": 312.029999 },
					{ "name": "AMZN", "date": "20130919", "value": 312.059998 },
					{ "name": "AMZN", "date": "20130920", "value": 316.339996 },
					{ "name": "AMZN", "date": "20130923", "value": 311.48999 },
					{ "name": "AMZN", "date": "20130924", "value": 314.130005 },
					{ "name": "AMZN", "date": "20130925", "value": 312.649994 },
					{ "name": "AMZN", "date": "20130926", "value": 318.119995 },
					{ "name": "AMZN", "date": "20130927", "value": 316.01001 },
					{ "name": "AMZN", "date": "20130930", "value": 312.640015 },
					{ "name": "AMZN", "date": "20131001", "value": 320.950012 },
					{ "name": "AMZN", "date": "20131002", "value": 320.51001 },
					{ "name": "AMZN", "date": "20131003", "value": 314.76001 },
					{ "name": "AMZN", "date": "20131004", "value": 319.040009 },
					{ "name": "AMZN", "date": "20131007", "value": 310.029999 },
					{ "name": "AMZN", "date": "20131008", "value": 303.230011 },
					{ "name": "AMZN", "date": "20131009", "value": 298.230011 },
					{ "name": "AMZN", "date": "20131010", "value": 305.170013 },
					{ "name": "AMZN", "date": "20131011", "value": 310.890015 },
					{ "name": "AMZN", "date": "20131014", "value": 310.700012 },
					{ "name": "AMZN", "date": "20131015", "value": 306.399994 },
					{ "name": "AMZN", "date": "20131016", "value": 310.48999 },
					{ "name": "AMZN", "date": "20131017", "value": 310.769989 },
					{ "name": "AMZN", "date": "20131018", "value": 328.929993 },
					{ "name": "AMZN", "date": "20131021", "value": 326.440002 },
					{ "name": "AMZN", "date": "20131022", "value": 332.540009 },
					{ "name": "AMZN", "date": "20131023", "value": 326.76001 },
					{ "name": "AMZN", "date": "20131024", "value": 332.209991 },
					{ "name": "AMZN", "date": "20131025", "value": 363.390015 },
					{ "name": "AMZN", "date": "20131028", "value": 358.160004 },
					{ "name": "AMZN", "date": "20131029", "value": 362.700012 },
					{ "name": "AMZN", "date": "20131030", "value": 361.079987 },
					{ "name": "AMZN", "date": "20131031", "value": 364.029999 },
					{ "name": "AMZN", "date": "20131101", "value": 359 },
					{ "name": "AMZN", "date": "20131104", "value": 358.73999 },
					{ "name": "AMZN", "date": "20131105", "value": 358.890015 },
					{ "name": "AMZN", "date": "20131106", "value": 356.179993 },
					{ "name": "AMZN", "date": "20131107", "value": 343.559998 },
					{ "name": "AMZN", "date": "20131108", "value": 350.309998 },
					{ "name": "AMZN", "date": "20131111", "value": 354.380005 },
					{ "name": "AMZN", "date": "20131112", "value": 349.529999 },
					{ "name": "AMZN", "date": "20131113", "value": 356.220001 },
					{ "name": "AMZN", "date": "20131114", "value": 367.399994 },
					{ "name": "AMZN", "date": "20131115", "value": 369.170013 },
					{ "name": "AMZN", "date": "20131118", "value": 366.179993 },
					{ "name": "AMZN", "date": "20131119", "value": 364.940002 },
					{ "name": "AMZN", "date": "20131120", "value": 362.570007 },
					{ "name": "AMZN", "date": "20131121", "value": 368.920013 },
					{ "name": "AMZN", "date": "20131122", "value": 372.309998 },
					{ "name": "AMZN", "date": "20131125", "value": 376.640015 },
					{ "name": "AMZN", "date": "20131126", "value": 381.369995 },
					{ "name": "AMZN", "date": "20131127", "value": 386.709991 },
					{ "name": "AMZN", "date": "20131129", "value": 393.619995 },
					{ "name": "AMZN", "date": "20131202", "value": 392.299988 },
					{ "name": "AMZN", "date": "20131203", "value": 384.660004 },
					{ "name": "AMZN", "date": "20131204", "value": 385.959991 },
					{ "name": "AMZN", "date": "20131205", "value": 384.48999 },
					{ "name": "AMZN", "date": "20131206", "value": 386.950012 },
					{ "name": "AMZN", "date": "20131209", "value": 384.890015 },
					{ "name": "AMZN", "date": "20131210", "value": 387.779999 },
					{ "name": "AMZN", "date": "20131211", "value": 382.190002 },
					{ "name": "AMZN", "date": "20131212", "value": 381.25 },
					{ "name": "AMZN", "date": "20131213", "value": 384.23999 },
					{ "name": "AMZN", "date": "20131216", "value": 388.970001 },
					{ "name": "AMZN", "date": "20131217", "value": 387.649994 },
					{ "name": "AMZN", "date": "20131218", "value": 395.959991 },
					{ "name": "AMZN", "date": "20131219", "value": 395.190002 },
					{ "name": "AMZN", "date": "20131220", "value": 402.200012 },
					{ "name": "AMZN", "date": "20131223", "value": 402.920013 },
					{ "name": "AMZN", "date": "20131224", "value": 399.200012 },
					{ "name": "AMZN", "date": "20131226", "value": 404.390015 },
					{ "name": "AMZN", "date": "20131227", "value": 398.079987 },
					{ "name": "AMZN", "date": "20131230", "value": 393.369995 },
					{ "name": "AMZN", "date": "20131231", "value": 398.790009 },
					{ "name": "AMZN", "date": "20140102", "value": 397.970001 },
					{ "name": "AMZN", "date": "20140103", "value": 396.440002 },
					{ "name": "AMZN", "date": "20140106", "value": 393.630005 },
					{ "name": "AMZN", "date": "20140107", "value": 398.029999 },
					{ "name": "AMZN", "date": "20140108", "value": 401.920013 },
					{ "name": "AMZN", "date": "20140109", "value": 401.01001 },
					{ "name": "AMZN", "date": "20140110", "value": 397.660004 },
					{ "name": "AMZN", "date": "20140113", "value": 390.980011 },
					{ "name": "AMZN", "date": "20140114", "value": 397.540009 },
					{ "name": "AMZN", "date": "20140115", "value": 395.869995 },
					{ "name": "AMZN", "date": "20140116", "value": 395.799988 },
					{ "name": "AMZN", "date": "20140117", "value": 399.609985 },
					{ "name": "AMZN", "date": "20140121", "value": 407.049988 },
					{ "name": "AMZN", "date": "20140122", "value": 404.540009 },
					{ "name": "AMZN", "date": "20140123", "value": 399.869995 },
					{ "name": "AMZN", "date": "20140124", "value": 387.600006 },
					{ "name": "AMZN", "date": "20140127", "value": 386.279999 },
					{ "name": "AMZN", "date": "20140128", "value": 394.429993 },
					{ "name": "AMZN", "date": "20140129", "value": 384.200012 },
					{ "name": "AMZN", "date": "20140130", "value": 403.01001 },
					{ "name": "AMZN", "date": "20140131", "value": 358.690002 },
					{ "name": "AMZN", "date": "20140203", "value": 346.149994 },
					{ "name": "AMZN", "date": "20140204", "value": 347.950012 },
					{ "name": "AMZN", "date": "20140205", "value": 346.450012 },
					{ "name": "AMZN", "date": "20140206", "value": 354.589996 },
					{ "name": "AMZN", "date": "20140207", "value": 361.079987 },
					{ "name": "AMZN", "date": "20140210", "value": 360.869995 },
					{ "name": "AMZN", "date": "20140211", "value": 361.790009 },
					{ "name": "AMZN", "date": "20140212", "value": 349.25 },
					{ "name": "AMZN", "date": "20140213", "value": 357.200012 },
					{ "name": "AMZN", "date": "20140214", "value": 357.350006 },
					{ "name": "AMZN", "date": "20140218", "value": 353.649994 },
					{ "name": "AMZN", "date": "20140219", "value": 347.380005 },
					{ "name": "AMZN", "date": "20140220", "value": 349.799988 },
					{ "name": "AMZN", "date": "20140221", "value": 346.76001 },
					{ "name": "AMZN", "date": "20140224", "value": 351.779999 },
					{ "name": "AMZN", "date": "20140225", "value": 358.320007 },
					{ "name": "AMZN", "date": "20140226", "value": 359.799988 },
					{ "name": "AMZN", "date": "20140227", "value": 360.130005 },
					{ "name": "AMZN", "date": "20140228", "value": 362.100006 },
					{ "name": "AMZN", "date": "20140303", "value": 359.779999 },
					{ "name": "AMZN", "date": "20140304", "value": 363.899994 },
					{ "name": "AMZN", "date": "20140305", "value": 372.369995 },
					{ "name": "AMZN", "date": "20140306", "value": 372.160004 },
					{ "name": "AMZN", "date": "20140307", "value": 372.059998 },
					{ "name": "AMZN", "date": "20140310", "value": 370.529999 },
					{ "name": "AMZN", "date": "20140311", "value": 368.820007 },
					{ "name": "AMZN", "date": "20140312", "value": 370.640015 },
					{ "name": "AMZN", "date": "20140313", "value": 371.51001 },
					{ "name": "AMZN", "date": "20140314", "value": 373.73999 },
					{ "name": "AMZN", "date": "20140317", "value": 375.040009 },
					{ "name": "AMZN", "date": "20140318", "value": 378.769989 },
					{ "name": "AMZN", "date": "20140319", "value": 373.230011 },
					{ "name": "AMZN", "date": "20140320", "value": 368.970001 },
					{ "name": "AMZN", "date": "20140321", "value": 360.619995 },
					{ "name": "AMZN", "date": "20140324", "value": 351.850006 },
					{ "name": "AMZN", "date": "20140325", "value": 354.709991 },
					{ "name": "AMZN", "date": "20140326", "value": 343.410004 },
					{ "name": "AMZN", "date": "20140327", "value": 338.470001 },
					{ "name": "AMZN", "date": "20140328", "value": 338.290009 },
					{ "name": "AMZN", "date": "20140331", "value": 336.369995 },
					{ "name": "AMZN", "date": "20140401", "value": 342.98999 },
					{ "name": "AMZN", "date": "20140402", "value": 341.959991 },
					{ "name": "AMZN", "date": "20140403", "value": 333.619995 },
					{ "name": "AMZN", "date": "20140404", "value": 323 },
					{ "name": "AMZN", "date": "20140407", "value": 317.76001 },
					{ "name": "AMZN", "date": "20140408", "value": 327.070007 },
					{ "name": "AMZN", "date": "20140409", "value": 331.809998 },
					{ "name": "AMZN", "date": "20140410", "value": 317.109985 },
					{ "name": "AMZN", "date": "20140411", "value": 311.730011 },
					{ "name": "AMZN", "date": "20140414", "value": 315.910004 },
					{ "name": "AMZN", "date": "20140415", "value": 316.079987 },
					{ "name": "AMZN", "date": "20140416", "value": 323.679993 },
					{ "name": "AMZN", "date": "20140417", "value": 324.910004 },
					{ "name": "AMZN", "date": "20140421", "value": 330.869995 },
					{ "name": "AMZN", "date": "20140422", "value": 329.320007 },
					{ "name": "AMZN", "date": "20140423", "value": 324.579987 },
					{ "name": "AMZN", "date": "20140424", "value": 337.149994 },
					{ "name": "AMZN", "date": "20140425", "value": 303.829987 },
					{ "name": "AMZN", "date": "20140428", "value": 296.579987 },
					{ "name": "AMZN", "date": "20140429", "value": 300.380005 },
					{ "name": "AMZN", "date": "20140430", "value": 304.130005 },
					{ "name": "AMZN", "date": "20140501", "value": 307.890015 },
					{ "name": "AMZN", "date": "20140502", "value": 308.01001 },
					{ "name": "AMZN", "date": "20140505", "value": 310.049988 },
					{ "name": "AMZN", "date": "20140506", "value": 297.380005 },
					{ "name": "AMZN", "date": "20140507", "value": 292.709991 },
					{ "name": "AMZN", "date": "20140508", "value": 288.320007 },
					{ "name": "AMZN", "date": "20140509", "value": 292.23999 },
					{ "name": "AMZN", "date": "20140512", "value": 302.859985 },
					{ "name": "AMZN", "date": "20140513", "value": 304.640015 },
					{ "name": "AMZN", "date": "20140514", "value": 297.619995 },
					{ "name": "AMZN", "date": "20140515", "value": 295.190002 },
					{ "name": "AMZN", "date": "20140516", "value": 297.700012 },
					{ "name": "AMZN", "date": "20140519", "value": 296.76001 },
					{ "name": "AMZN", "date": "20140520", "value": 301.190002 },
					{ "name": "AMZN", "date": "20140521", "value": 305.01001 },
					{ "name": "AMZN", "date": "20140522", "value": 304.910004 },
					{ "name": "AMZN", "date": "20140523", "value": 312.23999 },
					{ "name": "AMZN", "date": "20140527", "value": 310.820007 },
					{ "name": "AMZN", "date": "20140528", "value": 310.160004 },
					{ "name": "AMZN", "date": "20140529", "value": 313.779999 },
					{ "name": "AMZN", "date": "20140530", "value": 312.549988 },
					{ "name": "AMZN", "date": "20140602", "value": 308.839996 },
					{ "name": "AMZN", "date": "20140603", "value": 307.190002 },
					{ "name": "AMZN", "date": "20140604", "value": 306.779999 },
					{ "name": "AMZN", "date": "20140605", "value": 323.570007 },
					{ "name": "AMZN", "date": "20140606", "value": 329.670013 },
					{ "name": "AMZN", "date": "20140609", "value": 327.5 },
					{ "name": "AMZN", "date": "20140610", "value": 332.410004 },
					{ "name": "AMZN", "date": "20140611", "value": 335.200012 },
					{ "name": "AMZN", "date": "20140612", "value": 325.910004 },
					{ "name": "AMZN", "date": "20140613", "value": 326.269989 },
					{ "name": "AMZN", "date": "20140616", "value": 327.619995 },
					{ "name": "AMZN", "date": "20140617", "value": 325.619995 },
					{ "name": "AMZN", "date": "20140618", "value": 334.380005 },
					{ "name": "AMZN", "date": "20140619", "value": 327 },
					{ "name": "AMZN", "date": "20140620", "value": 324.200012 },
					{ "name": "AMZN", "date": "20140623", "value": 327.23999 },
					{ "name": "AMZN", "date": "20140624", "value": 324.160004 },
					{ "name": "AMZN", "date": "20140625", "value": 327.440002 },
					{ "name": "AMZN", "date": "20140626", "value": 325.690002 },
					{ "name": "AMZN", "date": "20140627", "value": 324.570007 },
					{ "name": "AMZN", "date": "20140630", "value": 324.779999 },
					{ "name": "AMZN", "date": "20140701", "value": 332.390015 },
					{ "name": "AMZN", "date": "20140702", "value": 332.850006 },
					{ "name": "AMZN", "date": "20140703", "value": 337.48999 },
					{ "name": "AMZN", "date": "20140707", "value": 333.549988 },
					{ "name": "AMZN", "date": "20140708", "value": 323.809998 },
					{ "name": "AMZN", "date": "20140709", "value": 329.970001 },
					{ "name": "AMZN", "date": "20140710", "value": 327.920013 },
					{ "name": "AMZN", "date": "20140711", "value": 346.200012 },
					{ "name": "AMZN", "date": "20140714", "value": 355.320007 },
					{ "name": "AMZN", "date": "20140715", "value": 354.440002 },
					{ "name": "AMZN", "date": "20140716", "value": 355.899994 },
					{ "name": "AMZN", "date": "20140717", "value": 352.450012 },
					{ "name": "AMZN", "date": "20140718", "value": 358.660004 },
					{ "name": "AMZN", "date": "20140721", "value": 359.76001 },
					{ "name": "AMZN", "date": "20140722", "value": 360.839996 },
					{ "name": "AMZN", "date": "20140723", "value": 358.140015 },
					{ "name": "AMZN", "date": "20140724", "value": 358.609985 },
					{ "name": "AMZN", "date": "20140725", "value": 324.01001 },
					{ "name": "AMZN", "date": "20140728", "value": 320.410004 },
					{ "name": "AMZN", "date": "20140729", "value": 320 },
					{ "name": "AMZN", "date": "20140730", "value": 322.51001 },
					{ "name": "AMZN", "date": "20140731", "value": 312.98999 },
					{ "name": "AMZN", "date": "20140801", "value": 307.059998 },
					{ "name": "AMZN", "date": "20140804", "value": 313.649994 },
					{ "name": "AMZN", "date": "20140805", "value": 312.320007 },
					{ "name": "AMZN", "date": "20140806", "value": 313.890015 },
					{ "name": "AMZN", "date": "20140807", "value": 311.450012 },
					{ "name": "AMZN", "date": "20140808", "value": 316.799988 },
					{ "name": "AMZN", "date": "20140811", "value": 318.329987 },
					{ "name": "AMZN", "date": "20140812", "value": 319.320007 },
					{ "name": "AMZN", "date": "20140813", "value": 326.279999 },
					{ "name": "AMZN", "date": "20140814", "value": 333.209991 },
					{ "name": "AMZN", "date": "20140815", "value": 333.630005 },
					{ "name": "AMZN", "date": "20140818", "value": 334.529999 },
					{ "name": "AMZN", "date": "20140819", "value": 335.130005 },
					{ "name": "AMZN", "date": "20140820", "value": 335.779999 },
					{ "name": "AMZN", "date": "20140821", "value": 332.910004 },
					{ "name": "AMZN", "date": "20140822", "value": 331.589996 },
					{ "name": "AMZN", "date": "20140825", "value": 334.019989 },
					{ "name": "AMZN", "date": "20140826", "value": 341.829987 },
					{ "name": "AMZN", "date": "20140827", "value": 343.179993 },
					{ "name": "AMZN", "date": "20140828", "value": 340.019989 },
					{ "name": "AMZN", "date": "20140829", "value": 339.040009 },
					{ "name": "AMZN", "date": "20140902", "value": 342.380005 },
					{ "name": "AMZN", "date": "20140903", "value": 339 },
					{ "name": "AMZN", "date": "20140904", "value": 345.950012 },
					{ "name": "AMZN", "date": "20140905", "value": 346.380005 },
					{ "name": "AMZN", "date": "20140908", "value": 342.339996 },
					{ "name": "AMZN", "date": "20140909", "value": 329.75 },
					{ "name": "AMZN", "date": "20140910", "value": 331.329987 },
					{ "name": "AMZN", "date": "20140911", "value": 330.519989 },
					{ "name": "AMZN", "date": "20140912", "value": 331.190002 },
					{ "name": "AMZN", "date": "20140915", "value": 323.890015 },
					{ "name": "AMZN", "date": "20140916", "value": 327.76001 },
					{ "name": "AMZN", "date": "20140917", "value": 324 },
					{ "name": "AMZN", "date": "20140918", "value": 325 },
					{ "name": "AMZN", "date": "20140919", "value": 331.320007 },
					{ "name": "AMZN", "date": "20140922", "value": 324.5 },
					{ "name": "AMZN", "date": "20140923", "value": 323.630005 },
					{ "name": "AMZN", "date": "20140924", "value": 328.209991 },
					{ "name": "AMZN", "date": "20140925", "value": 321.929993 },
					{ "name": "AMZN", "date": "20140926", "value": 323.209991 },
					{ "name": "AMZN", "date": "20140929", "value": 321.820007 },
					{ "name": "AMZN", "date": "20140930", "value": 322.440002 },
					{ "name": "AMZN", "date": "20141001", "value": 317.459991 },
					{ "name": "AMZN", "date": "20141002", "value": 318.410004 },
					{ "name": "AMZN", "date": "20141003", "value": 322.73999 },
					{ "name": "AMZN", "date": "20141006", "value": 322.200012 },
					{ "name": "AMZN", "date": "20141007", "value": 316.980011 },
					{ "name": "AMZN", "date": "20141008", "value": 322.700012 },
					{ "name": "AMZN", "date": "20141009", "value": 315.369995 },
					{ "name": "AMZN", "date": "20141010", "value": 311.390015 },
					{ "name": "AMZN", "date": "20141013", "value": 306.450012 },
					{ "name": "AMZN", "date": "20141014", "value": 308.309998 },
					{ "name": "AMZN", "date": "20141015", "value": 305.970001 },
					{ "name": "AMZN", "date": "20141016", "value": 302.859985 },
					{ "name": "AMZN", "date": "20141017", "value": 303.640015 },
					{ "name": "AMZN", "date": "20141020", "value": 306.209991 },
					{ "name": "AMZN", "date": "20141021", "value": 315.329987 },
					{ "name": "AMZN", "date": "20141022", "value": 312.970001 },
					{ "name": "AMZN", "date": "20141023", "value": 313.179993 },
					{ "name": "AMZN", "date": "20141024", "value": 287.059998 },
					{ "name": "AMZN", "date": "20141027", "value": 289.970001 },
					{ "name": "AMZN", "date": "20141028", "value": 295.589996 },
					{ "name": "AMZN", "date": "20141029", "value": 294.119995 },
					{ "name": "AMZN", "date": "20141030", "value": 299.070007 },
					{ "name": "AMZN", "date": "20141031", "value": 305.459991 },
					{ "name": "AMZN", "date": "20141103", "value": 305.720001 },
					{ "name": "AMZN", "date": "20141104", "value": 302.809998 },
					{ "name": "AMZN", "date": "20141105", "value": 296.519989 },
					{ "name": "AMZN", "date": "20141106", "value": 296.640015 },
					{ "name": "AMZN", "date": "20141107", "value": 299.859985 },
					{ "name": "AMZN", "date": "20141110", "value": 305.109985 },
					{ "name": "AMZN", "date": "20141111", "value": 312.01001 },
					{ "name": "AMZN", "date": "20141112", "value": 311.51001 },
					{ "name": "AMZN", "date": "20141113", "value": 316.480011 },
					{ "name": "AMZN", "date": "20141114", "value": 327.820007 },
					{ "name": "AMZN", "date": "20141117", "value": 323.049988 },
					{ "name": "AMZN", "date": "20141118", "value": 324.929993 },
					{ "name": "AMZN", "date": "20141119", "value": 326.540009 },
					{ "name": "AMZN", "date": "20141120", "value": 330.540009 },
					{ "name": "AMZN", "date": "20141121", "value": 332.630005 },
					{ "name": "AMZN", "date": "20141124", "value": 335.640015 },
					{ "name": "AMZN", "date": "20141125", "value": 335.040009 },
					{ "name": "AMZN", "date": "20141126", "value": 333.570007 },
					{ "name": "AMZN", "date": "20141128", "value": 338.640015 },
					{ "name": "AMZN", "date": "20141201", "value": 326 },
					{ "name": "AMZN", "date": "20141202", "value": 326.309998 },
					{ "name": "AMZN", "date": "20141203", "value": 316.5 },
					{ "name": "AMZN", "date": "20141204", "value": 316.929993 },
					{ "name": "AMZN", "date": "20141205", "value": 312.630005 },
					{ "name": "AMZN", "date": "20141208", "value": 306.640015 },
					{ "name": "AMZN", "date": "20141209", "value": 312.5 },
					{ "name": "AMZN", "date": "20141210", "value": 305.839996 },
					{ "name": "AMZN", "date": "20141211", "value": 307.359985 },
					{ "name": "AMZN", "date": "20141212", "value": 307.320007 },
					{ "name": "AMZN", "date": "20141215", "value": 306.070007 },
					{ "name": "AMZN", "date": "20141216", "value": 295.059998 },
					{ "name": "AMZN", "date": "20141217", "value": 298.880005 },
					{ "name": "AMZN", "date": "20141218", "value": 297.730011 },
					{ "name": "AMZN", "date": "20141219", "value": 299.899994 },
					{ "name": "AMZN", "date": "20141222", "value": 306.540009 },
					{ "name": "AMZN", "date": "20141223", "value": 306.290009 },
					{ "name": "AMZN", "date": "20141224", "value": 303.029999 },
					{ "name": "AMZN", "date": "20141226", "value": 309.089996 },
					{ "name": "AMZN", "date": "20141229", "value": 312.040009 },
					{ "name": "AMZN", "date": "20141230", "value": 310.299988 },
					{ "name": "AMZN", "date": "20141231", "value": 310.350006 },
					{ "name": "AMZN", "date": "20150102", "value": 308.519989 },
					{ "name": "AMZN", "date": "20150105", "value": 302.190002 },
					{ "name": "AMZN", "date": "20150106", "value": 295.290009 },
					{ "name": "AMZN", "date": "20150107", "value": 298.420013 },
					{ "name": "AMZN", "date": "20150108", "value": 300.459991 },
					{ "name": "AMZN", "date": "20150109", "value": 296.929993 },
					{ "name": "AMZN", "date": "20150112", "value": 291.410004 },
					{ "name": "AMZN", "date": "20150113", "value": 294.73999 },
					{ "name": "AMZN", "date": "20150114", "value": 293.269989 },
					{ "name": "AMZN", "date": "20150115", "value": 286.950012 },
					{ "name": "AMZN", "date": "20150116", "value": 290.73999 },
					{ "name": "AMZN", "date": "20150120", "value": 289.440002 },
					{ "name": "AMZN", "date": "20150121", "value": 297.25 },
					{ "name": "AMZN", "date": "20150122", "value": 310.320007 },
					{ "name": "AMZN", "date": "20150123", "value": 312.390015 },
					{ "name": "AMZN", "date": "20150126", "value": 309.660004 },
					{ "name": "AMZN", "date": "20150127", "value": 306.75 },
					{ "name": "AMZN", "date": "20150128", "value": 303.910004 },
					{ "name": "AMZN", "date": "20150129", "value": 311.779999 },
					{ "name": "AMZN", "date": "20150130", "value": 354.529999 },
					{ "name": "AMZN", "date": "20150202", "value": 364.470001 },
					{ "name": "AMZN", "date": "20150203", "value": 363.549988 },
					{ "name": "AMZN", "date": "20150204", "value": 364.75 },
					{ "name": "AMZN", "date": "20150205", "value": 373.890015 },
					{ "name": "AMZN", "date": "20150206", "value": 374.279999 },
					{ "name": "AMZN", "date": "20150209", "value": 370.559998 },
					{ "name": "AMZN", "date": "20150210", "value": 373 },
					{ "name": "AMZN", "date": "20150211", "value": 375.140015 },
					{ "name": "AMZN", "date": "20150212", "value": 377.170013 },
					{ "name": "AMZN", "date": "20150213", "value": 381.829987 },
					{ "name": "AMZN", "date": "20150217", "value": 375.429993 },
					{ "name": "AMZN", "date": "20150218", "value": 373.369995 },
					{ "name": "AMZN", "date": "20150219", "value": 379 },
					{ "name": "AMZN", "date": "20150220", "value": 383.660004 },
					{ "name": "AMZN", "date": "20150223", "value": 380.140015 },
					{ "name": "AMZN", "date": "20150224", "value": 378.589996 },
					{ "name": "AMZN", "date": "20150225", "value": 385.369995 },
					{ "name": "AMZN", "date": "20150226", "value": 384.799988 },
					{ "name": "AMZN", "date": "20150227", "value": 380.160004 },
					{ "name": "AMZN", "date": "20150302", "value": 385.660004 },
					{ "name": "AMZN", "date": "20150303", "value": 384.609985 },
					{ "name": "AMZN", "date": "20150304", "value": 382.720001 },
					{ "name": "AMZN", "date": "20150305", "value": 387.829987 },
					{ "name": "AMZN", "date": "20150306", "value": 380.089996 },
					{ "name": "AMZN", "date": "20150309", "value": 378.559998 },
					{ "name": "AMZN", "date": "20150310", "value": 369.51001 },
					{ "name": "AMZN", "date": "20150311", "value": 366.369995 },
					{ "name": "AMZN", "date": "20150312", "value": 374.23999 },
					{ "name": "AMZN", "date": "20150313", "value": 370.579987 },
					{ "name": "AMZN", "date": "20150316", "value": 373.350006 },
					{ "name": "AMZN", "date": "20150317", "value": 371.920013 },
					{ "name": "AMZN", "date": "20150318", "value": 375.140015 },
					{ "name": "AMZN", "date": "20150319", "value": 373.23999 },
					{ "name": "AMZN", "date": "20150320", "value": 378.48999 },
					{ "name": "AMZN", "date": "20150323", "value": 375.109985 },
					{ "name": "AMZN", "date": "20150324", "value": 374.089996 },
					{ "name": "AMZN", "date": "20150325", "value": 370.959991 },
					{ "name": "AMZN", "date": "20150326", "value": 367.350006 },
					{ "name": "AMZN", "date": "20150327", "value": 370.559998 },
					{ "name": "AMZN", "date": "20150330", "value": 374.589996 },
					{ "name": "AMZN", "date": "20150331", "value": 372.100006 },
					{ "name": "AMZN", "date": "20150401", "value": 370.26001 },
					{ "name": "AMZN", "date": "20150402", "value": 372.25 },
					{ "name": "AMZN", "date": "20150406", "value": 377.040009 },
					{ "name": "AMZN", "date": "20150407", "value": 374.410004 },
					{ "name": "AMZN", "date": "20150408", "value": 381.200012 },
					{ "name": "AMZN", "date": "20150409", "value": 383.540009 },
					{ "name": "AMZN", "date": "20150410", "value": 382.649994 },
					{ "name": "AMZN", "date": "20150413", "value": 382.359985 },
					{ "name": "AMZN", "date": "20150414", "value": 385.109985 },
					{ "name": "AMZN", "date": "20150415", "value": 383.450012 },
					{ "name": "AMZN", "date": "20150416", "value": 386.040009 },
					{ "name": "AMZN", "date": "20150417", "value": 375.559998 },
					{ "name": "AMZN", "date": "20150420", "value": 389.51001 },
					{ "name": "AMZN", "date": "20150421", "value": 391.179993 },
					{ "name": "AMZN", "date": "20150422", "value": 389.799988 },
					{ "name": "AMZN", "date": "20150423", "value": 389.98999 },
					{ "name": "AMZN", "date": "20150424", "value": 445.100006 },
					{ "name": "AMZN", "date": "20150427", "value": 438.559998 },
					{ "name": "AMZN", "date": "20150428", "value": 429.309998 },
					{ "name": "AMZN", "date": "20150429", "value": 429.369995 },
					{ "name": "AMZN", "date": "20150430", "value": 421.779999 },
					{ "name": "AMZN", "date": "20150501", "value": 422.869995 },
					{ "name": "AMZN", "date": "20150504", "value": 423.040009 },
					{ "name": "AMZN", "date": "20150505", "value": 421.190002 },
					{ "name": "AMZN", "date": "20150506", "value": 419.100006 },
					{ "name": "AMZN", "date": "20150507", "value": 426.880005 },
					{ "name": "AMZN", "date": "20150508", "value": 433.690002 },
					{ "name": "AMZN", "date": "20150511", "value": 432.850006 },
					{ "name": "AMZN", "date": "20150512", "value": 431.019989 },
					{ "name": "AMZN", "date": "20150513", "value": 426.869995 },
					{ "name": "AMZN", "date": "20150514", "value": 432.279999 },
					{ "name": "AMZN", "date": "20150515", "value": 426 },
					{ "name": "AMZN", "date": "20150518", "value": 425.23999 },
					{ "name": "AMZN", "date": "20150519", "value": 421.709991 },
					{ "name": "AMZN", "date": "20150520", "value": 423.859985 },
					{ "name": "AMZN", "date": "20150521", "value": 431.630005 },
					{ "name": "AMZN", "date": "20150522", "value": 427.630005 },
					{ "name": "AMZN", "date": "20150526", "value": 425.470001 },
					{ "name": "AMZN", "date": "20150527", "value": 431.420013 },
					{ "name": "AMZN", "date": "20150528", "value": 426.570007 },
					{ "name": "AMZN", "date": "20150529", "value": 429.230011 },
					{ "name": "AMZN", "date": "20150601", "value": 430.920013 },
					{ "name": "AMZN", "date": "20150602", "value": 430.98999 },
					{ "name": "AMZN", "date": "20150603", "value": 436.589996 },
					{ "name": "AMZN", "date": "20150604", "value": 430.779999 },
					{ "name": "AMZN", "date": "20150605", "value": 426.950012 },
					{ "name": "AMZN", "date": "20150608", "value": 423.5 },
					{ "name": "AMZN", "date": "20150609", "value": 425.480011 },
					{ "name": "AMZN", "date": "20150610", "value": 430.769989 },
					{ "name": "AMZN", "date": "20150611", "value": 432.970001 },
					{ "name": "AMZN", "date": "20150612", "value": 429.920013 },
					{ "name": "AMZN", "date": "20150615", "value": 423.670013 },
					{ "name": "AMZN", "date": "20150616", "value": 427.26001 },
					{ "name": "AMZN", "date": "20150617", "value": 427.809998 },
					{ "name": "AMZN", "date": "20150618", "value": 439.390015 },
					{ "name": "AMZN", "date": "20150619", "value": 434.920013 },
					{ "name": "AMZN", "date": "20150622", "value": 436.290009 },
					{ "name": "AMZN", "date": "20150623", "value": 445.98999 },
					{ "name": "AMZN", "date": "20150624", "value": 440.839996 },
					{ "name": "AMZN", "date": "20150625", "value": 440.100006 },
					{ "name": "AMZN", "date": "20150626", "value": 438.100006 },
					{ "name": "AMZN", "date": "20150629", "value": 429.859985 },
					{ "name": "AMZN", "date": "20150630", "value": 434.089996 },
					{ "name": "AMZN", "date": "20150701", "value": 437.390015 },
					{ "name": "AMZN", "date": "20150702", "value": 437.709991 },
					{ "name": "AMZN", "date": "20150706", "value": 436.040009 },
					{ "name": "AMZN", "date": "20150707", "value": 436.720001 },
					{ "name": "AMZN", "date": "20150708", "value": 429.700012 },
					{ "name": "AMZN", "date": "20150709", "value": 434.390015 },
					{ "name": "AMZN", "date": "20150710", "value": 443.51001 },
					{ "name": "AMZN", "date": "20150713", "value": 455.570007 },
					{ "name": "AMZN", "date": "20150714", "value": 465.570007 },
					{ "name": "AMZN", "date": "20150715", "value": 461.190002 },
					{ "name": "AMZN", "date": "20150716", "value": 475.480011 },
					{ "name": "AMZN", "date": "20150717", "value": 483.01001 },
					{ "name": "AMZN", "date": "20150720", "value": 488.100006 },
					{ "name": "AMZN", "date": "20150721", "value": 488 },
					{ "name": "AMZN", "date": "20150722", "value": 488.269989 },
					{ "name": "AMZN", "date": "20150723", "value": 482.179993 },
					{ "name": "AMZN", "date": "20150724", "value": 529.419983 },
					{ "name": "AMZN", "date": "20150727", "value": 531.409973 },
					{ "name": "AMZN", "date": "20150728", "value": 526.030029 },
					{ "name": "AMZN", "date": "20150729", "value": 529 },
					{ "name": "AMZN", "date": "20150730", "value": 536.76001 },
					{ "name": "AMZN", "date": "20150731", "value": 536.150024 },
					{ "name": "AMZN", "date": "20150803", "value": 535.030029 },
					{ "name": "AMZN", "date": "20150804", "value": 531.900024 },
					{ "name": "AMZN", "date": "20150805", "value": 537.01001 },
					{ "name": "AMZN", "date": "20150806", "value": 529.460022 },
					{ "name": "AMZN", "date": "20150807", "value": 522.619995 },
					{ "name": "AMZN", "date": "20150810", "value": 524 },
					{ "name": "AMZN", "date": "20150811", "value": 527.460022 },
					{ "name": "AMZN", "date": "20150812", "value": 525.909973 },
					{ "name": "AMZN", "date": "20150813", "value": 529.659973 },
					{ "name": "AMZN", "date": "20150814", "value": 531.52002 },
					{ "name": "AMZN", "date": "20150817", "value": 535.219971 },
					{ "name": "AMZN", "date": "20150818", "value": 535.02002 },
					{ "name": "AMZN", "date": "20150819", "value": 532.919983 },
					{ "name": "AMZN", "date": "20150820", "value": 515.780029 },
					{ "name": "AMZN", "date": "20150821", "value": 494.470001 },
					{ "name": "AMZN", "date": "20150824", "value": 463.369995 },
					{ "name": "AMZN", "date": "20150825", "value": 466.369995 },
					{ "name": "AMZN", "date": "20150826", "value": 500.769989 },
					{ "name": "AMZN", "date": "20150827", "value": 518.369995 },
					{ "name": "AMZN", "date": "20150828", "value": 518.01001 },
					{ "name": "AMZN", "date": "20150831", "value": 512.890015 },
					{ "name": "AMZN", "date": "20150901", "value": 496.540009 },
					{ "name": "AMZN", "date": "20150902", "value": 510.549988 },
					{ "name": "AMZN", "date": "20150903", "value": 504.720001 },
					{ "name": "AMZN", "date": "20150904", "value": 499 },
					{ "name": "AMZN", "date": "20150908", "value": 517.539978 },
					{ "name": "AMZN", "date": "20150909", "value": 516.890015 },
					{ "name": "AMZN", "date": "20150910", "value": 522.23999 },
					{ "name": "AMZN", "date": "20150911", "value": 529.440002 },
					{ "name": "AMZN", "date": "20150914", "value": 521.380005 },
					{ "name": "AMZN", "date": "20150915", "value": 522.369995 },
					{ "name": "AMZN", "date": "20150916", "value": 527.390015 },
					{ "name": "AMZN", "date": "20150917", "value": 538.869995 },
					{ "name": "AMZN", "date": "20150918", "value": 540.26001 },
					{ "name": "AMZN", "date": "20150921", "value": 548.390015 },
					{ "name": "AMZN", "date": "20150922", "value": 538.400024 },
					{ "name": "AMZN", "date": "20150923", "value": 536.070007 },
					{ "name": "AMZN", "date": "20150924", "value": 533.75 },
					{ "name": "AMZN", "date": "20150925", "value": 524.25 },
					{ "name": "AMZN", "date": "20150928", "value": 504.059998 },
					{ "name": "AMZN", "date": "20150929", "value": 496.070007 },
					{ "name": "AMZN", "date": "20150930", "value": 511.890015 },
					{ "name": "AMZN", "date": "20151001", "value": 520.719971 },
					{ "name": "AMZN", "date": "20151002", "value": 532.539978 },
					{ "name": "AMZN", "date": "20151005", "value": 543.679993 },
					{ "name": "AMZN", "date": "20151006", "value": 537.47998 },
					{ "name": "AMZN", "date": "20151007", "value": 541.940002 },
					{ "name": "AMZN", "date": "20151008", "value": 533.159973 },
					{ "name": "AMZN", "date": "20151009", "value": 539.799988 },
					{ "name": "AMZN", "date": "20151012", "value": 550.190002 },
					{ "name": "AMZN", "date": "20151013", "value": 548.900024 },
					{ "name": "AMZN", "date": "20151014", "value": 544.830017 },
					{ "name": "AMZN", "date": "20151015", "value": 562.440002 },
					{ "name": "AMZN", "date": "20151016", "value": 570.76001 },
					{ "name": "AMZN", "date": "20151019", "value": 573.150024 },
					{ "name": "AMZN", "date": "20151020", "value": 560.880005 },
					{ "name": "AMZN", "date": "20151021", "value": 555.77002 },
					{ "name": "AMZN", "date": "20151022", "value": 563.909973 },
					{ "name": "AMZN", "date": "20151023", "value": 599.030029 },
					{ "name": "AMZN", "date": "20151026", "value": 608.609985 },
					{ "name": "AMZN", "date": "20151027", "value": 611.01001 },
					{ "name": "AMZN", "date": "20151028", "value": 617.099976 },
					{ "name": "AMZN", "date": "20151029", "value": 626.549988 },
					{ "name": "AMZN", "date": "20151030", "value": 625.900024 },
					{ "name": "AMZN", "date": "20151102", "value": 628.349976 },
					{ "name": "AMZN", "date": "20151103", "value": 625.309998 },
					{ "name": "AMZN", "date": "20151104", "value": 640.950012 },
					{ "name": "AMZN", "date": "20151105", "value": 655.650024 },
					{ "name": "AMZN", "date": "20151106", "value": 659.369995 },
					{ "name": "AMZN", "date": "20151109", "value": 655.48999 },
					{ "name": "AMZN", "date": "20151110", "value": 659.679993 },
					{ "name": "AMZN", "date": "20151111", "value": 673.25 },
					{ "name": "AMZN", "date": "20151112", "value": 665.599976 },
					{ "name": "AMZN", "date": "20151113", "value": 642.349976 },
					{ "name": "AMZN", "date": "20151116", "value": 647.809998 },
					{ "name": "AMZN", "date": "20151117", "value": 643.299988 },
					{ "name": "AMZN", "date": "20151118", "value": 663.539978 },
					{ "name": "AMZN", "date": "20151119", "value": 661.27002 },
					{ "name": "AMZN", "date": "20151120", "value": 668.450012 },
					{ "name": "AMZN", "date": "20151123", "value": 678.98999 },
					{ "name": "AMZN", "date": "20151124", "value": 671.150024 },
					{ "name": "AMZN", "date": "20151125", "value": 675.340027 },
					{ "name": "AMZN", "date": "20151127", "value": 673.26001 },
					{ "name": "AMZN", "date": "20151130", "value": 664.799988 },
					{ "name": "AMZN", "date": "20151201", "value": 679.059998 },
					{ "name": "AMZN", "date": "20151202", "value": 676.01001 },
					{ "name": "AMZN", "date": "20151203", "value": 666.25 },
					{ "name": "AMZN", "date": "20151204", "value": 672.640015 },
					{ "name": "AMZN", "date": "20151207", "value": 669.830017 },
					{ "name": "AMZN", "date": "20151208", "value": 677.330017 },
					{ "name": "AMZN", "date": "20151209", "value": 664.789978 },
					{ "name": "AMZN", "date": "20151210", "value": 662.320007 },
					{ "name": "AMZN", "date": "20151211", "value": 640.150024 },
					{ "name": "AMZN", "date": "20151214", "value": 657.909973 },
					{ "name": "AMZN", "date": "20151215", "value": 658.640015 },
					{ "name": "AMZN", "date": "20151216", "value": 675.77002 },
					{ "name": "AMZN", "date": "20151217", "value": 670.650024 },
					{ "name": "AMZN", "date": "20151218", "value": 664.140015 },
					{ "name": "AMZN", "date": "20151221", "value": 664.51001 },
					{ "name": "AMZN", "date": "20151222", "value": 663.150024 },
					{ "name": "AMZN", "date": "20151223", "value": 663.700012 },
					{ "name": "AMZN", "date": "20151224", "value": 662.789978 },
					{ "name": "AMZN", "date": "20151228", "value": 675.200012 },
					{ "name": "AMZN", "date": "20151229", "value": 693.969971 },
					{ "name": "AMZN", "date": "20151230", "value": 689.070007 },
					{ "name": "AMZN", "date": "20151231", "value": 675.890015 },
					{ "name": "AMZN", "date": "20160104", "value": 636.98999 },
					{ "name": "AMZN", "date": "20160105", "value": 633.789978 },
					{ "name": "AMZN", "date": "20160106", "value": 632.650024 },
					{ "name": "AMZN", "date": "20160107", "value": 607.940002 },
					{ "name": "AMZN", "date": "20160108", "value": 607.049988 },
					{ "name": "AMZN", "date": "20160111", "value": 617.73999 },
					{ "name": "AMZN", "date": "20160112", "value": 617.890015 },
					{ "name": "AMZN", "date": "20160113", "value": 581.809998 },
					{ "name": "AMZN", "date": "20160114", "value": 593 },
					{ "name": "AMZN", "date": "20160115", "value": 570.179993 },
					{ "name": "AMZN", "date": "20160119", "value": 574.47998 },
					{ "name": "AMZN", "date": "20160120", "value": 571.77002 },
					{ "name": "AMZN", "date": "20160121", "value": 575.02002 },
					{ "name": "AMZN", "date": "20160122", "value": 596.380005 },
					{ "name": "AMZN", "date": "20160125", "value": 596.530029 },
					{ "name": "AMZN", "date": "20160126", "value": 601.25 },
					{ "name": "AMZN", "date": "20160127", "value": 583.349976 },
					{ "name": "AMZN", "date": "20160128", "value": 635.349976 },
					{ "name": "AMZN", "date": "20160129", "value": 587 },
					{ "name": "AMZN", "date": "20160201", "value": 574.809998 },
					{ "name": "AMZN", "date": "20160202", "value": 552.099976 },
					{ "name": "AMZN", "date": "20160203", "value": 531.070007 },
					{ "name": "AMZN", "date": "20160204", "value": 536.26001 },
					{ "name": "AMZN", "date": "20160205", "value": 502.130005 },
					{ "name": "AMZN", "date": "20160208", "value": 488.100006 },
					{ "name": "AMZN", "date": "20160209", "value": 482.070007 },
					{ "name": "AMZN", "date": "20160210", "value": 490.480011 },
					{ "name": "AMZN", "date": "20160211", "value": 503.820007 },
					{ "name": "AMZN", "date": "20160212", "value": 507.079987 },
					{ "name": "AMZN", "date": "20160216", "value": 521.099976 },
					{ "name": "AMZN", "date": "20160217", "value": 534.099976 },
					{ "name": "AMZN", "date": "20160218", "value": 525 },
					{ "name": "AMZN", "date": "20160219", "value": 534.900024 },
					{ "name": "AMZN", "date": "20160222", "value": 559.5 },
					{ "name": "AMZN", "date": "20160223", "value": 552.940002 },
					{ "name": "AMZN", "date": "20160224", "value": 554.039978 },
					{ "name": "AMZN", "date": "20160225", "value": 555.150024 },
					{ "name": "AMZN", "date": "20160226", "value": 555.22998 },
					{ "name": "AMZN", "date": "20160229", "value": 552.52002 },
					{ "name": "AMZN", "date": "20160301", "value": 579.039978 },
					{ "name": "AMZN", "date": "20160302", "value": 580.210022 },
					{ "name": "AMZN", "date": "20160303", "value": 577.48999 },
					{ "name": "AMZN", "date": "20160304", "value": 575.140015 },
					{ "name": "AMZN", "date": "20160307", "value": 562.799988 },
					{ "name": "AMZN", "date": "20160308", "value": 560.26001 },
					{ "name": "AMZN", "date": "20160309", "value": 559.469971 },
					{ "name": "AMZN", "date": "20160310", "value": 558.929993 },
					{ "name": "AMZN", "date": "20160311", "value": 569.609985 },
					{ "name": "AMZN", "date": "20160314", "value": 573.369995 },
					{ "name": "AMZN", "date": "20160315", "value": 577.02002 },
					{ "name": "AMZN", "date": "20160316", "value": 574.27002 },
					{ "name": "AMZN", "date": "20160317", "value": 559.440002 },
					{ "name": "AMZN", "date": "20160318", "value": 552.080017 },
					{ "name": "AMZN", "date": "20160321", "value": 553.97998 },
					{ "name": "AMZN", "date": "20160322", "value": 560.47998 },
					{ "name": "AMZN", "date": "20160323", "value": 569.630005 },
					{ "name": "AMZN", "date": "20160324", "value": 582.950012 },
					{ "name": "AMZN", "date": "20160328", "value": 579.869995 },
					{ "name": "AMZN", "date": "20160329", "value": 593.859985 },
					{ "name": "AMZN", "date": "20160330", "value": 598.690002 },
					{ "name": "AMZN", "date": "20160331", "value": 593.640015 },
					{ "name": "AMZN", "date": "20160401", "value": 598.5 },
					{ "name": "AMZN", "date": "20160404", "value": 593.190002 },
					{ "name": "AMZN", "date": "20160405", "value": 586.140015 },
					{ "name": "AMZN", "date": "20160406", "value": 602.080017 },
					{ "name": "AMZN", "date": "20160407", "value": 591.429993 },
					{ "name": "AMZN", "date": "20160408", "value": 594.599976 },
					{ "name": "AMZN", "date": "20160411", "value": 595.929993 },
					{ "name": "AMZN", "date": "20160412", "value": 603.169983 },
					{ "name": "AMZN", "date": "20160413", "value": 614.820007 },
					{ "name": "AMZN", "date": "20160414", "value": 620.75 },
					{ "name": "AMZN", "date": "20160415", "value": 625.890015 },
					{ "name": "AMZN", "date": "20160418", "value": 635.349976 },
					{ "name": "AMZN", "date": "20160419", "value": 627.900024 },
					{ "name": "AMZN", "date": "20160420", "value": 632.98999 },
					{ "name": "AMZN", "date": "20160421", "value": 631 },
					{ "name": "AMZN", "date": "20160422", "value": 620.5 },
					{ "name": "AMZN", "date": "20160425", "value": 626.200012 },
					{ "name": "AMZN", "date": "20160426", "value": 616.880005 },
					{ "name": "AMZN", "date": "20160427", "value": 606.570007 },
					{ "name": "AMZN", "date": "20160428", "value": 602 },
					{ "name": "AMZN", "date": "20160429", "value": 659.590027 },
					{ "name": "AMZN", "date": "20160502", "value": 683.849976 },
					{ "name": "AMZN", "date": "20160503", "value": 671.320007 },
					{ "name": "AMZN", "date": "20160504", "value": 670.900024 },
					{ "name": "AMZN", "date": "20160505", "value": 659.090027 },
					{ "name": "AMZN", "date": "20160506", "value": 673.950012 },
					{ "name": "AMZN", "date": "20160509", "value": 679.75 },
					{ "name": "AMZN", "date": "20160510", "value": 703.070007 },
					{ "name": "AMZN", "date": "20160511", "value": 713.22998 },
					{ "name": "AMZN", "date": "20160512", "value": 717.929993 },
					{ "name": "AMZN", "date": "20160513", "value": 709.919983 },
					{ "name": "AMZN", "date": "20160516", "value": 710.659973 },
					{ "name": "AMZN", "date": "20160517", "value": 695.27002 },
					{ "name": "AMZN", "date": "20160518", "value": 697.450012 },
					{ "name": "AMZN", "date": "20160519", "value": 698.52002 },
					{ "name": "AMZN", "date": "20160520", "value": 702.799988 },
					{ "name": "AMZN", "date": "20160523", "value": 696.75 },
					{ "name": "AMZN", "date": "20160524", "value": 704.200012 },
					{ "name": "AMZN", "date": "20160525", "value": 708.349976 },
					{ "name": "AMZN", "date": "20160526", "value": 714.909973 },
					{ "name": "AMZN", "date": "20160527", "value": 712.23999 },
					{ "name": "AMZN", "date": "20160531", "value": 722.789978 },
					{ "name": "AMZN", "date": "20160601", "value": 719.440002 },
					{ "name": "AMZN", "date": "20160602", "value": 728.23999 },
					{ "name": "AMZN", "date": "20160603", "value": 725.539978 },
					{ "name": "AMZN", "date": "20160606", "value": 726.72998 },
					{ "name": "AMZN", "date": "20160607", "value": 723.73999 },
					{ "name": "AMZN", "date": "20160608", "value": 726.640015 },
					{ "name": "AMZN", "date": "20160609", "value": 727.650024 },
					{ "name": "AMZN", "date": "20160610", "value": 717.909973 },
					{ "name": "AMZN", "date": "20160613", "value": 715.23999 },
					{ "name": "AMZN", "date": "20160614", "value": 719.299988 },
					{ "name": "AMZN", "date": "20160615", "value": 714.26001 },
					{ "name": "AMZN", "date": "20160616", "value": 717.51001 },
					{ "name": "AMZN", "date": "20160617", "value": 706.390015 },
					{ "name": "AMZN", "date": "20160620", "value": 714.01001 },
					{ "name": "AMZN", "date": "20160621", "value": 715.820007 },
					{ "name": "AMZN", "date": "20160622", "value": 710.599976 },
					{ "name": "AMZN", "date": "20160623", "value": 722.080017 },
					{ "name": "AMZN", "date": "20160624", "value": 698.960022 },
					{ "name": "AMZN", "date": "20160627", "value": 691.359985 },
					{ "name": "AMZN", "date": "20160628", "value": 707.950012 },
					{ "name": "AMZN", "date": "20160629", "value": 715.599976 },
					{ "name": "AMZN", "date": "20160630", "value": 715.619995 },
					{ "name": "AMZN", "date": "20160701", "value": 725.679993 },
					{ "name": "AMZN", "date": "20160705", "value": 728.099976 },
					{ "name": "AMZN", "date": "20160706", "value": 737.609985 },
					{ "name": "AMZN", "date": "20160707", "value": 736.570007 },
					{ "name": "AMZN", "date": "20160708", "value": 745.809998 },
					{ "name": "AMZN", "date": "20160711", "value": 753.780029 },
					{ "name": "AMZN", "date": "20160712", "value": 748.210022 },
					{ "name": "AMZN", "date": "20160713", "value": 742.630005 },
					{ "name": "AMZN", "date": "20160714", "value": 741.200012 },
					{ "name": "AMZN", "date": "20160715", "value": 735.440002 },
					{ "name": "AMZN", "date": "20160718", "value": 736.070007 },
					{ "name": "AMZN", "date": "20160719", "value": 739.950012 },
					{ "name": "AMZN", "date": "20160720", "value": 745.719971 },
					{ "name": "AMZN", "date": "20160721", "value": 744.429993 },
					{ "name": "AMZN", "date": "20160722", "value": 744.859985 },
					{ "name": "AMZN", "date": "20160725", "value": 739.609985 },
					{ "name": "AMZN", "date": "20160726", "value": 735.590027 },
					{ "name": "AMZN", "date": "20160727", "value": 736.669983 },
					{ "name": "AMZN", "date": "20160728", "value": 752.609985 },
					{ "name": "AMZN", "date": "20160729", "value": 758.809998 },
					{ "name": "AMZN", "date": "20160801", "value": 767.73999 },
					{ "name": "AMZN", "date": "20160802", "value": 760.580017 },
					{ "name": "AMZN", "date": "20160803", "value": 754.640015 },
					{ "name": "AMZN", "date": "20160804", "value": 760.77002 },
					{ "name": "AMZN", "date": "20160805", "value": 765.97998 },
					{ "name": "AMZN", "date": "20160808", "value": 766.559998 },
					{ "name": "AMZN", "date": "20160809", "value": 768.309998 },
					{ "name": "AMZN", "date": "20160810", "value": 768.559998 },
					{ "name": "AMZN", "date": "20160811", "value": 771.23999 },
					{ "name": "AMZN", "date": "20160812", "value": 772.559998 },
					{ "name": "AMZN", "date": "20160815", "value": 768.48999 },
					{ "name": "AMZN", "date": "20160816", "value": 764.039978 },
					{ "name": "AMZN", "date": "20160817", "value": 764.630005 },
					{ "name": "AMZN", "date": "20160818", "value": 764.460022 },
					{ "name": "AMZN", "date": "20160819", "value": 757.309998 },
					{ "name": "AMZN", "date": "20160822", "value": 759.47998 },
					{ "name": "AMZN", "date": "20160823", "value": 762.450012 },
					{ "name": "AMZN", "date": "20160824", "value": 757.25 },
					{ "name": "AMZN", "date": "20160825", "value": 759.219971 },
					{ "name": "AMZN", "date": "20160826", "value": 769 },
					{ "name": "AMZN", "date": "20160829", "value": 771.289978 },
					{ "name": "AMZN", "date": "20160830", "value": 767.580017 },
					{ "name": "AMZN", "date": "20160831", "value": 769.159973 },
					{ "name": "AMZN", "date": "20160901", "value": 770.619995 },
					{ "name": "AMZN", "date": "20160902", "value": 772.440002 },
					{ "name": "AMZN", "date": "20160906", "value": 788.869995 },
					{ "name": "AMZN", "date": "20160907", "value": 784.47998 },
					{ "name": "AMZN", "date": "20160908", "value": 784.059998 },
					{ "name": "AMZN", "date": "20160909", "value": 760.140015 },
					{ "name": "AMZN", "date": "20160912", "value": 771.48999 },
					{ "name": "AMZN", "date": "20160913", "value": 761.01001 },
					{ "name": "AMZN", "date": "20160914", "value": 761.090027 },
					{ "name": "AMZN", "date": "20160915", "value": 769.690002 },
					{ "name": "AMZN", "date": "20160916", "value": 778.52002 },
					{ "name": "AMZN", "date": "20160919", "value": 775.099976 },
					{ "name": "AMZN", "date": "20160920", "value": 780.219971 },
					{ "name": "AMZN", "date": "20160921", "value": 789.73999 },
					{ "name": "AMZN", "date": "20160922", "value": 804.700012 },
					{ "name": "AMZN", "date": "20160923", "value": 805.75 },
					{ "name": "AMZN", "date": "20160926", "value": 799.159973 },
					{ "name": "AMZN", "date": "20160927", "value": 816.109985 },
					{ "name": "AMZN", "date": "20160928", "value": 828.719971 },
					{ "name": "AMZN", "date": "20160929", "value": 829.049988 },
					{ "name": "AMZN", "date": "20160930", "value": 837.309998 },
					{ "name": "AMZN", "date": "20161003", "value": 836.73999 },
					{ "name": "AMZN", "date": "20161004", "value": 834.030029 },
					{ "name": "AMZN", "date": "20161005", "value": 844.359985 },
					{ "name": "AMZN", "date": "20161006", "value": 841.659973 },
					{ "name": "AMZN", "date": "20161007", "value": 839.429993 },
					{ "name": "AMZN", "date": "20161010", "value": 841.710022 },
					{ "name": "AMZN", "date": "20161011", "value": 831 },
					{ "name": "AMZN", "date": "20161012", "value": 834.090027 },
					{ "name": "AMZN", "date": "20161013", "value": 829.280029 },
					{ "name": "AMZN", "date": "20161014", "value": 822.960022 },
					{ "name": "AMZN", "date": "20161017", "value": 812.950012 },
					{ "name": "AMZN", "date": "20161018", "value": 817.650024 },
					{ "name": "AMZN", "date": "20161019", "value": 817.690002 },
					{ "name": "AMZN", "date": "20161020", "value": 810.320007 },
					{ "name": "AMZN", "date": "20161021", "value": 818.98999 },
					{ "name": "AMZN", "date": "20161024", "value": 838.090027 },
					{ "name": "AMZN", "date": "20161025", "value": 835.179993 },
					{ "name": "AMZN", "date": "20161026", "value": 822.590027 },
					{ "name": "AMZN", "date": "20161027", "value": 818.359985 },
					{ "name": "AMZN", "date": "20161028", "value": 776.320007 },
					{ "name": "AMZN", "date": "20161031", "value": 789.820007 },
					{ "name": "AMZN", "date": "20161101", "value": 785.409973 },
					{ "name": "AMZN", "date": "20161102", "value": 765.559998 },
					{ "name": "AMZN", "date": "20161103", "value": 767.030029 },
					{ "name": "AMZN", "date": "20161104", "value": 755.049988 },
					{ "name": "AMZN", "date": "20161107", "value": 784.929993 },
					{ "name": "AMZN", "date": "20161108", "value": 787.75 },
					{ "name": "AMZN", "date": "20161109", "value": 771.880005 },
					{ "name": "AMZN", "date": "20161110", "value": 742.380005 },
					{ "name": "AMZN", "date": "20161111", "value": 739.01001 },
					{ "name": "AMZN", "date": "20161114", "value": 719.070007 },
					{ "name": "AMZN", "date": "20161115", "value": 743.23999 },
					{ "name": "AMZN", "date": "20161116", "value": 746.48999 },
					{ "name": "AMZN", "date": "20161117", "value": 756.400024 },
					{ "name": "AMZN", "date": "20161118", "value": 760.159973 },
					{ "name": "AMZN", "date": "20161121", "value": 780 },
					{ "name": "AMZN", "date": "20161122", "value": 785.330017 },
					{ "name": "AMZN", "date": "20161123", "value": 780.119995 },
					{ "name": "AMZN", "date": "20161125", "value": 780.369995 },
					{ "name": "AMZN", "date": "20161128", "value": 766.77002 },
					{ "name": "AMZN", "date": "20161129", "value": 762.52002 },
					{ "name": "AMZN", "date": "20161130", "value": 750.570007 },
					{ "name": "AMZN", "date": "20161201", "value": 743.650024 },
					{ "name": "AMZN", "date": "20161202", "value": 740.340027 },
					{ "name": "AMZN", "date": "20161205", "value": 759.359985 },
					{ "name": "AMZN", "date": "20161206", "value": 764.719971 },
					{ "name": "AMZN", "date": "20161207", "value": 770.419983 },
					{ "name": "AMZN", "date": "20161208", "value": 767.330017 },
					{ "name": "AMZN", "date": "20161209", "value": 768.659973 },
					{ "name": "AMZN", "date": "20161212", "value": 760.119995 },
					{ "name": "AMZN", "date": "20161213", "value": 774.340027 },
					{ "name": "AMZN", "date": "20161214", "value": 768.820007 },
					{ "name": "AMZN", "date": "20161215", "value": 761 },
					{ "name": "AMZN", "date": "20161216", "value": 757.77002 },
					{ "name": "AMZN", "date": "20161219", "value": 766 },
					{ "name": "AMZN", "date": "20161220", "value": 771.219971 },
					{ "name": "AMZN", "date": "20161221", "value": 770.599976 },
					{ "name": "AMZN", "date": "20161222", "value": 766.340027 },
					{ "name": "AMZN", "date": "20161223", "value": 760.590027 },
					{ "name": "AMZN", "date": "20161227", "value": 771.400024 },
					{ "name": "AMZN", "date": "20161228", "value": 772.130005 },
					{ "name": "AMZN", "date": "20161229", "value": 765.150024 },
					{ "name": "AMZN", "date": "20161230", "value": 749.869995 },
					{ "name": "AMZN", "date": "20170103", "value": 753.669983 },
					{ "name": "AMZN", "date": "20170104", "value": 757.179993 },
					{ "name": "AMZN", "date": "20170105", "value": 780.450012 },
					{ "name": "AMZN", "date": "20170106", "value": 795.98999 },
					{ "name": "AMZN", "date": "20170109", "value": 796.919983 },
					{ "name": "AMZN", "date": "20170110", "value": 795.900024 },
					{ "name": "AMZN", "date": "20170111", "value": 799.02002 },
					{ "name": "AMZN", "date": "20170112", "value": 813.640015 },
					{ "name": "AMZN", "date": "20170113", "value": 817.140015 },
					{ "name": "AMZN", "date": "20170117", "value": 809.719971 },
					{ "name": "AMZN", "date": "20170118", "value": 807.47998 },
					{ "name": "AMZN", "date": "20170119", "value": 809.039978 },
					{ "name": "AMZN", "date": "20170120", "value": 808.330017 },
					{ "name": "AMZN", "date": "20170123", "value": 817.880005 },
					{ "name": "AMZN", "date": "20170124", "value": 822.440002 },
					{ "name": "AMZN", "date": "20170125", "value": 836.52002 },
					{ "name": "AMZN", "date": "20170126", "value": 839.150024 },
					{ "name": "AMZN", "date": "20170127", "value": 835.77002 },
					{ "name": "AMZN", "date": "20170130", "value": 830.380005 },
					{ "name": "AMZN", "date": "20170131", "value": 823.47998 },
					{ "name": "AMZN", "date": "20170201", "value": 832.349976 },
					{ "name": "AMZN", "date": "20170202", "value": 839.950012 },
					{ "name": "AMZN", "date": "20170203", "value": 810.200012 },
					{ "name": "AMZN", "date": "20170206", "value": 807.640015 },
					{ "name": "AMZN", "date": "20170207", "value": 812.5 },
					{ "name": "AMZN", "date": "20170208", "value": 819.710022 },
					{ "name": "AMZN", "date": "20170209", "value": 821.359985 },
					{ "name": "AMZN", "date": "20170210", "value": 827.460022 },
					{ "name": "AMZN", "date": "20170213", "value": 836.530029 },
					{ "name": "AMZN", "date": "20170214", "value": 836.390015 },
					{ "name": "AMZN", "date": "20170215", "value": 842.700012 },
					{ "name": "AMZN", "date": "20170216", "value": 844.140015 },
					{ "name": "AMZN", "date": "20170217", "value": 845.070007 },
					{ "name": "AMZN", "date": "20170221", "value": 856.440002 },
					{ "name": "AMZN", "date": "20170222", "value": 855.609985 },
					{ "name": "AMZN", "date": "20170223", "value": 852.190002 },
					{ "name": "AMZN", "date": "20170224", "value": 845.23999 },
					{ "name": "AMZN", "date": "20170227", "value": 848.640015 },
					{ "name": "AMZN", "date": "20170228", "value": 845.039978 },
					{ "name": "AMZN", "date": "20170301", "value": 853.080017 },
					{ "name": "AMZN", "date": "20170302", "value": 848.909973 },
					{ "name": "AMZN", "date": "20170303", "value": 849.880005 },
					{ "name": "AMZN", "date": "20170306", "value": 846.609985 },
					{ "name": "AMZN", "date": "20170307", "value": 846.02002 },
					{ "name": "AMZN", "date": "20170308", "value": 850.5 },
					{ "name": "AMZN", "date": "20170309", "value": 853 },
					{ "name": "AMZN", "date": "20170310", "value": 852.460022 },
					{ "name": "AMZN", "date": "20170313", "value": 854.590027 },
					{ "name": "AMZN", "date": "20170314", "value": 852.530029 },
					{ "name": "AMZN", "date": "20170315", "value": 852.969971 },
					{ "name": "AMZN", "date": "20170316", "value": 853.419983 },
					{ "name": "AMZN", "date": "20170317", "value": 852.309998 },
					{ "name": "AMZN", "date": "20170320", "value": 856.969971 },
					{ "name": "AMZN", "date": "20170321", "value": 843.200012 },
					{ "name": "AMZN", "date": "20170322", "value": 848.059998 },
					{ "name": "AMZN", "date": "20170323", "value": 847.380005 },
					{ "name": "AMZN", "date": "20170324", "value": 845.609985 },
					{ "name": "AMZN", "date": "20170327", "value": 846.820007 },
					{ "name": "AMZN", "date": "20170328", "value": 856 },
					{ "name": "AMZN", "date": "20170329", "value": 874.320007 },
					{ "name": "AMZN", "date": "20170330", "value": 876.340027 },
					{ "name": "AMZN", "date": "20170331", "value": 886.539978 },
					{ "name": "AMZN", "date": "20170403", "value": 891.51001 },
					{ "name": "AMZN", "date": "20170404", "value": 906.830017 },
					{ "name": "AMZN", "date": "20170405", "value": 909.280029 },
					{ "name": "AMZN", "date": "20170406", "value": 898.280029 },
					{ "name": "AMZN", "date": "20170407", "value": 894.880005 },
					{ "name": "AMZN", "date": "20170410", "value": 907.039978 },
					{ "name": "AMZN", "date": "20170411", "value": 902.359985 },
					{ "name": "AMZN", "date": "20170412", "value": 896.22998 },
					{ "name": "AMZN", "date": "20170413", "value": 884.669983 },
					{ "name": "AMZN", "date": "20170417", "value": 901.98999 },
					{ "name": "AMZN", "date": "20170418", "value": 903.780029 },
					{ "name": "AMZN", "date": "20170419", "value": 899.200012 },
					{ "name": "AMZN", "date": "20170420", "value": 902.059998 },
					{ "name": "AMZN", "date": "20170421", "value": 898.530029 },
					{ "name": "AMZN", "date": "20170424", "value": 907.409973 },
					{ "name": "AMZN", "date": "20170425", "value": 907.619995 },
					{ "name": "AMZN", "date": "20170426", "value": 909.289978 },
					{ "name": "AMZN", "date": "20170427", "value": 918.380005 },
					{ "name": "AMZN", "date": "20170428", "value": 924.98999 },
					{ "name": "AMZN", "date": "20170501", "value": 948.22998 },
					{ "name": "AMZN", "date": "20170502", "value": 946.940002 },
					{ "name": "AMZN", "date": "20170503", "value": 941.030029 },
					{ "name": "AMZN", "date": "20170504", "value": 937.530029 },
					{ "name": "AMZN", "date": "20170505", "value": 934.150024 },
					{ "name": "AMZN", "date": "20170508", "value": 949.039978 },
					{ "name": "AMZN", "date": "20170509", "value": 952.820007 },
					{ "name": "AMZN", "date": "20170510", "value": 948.950012 },
					{ "name": "AMZN", "date": "20170511", "value": 947.619995 },
					{ "name": "AMZN", "date": "20170512", "value": 961.349976 },
					{ "name": "AMZN", "date": "20170515", "value": 957.969971 },
					{ "name": "AMZN", "date": "20170516", "value": 966.070007 },
					{ "name": "AMZN", "date": "20170517", "value": 944.76001 },
					{ "name": "AMZN", "date": "20170518", "value": 958.48999 },
					{ "name": "AMZN", "date": "20170519", "value": 959.840027 },
					{ "name": "AMZN", "date": "20170522", "value": 970.669983 },
					{ "name": "AMZN", "date": "20170523", "value": 971.539978 },
					{ "name": "AMZN", "date": "20170524", "value": 980.349976 },
					{ "name": "AMZN", "date": "20170525", "value": 993.380005 },
					{ "name": "AMZN", "date": "20170526", "value": 995.780029 },
					{ "name": "AMZN", "date": "20170530", "value": 996.700012 },
					{ "name": "AMZN", "date": "20170531", "value": 994.619995 },
					{ "name": "AMZN", "date": "20170601", "value": 995.950012 },
					{ "name": "AMZN", "date": "20170602", "value": 1006.72998 },
					{ "name": "AMZN", "date": "20170605", "value": 1011.340027 },
					{ "name": "AMZN", "date": "20170606", "value": 1003 },
					{ "name": "AMZN", "date": "20170607", "value": 1010.070007 },
					{ "name": "AMZN", "date": "20170608", "value": 1010.27002 },
					{ "name": "AMZN", "date": "20170609", "value": 978.309998 },
					{ "name": "AMZN", "date": "20170612", "value": 964.909973 },
					{ "name": "AMZN", "date": "20170613", "value": 980.789978 },
					{ "name": "AMZN", "date": "20170614", "value": 976.469971 },
					{ "name": "AMZN", "date": "20170615", "value": 964.169983 },
					{ "name": "AMZN", "date": "20170616", "value": 987.710022 },
					{ "name": "AMZN", "date": "20170619", "value": 995.169983 },
					{ "name": "AMZN", "date": "20170620", "value": 992.590027 },
					{ "name": "AMZN", "date": "20170621", "value": 1002.22998 },
					{ "name": "AMZN", "date": "20170622", "value": 1001.299988 },
					{ "name": "AMZN", "date": "20170623", "value": 1003.73999 },
					{ "name": "AMZN", "date": "20170626", "value": 993.97998 },
					{ "name": "AMZN", "date": "20170627", "value": 976.780029 },
					{ "name": "AMZN", "date": "20170628", "value": 990.330017 },
					{ "name": "AMZN", "date": "20170629", "value": 975.929993 },
					{ "name": "AMZN", "date": "20170630", "value": 968 },
					{ "name": "AMZN", "date": "20170703", "value": 953.659973 },
					{ "name": "AMZN", "date": "20170705", "value": 971.400024 },
					{ "name": "AMZN", "date": "20170706", "value": 965.140015 },
					{ "name": "AMZN", "date": "20170707", "value": 978.76001 },
					{ "name": "AMZN", "date": "20170710", "value": 996.469971 },
					{ "name": "AMZN", "date": "20170711", "value": 994.130005 },
					{ "name": "AMZN", "date": "20170712", "value": 1006.51001 },
					{ "name": "AMZN", "date": "20170713", "value": 1000.630005 },
					{ "name": "AMZN", "date": "20170714", "value": 1001.809998 },
					{ "name": "AMZN", "date": "20170717", "value": 1010.039978 },
					{ "name": "AMZN", "date": "20170718", "value": 1024.449951 },
					{ "name": "AMZN", "date": "20170719", "value": 1026.869995 },
					{ "name": "AMZN", "date": "20170720", "value": 1028.699951 },
					{ "name": "AMZN", "date": "20170721", "value": 1025.670044 },
					{ "name": "AMZN", "date": "20170724", "value": 1038.949951 },
					{ "name": "AMZN", "date": "20170725", "value": 1039.869995 },
					{ "name": "AMZN", "date": "20170726", "value": 1052.800049 },
					{ "name": "AMZN", "date": "20170727", "value": 1046 },
					{ "name": "AMZN", "date": "20170728", "value": 1020.039978 },
					{ "name": "AMZN", "date": "20170731", "value": 987.780029 },
					{ "name": "AMZN", "date": "20170801", "value": 996.190002 },
					{ "name": "AMZN", "date": "20170802", "value": 995.890015 },
					{ "name": "AMZN", "date": "20170803", "value": 986.919983 },
					{ "name": "AMZN", "date": "20170804", "value": 987.580017 },
					{ "name": "AMZN", "date": "20170807", "value": 992.27002 },
					{ "name": "AMZN", "date": "20170808", "value": 989.840027 },
					{ "name": "AMZN", "date": "20170809", "value": 982.01001 },
					{ "name": "AMZN", "date": "20170810", "value": 956.919983 },
					{ "name": "AMZN", "date": "20170811", "value": 967.98999 },
					{ "name": "AMZN", "date": "20170814", "value": 983.299988 },
					{ "name": "AMZN", "date": "20170815", "value": 982.73999 },
					{ "name": "AMZN", "date": "20170816", "value": 978.179993 },
					{ "name": "AMZN", "date": "20170817", "value": 960.570007 },
					{ "name": "AMZN", "date": "20170818", "value": 958.469971 },
					{ "name": "AMZN", "date": "20170821", "value": 953.289978 },
					{ "name": "AMZN", "date": "20170822", "value": 966.900024 },
					{ "name": "AMZN", "date": "20170823", "value": 958 },
					{ "name": "AMZN", "date": "20170824", "value": 952.450012 },
					{ "name": "AMZN", "date": "20170825", "value": 945.26001 },
					{ "name": "AMZN", "date": "20170828", "value": 946.02002 },
					{ "name": "AMZN", "date": "20170829", "value": 954.059998 },
					{ "name": "AMZN", "date": "20170830", "value": 967.590027 },
					{ "name": "AMZN", "date": "20170831", "value": 980.599976 },
					{ "name": "AMZN", "date": "20170901", "value": 978.25 },
					{ "name": "AMZN", "date": "20170905", "value": 965.27002 },
					{ "name": "AMZN", "date": "20170906", "value": 967.799988 },
					{ "name": "AMZN", "date": "20170907", "value": 979.469971 },
					{ "name": "AMZN", "date": "20170908", "value": 965.900024 },
					{ "name": "AMZN", "date": "20170911", "value": 977.960022 },
					{ "name": "AMZN", "date": "20170912", "value": 982.580017 },
					{ "name": "AMZN", "date": "20170913", "value": 999.599976 },
					{ "name": "AMZN", "date": "20170914", "value": 992.210022 },
					{ "name": "AMZN", "date": "20170915", "value": 986.789978 },
					{ "name": "AMZN", "date": "20170918", "value": 974.190002 },
					{ "name": "AMZN", "date": "20170919", "value": 969.859985 },
					{ "name": "AMZN", "date": "20170920", "value": 973.210022 },
					{ "name": "AMZN", "date": "20170921", "value": 964.650024 },
					{ "name": "AMZN", "date": "20170922", "value": 955.099976 },
					{ "name": "AMZN", "date": "20170925", "value": 939.789978 },
					{ "name": "AMZN", "date": "20170926", "value": 938.599976 },
					{ "name": "AMZN", "date": "20170927", "value": 950.869995 },
					{ "name": "AMZN", "date": "20170928", "value": 956.400024 },
					{ "name": "AMZN", "date": "20170929", "value": 961.349976 },
					{ "name": "AMZN", "date": "20171002", "value": 959.190002 },
					{ "name": "AMZN", "date": "20171003", "value": 957.099976 },
					{ "name": "AMZN", "date": "20171004", "value": 965.450012 },
					{ "name": "AMZN", "date": "20171005", "value": 980.849976 },
					{ "name": "AMZN", "date": "20171006", "value": 989.580017 },
					{ "name": "AMZN", "date": "20171009", "value": 990.98999 },
					{ "name": "AMZN", "date": "20171010", "value": 987.200012 },
					{ "name": "AMZN", "date": "20171011", "value": 995 },
					{ "name": "AMZN", "date": "20171012", "value": 1000.929993 },
					{ "name": "AMZN", "date": "20171013", "value": 1002.940002 },
					{ "name": "AMZN", "date": "20171016", "value": 1006.340027 },
					{ "name": "AMZN", "date": "20171017", "value": 1009.130005 },
					{ "name": "AMZN", "date": "20171018", "value": 997 },
					{ "name": "AMZN", "date": "20171019", "value": 986.609985 },
					{ "name": "AMZN", "date": "20171020", "value": 982.909973 },
					{ "name": "AMZN", "date": "20171023", "value": 966.299988 },
					{ "name": "AMZN", "date": "20171024", "value": 975.900024 },
					{ "name": "AMZN", "date": "20171025", "value": 972.909973 },
					{ "name": "AMZN", "date": "20171026", "value": 972.429993 },
					{ "name": "AMZN", "date": "20171027", "value": 1100.949951 },
					{ "name": "AMZN", "date": "20171030", "value": 1110.849976 },
					{ "name": "AMZN", "date": "20171031", "value": 1105.280029 },
					{ "name": "AMZN", "date": "20171101", "value": 1103.680054 },
					{ "name": "AMZN", "date": "20171102", "value": 1094.219971 },
					{ "name": "AMZN", "date": "20171103", "value": 1111.599976 },
					{ "name": "AMZN", "date": "20171106", "value": 1120.660034 },
					{ "name": "AMZN", "date": "20171107", "value": 1123.170044 },
					{ "name": "AMZN", "date": "20171108", "value": 1132.880005 },
					{ "name": "AMZN", "date": "20171109", "value": 1129.130005 },
					{ "name": "AMZN", "date": "20171110", "value": 1125.349976 },
					{ "name": "AMZN", "date": "20171113", "value": 1129.170044 },
					{ "name": "AMZN", "date": "20171114", "value": 1136.839966 },
					{ "name": "AMZN", "date": "20171115", "value": 1126.689941 },
					{ "name": "AMZN", "date": "20171116", "value": 1137.290039 },
					{ "name": "AMZN", "date": "20171117", "value": 1129.880005 },
					{ "name": "AMZN", "date": "20171120", "value": 1126.310059 },
					{ "name": "AMZN", "date": "20171121", "value": 1139.48999 },
					{ "name": "AMZN", "date": "20171122", "value": 1156.160034 },
					{ "name": "AMZN", "date": "20171124", "value": 1186 },
					{ "name": "AMZN", "date": "20171127", "value": 1195.829956 },
					{ "name": "AMZN", "date": "20171128", "value": 1193.599976 },
					{ "name": "AMZN", "date": "20171129", "value": 1161.27002 },
					{ "name": "AMZN", "date": "20171130", "value": 1176.75 },
					{ "name": "AMZN", "date": "20171201", "value": 1162.349976 },
					{ "name": "AMZN", "date": "20171204", "value": 1133.949951 },
					{ "name": "AMZN", "date": "20171205", "value": 1141.569946 },
					{ "name": "AMZN", "date": "20171206", "value": 1152.349976 },
					{ "name": "AMZN", "date": "20171207", "value": 1159.790039 },
					{ "name": "AMZN", "date": "20171208", "value": 1162 },
					{ "name": "AMZN", "date": "20171211", "value": 1168.920044 },
					{ "name": "AMZN", "date": "20171212", "value": 1165.079956 },
					{ "name": "AMZN", "date": "20171213", "value": 1164.130005 },
					{ "name": "AMZN", "date": "20171214", "value": 1174.26001 },
					{ "name": "AMZN", "date": "20171215", "value": 1179.140015 },
					{ "name": "AMZN", "date": "20171218", "value": 1190.579956 },
					{ "name": "AMZN", "date": "20171219", "value": 1187.380005 },
					{ "name": "AMZN", "date": "20171220", "value": 1177.619995 },
					{ "name": "AMZN", "date": "20171221", "value": 1174.76001 },
					{ "name": "AMZN", "date": "20171222", "value": 1168.359985 },
					{ "name": "AMZN", "date": "20171226", "value": 1176.76001 },
					{ "name": "AMZN", "date": "20171227", "value": 1182.26001 },
					{ "name": "AMZN", "date": "20171228", "value": 1186.099976 },
					{ "name": "AMZN", "date": "20171229", "value": 1169.469971 },
					{ "name": "AMZN", "date": "20180102", "value": 1189.01001 },
					{ "name": "AMZN", "date": "20180103", "value": 1204.199951 },
					{ "name": "AMZN", "date": "20180104", "value": 1209.589966 },
					{ "name": "AMZN", "date": "20180105", "value": 1229.140015 },
					{ "name": "AMZN", "date": "20180108", "value": 1246.869995 },
					{ "name": "AMZN", "date": "20180109", "value": 1252.699951 },
					{ "name": "AMZN", "date": "20180110", "value": 1254.329956 },
					{ "name": "AMZN", "date": "20180111", "value": 1276.680054 },
					{ "name": "AMZN", "date": "20180112", "value": 1305.199951 },
					{ "name": "AMZN", "date": "20180116", "value": 1304.859985 },
					{ "name": "AMZN", "date": "20180117", "value": 1295 },
					{ "name": "AMZN", "date": "20180118", "value": 1293.319946 },
					{ "name": "AMZN", "date": "20180119", "value": 1294.579956 },
					{ "name": "AMZN", "date": "20180122", "value": 1327.310059 },
					{ "name": "AMZN", "date": "20180123", "value": 1362.540039 },
					{ "name": "AMZN", "date": "20180124", "value": 1357.51001 },
					{ "name": "AMZN", "date": "20180125", "value": 1377.949951 },
					{ "name": "AMZN", "date": "20180126", "value": 1402.050049 },
					{ "name": "AMZN", "date": "20180129", "value": 1417.680054 },
					{ "name": "AMZN", "date": "20180130", "value": 1437.819946 },
					{ "name": "AMZN", "date": "20180131", "value": 1450.890015 },
					{ "name": "AMZN", "date": "20180201", "value": 1390 },
					{ "name": "AMZN", "date": "20180202", "value": 1429.949951 },
					{ "name": "AMZN", "date": "20180205", "value": 1390 },
					{ "name": "AMZN", "date": "20180206", "value": 1442.839966 },
					{ "name": "AMZN", "date": "20180207", "value": 1416.780029 },
					{ "name": "AMZN", "date": "20180208", "value": 1350.5 },
					{ "name": "AMZN", "date": "20180209", "value": 1339.599976 },
					{ "name": "AMZN", "date": "20180212", "value": 1386.22998 },
					{ "name": "AMZN", "date": "20180213", "value": 1414.51001 },
					{ "name": "AMZN", "date": "20180214", "value": 1451.050049 },
					{ "name": "AMZN", "date": "20180215", "value": 1461.76001 },
					{ "name": "AMZN", "date": "20180216", "value": 1448.689941 },
					{ "name": "AMZN", "date": "20180220", "value": 1468.349976 },
					{ "name": "AMZN", "date": "20180221", "value": 1482.920044 },
					{ "name": "AMZN", "date": "20180222", "value": 1485.339966 },
					{ "name": "AMZN", "date": "20180223", "value": 1500 },
					{ "name": "AMZN", "date": "20180226", "value": 1521.949951 },
					{ "name": "AMZN", "date": "20180227", "value": 1511.97998 },
					{ "name": "AMZN", "date": "20180228", "value": 1512.449951 },
					{ "name": "AMZN", "date": "20180301", "value": 1493.449951 },
					{ "name": "AMZN", "date": "20180302", "value": 1500.25 },
					{ "name": "AMZN", "date": "20180305", "value": 1523.609985 },
					{ "name": "AMZN", "date": "20180306", "value": 1537.640015 },
					{ "name": "AMZN", "date": "20180307", "value": 1545 },
					{ "name": "AMZN", "date": "20180308", "value": 1551.859985 },
					{ "name": "AMZN", "date": "20180309", "value": 1578.890015 },
					{ "name": "AMZN", "date": "20180312", "value": 1598.390015 },
					{ "name": "AMZN", "date": "20180313", "value": 1588.180054 },
					{ "name": "AMZN", "date": "20180314", "value": 1591 },
					{ "name": "AMZN", "date": "20180315", "value": 1582.319946 },
					{ "name": "AMZN", "date": "20180316", "value": 1571.680054 },
					{ "name": "AMZN", "date": "20180319", "value": 1544.930054 },
					{ "name": "AMZN", "date": "20180320", "value": 1586.51001 },
					{ "name": "AMZN", "date": "20180321", "value": 1581.859985 },
					{ "name": "AMZN", "date": "20180322", "value": 1544.920044 },
					{ "name": "AMZN", "date": "20180323", "value": 1495.560059 },
					{ "name": "AMZN", "date": "20180326", "value": 1555.859985 },
					{ "name": "AMZN", "date": "20180327", "value": 1497.050049 },
					{ "name": "AMZN", "date": "20180328", "value": 1431.420044 },
					{ "name": "AMZN", "date": "20180329", "value": 1447.339966 },
					{ "name": "AMZN", "date": "20180402", "value": 1371.98999 },
					{ "name": "AMZN", "date": "20180403", "value": 1392.050049 },
					{ "name": "AMZN", "date": "20180404", "value": 1410.569946 },
					{ "name": "AMZN", "date": "20180405", "value": 1451.75 },
					{ "name": "AMZN", "date": "20180406", "value": 1405.22998 },
					{ "name": "AMZN", "date": "20180409", "value": 1406.079956 },
					{ "name": "AMZN", "date": "20180410", "value": 1436.219971 },
					{ "name": "AMZN", "date": "20180411", "value": 1427.050049 },
					{ "name": "AMZN", "date": "20180412", "value": 1448.5 },
					{ "name": "AMZN", "date": "20180413", "value": 1430.790039 },
					{ "name": "AMZN", "date": "20180416", "value": 1441.5 },
					{ "name": "AMZN", "date": "20180417", "value": 1503.829956 },
					{ "name": "AMZN", "date": "20180418", "value": 1527.839966 },
					{ "name": "AMZN", "date": "20180419", "value": 1556.910034 },
					{ "name": "AMZN", "date": "20180420", "value": 1527.48999 },
					{ "name": "AMZN", "date": "20180423", "value": 1517.859985 },
					{ "name": "AMZN", "date": "20180424", "value": 1460.089966 },
					{ "name": "AMZN", "date": "20180425", "value": 1460.170044 },
					{ "name": "AMZN", "date": "20180426", "value": 1517.959961 },
					{ "name": "AMZN", "date": "20180427", "value": 1572.619995 },
					{ "name": "AMZN", "date": "20180430", "value": 1566.130005 },
					{ "name": "AMZN", "date": "20180501", "value": 1582.26001 },
					{ "name": "AMZN", "date": "20180502", "value": 1569.680054 },
					{ "name": "AMZN", "date": "20180503", "value": 1572.079956 },
					{ "name": "AMZN", "date": "20180504", "value": 1580.949951 },
					{ "name": "AMZN", "date": "20180507", "value": 1600.140015 },
					{ "name": "AMZN", "date": "20180508", "value": 1592.390015 },
					{ "name": "AMZN", "date": "20180509", "value": 1608 },
					{ "name": "AMZN", "date": "20180510", "value": 1609.079956 },
					{ "name": "AMZN", "date": "20180511", "value": 1602.910034 },
					{ "name": "GOOG", "date": "20130513", "value": 435.929688 },
					{ "name": "GOOG", "date": "20130514", "value": 440.683777 },
					{ "name": "GOOG", "date": "20130515", "value": 454.985748 },
					{ "name": "GOOG", "date": "20130516", "value": 449.014587 },
					{ "name": "GOOG", "date": "20130517", "value": 451.652435 },
					{ "name": "GOOG", "date": "20130520", "value": 451.329529 },
					{ "name": "GOOG", "date": "20130521", "value": 450.554565 },
					{ "name": "GOOG", "date": "20130522", "value": 441.836273 },
					{ "name": "GOOG", "date": "20130523", "value": 438.542694 },
					{ "name": "GOOG", "date": "20130524", "value": 433.838287 },
					{ "name": "GOOG", "date": "20130528", "value": 437.787628 },
					{ "name": "GOOG", "date": "20130529", "value": 431.349487 },
					{ "name": "GOOG", "date": "20130530", "value": 432.566559 },
					{ "name": "GOOG", "date": "20130531", "value": 432.795074 },
					{ "name": "GOOG", "date": "20130603", "value": 431.011688 },
					{ "name": "GOOG", "date": "20130604", "value": 426.774231 },
					{ "name": "GOOG", "date": "20130605", "value": 427.072296 },
					{ "name": "GOOG", "date": "20130606", "value": 429.526337 },
					{ "name": "GOOG", "date": "20130607", "value": 437.022583 },
					{ "name": "GOOG", "date": "20130610", "value": 442.233704 },
					{ "name": "GOOG", "date": "20130611", "value": 437.062317 },
					{ "name": "GOOG", "date": "20130612", "value": 433.172638 },
					{ "name": "GOOG", "date": "20130613", "value": 435.666412 },
					{ "name": "GOOG", "date": "20130614", "value": 434.692749 },
					{ "name": "GOOG", "date": "20130617", "value": 440.261536 },
					{ "name": "GOOG", "date": "20130618", "value": 447.400085 },
					{ "name": "GOOG", "date": "20130619", "value": 447.429901 },
					{ "name": "GOOG", "date": "20130620", "value": 439.511414 },
					{ "name": "GOOG", "date": "20130621", "value": 437.618713 },
					{ "name": "GOOG", "date": "20130624", "value": 432.084717 },
					{ "name": "GOOG", "date": "20130625", "value": 430.3013 },
					{ "name": "GOOG", "date": "20130626", "value": 434.002228 },
					{ "name": "GOOG", "date": "20130627", "value": 435.701172 },
					{ "name": "GOOG", "date": "20130628", "value": 437.340515 },
					{ "name": "GOOG", "date": "20130701", "value": 441.071259 },
					{ "name": "GOOG", "date": "20130702", "value": 438.30426 },
					{ "name": "GOOG", "date": "20130703", "value": 440.350952 },
					{ "name": "GOOG", "date": "20130705", "value": 443.858124 },
					{ "name": "GOOG", "date": "20130708", "value": 449.620636 },
					{ "name": "GOOG", "date": "20130709", "value": 449.69516 },
					{ "name": "GOOG", "date": "20130710", "value": 450.067749 },
					{ "name": "GOOG", "date": "20130711", "value": 457.146698 },
					{ "name": "GOOG", "date": "20130712", "value": 458.517792 },
					{ "name": "GOOG", "date": "20130715", "value": 459.35733 },
					{ "name": "GOOG", "date": "20130716", "value": 456.83374 },
					{ "name": "GOOG", "date": "20130717", "value": 456.307159 },
					{ "name": "GOOG", "date": "20130718", "value": 452.397583 },
					{ "name": "GOOG", "date": "20130719", "value": 445.403076 },
					{ "name": "GOOG", "date": "20130722", "value": 452.407532 },
					{ "name": "GOOG", "date": "20130723", "value": 448.979828 },
					{ "name": "GOOG", "date": "20130724", "value": 448.532715 },
					{ "name": "GOOG", "date": "20130725", "value": 440.981842 },
					{ "name": "GOOG", "date": "20130726", "value": 439.814423 },
					{ "name": "GOOG", "date": "20130729", "value": 438.284393 },
					{ "name": "GOOG", "date": "20130730", "value": 442.581421 },
					{ "name": "GOOG", "date": "20130731", "value": 441.006683 },
					{ "name": "GOOG", "date": "20130801", "value": 449.188477 },
					{ "name": "GOOG", "date": "20130802", "value": 450.355865 },
					{ "name": "GOOG", "date": "20130805", "value": 449.575928 },
					{ "name": "GOOG", "date": "20130806", "value": 445.388184 },
					{ "name": "GOOG", "date": "20130807", "value": 442.447296 },
					{ "name": "GOOG", "date": "20130808", "value": 443.445801 },
					{ "name": "GOOG", "date": "20130809", "value": 442.328094 },
					{ "name": "GOOG", "date": "20130812", "value": 439.893921 },
					{ "name": "GOOG", "date": "20130813", "value": 437.777679 },
					{ "name": "GOOG", "date": "20130814", "value": 432.094635 },
					{ "name": "GOOG", "date": "20130815", "value": 427.052429 },
					{ "name": "GOOG", "date": "20130816", "value": 425.68631 },
					{ "name": "GOOG", "date": "20130819", "value": 430.028076 },
					{ "name": "GOOG", "date": "20130820", "value": 429.913818 },
					{ "name": "GOOG", "date": "20130821", "value": 431.856201 },
					{ "name": "GOOG", "date": "20130822", "value": 434.032043 },
					{ "name": "GOOG", "date": "20130823", "value": 432.293335 },
					{ "name": "GOOG", "date": "20130826", "value": 430.395691 },
					{ "name": "GOOG", "date": "20130827", "value": 422.328156 },
					{ "name": "GOOG", "date": "20130828", "value": 421.533325 },
					{ "name": "GOOG", "date": "20130829", "value": 424.951111 },
					{ "name": "GOOG", "date": "20130830", "value": 420.713654 },
					{ "name": "GOOG", "date": "20130903", "value": 427.410095 },
					{ "name": "GOOG", "date": "20130904", "value": 432.998749 },
					{ "name": "GOOG", "date": "20130905", "value": 436.938141 },
					{ "name": "GOOG", "date": "20130906", "value": 436.948059 },
					{ "name": "GOOG", "date": "20130909", "value": 441.155701 },
					{ "name": "GOOG", "date": "20130910", "value": 441.463715 },
					{ "name": "GOOG", "date": "20130911", "value": 445.199402 },
					{ "name": "GOOG", "date": "20130912", "value": 443.644531 },
					{ "name": "GOOG", "date": "20130913", "value": 441.662415 },
					{ "name": "GOOG", "date": "20130916", "value": 441.011658 },
					{ "name": "GOOG", "date": "20130917", "value": 440.191986 },
					{ "name": "GOOG", "date": "20130918", "value": 448.741364 },
					{ "name": "GOOG", "date": "20130919", "value": 446.292297 },
					{ "name": "GOOG", "date": "20130920", "value": 448.637054 },
					{ "name": "GOOG", "date": "20130923", "value": 440.385712 },
					{ "name": "GOOG", "date": "20130924", "value": 440.554626 },
					{ "name": "GOOG", "date": "20130925", "value": 435.78067 },
					{ "name": "GOOG", "date": "20130926", "value": 436.24762 },
					{ "name": "GOOG", "date": "20130927", "value": 435.363373 },
					{ "name": "GOOG", "date": "20130930", "value": 435.124939 },
					{ "name": "GOOG", "date": "20131001", "value": 440.634094 },
					{ "name": "GOOG", "date": "20131002", "value": 441.125916 },
					{ "name": "GOOG", "date": "20131003", "value": 435.214355 },
					{ "name": "GOOG", "date": "20131004", "value": 433.356445 },
					{ "name": "GOOG", "date": "20131007", "value": 430.072784 },
					{ "name": "GOOG", "date": "20131008", "value": 424.076782 },
					{ "name": "GOOG", "date": "20131009", "value": 425.164703 },
					{ "name": "GOOG", "date": "20131010", "value": 431.314728 },
					{ "name": "GOOG", "date": "20131011", "value": 433.177612 },
					{ "name": "GOOG", "date": "20131014", "value": 435.224274 },
					{ "name": "GOOG", "date": "20131015", "value": 438.155212 },
					{ "name": "GOOG", "date": "20131016", "value": 446.113464 },
					{ "name": "GOOG", "date": "20131017", "value": 441.523315 },
					{ "name": "GOOG", "date": "20131018", "value": 502.437134 },
					{ "name": "GOOG", "date": "20131021", "value": 498.408325 },
					{ "name": "GOOG", "date": "20131022", "value": 500.246368 },
					{ "name": "GOOG", "date": "20131023", "value": 512.372498 },
					{ "name": "GOOG", "date": "20131024", "value": 509.461456 },
					{ "name": "GOOG", "date": "20131025", "value": 504.319885 },
					{ "name": "GOOG", "date": "20131028", "value": 504.22052 },
					{ "name": "GOOG", "date": "20131029", "value": 514.771912 },
					{ "name": "GOOG", "date": "20131030", "value": 511.880707 },
					{ "name": "GOOG", "date": "20131031", "value": 511.960205 },
					{ "name": "GOOG", "date": "20131101", "value": 510.20163 },
					{ "name": "GOOG", "date": "20131104", "value": 509.739624 },
					{ "name": "GOOG", "date": "20131105", "value": 507.459473 },
					{ "name": "GOOG", "date": "20131106", "value": 508.070496 },
					{ "name": "GOOG", "date": "20131107", "value": 500.718323 },
					{ "name": "GOOG", "date": "20131108", "value": 504.732208 },
					{ "name": "GOOG", "date": "20131111", "value": 502.029785 },
					{ "name": "GOOG", "date": "20131112", "value": 502.620941 },
					{ "name": "GOOG", "date": "20131113", "value": 512.899109 },
					{ "name": "GOOG", "date": "20131114", "value": 514.270142 },
					{ "name": "GOOG", "date": "20131115", "value": 513.440552 },
					{ "name": "GOOG", "date": "20131118", "value": 512.442078 },
					{ "name": "GOOG", "date": "20131119", "value": 509.287567 },
					{ "name": "GOOG", "date": "20131120", "value": 507.851898 },
					{ "name": "GOOG", "date": "20131121", "value": 513.693909 },
					{ "name": "GOOG", "date": "20131122", "value": 512.610962 },
					{ "name": "GOOG", "date": "20131125", "value": 519.585571 },
					{ "name": "GOOG", "date": "20131126", "value": 525.785278 },
					{ "name": "GOOG", "date": "20131127", "value": 528.120117 },
					{ "name": "GOOG", "date": "20131129", "value": 526.37146 },
					{ "name": "GOOG", "date": "20131202", "value": 523.832947 },
					{ "name": "GOOG", "date": "20131203", "value": 523.226929 },
					{ "name": "GOOG", "date": "20131204", "value": 525.671021 },
					{ "name": "GOOG", "date": "20131205", "value": 525.253723 },
					{ "name": "GOOG", "date": "20131206", "value": 531.478271 },
					{ "name": "GOOG", "date": "20131209", "value": 535.586548 },
					{ "name": "GOOG", "date": "20131210", "value": 538.825439 },
					{ "name": "GOOG", "date": "20131211", "value": 535.164246 },
					{ "name": "GOOG", "date": "20131212", "value": 531.522949 },
					{ "name": "GOOG", "date": "20131213", "value": 526.96759 },
					{ "name": "GOOG", "date": "20131216", "value": 533.023193 },
					{ "name": "GOOG", "date": "20131217", "value": 531.473267 },
					{ "name": "GOOG", "date": "20131218", "value": 538.870178 },
					{ "name": "GOOG", "date": "20131219", "value": 539.600403 },
					{ "name": "GOOG", "date": "20131220", "value": 546.753906 },
					{ "name": "GOOG", "date": "20131223", "value": 553.947083 },
					{ "name": "GOOG", "date": "20131224", "value": 552.327637 },
					{ "name": "GOOG", "date": "20131226", "value": 555.119507 },
					{ "name": "GOOG", "date": "20131227", "value": 555.586426 },
					{ "name": "GOOG", "date": "20131230", "value": 551.145325 },
					{ "name": "GOOG", "date": "20131231", "value": 556.734009 },
					{ "name": "GOOG", "date": "20140102", "value": 552.963501 },
					{ "name": "GOOG", "date": "20140103", "value": 548.929749 },
					{ "name": "GOOG", "date": "20140106", "value": 555.049927 },
					{ "name": "GOOG", "date": "20140107", "value": 565.750366 },
					{ "name": "GOOG", "date": "20140108", "value": 566.927673 },
					{ "name": "GOOG", "date": "20140109", "value": 561.468201 },
					{ "name": "GOOG", "date": "20140110", "value": 561.438354 },
					{ "name": "GOOG", "date": "20140113", "value": 557.861633 },
					{ "name": "GOOG", "date": "20140114", "value": 570.986267 },
					{ "name": "GOOG", "date": "20140115", "value": 570.598816 },
					{ "name": "GOOG", "date": "20140116", "value": 574.374268 },
					{ "name": "GOOG", "date": "20140117", "value": 571.547607 },
					{ "name": "GOOG", "date": "20140121", "value": 578.090088 },
					{ "name": "GOOG", "date": "20140122", "value": 578.745789 },
					{ "name": "GOOG", "date": "20140123", "value": 576.301697 },
					{ "name": "GOOG", "date": "20140124", "value": 558.283875 },
					{ "name": "GOOG", "date": "20140127", "value": 547.056946 },
					{ "name": "GOOG", "date": "20140128", "value": 557.876526 },
					{ "name": "GOOG", "date": "20140129", "value": 549.883545 },
					{ "name": "GOOG", "date": "20140130", "value": 564.02655 },
					{ "name": "GOOG", "date": "20140131", "value": 586.669312 },
					{ "name": "GOOG", "date": "20140203", "value": 563.052856 },
					{ "name": "GOOG", "date": "20140204", "value": 565.402588 },
					{ "name": "GOOG", "date": "20140205", "value": 567.906311 },
					{ "name": "GOOG", "date": "20140206", "value": 576.232178 },
					{ "name": "GOOG", "date": "20140207", "value": 584.91571 },
					{ "name": "GOOG", "date": "20140210", "value": 582.675232 },
					{ "name": "GOOG", "date": "20140211", "value": 591.244507 },
					{ "name": "GOOG", "date": "20140212", "value": 589.510803 },
					{ "name": "GOOG", "date": "20140213", "value": 596.07312 },
					{ "name": "GOOG", "date": "20140214", "value": 597.513733 },
					{ "name": "GOOG", "date": "20140218", "value": 601.527649 },
					{ "name": "GOOG", "date": "20140219", "value": 597.285217 },
					{ "name": "GOOG", "date": "20140220", "value": 598.16449 },
					{ "name": "GOOG", "date": "20140221", "value": 598.005554 },
					{ "name": "GOOG", "date": "20140224", "value": 602.337402 },
					{ "name": "GOOG", "date": "20140225", "value": 606.058167 },
					{ "name": "GOOG", "date": "20140226", "value": 606.142639 },
					{ "name": "GOOG", "date": "20140227", "value": 605.66571 },
					{ "name": "GOOG", "date": "20140228", "value": 603.897217 },
					{ "name": "GOOG", "date": "20140303", "value": 597.459106 },
					{ "name": "GOOG", "date": "20140304", "value": 603.529602 },
					{ "name": "GOOG", "date": "20140305", "value": 605.193787 },
					{ "name": "GOOG", "date": "20140306", "value": 605.864441 },
					{ "name": "GOOG", "date": "20140307", "value": 603.470032 },
					{ "name": "GOOG", "date": "20140310", "value": 601.870422 },
					{ "name": "GOOG", "date": "20140311", "value": 596.117798 },
					{ "name": "GOOG", "date": "20140312", "value": 599.749207 },
					{ "name": "GOOG", "date": "20140313", "value": 590.688171 },
					{ "name": "GOOG", "date": "20140314", "value": 582.610657 },
					{ "name": "GOOG", "date": "20140317", "value": 592.198303 },
					{ "name": "GOOG", "date": "20140318", "value": 601.716431 },
					{ "name": "GOOG", "date": "20140319", "value": 595.750244 },
					{ "name": "GOOG", "date": "20140320", "value": 594.711975 },
					{ "name": "GOOG", "date": "20140321", "value": 587.697571 },
					{ "name": "GOOG", "date": "20140324", "value": 575.223694 },
					{ "name": "GOOG", "date": "20140325", "value": 575.61615 },
					{ "name": "GOOG", "date": "20140326", "value": 562.327576 },
					{ "name": "GOOG", "date": "20140327", "value": 555.406067 },
					{ "name": "GOOG", "date": "20140328", "value": 556.927734 },
					{ "name": "GOOG", "date": "20140331", "value": 553.924255 },
					{ "name": "GOOG", "date": "20140401", "value": 564.058533 },
					{ "name": "GOOG", "date": "20140402", "value": 563.899353 },
					{ "name": "GOOG", "date": "20140403", "value": 566.62439 },
					{ "name": "GOOG", "date": "20140404", "value": 540.169861 },
					{ "name": "GOOG", "date": "20140407", "value": 535.207153 },
					{ "name": "GOOG", "date": "20140408", "value": 551.86554 },
					{ "name": "GOOG", "date": "20140409", "value": 561.054993 },
					{ "name": "GOOG", "date": "20140410", "value": 537.991821 },
					{ "name": "GOOG", "date": "20140411", "value": 527.698425 },
					{ "name": "GOOG", "date": "20140414", "value": 529.60791 },
					{ "name": "GOOG", "date": "20140415", "value": 533.50647 },
					{ "name": "GOOG", "date": "20140416", "value": 553.496582 },
					{ "name": "GOOG", "date": "20140417", "value": 533.168335 },
					{ "name": "GOOG", "date": "20140421", "value": 525.729248 },
					{ "name": "GOOG", "date": "20140422", "value": 531.885437 },
					{ "name": "GOOG", "date": "20140423", "value": 524.058472 },
					{ "name": "GOOG", "date": "20140424", "value": 522.288208 },
					{ "name": "GOOG", "date": "20140425", "value": 513.3573 },
					{ "name": "GOOG", "date": "20140428", "value": 514.32196 },
					{ "name": "GOOG", "date": "20140429", "value": 524.81427 },
					{ "name": "GOOG", "date": "20140430", "value": 523.779968 },
					{ "name": "GOOG", "date": "20140501", "value": 528.444336 },
					{ "name": "GOOG", "date": "20140502", "value": 525.04303 },
					{ "name": "GOOG", "date": "20140505", "value": 524.923706 },
					{ "name": "GOOG", "date": "20140506", "value": 512.322998 },
					{ "name": "GOOG", "date": "20140507", "value": 507.171295 },
					{ "name": "GOOG", "date": "20140508", "value": 508.205627 },
					{ "name": "GOOG", "date": "20140509", "value": 515.893311 },
					{ "name": "GOOG", "date": "20140512", "value": 527.022156 },
					{ "name": "GOOG", "date": "20140513", "value": 530.174805 },
					{ "name": "GOOG", "date": "20140514", "value": 523.77002 },
					{ "name": "GOOG", "date": "20140515", "value": 517.136536 },
					{ "name": "GOOG", "date": "20140516", "value": 517.782959 },
					{ "name": "GOOG", "date": "20140519", "value": 525.967957 },
					{ "name": "GOOG", "date": "20140520", "value": 526.872986 },
					{ "name": "GOOG", "date": "20140521", "value": 535.992798 },
					{ "name": "GOOG", "date": "20140522", "value": 542.079346 },
					{ "name": "GOOG", "date": "20140523", "value": 549.677551 },
					{ "name": "GOOG", "date": "20140527", "value": 562.855103 },
					{ "name": "GOOG", "date": "20140528", "value": 558.608459 },
					{ "name": "GOOG", "date": "20140529", "value": 557.017212 },
					{ "name": "GOOG", "date": "20140530", "value": 556.828247 },
					{ "name": "GOOG", "date": "20140602", "value": 550.900879 },
					{ "name": "GOOG", "date": "20140603", "value": 541.960022 },
					{ "name": "GOOG", "date": "20140604", "value": 541.681519 },
					{ "name": "GOOG", "date": "20140605", "value": 550.871033 },
					{ "name": "GOOG", "date": "20140606", "value": 553.28772 },
					{ "name": "GOOG", "date": "20140609", "value": 559.046082 },
					{ "name": "GOOG", "date": "20140610", "value": 557.484619 },
					{ "name": "GOOG", "date": "20140611", "value": 555.783997 },
					{ "name": "GOOG", "date": "20140612", "value": 548.334961 },
					{ "name": "GOOG", "date": "20140613", "value": 548.742737 },
					{ "name": "GOOG", "date": "20140616", "value": 541.30365 },
					{ "name": "GOOG", "date": "20140617", "value": 540.040588 },
					{ "name": "GOOG", "date": "20140618", "value": 550.343933 },
					{ "name": "GOOG", "date": "20140619", "value": 551.86554 },
					{ "name": "GOOG", "date": "20140620", "value": 553.317566 },
					{ "name": "GOOG", "date": "20140623", "value": 561.860596 },
					{ "name": "GOOG", "date": "20140624", "value": 561.53241 },
					{ "name": "GOOG", "date": "20140625", "value": 575.485657 },
					{ "name": "GOOG", "date": "20140626", "value": 572.850159 },
					{ "name": "GOOG", "date": "20140627", "value": 574.083374 },
					{ "name": "GOOG", "date": "20140630", "value": 572.134094 },
					{ "name": "GOOG", "date": "20140701", "value": 579.483704 },
					{ "name": "GOOG", "date": "20140702", "value": 579.150513 },
					{ "name": "GOOG", "date": "20140703", "value": 581.53241 },
					{ "name": "GOOG", "date": "20140707", "value": 579.065979 },
					{ "name": "GOOG", "date": "20140708", "value": 567.967041 },
					{ "name": "GOOG", "date": "20140709", "value": 572.929749 },
					{ "name": "GOOG", "date": "20140710", "value": 567.976929 },
					{ "name": "GOOG", "date": "20140711", "value": 576.012756 },
					{ "name": "GOOG", "date": "20140714", "value": 581.671631 },
					{ "name": "GOOG", "date": "20140715", "value": 581.582153 },
					{ "name": "GOOG", "date": "20140716", "value": 579.473755 },
					{ "name": "GOOG", "date": "20140717", "value": 570.59259 },
					{ "name": "GOOG", "date": "20140718", "value": 591.825806 },
					{ "name": "GOOG", "date": "20140721", "value": 586.246521 },
					{ "name": "GOOG", "date": "20140722", "value": 591.487671 },
					{ "name": "GOOG", "date": "20140723", "value": 592.720886 },
					{ "name": "GOOG", "date": "20140724", "value": 590.105286 },
					{ "name": "GOOG", "date": "20140725", "value": 585.79895 },
					{ "name": "GOOG", "date": "20140728", "value": 587.3703 },
					{ "name": "GOOG", "date": "20140729", "value": 582.407593 },
					{ "name": "GOOG", "date": "20140730", "value": 584.207703 },
					{ "name": "GOOG", "date": "20140731", "value": 568.474243 },
					{ "name": "GOOG", "date": "20140801", "value": 562.974487 },
					{ "name": "GOOG", "date": "20140804", "value": 570.015747 },
					{ "name": "GOOG", "date": "20140805", "value": 561.979919 },
					{ "name": "GOOG", "date": "20140806", "value": 563.276794 },
					{ "name": "GOOG", "date": "20140807", "value": 560.279297 },
					{ "name": "GOOG", "date": "20140808", "value": 565.659729 },
					{ "name": "GOOG", "date": "20140811", "value": 564.774536 },
					{ "name": "GOOG", "date": "20140812", "value": 559.65271 },
					{ "name": "GOOG", "date": "20140813", "value": 571.636841 },
					{ "name": "GOOG", "date": "20140814", "value": 571.507568 },
					{ "name": "GOOG", "date": "20140815", "value": 570.343933 },
					{ "name": "GOOG", "date": "20140818", "value": 578.976501 },
					{ "name": "GOOG", "date": "20140819", "value": 583.650757 },
					{ "name": "GOOG", "date": "20140820", "value": 581.293762 },
					{ "name": "GOOG", "date": "20140821", "value": 580.179871 },
					{ "name": "GOOG", "date": "20140822", "value": 579.374268 },
					{ "name": "GOOG", "date": "20140825", "value": 577.027222 },
					{ "name": "GOOG", "date": "20140826", "value": 574.700012 },
					{ "name": "GOOG", "date": "20140827", "value": 567.877502 },
					{ "name": "GOOG", "date": "20140828", "value": 566.087341 },
					{ "name": "GOOG", "date": "20140829", "value": 568.474243 },
					{ "name": "GOOG", "date": "20140902", "value": 574.172913 },
					{ "name": "GOOG", "date": "20140903", "value": 574.779541 },
					{ "name": "GOOG", "date": "20140904", "value": 578.797485 },
					{ "name": "GOOG", "date": "20140905", "value": 582.875061 },
					{ "name": "GOOG", "date": "20140908", "value": 586.495117 },
					{ "name": "GOOG", "date": "20140909", "value": 577.832764 },
					{ "name": "GOOG", "date": "20140910", "value": 579.911316 },
					{ "name": "GOOG", "date": "20140911", "value": 578.170898 },
					{ "name": "GOOG", "date": "20140912", "value": 572.472229 },
					{ "name": "GOOG", "date": "20140915", "value": 569.966003 },
					{ "name": "GOOG", "date": "20140916", "value": 576.778564 },
					{ "name": "GOOG", "date": "20140917", "value": 581.572205 },
					{ "name": "GOOG", "date": "20140918", "value": 586.047607 },
					{ "name": "GOOG", "date": "20140919", "value": 592.820374 },
					{ "name": "GOOG", "date": "20140922", "value": 584.157959 },
					{ "name": "GOOG", "date": "20140923", "value": 577.952087 },
					{ "name": "GOOG", "date": "20140924", "value": 584.774597 },
					{ "name": "GOOG", "date": "20140925", "value": 571.915283 },
					{ "name": "GOOG", "date": "20140926", "value": 573.944153 },
					{ "name": "GOOG", "date": "20140929", "value": 573.208191 },
					{ "name": "GOOG", "date": "20140930", "value": 574.202698 },
					{ "name": "GOOG", "date": "20141001", "value": 565.162415 },
					{ "name": "GOOG", "date": "20141002", "value": 566.962524 },
					{ "name": "GOOG", "date": "20141003", "value": 572.134094 },
					{ "name": "GOOG", "date": "20141006", "value": 574.192749 },
					{ "name": "GOOG", "date": "20141007", "value": 560.657227 },
					{ "name": "GOOG", "date": "20141008", "value": 569.369324 },
					{ "name": "GOOG", "date": "20141009", "value": 557.812866 },
					{ "name": "GOOG", "date": "20141010", "value": 541.512451 },
					{ "name": "GOOG", "date": "20141013", "value": 530.294128 },
					{ "name": "GOOG", "date": "20141014", "value": 534.998291 },
					{ "name": "GOOG", "date": "20141015", "value": 527.131531 },
					{ "name": "GOOG", "date": "20141016", "value": 521.641724 },
					{ "name": "GOOG", "date": "20141017", "value": 508.374695 },
					{ "name": "GOOG", "date": "20141020", "value": 517.991821 },
					{ "name": "GOOG", "date": "20141021", "value": 523.660645 },
					{ "name": "GOOG", "date": "20141022", "value": 529.796875 },
					{ "name": "GOOG", "date": "20141023", "value": 541.005249 },
					{ "name": "GOOG", "date": "20141024", "value": 536.828247 },
					{ "name": "GOOG", "date": "20141027", "value": 537.812805 },
					{ "name": "GOOG", "date": "20141028", "value": 545.898376 },
					{ "name": "GOOG", "date": "20141029", "value": 546.325989 },
					{ "name": "GOOG", "date": "20141030", "value": 547.300659 },
					{ "name": "GOOG", "date": "20141031", "value": 556.022705 },
					{ "name": "GOOG", "date": "20141103", "value": 552.183777 },
					{ "name": "GOOG", "date": "20141104", "value": 551.079895 },
					{ "name": "GOOG", "date": "20141105", "value": 542.934631 },
					{ "name": "GOOG", "date": "20141106", "value": 539.075867 },
					{ "name": "GOOG", "date": "20141107", "value": 538.051514 },
					{ "name": "GOOG", "date": "20141110", "value": 544.496094 },
					{ "name": "GOOG", "date": "20141111", "value": 547.280762 },
					{ "name": "GOOG", "date": "20141112", "value": 544.317078 },
					{ "name": "GOOG", "date": "20141113", "value": 542.397583 },
					{ "name": "GOOG", "date": "20141114", "value": 541.422974 },
					{ "name": "GOOG", "date": "20141117", "value": 533.576111 },
					{ "name": "GOOG", "date": "20141118", "value": 532.104187 },
					{ "name": "GOOG", "date": "20141119", "value": 534.053467 },
					{ "name": "GOOG", "date": "20141120", "value": 531.905273 },
					{ "name": "GOOG", "date": "20141121", "value": 534.560669 },
					{ "name": "GOOG", "date": "20141124", "value": 536.321045 },
					{ "name": "GOOG", "date": "20141125", "value": 538.121094 },
					{ "name": "GOOG", "date": "20141126", "value": 537.414978 },
					{ "name": "GOOG", "date": "20141128", "value": 538.867004 },
					{ "name": "GOOG", "date": "20141201", "value": 530.88092 },
					{ "name": "GOOG", "date": "20141202", "value": 530.831177 },
					{ "name": "GOOG", "date": "20141203", "value": 528.41449 },
					{ "name": "GOOG", "date": "20141204", "value": 534.371765 },
					{ "name": "GOOG", "date": "20141205", "value": 522.387634 },
					{ "name": "GOOG", "date": "20141208", "value": 524.098206 },
					{ "name": "GOOG", "date": "20141209", "value": 530.453308 },
					{ "name": "GOOG", "date": "20141210", "value": 523.183228 },
					{ "name": "GOOG", "date": "20141211", "value": 525.450806 },
					{ "name": "GOOG", "date": "20141212", "value": 515.82373 },
					{ "name": "GOOG", "date": "20141215", "value": 510.990295 },
					{ "name": "GOOG", "date": "20141216", "value": 492.680969 },
					{ "name": "GOOG", "date": "20141217", "value": 502.129028 },
					{ "name": "GOOG", "date": "20141218", "value": 508.305054 },
					{ "name": "GOOG", "date": "20141219", "value": 513.526367 },
					{ "name": "GOOG", "date": "20141222", "value": 521.999756 },
					{ "name": "GOOG", "date": "20141223", "value": 527.688477 },
					{ "name": "GOOG", "date": "20141224", "value": 525.878418 },
					{ "name": "GOOG", "date": "20141226", "value": 531.10968 },
					{ "name": "GOOG", "date": "20141229", "value": 527.429932 },
					{ "name": "GOOG", "date": "20141230", "value": 527.519409 },
					{ "name": "GOOG", "date": "20141231", "value": 523.521423 },
					{ "name": "GOOG", "date": "20150102", "value": 521.937744 },
					{ "name": "GOOG", "date": "20150105", "value": 511.057617 },
					{ "name": "GOOG", "date": "20150106", "value": 499.212799 },
					{ "name": "GOOG", "date": "20150107", "value": 498.357513 },
					{ "name": "GOOG", "date": "20150108", "value": 499.928864 },
					{ "name": "GOOG", "date": "20150109", "value": 493.454498 },
					{ "name": "GOOG", "date": "20150112", "value": 489.854309 },
					{ "name": "GOOG", "date": "20150113", "value": 493.464447 },
					{ "name": "GOOG", "date": "20150114", "value": 498.128784 },
					{ "name": "GOOG", "date": "20150115", "value": 499.043732 },
					{ "name": "GOOG", "date": "20150116", "value": 505.299316 },
					{ "name": "GOOG", "date": "20150120", "value": 504.125763 },
					{ "name": "GOOG", "date": "20150121", "value": 515.204773 },
					{ "name": "GOOG", "date": "20150122", "value": 531.465332 },
					{ "name": "GOOG", "date": "20150123", "value": 536.994873 },
					{ "name": "GOOG", "date": "20150126", "value": 532.280823 },
					{ "name": "GOOG", "date": "20150127", "value": 515.791565 },
					{ "name": "GOOG", "date": "20150128", "value": 507.208801 },
					{ "name": "GOOG", "date": "20150129", "value": 507.865204 },
					{ "name": "GOOG", "date": "20150130", "value": 531.594604 },
					{ "name": "GOOG", "date": "20150202", "value": 525.587646 },
					{ "name": "GOOG", "date": "20150203", "value": 526.343506 },
					{ "name": "GOOG", "date": "20150204", "value": 519.898987 },
					{ "name": "GOOG", "date": "20150205", "value": 524.692566 },
					{ "name": "GOOG", "date": "20150206", "value": 528.093872 },
					{ "name": "GOOG", "date": "20150209", "value": 524.941223 },
					{ "name": "GOOG", "date": "20150210", "value": 534.001343 },
					{ "name": "GOOG", "date": "20150211", "value": 533.036682 },
					{ "name": "GOOG", "date": "20150212", "value": 539.958557 },
					{ "name": "GOOG", "date": "20150213", "value": 546.00531 },
					{ "name": "GOOG", "date": "20150217", "value": 539.86908 },
					{ "name": "GOOG", "date": "20150218", "value": 536.746277 },
					{ "name": "GOOG", "date": "20150219", "value": 539.901306 },
					{ "name": "GOOG", "date": "20150220", "value": 536.000366 },
					{ "name": "GOOG", "date": "20150223", "value": 528.998901 },
					{ "name": "GOOG", "date": "20150224", "value": 533.156006 },
					{ "name": "GOOG", "date": "20150225", "value": 540.893433 },
					{ "name": "GOOG", "date": "20150226", "value": 552.43988 },
					{ "name": "GOOG", "date": "20150227", "value": 555.343933 },
					{ "name": "GOOG", "date": "20150302", "value": 568.213074 },
					{ "name": "GOOG", "date": "20150303", "value": 570.500488 },
					{ "name": "GOOG", "date": "20150304", "value": 570.231995 },
					{ "name": "GOOG", "date": "20150305", "value": 572.181274 },
					{ "name": "GOOG", "date": "20150306", "value": 564.578125 },
					{ "name": "GOOG", "date": "20150309", "value": 565.736694 },
					{ "name": "GOOG", "date": "20150310", "value": 551.972473 },
					{ "name": "GOOG", "date": "20150311", "value": 548.163452 },
					{ "name": "GOOG", "date": "20150312", "value": 552.469727 },
					{ "name": "GOOG", "date": "20150313", "value": 544.324585 },
					{ "name": "GOOG", "date": "20150316", "value": 551.47522 },
					{ "name": "GOOG", "date": "20150317", "value": 547.825317 },
					{ "name": "GOOG", "date": "20150318", "value": 556.437866 },
					{ "name": "GOOG", "date": "20150319", "value": 554.936157 },
					{ "name": "GOOG", "date": "20150320", "value": 557.293213 },
					{ "name": "GOOG", "date": "20150323", "value": 555.751648 },
					{ "name": "GOOG", "date": "20150324", "value": 567.069397 },
					{ "name": "GOOG", "date": "20150325", "value": 555.726807 },
					{ "name": "GOOG", "date": "20150326", "value": 552.131592 },
					{ "name": "GOOG", "date": "20150327", "value": 545.338989 },
					{ "name": "GOOG", "date": "20150330", "value": 549.008789 },
					{ "name": "GOOG", "date": "20150331", "value": 545.000854 },
					{ "name": "GOOG", "date": "20150401", "value": 539.590576 },
					{ "name": "GOOG", "date": "20150402", "value": 532.59906 },
					{ "name": "GOOG", "date": "20150406", "value": 533.827332 },
					{ "name": "GOOG", "date": "20150407", "value": 534.080933 },
					{ "name": "GOOG", "date": "20150408", "value": 538.645813 },
					{ "name": "GOOG", "date": "20150409", "value": 537.820374 },
					{ "name": "GOOG", "date": "20150410", "value": 537.054565 },
					{ "name": "GOOG", "date": "20150413", "value": 536.219177 },
					{ "name": "GOOG", "date": "20150414", "value": 527.487183 },
					{ "name": "GOOG", "date": "20150415", "value": 529.617859 },
					{ "name": "GOOG", "date": "20150416", "value": 530.87854 },
					{ "name": "GOOG", "date": "20150417", "value": 521.181885 },
					{ "name": "GOOG", "date": "20150420", "value": 532.44989 },
					{ "name": "GOOG", "date": "20150421", "value": 531.049988 },
					{ "name": "GOOG", "date": "20150422", "value": 536.413086 },
					{ "name": "GOOG", "date": "20150423", "value": 544.006287 },
					{ "name": "GOOG", "date": "20150424", "value": 561.967468 },
					{ "name": "GOOG", "date": "20150427", "value": 555.369995 },
					{ "name": "GOOG", "date": "20150428", "value": 553.679993 },
					{ "name": "GOOG", "date": "20150429", "value": 549.080017 },
					{ "name": "GOOG", "date": "20150430", "value": 537.340027 },
					{ "name": "GOOG", "date": "20150501", "value": 537.900024 },
					{ "name": "GOOG", "date": "20150504", "value": 540.780029 },
					{ "name": "GOOG", "date": "20150505", "value": 530.799988 },
					{ "name": "GOOG", "date": "20150506", "value": 524.219971 },
					{ "name": "GOOG", "date": "20150507", "value": 530.700012 },
					{ "name": "GOOG", "date": "20150508", "value": 538.219971 },
					{ "name": "GOOG", "date": "20150511", "value": 535.700012 },
					{ "name": "GOOG", "date": "20150512", "value": 529.039978 },
					{ "name": "GOOG", "date": "20150513", "value": 529.619995 },
					{ "name": "GOOG", "date": "20150514", "value": 538.400024 },
					{ "name": "GOOG", "date": "20150515", "value": 533.849976 },
					{ "name": "GOOG", "date": "20150518", "value": 532.299988 },
					{ "name": "GOOG", "date": "20150519", "value": 537.359985 },
					{ "name": "GOOG", "date": "20150520", "value": 539.27002 },
					{ "name": "GOOG", "date": "20150521", "value": 542.51001 },
					{ "name": "GOOG", "date": "20150522", "value": 540.109985 },
					{ "name": "GOOG", "date": "20150526", "value": 532.320007 },
					{ "name": "GOOG", "date": "20150527", "value": 539.789978 },
					{ "name": "GOOG", "date": "20150528", "value": 539.780029 },
					{ "name": "GOOG", "date": "20150529", "value": 532.109985 },
					{ "name": "GOOG", "date": "20150601", "value": 533.98999 },
					{ "name": "GOOG", "date": "20150602", "value": 539.179993 },
					{ "name": "GOOG", "date": "20150603", "value": 540.309998 },
					{ "name": "GOOG", "date": "20150604", "value": 536.700012 },
					{ "name": "GOOG", "date": "20150605", "value": 533.330017 },
					{ "name": "GOOG", "date": "20150608", "value": 526.830017 },
					{ "name": "GOOG", "date": "20150609", "value": 526.690002 },
					{ "name": "GOOG", "date": "20150610", "value": 536.690002 },
					{ "name": "GOOG", "date": "20150611", "value": 534.609985 },
					{ "name": "GOOG", "date": "20150612", "value": 532.330017 },
					{ "name": "GOOG", "date": "20150615", "value": 527.200012 },
					{ "name": "GOOG", "date": "20150616", "value": 528.150024 },
					{ "name": "GOOG", "date": "20150617", "value": 529.26001 },
					{ "name": "GOOG", "date": "20150618", "value": 536.72998 },
					{ "name": "GOOG", "date": "20150619", "value": 536.690002 },
					{ "name": "GOOG", "date": "20150622", "value": 538.190002 },
					{ "name": "GOOG", "date": "20150623", "value": 540.47998 },
					{ "name": "GOOG", "date": "20150624", "value": 537.840027 },
					{ "name": "GOOG", "date": "20150625", "value": 535.22998 },
					{ "name": "GOOG", "date": "20150626", "value": 531.690002 },
					{ "name": "GOOG", "date": "20150629", "value": 521.52002 },
					{ "name": "GOOG", "date": "20150630", "value": 520.51001 },
					{ "name": "GOOG", "date": "20150701", "value": 521.840027 },
					{ "name": "GOOG", "date": "20150702", "value": 523.400024 },
					{ "name": "GOOG", "date": "20150706", "value": 522.859985 },
					{ "name": "GOOG", "date": "20150707", "value": 525.02002 },
					{ "name": "GOOG", "date": "20150708", "value": 516.830017 },
					{ "name": "GOOG", "date": "20150709", "value": 520.679993 },
					{ "name": "GOOG", "date": "20150710", "value": 530.130005 },
					{ "name": "GOOG", "date": "20150713", "value": 546.549988 },
					{ "name": "GOOG", "date": "20150714", "value": 561.099976 },
					{ "name": "GOOG", "date": "20150715", "value": 560.219971 },
					{ "name": "GOOG", "date": "20150716", "value": 579.849976 },
					{ "name": "GOOG", "date": "20150717", "value": 672.929993 },
					{ "name": "GOOG", "date": "20150720", "value": 663.02002 },
					{ "name": "GOOG", "date": "20150721", "value": 662.299988 },
					{ "name": "GOOG", "date": "20150722", "value": 662.099976 },
					{ "name": "GOOG", "date": "20150723", "value": 644.280029 },
					{ "name": "GOOG", "date": "20150724", "value": 623.559998 },
					{ "name": "GOOG", "date": "20150727", "value": 627.26001 },
					{ "name": "GOOG", "date": "20150728", "value": 628 },
					{ "name": "GOOG", "date": "20150729", "value": 631.929993 },
					{ "name": "GOOG", "date": "20150730", "value": 632.590027 },
					{ "name": "GOOG", "date": "20150731", "value": 625.609985 },
					{ "name": "GOOG", "date": "20150803", "value": 631.210022 },
					{ "name": "GOOG", "date": "20150804", "value": 629.25 },
					{ "name": "GOOG", "date": "20150805", "value": 643.780029 },
					{ "name": "GOOG", "date": "20150806", "value": 642.679993 },
					{ "name": "GOOG", "date": "20150807", "value": 635.299988 },
					{ "name": "GOOG", "date": "20150810", "value": 633.72998 },
					{ "name": "GOOG", "date": "20150811", "value": 660.780029 },
					{ "name": "GOOG", "date": "20150812", "value": 659.559998 },
					{ "name": "GOOG", "date": "20150813", "value": 656.450012 },
					{ "name": "GOOG", "date": "20150814", "value": 657.119995 },
					{ "name": "GOOG", "date": "20150817", "value": 660.869995 },
					{ "name": "GOOG", "date": "20150818", "value": 656.130005 },
					{ "name": "GOOG", "date": "20150819", "value": 660.900024 },
					{ "name": "GOOG", "date": "20150820", "value": 646.830017 },
					{ "name": "GOOG", "date": "20150821", "value": 612.47998 },
					{ "name": "GOOG", "date": "20150824", "value": 589.609985 },
					{ "name": "GOOG", "date": "20150825", "value": 582.059998 },
					{ "name": "GOOG", "date": "20150826", "value": 628.619995 },
					{ "name": "GOOG", "date": "20150827", "value": 637.609985 },
					{ "name": "GOOG", "date": "20150828", "value": 630.380005 },
					{ "name": "GOOG", "date": "20150831", "value": 618.25 },
					{ "name": "GOOG", "date": "20150901", "value": 597.789978 },
					{ "name": "GOOG", "date": "20150902", "value": 614.340027 },
					{ "name": "GOOG", "date": "20150903", "value": 606.25 },
					{ "name": "GOOG", "date": "20150904", "value": 600.700012 },
					{ "name": "GOOG", "date": "20150908", "value": 614.659973 },
					{ "name": "GOOG", "date": "20150909", "value": 612.719971 },
					{ "name": "GOOG", "date": "20150910", "value": 621.349976 },
					{ "name": "GOOG", "date": "20150911", "value": 625.77002 },
					{ "name": "GOOG", "date": "20150914", "value": 623.23999 },
					{ "name": "GOOG", "date": "20150915", "value": 635.140015 },
					{ "name": "GOOG", "date": "20150916", "value": 635.97998 },
					{ "name": "GOOG", "date": "20150917", "value": 642.900024 },
					{ "name": "GOOG", "date": "20150918", "value": 629.25 },
					{ "name": "GOOG", "date": "20150921", "value": 635.440002 },
					{ "name": "GOOG", "date": "20150922", "value": 622.690002 },
					{ "name": "GOOG", "date": "20150923", "value": 622.359985 },
					{ "name": "GOOG", "date": "20150924", "value": 625.799988 },
					{ "name": "GOOG", "date": "20150925", "value": 611.969971 },
					{ "name": "GOOG", "date": "20150928", "value": 594.890015 },
					{ "name": "GOOG", "date": "20150929", "value": 594.969971 },
					{ "name": "GOOG", "date": "20150930", "value": 608.419983 },
					{ "name": "GOOG", "date": "20151001", "value": 611.289978 },
					{ "name": "GOOG", "date": "20151002", "value": 626.909973 },
					{ "name": "GOOG", "date": "20151005", "value": 641.469971 },
					{ "name": "GOOG", "date": "20151006", "value": 645.440002 },
					{ "name": "GOOG", "date": "20151007", "value": 642.359985 },
					{ "name": "GOOG", "date": "20151008", "value": 639.159973 },
					{ "name": "GOOG", "date": "20151009", "value": 643.609985 },
					{ "name": "GOOG", "date": "20151012", "value": 646.669983 },
					{ "name": "GOOG", "date": "20151013", "value": 652.299988 },
					{ "name": "GOOG", "date": "20151014", "value": 651.159973 },
					{ "name": "GOOG", "date": "20151015", "value": 661.73999 },
					{ "name": "GOOG", "date": "20151016", "value": 662.200012 },
					{ "name": "GOOG", "date": "20151019", "value": 666.099976 },
					{ "name": "GOOG", "date": "20151020", "value": 650.280029 },
					{ "name": "GOOG", "date": "20151021", "value": 642.609985 },
					{ "name": "GOOG", "date": "20151022", "value": 651.789978 },
					{ "name": "GOOG", "date": "20151023", "value": 702 },
					{ "name": "GOOG", "date": "20151026", "value": 712.780029 },
					{ "name": "GOOG", "date": "20151027", "value": 708.48999 },
					{ "name": "GOOG", "date": "20151028", "value": 712.950012 },
					{ "name": "GOOG", "date": "20151029", "value": 716.919983 },
					{ "name": "GOOG", "date": "20151030", "value": 710.809998 },
					{ "name": "GOOG", "date": "20151102", "value": 721.109985 },
					{ "name": "GOOG", "date": "20151103", "value": 722.159973 },
					{ "name": "GOOG", "date": "20151104", "value": 728.109985 },
					{ "name": "GOOG", "date": "20151105", "value": 731.25 },
					{ "name": "GOOG", "date": "20151106", "value": 733.76001 },
					{ "name": "GOOG", "date": "20151109", "value": 724.890015 },
					{ "name": "GOOG", "date": "20151110", "value": 728.320007 },
					{ "name": "GOOG", "date": "20151111", "value": 735.400024 },
					{ "name": "GOOG", "date": "20151112", "value": 731.22998 },
					{ "name": "GOOG", "date": "20151113", "value": 717 },
					{ "name": "GOOG", "date": "20151116", "value": 728.960022 },
					{ "name": "GOOG", "date": "20151117", "value": 725.299988 },
					{ "name": "GOOG", "date": "20151118", "value": 740 },
					{ "name": "GOOG", "date": "20151119", "value": 738.409973 },
					{ "name": "GOOG", "date": "20151120", "value": 756.599976 },
					{ "name": "GOOG", "date": "20151123", "value": 755.97998 },
					{ "name": "GOOG", "date": "20151124", "value": 748.280029 },
					{ "name": "GOOG", "date": "20151125", "value": 748.150024 },
					{ "name": "GOOG", "date": "20151127", "value": 750.26001 },
					{ "name": "GOOG", "date": "20151130", "value": 742.599976 },
					{ "name": "GOOG", "date": "20151201", "value": 767.039978 },
					{ "name": "GOOG", "date": "20151202", "value": 762.380005 },
					{ "name": "GOOG", "date": "20151203", "value": 752.539978 },
					{ "name": "GOOG", "date": "20151204", "value": 766.809998 },
					{ "name": "GOOG", "date": "20151207", "value": 763.25 },
					{ "name": "GOOG", "date": "20151208", "value": 762.369995 },
					{ "name": "GOOG", "date": "20151209", "value": 751.609985 },
					{ "name": "GOOG", "date": "20151210", "value": 749.460022 },
					{ "name": "GOOG", "date": "20151211", "value": 738.869995 },
					{ "name": "GOOG", "date": "20151214", "value": 747.77002 },
					{ "name": "GOOG", "date": "20151215", "value": 743.400024 },
					{ "name": "GOOG", "date": "20151216", "value": 758.090027 },
					{ "name": "GOOG", "date": "20151217", "value": 749.429993 },
					{ "name": "GOOG", "date": "20151218", "value": 739.309998 },
					{ "name": "GOOG", "date": "20151221", "value": 747.77002 },
					{ "name": "GOOG", "date": "20151222", "value": 750 },
					{ "name": "GOOG", "date": "20151223", "value": 750.309998 },
					{ "name": "GOOG", "date": "20151224", "value": 748.400024 },
					{ "name": "GOOG", "date": "20151228", "value": 762.51001 },
					{ "name": "GOOG", "date": "20151229", "value": 776.599976 },
					{ "name": "GOOG", "date": "20151230", "value": 771 },
					{ "name": "GOOG", "date": "20151231", "value": 758.880005 },
					{ "name": "GOOG", "date": "20160104", "value": 741.840027 },
					{ "name": "GOOG", "date": "20160105", "value": 742.580017 },
					{ "name": "GOOG", "date": "20160106", "value": 743.619995 },
					{ "name": "GOOG", "date": "20160107", "value": 726.390015 },
					{ "name": "GOOG", "date": "20160108", "value": 714.469971 },
					{ "name": "GOOG", "date": "20160111", "value": 716.030029 },
					{ "name": "GOOG", "date": "20160112", "value": 726.070007 },
					{ "name": "GOOG", "date": "20160113", "value": 700.559998 },
					{ "name": "GOOG", "date": "20160114", "value": 714.719971 },
					{ "name": "GOOG", "date": "20160115", "value": 694.450012 },
					{ "name": "GOOG", "date": "20160119", "value": 701.789978 },
					{ "name": "GOOG", "date": "20160120", "value": 698.450012 },
					{ "name": "GOOG", "date": "20160121", "value": 706.590027 },
					{ "name": "GOOG", "date": "20160122", "value": 725.25 },
					{ "name": "GOOG", "date": "20160125", "value": 711.669983 },
					{ "name": "GOOG", "date": "20160126", "value": 713.039978 },
					{ "name": "GOOG", "date": "20160127", "value": 699.98999 },
					{ "name": "GOOG", "date": "20160128", "value": 730.960022 },
					{ "name": "GOOG", "date": "20160129", "value": 742.950012 },
					{ "name": "GOOG", "date": "20160201", "value": 752 },
					{ "name": "GOOG", "date": "20160202", "value": 764.650024 },
					{ "name": "GOOG", "date": "20160203", "value": 726.950012 },
					{ "name": "GOOG", "date": "20160204", "value": 708.01001 },
					{ "name": "GOOG", "date": "20160205", "value": 683.570007 },
					{ "name": "GOOG", "date": "20160208", "value": 682.73999 },
					{ "name": "GOOG", "date": "20160209", "value": 678.109985 },
					{ "name": "GOOG", "date": "20160210", "value": 684.119995 },
					{ "name": "GOOG", "date": "20160211", "value": 683.109985 },
					{ "name": "GOOG", "date": "20160212", "value": 682.400024 },
					{ "name": "GOOG", "date": "20160216", "value": 691 },
					{ "name": "GOOG", "date": "20160217", "value": 708.400024 },
					{ "name": "GOOG", "date": "20160218", "value": 697.349976 },
					{ "name": "GOOG", "date": "20160219", "value": 700.909973 },
					{ "name": "GOOG", "date": "20160222", "value": 706.460022 },
					{ "name": "GOOG", "date": "20160223", "value": 695.849976 },
					{ "name": "GOOG", "date": "20160224", "value": 699.559998 },
					{ "name": "GOOG", "date": "20160225", "value": 705.75 },
					{ "name": "GOOG", "date": "20160226", "value": 705.070007 },
					{ "name": "GOOG", "date": "20160229", "value": 697.77002 },
					{ "name": "GOOG", "date": "20160301", "value": 718.809998 },
					{ "name": "GOOG", "date": "20160302", "value": 718.849976 },
					{ "name": "GOOG", "date": "20160303", "value": 712.419983 },
					{ "name": "GOOG", "date": "20160304", "value": 710.890015 },
					{ "name": "GOOG", "date": "20160307", "value": 695.159973 },
					{ "name": "GOOG", "date": "20160308", "value": 693.969971 },
					{ "name": "GOOG", "date": "20160309", "value": 705.23999 },
					{ "name": "GOOG", "date": "20160310", "value": 712.820007 },
					{ "name": "GOOG", "date": "20160311", "value": 726.820007 },
					{ "name": "GOOG", "date": "20160314", "value": 730.48999 },
					{ "name": "GOOG", "date": "20160315", "value": 728.330017 },
					{ "name": "GOOG", "date": "20160316", "value": 736.090027 },
					{ "name": "GOOG", "date": "20160317", "value": 737.780029 },
					{ "name": "GOOG", "date": "20160318", "value": 737.599976 },
					{ "name": "GOOG", "date": "20160321", "value": 742.090027 },
					{ "name": "GOOG", "date": "20160322", "value": 740.75 },
					{ "name": "GOOG", "date": "20160323", "value": 738.059998 },
					{ "name": "GOOG", "date": "20160324", "value": 735.299988 },
					{ "name": "GOOG", "date": "20160328", "value": 733.530029 },
					{ "name": "GOOG", "date": "20160329", "value": 744.77002 },
					{ "name": "GOOG", "date": "20160330", "value": 750.530029 },
					{ "name": "GOOG", "date": "20160331", "value": 744.950012 },
					{ "name": "GOOG", "date": "20160401", "value": 749.909973 },
					{ "name": "GOOG", "date": "20160404", "value": 745.289978 },
					{ "name": "GOOG", "date": "20160405", "value": 737.799988 },
					{ "name": "GOOG", "date": "20160406", "value": 745.690002 },
					{ "name": "GOOG", "date": "20160407", "value": 740.280029 },
					{ "name": "GOOG", "date": "20160408", "value": 739.150024 },
					{ "name": "GOOG", "date": "20160411", "value": 736.099976 },
					{ "name": "GOOG", "date": "20160412", "value": 743.090027 },
					{ "name": "GOOG", "date": "20160413", "value": 751.719971 },
					{ "name": "GOOG", "date": "20160414", "value": 753.200012 },
					{ "name": "GOOG", "date": "20160415", "value": 759 },
					{ "name": "GOOG", "date": "20160418", "value": 766.609985 },
					{ "name": "GOOG", "date": "20160419", "value": 753.929993 },
					{ "name": "GOOG", "date": "20160420", "value": 752.669983 },
					{ "name": "GOOG", "date": "20160421", "value": 759.140015 },
					{ "name": "GOOG", "date": "20160422", "value": 718.77002 },
					{ "name": "GOOG", "date": "20160425", "value": 723.150024 },
					{ "name": "GOOG", "date": "20160426", "value": 708.140015 },
					{ "name": "GOOG", "date": "20160427", "value": 705.840027 },
					{ "name": "GOOG", "date": "20160428", "value": 691.02002 },
					{ "name": "GOOG", "date": "20160429", "value": 693.01001 },
					{ "name": "GOOG", "date": "20160502", "value": 698.210022 },
					{ "name": "GOOG", "date": "20160503", "value": 692.359985 },
					{ "name": "GOOG", "date": "20160504", "value": 695.700012 },
					{ "name": "GOOG", "date": "20160505", "value": 701.429993 },
					{ "name": "GOOG", "date": "20160506", "value": 711.119995 },
					{ "name": "GOOG", "date": "20160509", "value": 712.900024 },
					{ "name": "GOOG", "date": "20160510", "value": 723.179993 },
					{ "name": "GOOG", "date": "20160511", "value": 715.289978 },
					{ "name": "GOOG", "date": "20160512", "value": 713.309998 },
					{ "name": "GOOG", "date": "20160513", "value": 710.830017 },
					{ "name": "GOOG", "date": "20160516", "value": 716.48999 },
					{ "name": "GOOG", "date": "20160517", "value": 706.22998 },
					{ "name": "GOOG", "date": "20160518", "value": 706.630005 },
					{ "name": "GOOG", "date": "20160519", "value": 700.320007 },
					{ "name": "GOOG", "date": "20160520", "value": 709.73999 },
					{ "name": "GOOG", "date": "20160523", "value": 704.23999 },
					{ "name": "GOOG", "date": "20160524", "value": 720.090027 },
					{ "name": "GOOG", "date": "20160525", "value": 725.27002 },
					{ "name": "GOOG", "date": "20160526", "value": 724.119995 },
					{ "name": "GOOG", "date": "20160527", "value": 732.659973 },
					{ "name": "GOOG", "date": "20160531", "value": 735.719971 },
					{ "name": "GOOG", "date": "20160601", "value": 734.150024 },
					{ "name": "GOOG", "date": "20160602", "value": 730.400024 },
					{ "name": "GOOG", "date": "20160603", "value": 722.340027 },
					{ "name": "GOOG", "date": "20160606", "value": 716.549988 },
					{ "name": "GOOG", "date": "20160607", "value": 716.650024 },
					{ "name": "GOOG", "date": "20160608", "value": 728.280029 },
					{ "name": "GOOG", "date": "20160609", "value": 728.580017 },
					{ "name": "GOOG", "date": "20160610", "value": 719.409973 },
					{ "name": "GOOG", "date": "20160613", "value": 718.359985 },
					{ "name": "GOOG", "date": "20160614", "value": 718.27002 },
					{ "name": "GOOG", "date": "20160615", "value": 718.919983 },
					{ "name": "GOOG", "date": "20160616", "value": 710.359985 },
					{ "name": "GOOG", "date": "20160617", "value": 691.719971 },
					{ "name": "GOOG", "date": "20160620", "value": 693.710022 },
					{ "name": "GOOG", "date": "20160621", "value": 695.940002 },
					{ "name": "GOOG", "date": "20160622", "value": 697.460022 },
					{ "name": "GOOG", "date": "20160623", "value": 701.869995 },
					{ "name": "GOOG", "date": "20160624", "value": 675.219971 },
					{ "name": "GOOG", "date": "20160627", "value": 668.26001 },
					{ "name": "GOOG", "date": "20160628", "value": 680.039978 },
					{ "name": "GOOG", "date": "20160629", "value": 684.109985 },
					{ "name": "GOOG", "date": "20160630", "value": 692.099976 },
					{ "name": "GOOG", "date": "20160701", "value": 699.210022 },
					{ "name": "GOOG", "date": "20160705", "value": 694.950012 },
					{ "name": "GOOG", "date": "20160706", "value": 697.77002 },
					{ "name": "GOOG", "date": "20160707", "value": 695.359985 },
					{ "name": "GOOG", "date": "20160708", "value": 705.630005 },
					{ "name": "GOOG", "date": "20160711", "value": 715.090027 },
					{ "name": "GOOG", "date": "20160712", "value": 720.640015 },
					{ "name": "GOOG", "date": "20160713", "value": 716.97998 },
					{ "name": "GOOG", "date": "20160714", "value": 720.950012 },
					{ "name": "GOOG", "date": "20160715", "value": 719.849976 },
					{ "name": "GOOG", "date": "20160718", "value": 733.780029 },
					{ "name": "GOOG", "date": "20160719", "value": 736.960022 },
					{ "name": "GOOG", "date": "20160720", "value": 741.190002 },
					{ "name": "GOOG", "date": "20160721", "value": 738.630005 },
					{ "name": "GOOG", "date": "20160722", "value": 742.73999 },
					{ "name": "GOOG", "date": "20160725", "value": 739.77002 },
					{ "name": "GOOG", "date": "20160726", "value": 738.419983 },
					{ "name": "GOOG", "date": "20160727", "value": 741.77002 },
					{ "name": "GOOG", "date": "20160728", "value": 745.909973 },
					{ "name": "GOOG", "date": "20160729", "value": 768.789978 },
					{ "name": "GOOG", "date": "20160801", "value": 772.880005 },
					{ "name": "GOOG", "date": "20160802", "value": 771.070007 },
					{ "name": "GOOG", "date": "20160803", "value": 773.179993 },
					{ "name": "GOOG", "date": "20160804", "value": 771.609985 },
					{ "name": "GOOG", "date": "20160805", "value": 782.219971 },
					{ "name": "GOOG", "date": "20160808", "value": 781.76001 },
					{ "name": "GOOG", "date": "20160809", "value": 784.26001 },
					{ "name": "GOOG", "date": "20160810", "value": 784.679993 },
					{ "name": "GOOG", "date": "20160811", "value": 784.849976 },
					{ "name": "GOOG", "date": "20160812", "value": 783.219971 },
					{ "name": "GOOG", "date": "20160815", "value": 782.440002 },
					{ "name": "GOOG", "date": "20160816", "value": 777.140015 },
					{ "name": "GOOG", "date": "20160817", "value": 779.909973 },
					{ "name": "GOOG", "date": "20160818", "value": 777.5 },
					{ "name": "GOOG", "date": "20160819", "value": 775.419983 },
					{ "name": "GOOG", "date": "20160822", "value": 772.150024 },
					{ "name": "GOOG", "date": "20160823", "value": 772.080017 },
					{ "name": "GOOG", "date": "20160824", "value": 769.640015 },
					{ "name": "GOOG", "date": "20160825", "value": 769.409973 },
					{ "name": "GOOG", "date": "20160826", "value": 769.539978 },
					{ "name": "GOOG", "date": "20160829", "value": 772.150024 },
					{ "name": "GOOG", "date": "20160830", "value": 769.090027 },
					{ "name": "GOOG", "date": "20160831", "value": 767.049988 },
					{ "name": "GOOG", "date": "20160901", "value": 768.780029 },
					{ "name": "GOOG", "date": "20160902", "value": 771.460022 },
					{ "name": "GOOG", "date": "20160906", "value": 780.080017 },
					{ "name": "GOOG", "date": "20160907", "value": 780.349976 },
					{ "name": "GOOG", "date": "20160908", "value": 775.320007 },
					{ "name": "GOOG", "date": "20160909", "value": 759.659973 },
					{ "name": "GOOG", "date": "20160912", "value": 769.02002 },
					{ "name": "GOOG", "date": "20160913", "value": 759.690002 },
					{ "name": "GOOG", "date": "20160914", "value": 762.48999 },
					{ "name": "GOOG", "date": "20160915", "value": 771.76001 },
					{ "name": "GOOG", "date": "20160916", "value": 768.880005 },
					{ "name": "GOOG", "date": "20160919", "value": 765.700012 },
					{ "name": "GOOG", "date": "20160920", "value": 771.409973 },
					{ "name": "GOOG", "date": "20160921", "value": 776.219971 },
					{ "name": "GOOG", "date": "20160922", "value": 787.210022 },
					{ "name": "GOOG", "date": "20160923", "value": 786.900024 },
					{ "name": "GOOG", "date": "20160926", "value": 774.210022 },
					{ "name": "GOOG", "date": "20160927", "value": 783.01001 },
					{ "name": "GOOG", "date": "20160928", "value": 781.559998 },
					{ "name": "GOOG", "date": "20160929", "value": 775.01001 },
					{ "name": "GOOG", "date": "20160930", "value": 777.289978 },
					{ "name": "GOOG", "date": "20161003", "value": 772.559998 },
					{ "name": "GOOG", "date": "20161004", "value": 776.429993 },
					{ "name": "GOOG", "date": "20161005", "value": 776.469971 },
					{ "name": "GOOG", "date": "20161006", "value": 776.859985 },
					{ "name": "GOOG", "date": "20161007", "value": 775.080017 },
					{ "name": "GOOG", "date": "20161010", "value": 785.940002 },
					{ "name": "GOOG", "date": "20161011", "value": 783.070007 },
					{ "name": "GOOG", "date": "20161012", "value": 786.140015 },
					{ "name": "GOOG", "date": "20161013", "value": 778.190002 },
					{ "name": "GOOG", "date": "20161014", "value": 778.530029 },
					{ "name": "GOOG", "date": "20161017", "value": 779.960022 },
					{ "name": "GOOG", "date": "20161018", "value": 795.26001 },
					{ "name": "GOOG", "date": "20161019", "value": 801.5 },
					{ "name": "GOOG", "date": "20161020", "value": 796.969971 },
					{ "name": "GOOG", "date": "20161021", "value": 799.369995 },
					{ "name": "GOOG", "date": "20161024", "value": 813.109985 },
					{ "name": "GOOG", "date": "20161025", "value": 807.669983 },
					{ "name": "GOOG", "date": "20161026", "value": 799.070007 },
					{ "name": "GOOG", "date": "20161027", "value": 795.349976 },
					{ "name": "GOOG", "date": "20161028", "value": 795.369995 },
					{ "name": "GOOG", "date": "20161031", "value": 784.539978 },
					{ "name": "GOOG", "date": "20161101", "value": 783.609985 },
					{ "name": "GOOG", "date": "20161102", "value": 768.700012 },
					{ "name": "GOOG", "date": "20161103", "value": 762.130005 },
					{ "name": "GOOG", "date": "20161104", "value": 762.02002 },
					{ "name": "GOOG", "date": "20161107", "value": 782.52002 },
					{ "name": "GOOG", "date": "20161108", "value": 790.51001 },
					{ "name": "GOOG", "date": "20161109", "value": 785.309998 },
					{ "name": "GOOG", "date": "20161110", "value": 762.559998 },
					{ "name": "GOOG", "date": "20161111", "value": 754.02002 },
					{ "name": "GOOG", "date": "20161114", "value": 736.080017 },
					{ "name": "GOOG", "date": "20161115", "value": 758.48999 },
					{ "name": "GOOG", "date": "20161116", "value": 764.47998 },
					{ "name": "GOOG", "date": "20161117", "value": 771.22998 },
					{ "name": "GOOG", "date": "20161118", "value": 760.539978 },
					{ "name": "GOOG", "date": "20161121", "value": 769.200012 },
					{ "name": "GOOG", "date": "20161122", "value": 768.27002 },
					{ "name": "GOOG", "date": "20161123", "value": 760.98999 },
					{ "name": "GOOG", "date": "20161125", "value": 761.679993 },
					{ "name": "GOOG", "date": "20161128", "value": 768.23999 },
					{ "name": "GOOG", "date": "20161129", "value": 770.840027 },
					{ "name": "GOOG", "date": "20161130", "value": 758.039978 },
					{ "name": "GOOG", "date": "20161201", "value": 747.919983 },
					{ "name": "GOOG", "date": "20161202", "value": 750.5 },
					{ "name": "GOOG", "date": "20161205", "value": 762.52002 },
					{ "name": "GOOG", "date": "20161206", "value": 759.109985 },
					{ "name": "GOOG", "date": "20161207", "value": 771.190002 },
					{ "name": "GOOG", "date": "20161208", "value": 776.419983 },
					{ "name": "GOOG", "date": "20161209", "value": 789.289978 },
					{ "name": "GOOG", "date": "20161212", "value": 789.27002 },
					{ "name": "GOOG", "date": "20161213", "value": 796.099976 },
					{ "name": "GOOG", "date": "20161214", "value": 797.070007 },
					{ "name": "GOOG", "date": "20161215", "value": 797.849976 },
					{ "name": "GOOG", "date": "20161216", "value": 790.799988 },
					{ "name": "GOOG", "date": "20161219", "value": 794.200012 },
					{ "name": "GOOG", "date": "20161220", "value": 796.419983 },
					{ "name": "GOOG", "date": "20161221", "value": 794.559998 },
					{ "name": "GOOG", "date": "20161222", "value": 791.26001 },
					{ "name": "GOOG", "date": "20161223", "value": 789.909973 },
					{ "name": "GOOG", "date": "20161227", "value": 791.549988 },
					{ "name": "GOOG", "date": "20161228", "value": 785.049988 },
					{ "name": "GOOG", "date": "20161229", "value": 782.789978 },
					{ "name": "GOOG", "date": "20161230", "value": 771.820007 },
					{ "name": "GOOG", "date": "20170103", "value": 786.140015 },
					{ "name": "GOOG", "date": "20170104", "value": 786.900024 },
					{ "name": "GOOG", "date": "20170105", "value": 794.02002 },
					{ "name": "GOOG", "date": "20170106", "value": 806.150024 },
					{ "name": "GOOG", "date": "20170109", "value": 806.650024 },
					{ "name": "GOOG", "date": "20170110", "value": 804.789978 },
					{ "name": "GOOG", "date": "20170111", "value": 807.909973 },
					{ "name": "GOOG", "date": "20170112", "value": 806.359985 },
					{ "name": "GOOG", "date": "20170113", "value": 807.880005 },
					{ "name": "GOOG", "date": "20170117", "value": 804.609985 },
					{ "name": "GOOG", "date": "20170118", "value": 806.070007 },
					{ "name": "GOOG", "date": "20170119", "value": 802.174988 },
					{ "name": "GOOG", "date": "20170120", "value": 805.02002 },
					{ "name": "GOOG", "date": "20170123", "value": 819.309998 },
					{ "name": "GOOG", "date": "20170124", "value": 823.869995 },
					{ "name": "GOOG", "date": "20170125", "value": 835.669983 },
					{ "name": "GOOG", "date": "20170126", "value": 832.150024 },
					{ "name": "GOOG", "date": "20170127", "value": 823.309998 },
					{ "name": "GOOG", "date": "20170130", "value": 802.320007 },
					{ "name": "GOOG", "date": "20170131", "value": 796.789978 },
					{ "name": "GOOG", "date": "20170201", "value": 795.695007 },
					{ "name": "GOOG", "date": "20170202", "value": 798.530029 },
					{ "name": "GOOG", "date": "20170203", "value": 801.48999 },
					{ "name": "GOOG", "date": "20170206", "value": 801.340027 },
					{ "name": "GOOG", "date": "20170207", "value": 806.969971 },
					{ "name": "GOOG", "date": "20170208", "value": 808.380005 },
					{ "name": "GOOG", "date": "20170209", "value": 809.559998 },
					{ "name": "GOOG", "date": "20170210", "value": 813.669983 },
					{ "name": "GOOG", "date": "20170213", "value": 819.23999 },
					{ "name": "GOOG", "date": "20170214", "value": 820.450012 },
					{ "name": "GOOG", "date": "20170215", "value": 818.97998 },
					{ "name": "GOOG", "date": "20170216", "value": 824.159973 },
					{ "name": "GOOG", "date": "20170217", "value": 828.070007 },
					{ "name": "GOOG", "date": "20170221", "value": 831.659973 },
					{ "name": "GOOG", "date": "20170222", "value": 830.76001 },
					{ "name": "GOOG", "date": "20170223", "value": 831.330017 },
					{ "name": "GOOG", "date": "20170224", "value": 828.640015 },
					{ "name": "GOOG", "date": "20170227", "value": 829.280029 },
					{ "name": "GOOG", "date": "20170228", "value": 823.210022 },
					{ "name": "GOOG", "date": "20170301", "value": 835.23999 },
					{ "name": "GOOG", "date": "20170302", "value": 830.630005 },
					{ "name": "GOOG", "date": "20170303", "value": 829.080017 },
					{ "name": "GOOG", "date": "20170306", "value": 827.780029 },
					{ "name": "GOOG", "date": "20170307", "value": 831.909973 },
					{ "name": "GOOG", "date": "20170308", "value": 835.369995 },
					{ "name": "GOOG", "date": "20170309", "value": 838.679993 },
					{ "name": "GOOG", "date": "20170310", "value": 843.25 },
					{ "name": "GOOG", "date": "20170313", "value": 845.539978 },
					{ "name": "GOOG", "date": "20170314", "value": 845.619995 },
					{ "name": "GOOG", "date": "20170315", "value": 847.200012 },
					{ "name": "GOOG", "date": "20170316", "value": 848.780029 },
					{ "name": "GOOG", "date": "20170317", "value": 852.119995 },
					{ "name": "GOOG", "date": "20170320", "value": 848.400024 },
					{ "name": "GOOG", "date": "20170321", "value": 830.460022 },
					{ "name": "GOOG", "date": "20170322", "value": 829.590027 },
					{ "name": "GOOG", "date": "20170323", "value": 817.580017 },
					{ "name": "GOOG", "date": "20170324", "value": 814.429993 },
					{ "name": "GOOG", "date": "20170327", "value": 819.51001 },
					{ "name": "GOOG", "date": "20170328", "value": 820.919983 },
					{ "name": "GOOG", "date": "20170329", "value": 831.409973 },
					{ "name": "GOOG", "date": "20170330", "value": 831.5 },
					{ "name": "GOOG", "date": "20170331", "value": 829.559998 },
					{ "name": "GOOG", "date": "20170403", "value": 838.549988 },
					{ "name": "GOOG", "date": "20170404", "value": 834.570007 },
					{ "name": "GOOG", "date": "20170405", "value": 831.409973 },
					{ "name": "GOOG", "date": "20170406", "value": 827.880005 },
					{ "name": "GOOG", "date": "20170407", "value": 824.669983 },
					{ "name": "GOOG", "date": "20170410", "value": 824.72998 },
					{ "name": "GOOG", "date": "20170411", "value": 823.349976 },
					{ "name": "GOOG", "date": "20170412", "value": 824.320007 },
					{ "name": "GOOG", "date": "20170413", "value": 823.559998 },
					{ "name": "GOOG", "date": "20170417", "value": 837.169983 },
					{ "name": "GOOG", "date": "20170418", "value": 836.820007 },
					{ "name": "GOOG", "date": "20170419", "value": 838.210022 },
					{ "name": "GOOG", "date": "20170420", "value": 841.650024 },
					{ "name": "GOOG", "date": "20170421", "value": 843.190002 },
					{ "name": "GOOG", "date": "20170424", "value": 862.76001 },
					{ "name": "GOOG", "date": "20170425", "value": 872.299988 },
					{ "name": "GOOG", "date": "20170426", "value": 871.72998 },
					{ "name": "GOOG", "date": "20170427", "value": 874.25 },
					{ "name": "GOOG", "date": "20170428", "value": 905.960022 },
					{ "name": "GOOG", "date": "20170501", "value": 912.570007 },
					{ "name": "GOOG", "date": "20170502", "value": 916.440002 },
					{ "name": "GOOG", "date": "20170503", "value": 927.039978 },
					{ "name": "GOOG", "date": "20170504", "value": 931.659973 },
					{ "name": "GOOG", "date": "20170505", "value": 927.130005 },
					{ "name": "GOOG", "date": "20170508", "value": 934.299988 },
					{ "name": "GOOG", "date": "20170509", "value": 932.169983 },
					{ "name": "GOOG", "date": "20170510", "value": 928.780029 },
					{ "name": "GOOG", "date": "20170511", "value": 930.599976 },
					{ "name": "GOOG", "date": "20170512", "value": 932.219971 },
					{ "name": "GOOG", "date": "20170515", "value": 937.080017 },
					{ "name": "GOOG", "date": "20170516", "value": 943 },
					{ "name": "GOOG", "date": "20170517", "value": 919.619995 },
					{ "name": "GOOG", "date": "20170518", "value": 930.23999 },
					{ "name": "GOOG", "date": "20170519", "value": 934.01001 },
					{ "name": "GOOG", "date": "20170522", "value": 941.859985 },
					{ "name": "GOOG", "date": "20170523", "value": 948.820007 },
					{ "name": "GOOG", "date": "20170524", "value": 954.960022 },
					{ "name": "GOOG", "date": "20170525", "value": 969.539978 },
					{ "name": "GOOG", "date": "20170526", "value": 971.469971 },
					{ "name": "GOOG", "date": "20170530", "value": 975.880005 },
					{ "name": "GOOG", "date": "20170531", "value": 964.859985 },
					{ "name": "GOOG", "date": "20170601", "value": 966.950012 },
					{ "name": "GOOG", "date": "20170602", "value": 975.599976 },
					{ "name": "GOOG", "date": "20170605", "value": 983.679993 },
					{ "name": "GOOG", "date": "20170606", "value": 976.570007 },
					{ "name": "GOOG", "date": "20170607", "value": 980.940002 },
					{ "name": "GOOG", "date": "20170608", "value": 983.409973 },
					{ "name": "GOOG", "date": "20170609", "value": 949.830017 },
					{ "name": "GOOG", "date": "20170612", "value": 942.900024 },
					{ "name": "GOOG", "date": "20170613", "value": 953.400024 },
					{ "name": "GOOG", "date": "20170614", "value": 950.76001 },
					{ "name": "GOOG", "date": "20170615", "value": 942.309998 },
					{ "name": "GOOG", "date": "20170616", "value": 939.780029 },
					{ "name": "GOOG", "date": "20170619", "value": 957.369995 },
					{ "name": "GOOG", "date": "20170620", "value": 950.630005 },
					{ "name": "GOOG", "date": "20170621", "value": 959.450012 },
					{ "name": "GOOG", "date": "20170622", "value": 957.090027 },
					{ "name": "GOOG", "date": "20170623", "value": 965.590027 },
					{ "name": "GOOG", "date": "20170626", "value": 952.27002 },
					{ "name": "GOOG", "date": "20170627", "value": 927.330017 },
					{ "name": "GOOG", "date": "20170628", "value": 940.48999 },
					{ "name": "GOOG", "date": "20170629", "value": 917.789978 },
					{ "name": "GOOG", "date": "20170630", "value": 908.72998 },
					{ "name": "GOOG", "date": "20170703", "value": 898.700012 },
					{ "name": "GOOG", "date": "20170705", "value": 911.710022 },
					{ "name": "GOOG", "date": "20170706", "value": 906.690002 },
					{ "name": "GOOG", "date": "20170707", "value": 918.590027 },
					{ "name": "GOOG", "date": "20170710", "value": 928.799988 },
					{ "name": "GOOG", "date": "20170711", "value": 930.090027 },
					{ "name": "GOOG", "date": "20170712", "value": 943.830017 },
					{ "name": "GOOG", "date": "20170713", "value": 947.159973 },
					{ "name": "GOOG", "date": "20170714", "value": 955.98999 },
					{ "name": "GOOG", "date": "20170717", "value": 953.419983 },
					{ "name": "GOOG", "date": "20170718", "value": 965.400024 },
					{ "name": "GOOG", "date": "20170719", "value": 970.890015 },
					{ "name": "GOOG", "date": "20170720", "value": 968.150024 },
					{ "name": "GOOG", "date": "20170721", "value": 972.919983 },
					{ "name": "GOOG", "date": "20170724", "value": 980.340027 },
					{ "name": "GOOG", "date": "20170725", "value": 950.700012 },
					{ "name": "GOOG", "date": "20170726", "value": 947.799988 },
					{ "name": "GOOG", "date": "20170727", "value": 934.090027 },
					{ "name": "GOOG", "date": "20170728", "value": 941.530029 },
					{ "name": "GOOG", "date": "20170731", "value": 930.5 },
					{ "name": "GOOG", "date": "20170801", "value": 930.830017 },
					{ "name": "GOOG", "date": "20170802", "value": 930.390015 },
					{ "name": "GOOG", "date": "20170803", "value": 923.650024 },
					{ "name": "GOOG", "date": "20170804", "value": 927.960022 },
					{ "name": "GOOG", "date": "20170807", "value": 929.359985 },
					{ "name": "GOOG", "date": "20170808", "value": 926.789978 },
					{ "name": "GOOG", "date": "20170809", "value": 922.900024 },
					{ "name": "GOOG", "date": "20170810", "value": 907.23999 },
					{ "name": "GOOG", "date": "20170811", "value": 914.390015 },
					{ "name": "GOOG", "date": "20170814", "value": 922.669983 },
					{ "name": "GOOG", "date": "20170815", "value": 922.219971 },
					{ "name": "GOOG", "date": "20170816", "value": 926.960022 },
					{ "name": "GOOG", "date": "20170817", "value": 910.97998 },
					{ "name": "GOOG", "date": "20170818", "value": 910.669983 },
					{ "name": "GOOG", "date": "20170821", "value": 906.659973 },
					{ "name": "GOOG", "date": "20170822", "value": 924.690002 },
					{ "name": "GOOG", "date": "20170823", "value": 927 },
					{ "name": "GOOG", "date": "20170824", "value": 921.280029 },
					{ "name": "GOOG", "date": "20170825", "value": 915.890015 },
					{ "name": "GOOG", "date": "20170828", "value": 913.809998 },
					{ "name": "GOOG", "date": "20170829", "value": 921.289978 },
					{ "name": "GOOG", "date": "20170830", "value": 929.570007 },
					{ "name": "GOOG", "date": "20170831", "value": 939.330017 },
					{ "name": "GOOG", "date": "20170901", "value": 937.340027 },
					{ "name": "GOOG", "date": "20170905", "value": 928.450012 },
					{ "name": "GOOG", "date": "20170906", "value": 927.809998 },
					{ "name": "GOOG", "date": "20170907", "value": 935.950012 },
					{ "name": "GOOG", "date": "20170908", "value": 926.5 },
					{ "name": "GOOG", "date": "20170911", "value": 929.080017 },
					{ "name": "GOOG", "date": "20170912", "value": 932.070007 },
					{ "name": "GOOG", "date": "20170913", "value": 935.090027 },
					{ "name": "GOOG", "date": "20170914", "value": 925.109985 },
					{ "name": "GOOG", "date": "20170915", "value": 920.289978 },
					{ "name": "GOOG", "date": "20170918", "value": 915 },
					{ "name": "GOOG", "date": "20170919", "value": 921.809998 },
					{ "name": "GOOG", "date": "20170920", "value": 931.580017 },
					{ "name": "GOOG", "date": "20170921", "value": 932.450012 },
					{ "name": "GOOG", "date": "20170922", "value": 928.530029 },
					{ "name": "GOOG", "date": "20170925", "value": 920.969971 },
					{ "name": "GOOG", "date": "20170926", "value": 924.859985 },
					{ "name": "GOOG", "date": "20170927", "value": 944.48999 },
					{ "name": "GOOG", "date": "20170928", "value": 949.5 },
					{ "name": "GOOG", "date": "20170929", "value": 959.109985 },
					{ "name": "GOOG", "date": "20171002", "value": 953.27002 },
					{ "name": "GOOG", "date": "20171003", "value": 957.789978 },
					{ "name": "GOOG", "date": "20171004", "value": 951.679993 },
					{ "name": "GOOG", "date": "20171005", "value": 969.960022 },
					{ "name": "GOOG", "date": "20171006", "value": 978.890015 },
					{ "name": "GOOG", "date": "20171009", "value": 977 },
					{ "name": "GOOG", "date": "20171010", "value": 972.599976 },
					{ "name": "GOOG", "date": "20171011", "value": 989.25 },
					{ "name": "GOOG", "date": "20171012", "value": 987.830017 },
					{ "name": "GOOG", "date": "20171013", "value": 989.679993 },
					{ "name": "GOOG", "date": "20171016", "value": 992 },
					{ "name": "GOOG", "date": "20171017", "value": 992.179993 },
					{ "name": "GOOG", "date": "20171018", "value": 992.809998 },
					{ "name": "GOOG", "date": "20171019", "value": 984.450012 },
					{ "name": "GOOG", "date": "20171020", "value": 988.200012 },
					{ "name": "GOOG", "date": "20171023", "value": 968.450012 },
					{ "name": "GOOG", "date": "20171024", "value": 970.539978 },
					{ "name": "GOOG", "date": "20171025", "value": 973.330017 },
					{ "name": "GOOG", "date": "20171026", "value": 972.559998 },
					{ "name": "GOOG", "date": "20171027", "value": 1019.27002 },
					{ "name": "GOOG", "date": "20171030", "value": 1017.109985 },
					{ "name": "GOOG", "date": "20171031", "value": 1016.640015 },
					{ "name": "GOOG", "date": "20171101", "value": 1025.5 },
					{ "name": "GOOG", "date": "20171102", "value": 1025.579956 },
					{ "name": "GOOG", "date": "20171103", "value": 1032.47998 },
					{ "name": "GOOG", "date": "20171106", "value": 1025.900024 },
					{ "name": "GOOG", "date": "20171107", "value": 1033.329956 },
					{ "name": "GOOG", "date": "20171108", "value": 1039.849976 },
					{ "name": "GOOG", "date": "20171109", "value": 1031.26001 },
					{ "name": "GOOG", "date": "20171110", "value": 1028.069946 },
					{ "name": "GOOG", "date": "20171113", "value": 1025.75 },
					{ "name": "GOOG", "date": "20171114", "value": 1026 },
					{ "name": "GOOG", "date": "20171115", "value": 1020.909973 },
					{ "name": "GOOG", "date": "20171116", "value": 1032.5 },
					{ "name": "GOOG", "date": "20171117", "value": 1019.090027 },
					{ "name": "GOOG", "date": "20171120", "value": 1018.380005 },
					{ "name": "GOOG", "date": "20171121", "value": 1034.48999 },
					{ "name": "GOOG", "date": "20171122", "value": 1035.959961 },
					{ "name": "GOOG", "date": "20171124", "value": 1040.609985 },
					{ "name": "GOOG", "date": "20171127", "value": 1054.209961 },
					{ "name": "GOOG", "date": "20171128", "value": 1047.410034 },
					{ "name": "GOOG", "date": "20171129", "value": 1021.659973 },
					{ "name": "GOOG", "date": "20171130", "value": 1021.409973 },
					{ "name": "GOOG", "date": "20171201", "value": 1010.169983 },
					{ "name": "GOOG", "date": "20171204", "value": 998.679993 },
					{ "name": "GOOG", "date": "20171205", "value": 1005.150024 },
					{ "name": "GOOG", "date": "20171206", "value": 1018.380005 },
					{ "name": "GOOG", "date": "20171207", "value": 1030.930054 },
					{ "name": "GOOG", "date": "20171208", "value": 1037.050049 },
					{ "name": "GOOG", "date": "20171211", "value": 1041.099976 },
					{ "name": "GOOG", "date": "20171212", "value": 1040.47998 },
					{ "name": "GOOG", "date": "20171213", "value": 1040.609985 },
					{ "name": "GOOG", "date": "20171214", "value": 1049.150024 },
					{ "name": "GOOG", "date": "20171215", "value": 1064.189941 },
					{ "name": "GOOG", "date": "20171218", "value": 1077.140015 },
					{ "name": "GOOG", "date": "20171219", "value": 1070.680054 },
					{ "name": "GOOG", "date": "20171220", "value": 1064.949951 },
					{ "name": "GOOG", "date": "20171221", "value": 1063.630005 },
					{ "name": "GOOG", "date": "20171222", "value": 1060.119995 },
					{ "name": "GOOG", "date": "20171226", "value": 1056.73999 },
					{ "name": "GOOG", "date": "20171227", "value": 1049.369995 },
					{ "name": "GOOG", "date": "20171228", "value": 1048.140015 },
					{ "name": "GOOG", "date": "20171229", "value": 1046.400024 },
					{ "name": "GOOG", "date": "20180102", "value": 1065 },
					{ "name": "GOOG", "date": "20180103", "value": 1082.47998 },
					{ "name": "GOOG", "date": "20180104", "value": 1086.400024 },
					{ "name": "GOOG", "date": "20180105", "value": 1102.22998 },
					{ "name": "GOOG", "date": "20180108", "value": 1106.939941 },
					{ "name": "GOOG", "date": "20180109", "value": 1106.26001 },
					{ "name": "GOOG", "date": "20180110", "value": 1102.609985 },
					{ "name": "GOOG", "date": "20180111", "value": 1105.52002 },
					{ "name": "GOOG", "date": "20180112", "value": 1122.26001 },
					{ "name": "GOOG", "date": "20180116", "value": 1121.76001 },
					{ "name": "GOOG", "date": "20180117", "value": 1131.97998 },
					{ "name": "GOOG", "date": "20180118", "value": 1129.790039 },
					{ "name": "GOOG", "date": "20180119", "value": 1137.51001 },
					{ "name": "GOOG", "date": "20180122", "value": 1155.810059 },
					{ "name": "GOOG", "date": "20180123", "value": 1169.969971 },
					{ "name": "GOOG", "date": "20180124", "value": 1164.23999 },
					{ "name": "GOOG", "date": "20180125", "value": 1170.369995 },
					{ "name": "GOOG", "date": "20180126", "value": 1175.839966 },
					{ "name": "GOOG", "date": "20180129", "value": 1175.579956 },
					{ "name": "GOOG", "date": "20180130", "value": 1163.689941 },
					{ "name": "GOOG", "date": "20180131", "value": 1169.939941 },
					{ "name": "GOOG", "date": "20180201", "value": 1167.699951 },
					{ "name": "GOOG", "date": "20180202", "value": 1111.900024 },
					{ "name": "GOOG", "date": "20180205", "value": 1055.800049 },
					{ "name": "GOOG", "date": "20180206", "value": 1080.599976 },
					{ "name": "GOOG", "date": "20180207", "value": 1048.579956 },
					{ "name": "GOOG", "date": "20180208", "value": 1001.52002 },
					{ "name": "GOOG", "date": "20180209", "value": 1037.780029 },
					{ "name": "GOOG", "date": "20180212", "value": 1051.939941 },
					{ "name": "GOOG", "date": "20180213", "value": 1052.099976 },
					{ "name": "GOOG", "date": "20180214", "value": 1069.699951 },
					{ "name": "GOOG", "date": "20180215", "value": 1089.52002 },
					{ "name": "GOOG", "date": "20180216", "value": 1094.800049 },
					{ "name": "GOOG", "date": "20180220", "value": 1102.459961 },
					{ "name": "GOOG", "date": "20180221", "value": 1111.339966 },
					{ "name": "GOOG", "date": "20180222", "value": 1106.630005 },
					{ "name": "GOOG", "date": "20180223", "value": 1126.790039 },
					{ "name": "GOOG", "date": "20180226", "value": 1143.75 },
					{ "name": "GOOG", "date": "20180227", "value": 1118.290039 },
					{ "name": "GOOG", "date": "20180228", "value": 1104.72998 },
					{ "name": "GOOG", "date": "20180301", "value": 1069.52002 },
					{ "name": "GOOG", "date": "20180302", "value": 1078.920044 },
					{ "name": "GOOG", "date": "20180305", "value": 1090.930054 },
					{ "name": "GOOG", "date": "20180306", "value": 1095.060059 },
					{ "name": "GOOG", "date": "20180307", "value": 1109.640015 },
					{ "name": "GOOG", "date": "20180308", "value": 1126 },
					{ "name": "GOOG", "date": "20180309", "value": 1160.040039 },
					{ "name": "GOOG", "date": "20180312", "value": 1164.5 },
					{ "name": "GOOG", "date": "20180313", "value": 1138.170044 },
					{ "name": "GOOG", "date": "20180314", "value": 1149.48999 },
					{ "name": "GOOG", "date": "20180315", "value": 1149.579956 },
					{ "name": "GOOG", "date": "20180316", "value": 1135.72998 },
					{ "name": "GOOG", "date": "20180319", "value": 1099.819946 },
					{ "name": "GOOG", "date": "20180320", "value": 1097.709961 },
					{ "name": "GOOG", "date": "20180321", "value": 1090.880005 },
					{ "name": "GOOG", "date": "20180322", "value": 1049.079956 },
					{ "name": "GOOG", "date": "20180323", "value": 1021.570007 },
					{ "name": "GOOG", "date": "20180326", "value": 1053.209961 },
					{ "name": "GOOG", "date": "20180327", "value": 1005.099976 },
					{ "name": "GOOG", "date": "20180328", "value": 1004.559998 },
					{ "name": "GOOG", "date": "20180329", "value": 1031.790039 },
					{ "name": "GOOG", "date": "20180402", "value": 1006.469971 },
					{ "name": "GOOG", "date": "20180403", "value": 1013.409973 },
					{ "name": "GOOG", "date": "20180404", "value": 1025.140015 },
					{ "name": "GOOG", "date": "20180405", "value": 1027.810059 },
					{ "name": "GOOG", "date": "20180406", "value": 1007.039978 },
					{ "name": "GOOG", "date": "20180409", "value": 1015.450012 },
					{ "name": "GOOG", "date": "20180410", "value": 1031.640015 },
					{ "name": "GOOG", "date": "20180411", "value": 1019.969971 },
					{ "name": "GOOG", "date": "20180412", "value": 1032.51001 },
					{ "name": "GOOG", "date": "20180413", "value": 1029.27002 },
					{ "name": "GOOG", "date": "20180416", "value": 1037.97998 },
					{ "name": "GOOG", "date": "20180417", "value": 1074.160034 },
					{ "name": "GOOG", "date": "20180418", "value": 1072.079956 },
					{ "name": "GOOG", "date": "20180419", "value": 1087.699951 },
					{ "name": "GOOG", "date": "20180420", "value": 1072.959961 },
					{ "name": "GOOG", "date": "20180423", "value": 1067.449951 },
					{ "name": "GOOG", "date": "20180424", "value": 1019.97998 },
					{ "name": "GOOG", "date": "20180425", "value": 1021.179993 },
					{ "name": "GOOG", "date": "20180426", "value": 1040.040039 },
					{ "name": "GOOG", "date": "20180427", "value": 1030.050049 },
					{ "name": "GOOG", "date": "20180430", "value": 1017.330017 },
					{ "name": "GOOG", "date": "20180501", "value": 1037.310059 },
					{ "name": "GOOG", "date": "20180502", "value": 1024.380005 },
					{ "name": "GOOG", "date": "20180503", "value": 1023.719971 },
					{ "name": "GOOG", "date": "20180504", "value": 1048.209961 },
					{ "name": "GOOG", "date": "20180507", "value": 1054.790039 },
					{ "name": "GOOG", "date": "20180508", "value": 1053.910034 },
					{ "name": "GOOG", "date": "20180509", "value": 1082.76001 },
					{ "name": "GOOG", "date": "20180510", "value": 1097.569946 },
					{ "name": "GOOG", "date": "20180511", "value": 1098.26001 },
					{ "name": "IBM", "date": "20130513", "value": 202.470001 },
					{ "name": "IBM", "date": "20130514", "value": 203.210007 },
					{ "name": "IBM", "date": "20130515", "value": 203.320007 },
					{ "name": "IBM", "date": "20130516", "value": 204.690002 },
					{ "name": "IBM", "date": "20130517", "value": 208.440002 },
					{ "name": "IBM", "date": "20130520", "value": 207.600006 },
					{ "name": "IBM", "date": "20130521", "value": 208.649994 },
					{ "name": "IBM", "date": "20130522", "value": 206.990005 },
					{ "name": "IBM", "date": "20130523", "value": 206.160004 },
					{ "name": "IBM", "date": "20130524", "value": 205.720001 },
					{ "name": "IBM", "date": "20130528", "value": 207.779999 },
					{ "name": "IBM", "date": "20130529", "value": 207.919998 },
					{ "name": "IBM", "date": "20130530", "value": 209.360001 },
					{ "name": "IBM", "date": "20130531", "value": 208.020004 },
					{ "name": "IBM", "date": "20130603", "value": 208.949997 },
					{ "name": "IBM", "date": "20130604", "value": 206.190002 },
					{ "name": "IBM", "date": "20130605", "value": 202.740005 },
					{ "name": "IBM", "date": "20130606", "value": 203.800003 },
					{ "name": "IBM", "date": "20130607", "value": 206.350006 },
					{ "name": "IBM", "date": "20130610", "value": 205.020004 },
					{ "name": "IBM", "date": "20130611", "value": 203.979996 },
					{ "name": "IBM", "date": "20130612", "value": 201.199997 },
					{ "name": "IBM", "date": "20130613", "value": 203.770004 },
					{ "name": "IBM", "date": "20130614", "value": 202.199997 },
					{ "name": "IBM", "date": "20130617", "value": 203.039993 },
					{ "name": "IBM", "date": "20130618", "value": 204.869995 },
					{ "name": "IBM", "date": "20130619", "value": 201.940002 },
					{ "name": "IBM", "date": "20130620", "value": 197.350006 },
					{ "name": "IBM", "date": "20130621", "value": 195.460007 },
					{ "name": "IBM", "date": "20130624", "value": 193.539993 },
					{ "name": "IBM", "date": "20130625", "value": 194.979996 },
					{ "name": "IBM", "date": "20130626", "value": 194.860001 },
					{ "name": "IBM", "date": "20130627", "value": 195.649994 },
					{ "name": "IBM", "date": "20130628", "value": 191.110001 },
					{ "name": "IBM", "date": "20130701", "value": 191.279999 },
					{ "name": "IBM", "date": "20130702", "value": 191.5 },
					{ "name": "IBM", "date": "20130703", "value": 193.25 },
					{ "name": "IBM", "date": "20130705", "value": 194.929993 },
					{ "name": "IBM", "date": "20130708", "value": 194.979996 },
					{ "name": "IBM", "date": "20130709", "value": 191.300003 },
					{ "name": "IBM", "date": "20130710", "value": 192.25 },
					{ "name": "IBM", "date": "20130711", "value": 192.800003 },
					{ "name": "IBM", "date": "20130712", "value": 192.070007 },
					{ "name": "IBM", "date": "20130715", "value": 194 },
					{ "name": "IBM", "date": "20130716", "value": 193.850006 },
					{ "name": "IBM", "date": "20130717", "value": 194.550003 },
					{ "name": "IBM", "date": "20130718", "value": 197.990005 },
					{ "name": "IBM", "date": "20130719", "value": 193.539993 },
					{ "name": "IBM", "date": "20130722", "value": 194.089996 },
					{ "name": "IBM", "date": "20130723", "value": 194.979996 },
					{ "name": "IBM", "date": "20130724", "value": 196.610001 },
					{ "name": "IBM", "date": "20130725", "value": 197.220001 },
					{ "name": "IBM", "date": "20130726", "value": 197.350006 },
					{ "name": "IBM", "date": "20130729", "value": 196.210007 },
					{ "name": "IBM", "date": "20130730", "value": 196.009995 },
					{ "name": "IBM", "date": "20130731", "value": 195.039993 },
					{ "name": "IBM", "date": "20130801", "value": 195.809998 },
					{ "name": "IBM", "date": "20130802", "value": 195.160004 },
					{ "name": "IBM", "date": "20130805", "value": 195.5 },
					{ "name": "IBM", "date": "20130806", "value": 190.990005 },
					{ "name": "IBM", "date": "20130807", "value": 188.559998 },
					{ "name": "IBM", "date": "20130808", "value": 187.929993 },
					{ "name": "IBM", "date": "20130809", "value": 187.820007 },
					{ "name": "IBM", "date": "20130812", "value": 189.089996 },
					{ "name": "IBM", "date": "20130813", "value": 188.419998 },
					{ "name": "IBM", "date": "20130814", "value": 187.529999 },
					{ "name": "IBM", "date": "20130815", "value": 185.789993 },
					{ "name": "IBM", "date": "20130816", "value": 185.339996 },
					{ "name": "IBM", "date": "20130819", "value": 184.229996 },
					{ "name": "IBM", "date": "20130820", "value": 184.559998 },
					{ "name": "IBM", "date": "20130821", "value": 184.860001 },
					{ "name": "IBM", "date": "20130822", "value": 185.190002 },
					{ "name": "IBM", "date": "20130823", "value": 185.419998 },
					{ "name": "IBM", "date": "20130826", "value": 184.740005 },
					{ "name": "IBM", "date": "20130827", "value": 182.740005 },
					{ "name": "IBM", "date": "20130828", "value": 182.160004 },
					{ "name": "IBM", "date": "20130829", "value": 182.639999 },
					{ "name": "IBM", "date": "20130830", "value": 182.270004 },
					{ "name": "IBM", "date": "20130903", "value": 183.960007 },
					{ "name": "IBM", "date": "20130904", "value": 183.130005 },
					{ "name": "IBM", "date": "20130905", "value": 184.149994 },
					{ "name": "IBM", "date": "20130906", "value": 183.029999 },
					{ "name": "IBM", "date": "20130909", "value": 184.979996 },
					{ "name": "IBM", "date": "20130910", "value": 186.600006 },
					{ "name": "IBM", "date": "20130911", "value": 190.699997 },
					{ "name": "IBM", "date": "20130912", "value": 190.729996 },
					{ "name": "IBM", "date": "20130913", "value": 192.169998 },
					{ "name": "IBM", "date": "20130916", "value": 193.149994 },
					{ "name": "IBM", "date": "20130917", "value": 192.160004 },
					{ "name": "IBM", "date": "20130918", "value": 194.419998 },
					{ "name": "IBM", "date": "20130919", "value": 193.389999 },
					{ "name": "IBM", "date": "20130920", "value": 190.020004 },
					{ "name": "IBM", "date": "20130923", "value": 190.990005 },
					{ "name": "IBM", "date": "20130924", "value": 189.970001 },
					{ "name": "IBM", "date": "20130925", "value": 189.470001 },
					{ "name": "IBM", "date": "20130926", "value": 190.220001 },
					{ "name": "IBM", "date": "20130927", "value": 186.919998 },
					{ "name": "IBM", "date": "20130930", "value": 185.179993 },
					{ "name": "IBM", "date": "20131001", "value": 186.380005 },
					{ "name": "IBM", "date": "20131002", "value": 184.960007 },
					{ "name": "IBM", "date": "20131003", "value": 183.860001 },
					{ "name": "IBM", "date": "20131004", "value": 184.100006 },
					{ "name": "IBM", "date": "20131007", "value": 182.009995 },
					{ "name": "IBM", "date": "20131008", "value": 178.720001 },
					{ "name": "IBM", "date": "20131009", "value": 181.320007 },
					{ "name": "IBM", "date": "20131010", "value": 184.770004 },
					{ "name": "IBM", "date": "20131011", "value": 186.160004 },
					{ "name": "IBM", "date": "20131014", "value": 186.970001 },
					{ "name": "IBM", "date": "20131015", "value": 184.660004 },
					{ "name": "IBM", "date": "20131016", "value": 186.729996 },
					{ "name": "IBM", "date": "20131017", "value": 174.830002 },
					{ "name": "IBM", "date": "20131018", "value": 173.779999 },
					{ "name": "IBM", "date": "20131021", "value": 172.860001 },
					{ "name": "IBM", "date": "20131022", "value": 174.970001 },
					{ "name": "IBM", "date": "20131023", "value": 175.770004 },
					{ "name": "IBM", "date": "20131024", "value": 177.800003 },
					{ "name": "IBM", "date": "20131025", "value": 176.850006 },
					{ "name": "IBM", "date": "20131028", "value": 177.350006 },
					{ "name": "IBM", "date": "20131029", "value": 182.119995 },
					{ "name": "IBM", "date": "20131030", "value": 180.149994 },
					{ "name": "IBM", "date": "20131031", "value": 179.210007 },
					{ "name": "IBM", "date": "20131101", "value": 179.229996 },
					{ "name": "IBM", "date": "20131104", "value": 180.270004 },
					{ "name": "IBM", "date": "20131105", "value": 177.850006 },
					{ "name": "IBM", "date": "20131106", "value": 179.190002 },
					{ "name": "IBM", "date": "20131107", "value": 180 },
					{ "name": "IBM", "date": "20131108", "value": 179.990005 },
					{ "name": "IBM", "date": "20131111", "value": 182.880005 },
					{ "name": "IBM", "date": "20131112", "value": 183.070007 },
					{ "name": "IBM", "date": "20131113", "value": 183.550003 },
					{ "name": "IBM", "date": "20131114", "value": 182.210007 },
					{ "name": "IBM", "date": "20131115", "value": 183.190002 },
					{ "name": "IBM", "date": "20131118", "value": 184.470001 },
					{ "name": "IBM", "date": "20131119", "value": 185.25 },
					{ "name": "IBM", "date": "20131120", "value": 185.190002 },
					{ "name": "IBM", "date": "20131121", "value": 184.130005 },
					{ "name": "IBM", "date": "20131122", "value": 181.300003 },
					{ "name": "IBM", "date": "20131125", "value": 178.940002 },
					{ "name": "IBM", "date": "20131126", "value": 177.309998 },
					{ "name": "IBM", "date": "20131127", "value": 178.970001 },
					{ "name": "IBM", "date": "20131129", "value": 179.679993 },
					{ "name": "IBM", "date": "20131202", "value": 177.479996 },
					{ "name": "IBM", "date": "20131203", "value": 176.080002 },
					{ "name": "IBM", "date": "20131204", "value": 175.740005 },
					{ "name": "IBM", "date": "20131205", "value": 176.080002 },
					{ "name": "IBM", "date": "20131206", "value": 177.669998 },
					{ "name": "IBM", "date": "20131209", "value": 177.460007 },
					{ "name": "IBM", "date": "20131210", "value": 177.119995 },
					{ "name": "IBM", "date": "20131211", "value": 175.199997 },
					{ "name": "IBM", "date": "20131212", "value": 173.369995 },
					{ "name": "IBM", "date": "20131213", "value": 172.800003 },
					{ "name": "IBM", "date": "20131216", "value": 177.850006 },
					{ "name": "IBM", "date": "20131217", "value": 175.759995 },
					{ "name": "IBM", "date": "20131218", "value": 178.699997 },
					{ "name": "IBM", "date": "20131219", "value": 180.220001 },
					{ "name": "IBM", "date": "20131220", "value": 180.020004 },
					{ "name": "IBM", "date": "20131223", "value": 182.229996 },
					{ "name": "IBM", "date": "20131224", "value": 183.220001 },
					{ "name": "IBM", "date": "20131226", "value": 185.350006 },
					{ "name": "IBM", "date": "20131227", "value": 185.080002 },
					{ "name": "IBM", "date": "20131230", "value": 186.410004 },
					{ "name": "IBM", "date": "20131231", "value": 187.570007 },
					{ "name": "IBM", "date": "20140102", "value": 185.529999 },
					{ "name": "IBM", "date": "20140103", "value": 186.639999 },
					{ "name": "IBM", "date": "20140106", "value": 186 },
					{ "name": "IBM", "date": "20140107", "value": 189.710007 },
					{ "name": "IBM", "date": "20140108", "value": 187.970001 },
					{ "name": "IBM", "date": "20140109", "value": 187.380005 },
					{ "name": "IBM", "date": "20140110", "value": 187.259995 },
					{ "name": "IBM", "date": "20140113", "value": 184.160004 },
					{ "name": "IBM", "date": "20140114", "value": 185.919998 },
					{ "name": "IBM", "date": "20140115", "value": 187.740005 },
					{ "name": "IBM", "date": "20140116", "value": 188.759995 },
					{ "name": "IBM", "date": "20140117", "value": 190.089996 },
					{ "name": "IBM", "date": "20140121", "value": 188.429993 },
					{ "name": "IBM", "date": "20140122", "value": 182.25 },
					{ "name": "IBM", "date": "20140123", "value": 182.729996 },
					{ "name": "IBM", "date": "20140124", "value": 179.639999 },
					{ "name": "IBM", "date": "20140127", "value": 177.899994 },
					{ "name": "IBM", "date": "20140128", "value": 176.850006 },
					{ "name": "IBM", "date": "20140129", "value": 176.399994 },
					{ "name": "IBM", "date": "20140130", "value": 177.360001 },
					{ "name": "IBM", "date": "20140131", "value": 176.679993 },
					{ "name": "IBM", "date": "20140203", "value": 172.899994 },
					{ "name": "IBM", "date": "20140204", "value": 172.839996 },
					{ "name": "IBM", "date": "20140205", "value": 174.240005 },
					{ "name": "IBM", "date": "20140206", "value": 174.669998 },
					{ "name": "IBM", "date": "20140207", "value": 177.25 },
					{ "name": "IBM", "date": "20140210", "value": 177.139999 },
					{ "name": "IBM", "date": "20140211", "value": 179.699997 },
					{ "name": "IBM", "date": "20140212", "value": 180.240005 },
					{ "name": "IBM", "date": "20140213", "value": 181.839996 },
					{ "name": "IBM", "date": "20140214", "value": 183.690002 },
					{ "name": "IBM", "date": "20140218", "value": 183.190002 },
					{ "name": "IBM", "date": "20140219", "value": 182.949997 },
					{ "name": "IBM", "date": "20140220", "value": 184.259995 },
					{ "name": "IBM", "date": "20140221", "value": 182.789993 },
					{ "name": "IBM", "date": "20140224", "value": 183.449997 },
					{ "name": "IBM", "date": "20140225", "value": 183.229996 },
					{ "name": "IBM", "date": "20140226", "value": 184.059998 },
					{ "name": "IBM", "date": "20140227", "value": 185.270004 },
					{ "name": "IBM", "date": "20140228", "value": 185.169998 },
					{ "name": "IBM", "date": "20140303", "value": 184.259995 },
					{ "name": "IBM", "date": "20140304", "value": 186.440002 },
					{ "name": "IBM", "date": "20140305", "value": 187.139999 },
					{ "name": "IBM", "date": "20140306", "value": 187.639999 },
					{ "name": "IBM", "date": "20140307", "value": 187.679993 },
					{ "name": "IBM", "date": "20140310", "value": 186.389999 },
					{ "name": "IBM", "date": "20140311", "value": 186.759995 },
					{ "name": "IBM", "date": "20140312", "value": 186.220001 },
					{ "name": "IBM", "date": "20140313", "value": 183.899994 },
					{ "name": "IBM", "date": "20140314", "value": 182.210007 },
					{ "name": "IBM", "date": "20140317", "value": 185.809998 },
					{ "name": "IBM", "date": "20140318", "value": 186.809998 },
					{ "name": "IBM", "date": "20140319", "value": 184.710007 },
					{ "name": "IBM", "date": "20140320", "value": 187.899994 },
					{ "name": "IBM", "date": "20140321", "value": 186.669998 },
					{ "name": "IBM", "date": "20140324", "value": 188.25 },
					{ "name": "IBM", "date": "20140325", "value": 195.039993 },
					{ "name": "IBM", "date": "20140326", "value": 192.619995 },
					{ "name": "IBM", "date": "20140327", "value": 189.830002 },
					{ "name": "IBM", "date": "20140328", "value": 190.449997 },
					{ "name": "IBM", "date": "20140331", "value": 192.490005 },
					{ "name": "IBM", "date": "20140401", "value": 194.5 },
					{ "name": "IBM", "date": "20140402", "value": 193.550003 },
					{ "name": "IBM", "date": "20140403", "value": 192.690002 },
					{ "name": "IBM", "date": "20140404", "value": 191.770004 },
					{ "name": "IBM", "date": "20140407", "value": 194.520004 },
					{ "name": "IBM", "date": "20140408", "value": 193.289993 },
					{ "name": "IBM", "date": "20140409", "value": 196.639999 },
					{ "name": "IBM", "date": "20140410", "value": 195.679993 },
					{ "name": "IBM", "date": "20140411", "value": 195.190002 },
					{ "name": "IBM", "date": "20140414", "value": 197.770004 },
					{ "name": "IBM", "date": "20140415", "value": 197.020004 },
					{ "name": "IBM", "date": "20140416", "value": 196.399994 },
					{ "name": "IBM", "date": "20140417", "value": 190.009995 },
					{ "name": "IBM", "date": "20140421", "value": 192.270004 },
					{ "name": "IBM", "date": "20140422", "value": 192.149994 },
					{ "name": "IBM", "date": "20140423", "value": 191.729996 },
					{ "name": "IBM", "date": "20140424", "value": 190.220001 },
					{ "name": "IBM", "date": "20140425", "value": 189.630005 },
					{ "name": "IBM", "date": "20140428", "value": 193.139999 },
					{ "name": "IBM", "date": "20140429", "value": 195.110001 },
					{ "name": "IBM", "date": "20140430", "value": 196.470001 },
					{ "name": "IBM", "date": "20140501", "value": 193.529999 },
					{ "name": "IBM", "date": "20140502", "value": 191.440002 },
					{ "name": "IBM", "date": "20140505", "value": 191.259995 },
					{ "name": "IBM", "date": "20140506", "value": 190.029999 },
					{ "name": "IBM", "date": "20140507", "value": 189.300003 },
					{ "name": "IBM", "date": "20140508", "value": 188.910004 },
					{ "name": "IBM", "date": "20140509", "value": 190.080002 },
					{ "name": "IBM", "date": "20140512", "value": 192.570007 },
					{ "name": "IBM", "date": "20140513", "value": 192.190002 },
					{ "name": "IBM", "date": "20140514", "value": 188.720001 },
					{ "name": "IBM", "date": "20140515", "value": 186.460007 },
					{ "name": "IBM", "date": "20140516", "value": 187.059998 },
					{ "name": "IBM", "date": "20140519", "value": 187 },
					{ "name": "IBM", "date": "20140520", "value": 184.889999 },
					{ "name": "IBM", "date": "20140521", "value": 186.389999 },
					{ "name": "IBM", "date": "20140522", "value": 185.679993 },
					{ "name": "IBM", "date": "20140523", "value": 185.940002 },
					{ "name": "IBM", "date": "20140527", "value": 184.779999 },
					{ "name": "IBM", "date": "20140528", "value": 183.080002 },
					{ "name": "IBM", "date": "20140529", "value": 183.759995 },
					{ "name": "IBM", "date": "20140530", "value": 184.360001 },
					{ "name": "IBM", "date": "20140602", "value": 185.690002 },
					{ "name": "IBM", "date": "20140603", "value": 184.369995 },
					{ "name": "IBM", "date": "20140604", "value": 184.509995 },
					{ "name": "IBM", "date": "20140605", "value": 185.979996 },
					{ "name": "IBM", "date": "20140606", "value": 186.369995 },
					{ "name": "IBM", "date": "20140609", "value": 186.220001 },
					{ "name": "IBM", "date": "20140610", "value": 184.289993 },
					{ "name": "IBM", "date": "20140611", "value": 182.25 },
					{ "name": "IBM", "date": "20140612", "value": 181.220001 },
					{ "name": "IBM", "date": "20140613", "value": 182.559998 },
					{ "name": "IBM", "date": "20140616", "value": 182.350006 },
					{ "name": "IBM", "date": "20140617", "value": 182.259995 },
					{ "name": "IBM", "date": "20140618", "value": 183.600006 },
					{ "name": "IBM", "date": "20140619", "value": 182.820007 },
					{ "name": "IBM", "date": "20140620", "value": 181.550003 },
					{ "name": "IBM", "date": "20140623", "value": 182.139999 },
					{ "name": "IBM", "date": "20140624", "value": 180.880005 },
					{ "name": "IBM", "date": "20140625", "value": 180.720001 },
					{ "name": "IBM", "date": "20140626", "value": 180.369995 },
					{ "name": "IBM", "date": "20140627", "value": 181.710007 },
					{ "name": "IBM", "date": "20140630", "value": 181.270004 },
					{ "name": "IBM", "date": "20140701", "value": 186.350006 },
					{ "name": "IBM", "date": "20140702", "value": 188.389999 },
					{ "name": "IBM", "date": "20140703", "value": 188.529999 },
					{ "name": "IBM", "date": "20140707", "value": 188.039993 },
					{ "name": "IBM", "date": "20140708", "value": 187.220001 },
					{ "name": "IBM", "date": "20140709", "value": 188.419998 },
					{ "name": "IBM", "date": "20140710", "value": 187.699997 },
					{ "name": "IBM", "date": "20140711", "value": 188 },
					{ "name": "IBM", "date": "20140714", "value": 189.860001 },
					{ "name": "IBM", "date": "20140715", "value": 188.490005 },
					{ "name": "IBM", "date": "20140716", "value": 192.360001 },
					{ "name": "IBM", "date": "20140717", "value": 192.490005 },
					{ "name": "IBM", "date": "20140718", "value": 192.5 },
					{ "name": "IBM", "date": "20140721", "value": 190.850006 },
					{ "name": "IBM", "date": "20140722", "value": 194.089996 },
					{ "name": "IBM", "date": "20140723", "value": 193.630005 },
					{ "name": "IBM", "date": "20140724", "value": 195.240005 },
					{ "name": "IBM", "date": "20140725", "value": 194.399994 },
					{ "name": "IBM", "date": "20140728", "value": 195.779999 },
					{ "name": "IBM", "date": "20140729", "value": 194.570007 },
					{ "name": "IBM", "date": "20140730", "value": 194 },
					{ "name": "IBM", "date": "20140731", "value": 191.669998 },
					{ "name": "IBM", "date": "20140801", "value": 189.149994 },
					{ "name": "IBM", "date": "20140804", "value": 189.639999 },
					{ "name": "IBM", "date": "20140805", "value": 187.100006 },
					{ "name": "IBM", "date": "20140806", "value": 185.970001 },
					{ "name": "IBM", "date": "20140807", "value": 184.300003 },
					{ "name": "IBM", "date": "20140808", "value": 186.630005 },
					{ "name": "IBM", "date": "20140811", "value": 187.470001 },
					{ "name": "IBM", "date": "20140812", "value": 187.339996 },
					{ "name": "IBM", "date": "20140813", "value": 187.949997 },
					{ "name": "IBM", "date": "20140814", "value": 187.880005 },
					{ "name": "IBM", "date": "20140815", "value": 187.380005 },
					{ "name": "IBM", "date": "20140818", "value": 189.360001 },
					{ "name": "IBM", "date": "20140819", "value": 190.070007 },
					{ "name": "IBM", "date": "20140820", "value": 190.100006 },
					{ "name": "IBM", "date": "20140821", "value": 191.229996 },
					{ "name": "IBM", "date": "20140822", "value": 190.410004 },
					{ "name": "IBM", "date": "20140825", "value": 191.160004 },
					{ "name": "IBM", "date": "20140826", "value": 192.990005 },
					{ "name": "IBM", "date": "20140827", "value": 192.25 },
					{ "name": "IBM", "date": "20140828", "value": 192 },
					{ "name": "IBM", "date": "20140829", "value": 192.300003 },
					{ "name": "IBM", "date": "20140902", "value": 191.559998 },
					{ "name": "IBM", "date": "20140903", "value": 191.949997 },
					{ "name": "IBM", "date": "20140904", "value": 190.679993 },
					{ "name": "IBM", "date": "20140905", "value": 191.199997 },
					{ "name": "IBM", "date": "20140908", "value": 190.139999 },
					{ "name": "IBM", "date": "20140909", "value": 189.990005 },
					{ "name": "IBM", "date": "20140910", "value": 191.539993 },
					{ "name": "IBM", "date": "20140911", "value": 191.720001 },
					{ "name": "IBM", "date": "20140912", "value": 191.279999 },
					{ "name": "IBM", "date": "20140915", "value": 191.809998 },
					{ "name": "IBM", "date": "20140916", "value": 192.960007 },
					{ "name": "IBM", "date": "20140917", "value": 192.800003 },
					{ "name": "IBM", "date": "20140918", "value": 193.75 },
					{ "name": "IBM", "date": "20140919", "value": 194 },
					{ "name": "IBM", "date": "20140922", "value": 193.110001 },
					{ "name": "IBM", "date": "20140923", "value": 191.619995 },
					{ "name": "IBM", "date": "20140924", "value": 192.309998 },
					{ "name": "IBM", "date": "20140925", "value": 189.009995 },
					{ "name": "IBM", "date": "20140926", "value": 190.059998 },
					{ "name": "IBM", "date": "20140929", "value": 189.639999 },
					{ "name": "IBM", "date": "20140930", "value": 189.830002 },
					{ "name": "IBM", "date": "20141001", "value": 187.169998 },
					{ "name": "IBM", "date": "20141002", "value": 186.910004 },
					{ "name": "IBM", "date": "20141003", "value": 188.669998 },
					{ "name": "IBM", "date": "20141006", "value": 189.039993 },
					{ "name": "IBM", "date": "20141007", "value": 185.710007 },
					{ "name": "IBM", "date": "20141008", "value": 189.360001 },
					{ "name": "IBM", "date": "20141009", "value": 186.419998 },
					{ "name": "IBM", "date": "20141010", "value": 185.929993 },
					{ "name": "IBM", "date": "20141013", "value": 183.520004 },
					{ "name": "IBM", "date": "20141014", "value": 183.800003 },
					{ "name": "IBM", "date": "20141015", "value": 181.75 },
					{ "name": "IBM", "date": "20141016", "value": 179.839996 },
					{ "name": "IBM", "date": "20141017", "value": 182.050003 },
					{ "name": "IBM", "date": "20141020", "value": 169.100006 },
					{ "name": "IBM", "date": "20141021", "value": 163.229996 },
					{ "name": "IBM", "date": "20141022", "value": 161.789993 },
					{ "name": "IBM", "date": "20141023", "value": 162.179993 },
					{ "name": "IBM", "date": "20141024", "value": 162.080002 },
					{ "name": "IBM", "date": "20141027", "value": 161.869995 },
					{ "name": "IBM", "date": "20141028", "value": 163.600006 },
					{ "name": "IBM", "date": "20141029", "value": 163.460007 },
					{ "name": "IBM", "date": "20141030", "value": 164.350006 },
					{ "name": "IBM", "date": "20141031", "value": 164.399994 },
					{ "name": "IBM", "date": "20141103", "value": 164.360001 },
					{ "name": "IBM", "date": "20141104", "value": 162.649994 },
					{ "name": "IBM", "date": "20141105", "value": 161.820007 },
					{ "name": "IBM", "date": "20141106", "value": 161.460007 },
					{ "name": "IBM", "date": "20141107", "value": 162.070007 },
					{ "name": "IBM", "date": "20141110", "value": 163.490005 },
					{ "name": "IBM", "date": "20141111", "value": 163.300003 },
					{ "name": "IBM", "date": "20141112", "value": 161.919998 },
					{ "name": "IBM", "date": "20141113", "value": 162.789993 },
					{ "name": "IBM", "date": "20141114", "value": 164.160004 },
					{ "name": "IBM", "date": "20141117", "value": 164.160004 },
					{ "name": "IBM", "date": "20141118", "value": 161.889999 },
					{ "name": "IBM", "date": "20141119", "value": 161.429993 },
					{ "name": "IBM", "date": "20141120", "value": 160.639999 },
					{ "name": "IBM", "date": "20141121", "value": 160.919998 },
					{ "name": "IBM", "date": "20141124", "value": 162.149994 },
					{ "name": "IBM", "date": "20141125", "value": 161.759995 },
					{ "name": "IBM", "date": "20141126", "value": 161.949997 },
					{ "name": "IBM", "date": "20141128", "value": 162.169998 },
					{ "name": "IBM", "date": "20141201", "value": 161.539993 },
					{ "name": "IBM", "date": "20141202", "value": 162.669998 },
					{ "name": "IBM", "date": "20141203", "value": 164.520004 },
					{ "name": "IBM", "date": "20141204", "value": 164.050003 },
					{ "name": "IBM", "date": "20141205", "value": 163.270004 },
					{ "name": "IBM", "date": "20141208", "value": 161.860001 },
					{ "name": "IBM", "date": "20141209", "value": 162.990005 },
					{ "name": "IBM", "date": "20141210", "value": 160.509995 },
					{ "name": "IBM", "date": "20141211", "value": 161.070007 },
					{ "name": "IBM", "date": "20141212", "value": 155.380005 },
					{ "name": "IBM", "date": "20141215", "value": 153.059998 },
					{ "name": "IBM", "date": "20141216", "value": 151.410004 },
					{ "name": "IBM", "date": "20141217", "value": 151.929993 },
					{ "name": "IBM", "date": "20141218", "value": 157.679993 },
					{ "name": "IBM", "date": "20141219", "value": 158.509995 },
					{ "name": "IBM", "date": "20141222", "value": 161.440002 },
					{ "name": "IBM", "date": "20141223", "value": 162.240005 },
					{ "name": "IBM", "date": "20141224", "value": 161.820007 },
					{ "name": "IBM", "date": "20141226", "value": 162.339996 },
					{ "name": "IBM", "date": "20141229", "value": 160.509995 },
					{ "name": "IBM", "date": "20141230", "value": 160.050003 },
					{ "name": "IBM", "date": "20141231", "value": 160.440002 },
					{ "name": "IBM", "date": "20150102", "value": 162.059998 },
					{ "name": "IBM", "date": "20150105", "value": 159.509995 },
					{ "name": "IBM", "date": "20150106", "value": 156.070007 },
					{ "name": "IBM", "date": "20150107", "value": 155.050003 },
					{ "name": "IBM", "date": "20150108", "value": 158.419998 },
					{ "name": "IBM", "date": "20150109", "value": 159.110001 },
					{ "name": "IBM", "date": "20150112", "value": 156.440002 },
					{ "name": "IBM", "date": "20150113", "value": 156.809998 },
					{ "name": "IBM", "date": "20150114", "value": 155.800003 },
					{ "name": "IBM", "date": "20150115", "value": 154.570007 },
					{ "name": "IBM", "date": "20150116", "value": 157.139999 },
					{ "name": "IBM", "date": "20150120", "value": 156.949997 },
					{ "name": "IBM", "date": "20150121", "value": 152.089996 },
					{ "name": "IBM", "date": "20150122", "value": 155.389999 },
					{ "name": "IBM", "date": "20150123", "value": 155.869995 },
					{ "name": "IBM", "date": "20150126", "value": 156.360001 },
					{ "name": "IBM", "date": "20150127", "value": 153.669998 },
					{ "name": "IBM", "date": "20150128", "value": 151.550003 },
					{ "name": "IBM", "date": "20150129", "value": 155.479996 },
					{ "name": "IBM", "date": "20150130", "value": 153.309998 },
					{ "name": "IBM", "date": "20150202", "value": 154.660004 },
					{ "name": "IBM", "date": "20150203", "value": 158.470001 },
					{ "name": "IBM", "date": "20150204", "value": 156.960007 },
					{ "name": "IBM", "date": "20150205", "value": 157.910004 },
					{ "name": "IBM", "date": "20150206", "value": 156.720001 },
					{ "name": "IBM", "date": "20150209", "value": 155.75 },
					{ "name": "IBM", "date": "20150210", "value": 158.559998 },
					{ "name": "IBM", "date": "20150211", "value": 158.199997 },
					{ "name": "IBM", "date": "20150212", "value": 158.520004 },
					{ "name": "IBM", "date": "20150213", "value": 160.399994 },
					{ "name": "IBM", "date": "20150217", "value": 160.960007 },
					{ "name": "IBM", "date": "20150218", "value": 162.190002 },
					{ "name": "IBM", "date": "20150219", "value": 163.889999 },
					{ "name": "IBM", "date": "20150220", "value": 163.649994 },
					{ "name": "IBM", "date": "20150223", "value": 162.910004 },
					{ "name": "IBM", "date": "20150224", "value": 164.830002 },
					{ "name": "IBM", "date": "20150225", "value": 162.809998 },
					{ "name": "IBM", "date": "20150226", "value": 160.869995 },
					{ "name": "IBM", "date": "20150227", "value": 161.940002 },
					{ "name": "IBM", "date": "20150302", "value": 160.479996 },
					{ "name": "IBM", "date": "20150303", "value": 161.029999 },
					{ "name": "IBM", "date": "20150304", "value": 159.419998 },
					{ "name": "IBM", "date": "20150305", "value": 161.179993 },
					{ "name": "IBM", "date": "20150306", "value": 158.5 },
					{ "name": "IBM", "date": "20150309", "value": 160.770004 },
					{ "name": "IBM", "date": "20150310", "value": 157.809998 },
					{ "name": "IBM", "date": "20150311", "value": 156.800003 },
					{ "name": "IBM", "date": "20150312", "value": 157.979996 },
					{ "name": "IBM", "date": "20150313", "value": 154.279999 },
					{ "name": "IBM", "date": "20150316", "value": 157.080002 },
					{ "name": "IBM", "date": "20150317", "value": 156.960007 },
					{ "name": "IBM", "date": "20150318", "value": 159.809998 },
					{ "name": "IBM", "date": "20150319", "value": 159.809998 },
					{ "name": "IBM", "date": "20150320", "value": 162.880005 },
					{ "name": "IBM", "date": "20150323", "value": 164.630005 },
					{ "name": "IBM", "date": "20150324", "value": 163 },
					{ "name": "IBM", "date": "20150325", "value": 159.199997 },
					{ "name": "IBM", "date": "20150326", "value": 160.589996 },
					{ "name": "IBM", "date": "20150327", "value": 160.399994 },
					{ "name": "IBM", "date": "20150330", "value": 162.669998 },
					{ "name": "IBM", "date": "20150331", "value": 160.5 },
					{ "name": "IBM", "date": "20150401", "value": 159.179993 },
					{ "name": "IBM", "date": "20150402", "value": 160.449997 },
					{ "name": "IBM", "date": "20150406", "value": 162.039993 },
					{ "name": "IBM", "date": "20150407", "value": 162.070007 },
					{ "name": "IBM", "date": "20150408", "value": 161.850006 },
					{ "name": "IBM", "date": "20150409", "value": 162.339996 },
					{ "name": "IBM", "date": "20150410", "value": 162.860001 },
					{ "name": "IBM", "date": "20150413", "value": 162.380005 },
					{ "name": "IBM", "date": "20150414", "value": 162.300003 },
					{ "name": "IBM", "date": "20150415", "value": 164.130005 },
					{ "name": "IBM", "date": "20150416", "value": 163.130005 },
					{ "name": "IBM", "date": "20150417", "value": 160.669998 },
					{ "name": "IBM", "date": "20150420", "value": 166.160004 },
					{ "name": "IBM", "date": "20150421", "value": 164.259995 },
					{ "name": "IBM", "date": "20150422", "value": 165.360001 },
					{ "name": "IBM", "date": "20150423", "value": 170.240005 },
					{ "name": "IBM", "date": "20150424", "value": 169.779999 },
					{ "name": "IBM", "date": "20150427", "value": 170.729996 },
					{ "name": "IBM", "date": "20150428", "value": 173.919998 },
					{ "name": "IBM", "date": "20150429", "value": 174.399994 },
					{ "name": "IBM", "date": "20150430", "value": 171.289993 },
					{ "name": "IBM", "date": "20150501", "value": 173.669998 },
					{ "name": "IBM", "date": "20150504", "value": 173.970001 },
					{ "name": "IBM", "date": "20150505", "value": 173.080002 },
					{ "name": "IBM", "date": "20150506", "value": 170.050003 },
					{ "name": "IBM", "date": "20150507", "value": 170.990005 },
					{ "name": "IBM", "date": "20150508", "value": 172.679993 },
					{ "name": "IBM", "date": "20150511", "value": 171.119995 },
					{ "name": "IBM", "date": "20150512", "value": 170.550003 },
					{ "name": "IBM", "date": "20150513", "value": 172.279999 },
					{ "name": "IBM", "date": "20150514", "value": 174.050003 },
					{ "name": "IBM", "date": "20150515", "value": 173.259995 },
					{ "name": "IBM", "date": "20150518", "value": 173.059998 },
					{ "name": "IBM", "date": "20150519", "value": 173.479996 },
					{ "name": "IBM", "date": "20150520", "value": 173.759995 },
					{ "name": "IBM", "date": "20150521", "value": 173.339996 },
					{ "name": "IBM", "date": "20150522", "value": 172.220001 },
					{ "name": "IBM", "date": "20150526", "value": 170.130005 },
					{ "name": "IBM", "date": "20150527", "value": 172 },
					{ "name": "IBM", "date": "20150528", "value": 171.710007 },
					{ "name": "IBM", "date": "20150529", "value": 169.649994 },
					{ "name": "IBM", "date": "20150601", "value": 170.179993 },
					{ "name": "IBM", "date": "20150602", "value": 169.649994 },
					{ "name": "IBM", "date": "20150603", "value": 169.919998 },
					{ "name": "IBM", "date": "20150604", "value": 168.380005 },
					{ "name": "IBM", "date": "20150605", "value": 167.399994 },
					{ "name": "IBM", "date": "20150608", "value": 165.339996 },
					{ "name": "IBM", "date": "20150609", "value": 165.679993 },
					{ "name": "IBM", "date": "20150610", "value": 168.919998 },
					{ "name": "IBM", "date": "20150611", "value": 168.779999 },
					{ "name": "IBM", "date": "20150612", "value": 166.990005 },
					{ "name": "IBM", "date": "20150615", "value": 166.259995 },
					{ "name": "IBM", "date": "20150616", "value": 166.839996 },
					{ "name": "IBM", "date": "20150617", "value": 167.169998 },
					{ "name": "IBM", "date": "20150618", "value": 168.25 },
					{ "name": "IBM", "date": "20150619", "value": 166.990005 },
					{ "name": "IBM", "date": "20150622", "value": 167.729996 },
					{ "name": "IBM", "date": "20150623", "value": 168.619995 },
					{ "name": "IBM", "date": "20150624", "value": 166.970001 },
					{ "name": "IBM", "date": "20150625", "value": 166.080002 },
					{ "name": "IBM", "date": "20150626", "value": 165.460007 },
					{ "name": "IBM", "date": "20150629", "value": 162.970001 },
					{ "name": "IBM", "date": "20150630", "value": 162.660004 },
					{ "name": "IBM", "date": "20150701", "value": 164.490005 },
					{ "name": "IBM", "date": "20150702", "value": 165.089996 },
					{ "name": "IBM", "date": "20150706", "value": 164.729996 },
					{ "name": "IBM", "date": "20150707", "value": 165 },
					{ "name": "IBM", "date": "20150708", "value": 163.160004 },
					{ "name": "IBM", "date": "20150709", "value": 163.850006 },
					{ "name": "IBM", "date": "20150710", "value": 166.949997 },
					{ "name": "IBM", "date": "20150713", "value": 169.380005 },
					{ "name": "IBM", "date": "20150714", "value": 168.610001 },
					{ "name": "IBM", "date": "20150715", "value": 168.529999 },
					{ "name": "IBM", "date": "20150716", "value": 171 },
					{ "name": "IBM", "date": "20150717", "value": 172.509995 },
					{ "name": "IBM", "date": "20150720", "value": 173.220001 },
					{ "name": "IBM", "date": "20150721", "value": 163.070007 },
					{ "name": "IBM", "date": "20150722", "value": 160.350006 },
					{ "name": "IBM", "date": "20150723", "value": 161.729996 },
					{ "name": "IBM", "date": "20150724", "value": 159.75 },
					{ "name": "IBM", "date": "20150727", "value": 159.070007 },
					{ "name": "IBM", "date": "20150728", "value": 160.050003 },
					{ "name": "IBM", "date": "20150729", "value": 161.089996 },
					{ "name": "IBM", "date": "20150730", "value": 160.960007 },
					{ "name": "IBM", "date": "20150731", "value": 161.990005 },
					{ "name": "IBM", "date": "20150803", "value": 158.710007 },
					{ "name": "IBM", "date": "20150804", "value": 157.600006 },
					{ "name": "IBM", "date": "20150805", "value": 157.899994 },
					{ "name": "IBM", "date": "20150806", "value": 156.320007 },
					{ "name": "IBM", "date": "20150807", "value": 155.119995 },
					{ "name": "IBM", "date": "20150810", "value": 156.75 },
					{ "name": "IBM", "date": "20150811", "value": 155.509995 },
					{ "name": "IBM", "date": "20150812", "value": 156.160004 },
					{ "name": "IBM", "date": "20150813", "value": 155.070007 },
					{ "name": "IBM", "date": "20150814", "value": 155.75 },
					{ "name": "IBM", "date": "20150817", "value": 156.309998 },
					{ "name": "IBM", "date": "20150818", "value": 156.009995 },
					{ "name": "IBM", "date": "20150819", "value": 153.940002 },
					{ "name": "IBM", "date": "20150820", "value": 152.660004 },
					{ "name": "IBM", "date": "20150821", "value": 148.850006 },
					{ "name": "IBM", "date": "20150824", "value": 143.470001 },
					{ "name": "IBM", "date": "20150825", "value": 140.960007 },
					{ "name": "IBM", "date": "20150826", "value": 146.699997 },
					{ "name": "IBM", "date": "20150827", "value": 148.539993 },
					{ "name": "IBM", "date": "20150828", "value": 147.979996 },
					{ "name": "IBM", "date": "20150831", "value": 147.889999 },
					{ "name": "IBM", "date": "20150901", "value": 142.679993 },
					{ "name": "IBM", "date": "20150902", "value": 145.050003 },
					{ "name": "IBM", "date": "20150903", "value": 146.779999 },
					{ "name": "IBM", "date": "20150904", "value": 143.699997 },
					{ "name": "IBM", "date": "20150908", "value": 147.229996 },
					{ "name": "IBM", "date": "20150909", "value": 145.050003 },
					{ "name": "IBM", "date": "20150910", "value": 146.199997 },
					{ "name": "IBM", "date": "20150911", "value": 147.369995 },
					{ "name": "IBM", "date": "20150914", "value": 145.649994 },
					{ "name": "IBM", "date": "20150915", "value": 147.529999 },
					{ "name": "IBM", "date": "20150916", "value": 148.410004 },
					{ "name": "IBM", "date": "20150917", "value": 148.139999 },
					{ "name": "IBM", "date": "20150918", "value": 144.509995 },
					{ "name": "IBM", "date": "20150921", "value": 146.479996 },
					{ "name": "IBM", "date": "20150922", "value": 144.429993 },
					{ "name": "IBM", "date": "20150923", "value": 143.660004 },
					{ "name": "IBM", "date": "20150924", "value": 144.410004 },
					{ "name": "IBM", "date": "20150925", "value": 145.419998 },
					{ "name": "IBM", "date": "20150928", "value": 142.520004 },
					{ "name": "IBM", "date": "20150929", "value": 142.470001 },
					{ "name": "IBM", "date": "20150930", "value": 144.970001 },
					{ "name": "IBM", "date": "20151001", "value": 143.589996 },
					{ "name": "IBM", "date": "20151002", "value": 144.580002 },
					{ "name": "IBM", "date": "20151005", "value": 149.039993 },
					{ "name": "IBM", "date": "20151006", "value": 148.779999 },
					{ "name": "IBM", "date": "20151007", "value": 150.089996 },
					{ "name": "IBM", "date": "20151008", "value": 152.279999 },
					{ "name": "IBM", "date": "20151009", "value": 152.389999 },
					{ "name": "IBM", "date": "20151012", "value": 151.139999 },
					{ "name": "IBM", "date": "20151013", "value": 149.619995 },
					{ "name": "IBM", "date": "20151014", "value": 150.009995 },
					{ "name": "IBM", "date": "20151015", "value": 150.089996 },
					{ "name": "IBM", "date": "20151016", "value": 150.389999 },
					{ "name": "IBM", "date": "20151019", "value": 149.220001 },
					{ "name": "IBM", "date": "20151020", "value": 140.639999 },
					{ "name": "IBM", "date": "20151021", "value": 140.919998 },
					{ "name": "IBM", "date": "20151022", "value": 144.089996 },
					{ "name": "IBM", "date": "20151023", "value": 144.679993 },
					{ "name": "IBM", "date": "20151026", "value": 143.660004 },
					{ "name": "IBM", "date": "20151027", "value": 137.860001 },
					{ "name": "IBM", "date": "20151028", "value": 140.830002 },
					{ "name": "IBM", "date": "20151029", "value": 140.550003 },
					{ "name": "IBM", "date": "20151030", "value": 140.080002 },
					{ "name": "IBM", "date": "20151102", "value": 140.369995 },
					{ "name": "IBM", "date": "20151103", "value": 141.880005 },
					{ "name": "IBM", "date": "20151104", "value": 141.630005 },
					{ "name": "IBM", "date": "20151105", "value": 139.889999 },
					{ "name": "IBM", "date": "20151106", "value": 138.25 },
					{ "name": "IBM", "date": "20151109", "value": 135.309998 },
					{ "name": "IBM", "date": "20151110", "value": 135.470001 },
					{ "name": "IBM", "date": "20151111", "value": 135.020004 },
					{ "name": "IBM", "date": "20151112", "value": 133.039993 },
					{ "name": "IBM", "date": "20151113", "value": 131.75 },
					{ "name": "IBM", "date": "20151116", "value": 133.710007 },
					{ "name": "IBM", "date": "20151117", "value": 133.820007 },
					{ "name": "IBM", "date": "20151118", "value": 135.820007 },
					{ "name": "IBM", "date": "20151119", "value": 136.740005 },
					{ "name": "IBM", "date": "20151120", "value": 138.5 },
					{ "name": "IBM", "date": "20151123", "value": 138.460007 },
					{ "name": "IBM", "date": "20151124", "value": 138.600006 },
					{ "name": "IBM", "date": "20151125", "value": 138 },
					{ "name": "IBM", "date": "20151127", "value": 138.460007 },
					{ "name": "IBM", "date": "20151130", "value": 139.419998 },
					{ "name": "IBM", "date": "20151201", "value": 141.279999 },
					{ "name": "IBM", "date": "20151202", "value": 139.699997 },
					{ "name": "IBM", "date": "20151203", "value": 138.919998 },
					{ "name": "IBM", "date": "20151204", "value": 140.429993 },
					{ "name": "IBM", "date": "20151207", "value": 139.550003 },
					{ "name": "IBM", "date": "20151208", "value": 138.050003 },
					{ "name": "IBM", "date": "20151209", "value": 136.610001 },
					{ "name": "IBM", "date": "20151210", "value": 136.779999 },
					{ "name": "IBM", "date": "20151211", "value": 134.570007 },
					{ "name": "IBM", "date": "20151214", "value": 135.929993 },
					{ "name": "IBM", "date": "20151215", "value": 137.789993 },
					{ "name": "IBM", "date": "20151216", "value": 139.289993 },
					{ "name": "IBM", "date": "20151217", "value": 136.75 },
					{ "name": "IBM", "date": "20151218", "value": 134.899994 },
					{ "name": "IBM", "date": "20151221", "value": 135.5 },
					{ "name": "IBM", "date": "20151222", "value": 137.929993 },
					{ "name": "IBM", "date": "20151223", "value": 138.539993 },
					{ "name": "IBM", "date": "20151224", "value": 138.25 },
					{ "name": "IBM", "date": "20151228", "value": 137.610001 },
					{ "name": "IBM", "date": "20151229", "value": 139.779999 },
					{ "name": "IBM", "date": "20151230", "value": 139.339996 },
					{ "name": "IBM", "date": "20151231", "value": 137.619995 },
					{ "name": "IBM", "date": "20160104", "value": 135.949997 },
					{ "name": "IBM", "date": "20160105", "value": 135.850006 },
					{ "name": "IBM", "date": "20160106", "value": 135.169998 },
					{ "name": "IBM", "date": "20160107", "value": 132.860001 },
					{ "name": "IBM", "date": "20160108", "value": 131.630005 },
					{ "name": "IBM", "date": "20160111", "value": 133.229996 },
					{ "name": "IBM", "date": "20160112", "value": 132.899994 },
					{ "name": "IBM", "date": "20160113", "value": 131.169998 },
					{ "name": "IBM", "date": "20160114", "value": 132.910004 },
					{ "name": "IBM", "date": "20160115", "value": 130.029999 },
					{ "name": "IBM", "date": "20160119", "value": 128.110001 },
					{ "name": "IBM", "date": "20160120", "value": 121.860001 },
					{ "name": "IBM", "date": "20160121", "value": 122.910004 },
					{ "name": "IBM", "date": "20160122", "value": 122.5 },
					{ "name": "IBM", "date": "20160125", "value": 122.080002 },
					{ "name": "IBM", "date": "20160126", "value": 122.589996 },
					{ "name": "IBM", "date": "20160127", "value": 120.959999 },
					{ "name": "IBM", "date": "20160128", "value": 122.220001 },
					{ "name": "IBM", "date": "20160129", "value": 124.790001 },
					{ "name": "IBM", "date": "20160201", "value": 124.830002 },
					{ "name": "IBM", "date": "20160202", "value": 122.940002 },
					{ "name": "IBM", "date": "20160203", "value": 124.720001 },
					{ "name": "IBM", "date": "20160204", "value": 127.650002 },
					{ "name": "IBM", "date": "20160205", "value": 128.570007 },
					{ "name": "IBM", "date": "20160208", "value": 126.980003 },
					{ "name": "IBM", "date": "20160209", "value": 124.07 },
					{ "name": "IBM", "date": "20160210", "value": 120.190002 },
					{ "name": "IBM", "date": "20160211", "value": 117.849998 },
					{ "name": "IBM", "date": "20160212", "value": 121.040001 },
					{ "name": "IBM", "date": "20160216", "value": 122.739998 },
					{ "name": "IBM", "date": "20160217", "value": 126.099998 },
					{ "name": "IBM", "date": "20160218", "value": 132.449997 },
					{ "name": "IBM", "date": "20160219", "value": 133.080002 },
					{ "name": "IBM", "date": "20160222", "value": 133.770004 },
					{ "name": "IBM", "date": "20160223", "value": 132.399994 },
					{ "name": "IBM", "date": "20160224", "value": 132.800003 },
					{ "name": "IBM", "date": "20160225", "value": 134.5 },
					{ "name": "IBM", "date": "20160226", "value": 132.029999 },
					{ "name": "IBM", "date": "20160229", "value": 131.029999 },
					{ "name": "IBM", "date": "20160301", "value": 134.369995 },
					{ "name": "IBM", "date": "20160302", "value": 136.300003 },
					{ "name": "IBM", "date": "20160303", "value": 137.800003 },
					{ "name": "IBM", "date": "20160304", "value": 137.800003 },
					{ "name": "IBM", "date": "20160307", "value": 140.149994 },
					{ "name": "IBM", "date": "20160308", "value": 139.070007 },
					{ "name": "IBM", "date": "20160309", "value": 140.410004 },
					{ "name": "IBM", "date": "20160310", "value": 140.190002 },
					{ "name": "IBM", "date": "20160311", "value": 142.360001 },
					{ "name": "IBM", "date": "20160314", "value": 142.779999 },
					{ "name": "IBM", "date": "20160315", "value": 142.960007 },
					{ "name": "IBM", "date": "20160316", "value": 144.789993 },
					{ "name": "IBM", "date": "20160317", "value": 147.039993 },
					{ "name": "IBM", "date": "20160318", "value": 147.089996 },
					{ "name": "IBM", "date": "20160321", "value": 148.630005 },
					{ "name": "IBM", "date": "20160322", "value": 148.100006 },
					{ "name": "IBM", "date": "20160323", "value": 145.399994 },
					{ "name": "IBM", "date": "20160324", "value": 147.949997 },
					{ "name": "IBM", "date": "20160328", "value": 148.399994 },
					{ "name": "IBM", "date": "20160329", "value": 149.330002 },
					{ "name": "IBM", "date": "20160330", "value": 148.410004 },
					{ "name": "IBM", "date": "20160331", "value": 151.449997 },
					{ "name": "IBM", "date": "20160401", "value": 152.520004 },
					{ "name": "IBM", "date": "20160404", "value": 152.070007 },
					{ "name": "IBM", "date": "20160405", "value": 150 },
					{ "name": "IBM", "date": "20160406", "value": 150.020004 },
					{ "name": "IBM", "date": "20160407", "value": 148.25 },
					{ "name": "IBM", "date": "20160408", "value": 149.350006 },
					{ "name": "IBM", "date": "20160411", "value": 149.25 },
					{ "name": "IBM", "date": "20160412", "value": 149.630005 },
					{ "name": "IBM", "date": "20160413", "value": 151.229996 },
					{ "name": "IBM", "date": "20160414", "value": 151.160004 },
					{ "name": "IBM", "date": "20160415", "value": 151.720001 },
					{ "name": "IBM", "date": "20160418", "value": 152.529999 },
					{ "name": "IBM", "date": "20160419", "value": 144 },
					{ "name": "IBM", "date": "20160420", "value": 146.110001 },
					{ "name": "IBM", "date": "20160421", "value": 149.300003 },
					{ "name": "IBM", "date": "20160422", "value": 148.5 },
					{ "name": "IBM", "date": "20160425", "value": 148.809998 },
					{ "name": "IBM", "date": "20160426", "value": 149.080002 },
					{ "name": "IBM", "date": "20160427", "value": 150.470001 },
					{ "name": "IBM", "date": "20160428", "value": 147.070007 },
					{ "name": "IBM", "date": "20160429", "value": 145.940002 },
					{ "name": "IBM", "date": "20160502", "value": 145.270004 },
					{ "name": "IBM", "date": "20160503", "value": 144.130005 },
					{ "name": "IBM", "date": "20160504", "value": 144.25 },
					{ "name": "IBM", "date": "20160505", "value": 146.470001 },
					{ "name": "IBM", "date": "20160506", "value": 147.289993 },
					{ "name": "IBM", "date": "20160509", "value": 147.339996 },
					{ "name": "IBM", "date": "20160510", "value": 149.970001 },
					{ "name": "IBM", "date": "20160511", "value": 148.949997 },
					{ "name": "IBM", "date": "20160512", "value": 148.839996 },
					{ "name": "IBM", "date": "20160513", "value": 147.720001 },
					{ "name": "IBM", "date": "20160516", "value": 149.460007 },
					{ "name": "IBM", "date": "20160517", "value": 148 },
					{ "name": "IBM", "date": "20160518", "value": 147.339996 },
					{ "name": "IBM", "date": "20160519", "value": 144.929993 },
					{ "name": "IBM", "date": "20160520", "value": 147.25 },
					{ "name": "IBM", "date": "20160523", "value": 146.770004 },
					{ "name": "IBM", "date": "20160524", "value": 148.309998 },
					{ "name": "IBM", "date": "20160525", "value": 151.690002 },
					{ "name": "IBM", "date": "20160526", "value": 152.440002 },
					{ "name": "IBM", "date": "20160527", "value": 152.839996 },
					{ "name": "IBM", "date": "20160531", "value": 153.740005 },
					{ "name": "IBM", "date": "20160601", "value": 152.509995 },
					{ "name": "IBM", "date": "20160602", "value": 153.5 },
					{ "name": "IBM", "date": "20160603", "value": 152.889999 },
					{ "name": "IBM", "date": "20160606", "value": 152.729996 },
					{ "name": "IBM", "date": "20160607", "value": 153.330002 },
					{ "name": "IBM", "date": "20160608", "value": 154 },
					{ "name": "IBM", "date": "20160609", "value": 153.419998 },
					{ "name": "IBM", "date": "20160610", "value": 152.369995 },
					{ "name": "IBM", "date": "20160613", "value": 151.279999 },
					{ "name": "IBM", "date": "20160614", "value": 151.059998 },
					{ "name": "IBM", "date": "20160615", "value": 150.679993 },
					{ "name": "IBM", "date": "20160616", "value": 151.059998 },
					{ "name": "IBM", "date": "20160617", "value": 151.990005 },
					{ "name": "IBM", "date": "20160620", "value": 153.610001 },
					{ "name": "IBM", "date": "20160621", "value": 154.050003 },
					{ "name": "IBM", "date": "20160622", "value": 152.919998 },
					{ "name": "IBM", "date": "20160623", "value": 155.350006 },
					{ "name": "IBM", "date": "20160624", "value": 146.589996 },
					{ "name": "IBM", "date": "20160627", "value": 143.5 },
					{ "name": "IBM", "date": "20160628", "value": 145.699997 },
					{ "name": "IBM", "date": "20160629", "value": 148.460007 },
					{ "name": "IBM", "date": "20160630", "value": 151.779999 },
					{ "name": "IBM", "date": "20160701", "value": 152.350006 },
					{ "name": "IBM", "date": "20160705", "value": 151.679993 },
					{ "name": "IBM", "date": "20160706", "value": 152.369995 },
					{ "name": "IBM", "date": "20160707", "value": 152.600006 },
					{ "name": "IBM", "date": "20160708", "value": 154.460007 },
					{ "name": "IBM", "date": "20160711", "value": 155.330002 },
					{ "name": "IBM", "date": "20160712", "value": 157.039993 },
					{ "name": "IBM", "date": "20160713", "value": 158.020004 },
					{ "name": "IBM", "date": "20160714", "value": 160.279999 },
					{ "name": "IBM", "date": "20160715", "value": 159.779999 },
					{ "name": "IBM", "date": "20160718", "value": 159.860001 },
					{ "name": "IBM", "date": "20160719", "value": 159.580002 },
					{ "name": "IBM", "date": "20160720", "value": 161.360001 },
					{ "name": "IBM", "date": "20160721", "value": 160.449997 },
					{ "name": "IBM", "date": "20160722", "value": 162.070007 },
					{ "name": "IBM", "date": "20160725", "value": 162.649994 },
					{ "name": "IBM", "date": "20160726", "value": 162.119995 },
					{ "name": "IBM", "date": "20160727", "value": 161.830002 },
					{ "name": "IBM", "date": "20160728", "value": 161.369995 },
					{ "name": "IBM", "date": "20160729", "value": 160.619995 },
					{ "name": "IBM", "date": "20160801", "value": 161.449997 },
					{ "name": "IBM", "date": "20160802", "value": 160.580002 },
					{ "name": "IBM", "date": "20160803", "value": 160.669998 },
					{ "name": "IBM", "date": "20160804", "value": 161.550003 },
					{ "name": "IBM", "date": "20160805", "value": 163.5 },
					{ "name": "IBM", "date": "20160808", "value": 162.039993 },
					{ "name": "IBM", "date": "20160809", "value": 161.770004 },
					{ "name": "IBM", "date": "20160810", "value": 162.080002 },
					{ "name": "IBM", "date": "20160811", "value": 163.529999 },
					{ "name": "IBM", "date": "20160812", "value": 161.949997 },
					{ "name": "IBM", "date": "20160815", "value": 161.880005 },
					{ "name": "IBM", "date": "20160816", "value": 160.699997 },
					{ "name": "IBM", "date": "20160817", "value": 160.440002 },
					{ "name": "IBM", "date": "20160818", "value": 161.360001 },
					{ "name": "IBM", "date": "20160819", "value": 160.039993 },
					{ "name": "IBM", "date": "20160822", "value": 160 },
					{ "name": "IBM", "date": "20160823", "value": 160.259995 },
					{ "name": "IBM", "date": "20160824", "value": 159.050003 },
					{ "name": "IBM", "date": "20160825", "value": 158.630005 },
					{ "name": "IBM", "date": "20160826", "value": 158.320007 },
					{ "name": "IBM", "date": "20160829", "value": 159.720001 },
					{ "name": "IBM", "date": "20160830", "value": 159.399994 },
					{ "name": "IBM", "date": "20160831", "value": 158.880005 },
					{ "name": "IBM", "date": "20160901", "value": 159.539993 },
					{ "name": "IBM", "date": "20160902", "value": 159.550003 },
					{ "name": "IBM", "date": "20160906", "value": 160.350006 },
					{ "name": "IBM", "date": "20160907", "value": 161.639999 },
					{ "name": "IBM", "date": "20160908", "value": 159 },
					{ "name": "IBM", "date": "20160909", "value": 155.690002 },
					{ "name": "IBM", "date": "20160912", "value": 158.289993 },
					{ "name": "IBM", "date": "20160913", "value": 155.809998 },
					{ "name": "IBM", "date": "20160914", "value": 154.050003 },
					{ "name": "IBM", "date": "20160915", "value": 155.660004 },
					{ "name": "IBM", "date": "20160916", "value": 153.839996 },
					{ "name": "IBM", "date": "20160919", "value": 154.869995 },
					{ "name": "IBM", "date": "20160920", "value": 154.449997 },
					{ "name": "IBM", "date": "20160921", "value": 155.529999 },
					{ "name": "IBM", "date": "20160922", "value": 156.110001 },
					{ "name": "IBM", "date": "20160923", "value": 154.979996 },
					{ "name": "IBM", "date": "20160926", "value": 153.979996 },
					{ "name": "IBM", "date": "20160927", "value": 156.770004 },
					{ "name": "IBM", "date": "20160928", "value": 158.289993 },
					{ "name": "IBM", "date": "20160929", "value": 158.110001 },
					{ "name": "IBM", "date": "20160930", "value": 158.850006 },
					{ "name": "IBM", "date": "20161003", "value": 157.610001 },
					{ "name": "IBM", "date": "20161004", "value": 156.460007 },
					{ "name": "IBM", "date": "20161005", "value": 157.080002 },
					{ "name": "IBM", "date": "20161006", "value": 156.880005 },
					{ "name": "IBM", "date": "20161007", "value": 155.669998 },
					{ "name": "IBM", "date": "20161010", "value": 157.020004 },
					{ "name": "IBM", "date": "20161011", "value": 154.789993 },
					{ "name": "IBM", "date": "20161012", "value": 154.289993 },
					{ "name": "IBM", "date": "20161013", "value": 153.720001 },
					{ "name": "IBM", "date": "20161014", "value": 154.449997 },
					{ "name": "IBM", "date": "20161017", "value": 154.770004 },
					{ "name": "IBM", "date": "20161018", "value": 150.720001 },
					{ "name": "IBM", "date": "20161019", "value": 151.259995 },
					{ "name": "IBM", "date": "20161020", "value": 151.520004 },
					{ "name": "IBM", "date": "20161021", "value": 149.630005 },
					{ "name": "IBM", "date": "20161024", "value": 150.570007 },
					{ "name": "IBM", "date": "20161025", "value": 150.880005 },
					{ "name": "IBM", "date": "20161026", "value": 151.809998 },
					{ "name": "IBM", "date": "20161027", "value": 153.350006 },
					{ "name": "IBM", "date": "20161028", "value": 152.610001 },
					{ "name": "IBM", "date": "20161031", "value": 153.690002 },
					{ "name": "IBM", "date": "20161101", "value": 152.789993 },
					{ "name": "IBM", "date": "20161102", "value": 151.949997 },
					{ "name": "IBM", "date": "20161103", "value": 152.369995 },
					{ "name": "IBM", "date": "20161104", "value": 152.429993 },
					{ "name": "IBM", "date": "20161107", "value": 155.720001 },
					{ "name": "IBM", "date": "20161108", "value": 155.169998 },
					{ "name": "IBM", "date": "20161109", "value": 154.809998 },
					{ "name": "IBM", "date": "20161110", "value": 160.220001 },
					{ "name": "IBM", "date": "20161111", "value": 161.270004 },
					{ "name": "IBM", "date": "20161114", "value": 158.210007 },
					{ "name": "IBM", "date": "20161115", "value": 158.669998 },
					{ "name": "IBM", "date": "20161116", "value": 159.289993 },
					{ "name": "IBM", "date": "20161117", "value": 159.800003 },
					{ "name": "IBM", "date": "20161118", "value": 160.389999 },
					{ "name": "IBM", "date": "20161121", "value": 162.770004 },
					{ "name": "IBM", "date": "20161122", "value": 162.669998 },
					{ "name": "IBM", "date": "20161123", "value": 161.979996 },
					{ "name": "IBM", "date": "20161125", "value": 163.139999 },
					{ "name": "IBM", "date": "20161128", "value": 164.520004 },
					{ "name": "IBM", "date": "20161129", "value": 163.529999 },
					{ "name": "IBM", "date": "20161130", "value": 162.220001 },
					{ "name": "IBM", "date": "20161201", "value": 159.820007 },
					{ "name": "IBM", "date": "20161202", "value": 160.020004 },
					{ "name": "IBM", "date": "20161205", "value": 159.839996 },
					{ "name": "IBM", "date": "20161206", "value": 160.350006 },
					{ "name": "IBM", "date": "20161207", "value": 164.789993 },
					{ "name": "IBM", "date": "20161208", "value": 165.360001 },
					{ "name": "IBM", "date": "20161209", "value": 166.520004 },
					{ "name": "IBM", "date": "20161212", "value": 165.5 },
					{ "name": "IBM", "date": "20161213", "value": 168.289993 },
					{ "name": "IBM", "date": "20161214", "value": 168.509995 },
					{ "name": "IBM", "date": "20161215", "value": 168.020004 },
					{ "name": "IBM", "date": "20161216", "value": 166.729996 },
					{ "name": "IBM", "date": "20161219", "value": 166.679993 },
					{ "name": "IBM", "date": "20161220", "value": 167.600006 },
					{ "name": "IBM", "date": "20161221", "value": 167.330002 },
					{ "name": "IBM", "date": "20161222", "value": 167.059998 },
					{ "name": "IBM", "date": "20161223", "value": 166.710007 },
					{ "name": "IBM", "date": "20161227", "value": 167.139999 },
					{ "name": "IBM", "date": "20161228", "value": 166.190002 },
					{ "name": "IBM", "date": "20161229", "value": 166.600006 },
					{ "name": "IBM", "date": "20161230", "value": 165.990005 },
					{ "name": "IBM", "date": "20170103", "value": 167.190002 },
					{ "name": "IBM", "date": "20170104", "value": 169.259995 },
					{ "name": "IBM", "date": "20170105", "value": 168.699997 },
					{ "name": "IBM", "date": "20170106", "value": 169.529999 },
					{ "name": "IBM", "date": "20170109", "value": 167.649994 },
					{ "name": "IBM", "date": "20170110", "value": 165.520004 },
					{ "name": "IBM", "date": "20170111", "value": 167.75 },
					{ "name": "IBM", "date": "20170112", "value": 167.949997 },
					{ "name": "IBM", "date": "20170113", "value": 167.339996 },
					{ "name": "IBM", "date": "20170117", "value": 167.889999 },
					{ "name": "IBM", "date": "20170118", "value": 166.800003 },
					{ "name": "IBM", "date": "20170119", "value": 166.809998 },
					{ "name": "IBM", "date": "20170120", "value": 170.550003 },
					{ "name": "IBM", "date": "20170123", "value": 171.029999 },
					{ "name": "IBM", "date": "20170124", "value": 175.899994 },
					{ "name": "IBM", "date": "20170125", "value": 178.289993 },
					{ "name": "IBM", "date": "20170126", "value": 178.660004 },
					{ "name": "IBM", "date": "20170127", "value": 177.300003 },
					{ "name": "IBM", "date": "20170130", "value": 175.800003 },
					{ "name": "IBM", "date": "20170131", "value": 174.520004 },
					{ "name": "IBM", "date": "20170201", "value": 174.289993 },
					{ "name": "IBM", "date": "20170202", "value": 174.580002 },
					{ "name": "IBM", "date": "20170203", "value": 175.820007 },
					{ "name": "IBM", "date": "20170206", "value": 175.860001 },
					{ "name": "IBM", "date": "20170207", "value": 178.460007 },
					{ "name": "IBM", "date": "20170208", "value": 176.169998 },
					{ "name": "IBM", "date": "20170209", "value": 177.210007 },
					{ "name": "IBM", "date": "20170210", "value": 178.679993 },
					{ "name": "IBM", "date": "20170213", "value": 179.360001 },
					{ "name": "IBM", "date": "20170214", "value": 180.130005 },
					{ "name": "IBM", "date": "20170215", "value": 181.679993 },
					{ "name": "IBM", "date": "20170216", "value": 181.429993 },
					{ "name": "IBM", "date": "20170217", "value": 180.669998 },
					{ "name": "IBM", "date": "20170221", "value": 180.259995 },
					{ "name": "IBM", "date": "20170222", "value": 181.149994 },
					{ "name": "IBM", "date": "20170223", "value": 181.649994 },
					{ "name": "IBM", "date": "20170224", "value": 181.350006 },
					{ "name": "IBM", "date": "20170227", "value": 179.399994 },
					{ "name": "IBM", "date": "20170228", "value": 179.820007 },
					{ "name": "IBM", "date": "20170301", "value": 181.949997 },
					{ "name": "IBM", "date": "20170302", "value": 180.529999 },
					{ "name": "IBM", "date": "20170303", "value": 180.050003 },
					{ "name": "IBM", "date": "20170306", "value": 180.470001 },
					{ "name": "IBM", "date": "20170307", "value": 180.380005 },
					{ "name": "IBM", "date": "20170308", "value": 179.449997 },
					{ "name": "IBM", "date": "20170309", "value": 177.179993 },
					{ "name": "IBM", "date": "20170310", "value": 177.830002 },
					{ "name": "IBM", "date": "20170313", "value": 176.460007 },
					{ "name": "IBM", "date": "20170314", "value": 175.720001 },
					{ "name": "IBM", "date": "20170315", "value": 175.809998 },
					{ "name": "IBM", "date": "20170316", "value": 177.240005 },
					{ "name": "IBM", "date": "20170317", "value": 175.649994 },
					{ "name": "IBM", "date": "20170320", "value": 175.699997 },
					{ "name": "IBM", "date": "20170321", "value": 173.880005 },
					{ "name": "IBM", "date": "20170322", "value": 174.779999 },
					{ "name": "IBM", "date": "20170323", "value": 174.820007 },
					{ "name": "IBM", "date": "20170324", "value": 173.830002 },
					{ "name": "IBM", "date": "20170327", "value": 173.770004 },
					{ "name": "IBM", "date": "20170328", "value": 174.509995 },
					{ "name": "IBM", "date": "20170329", "value": 173.940002 },
					{ "name": "IBM", "date": "20170330", "value": 173.860001 },
					{ "name": "IBM", "date": "20170331", "value": 174.139999 },
					{ "name": "IBM", "date": "20170403", "value": 174.5 },
					{ "name": "IBM", "date": "20170404", "value": 174.520004 },
					{ "name": "IBM", "date": "20170405", "value": 172.880005 },
					{ "name": "IBM", "date": "20170406", "value": 172.449997 },
					{ "name": "IBM", "date": "20170407", "value": 172.139999 },
					{ "name": "IBM", "date": "20170410", "value": 171.199997 },
					{ "name": "IBM", "date": "20170411", "value": 170.580002 },
					{ "name": "IBM", "date": "20170412", "value": 170.660004 },
					{ "name": "IBM", "date": "20170413", "value": 169.529999 },
					{ "name": "IBM", "date": "20170417", "value": 171.100006 },
					{ "name": "IBM", "date": "20170418", "value": 170.050003 },
					{ "name": "IBM", "date": "20170419", "value": 161.690002 },
					{ "name": "IBM", "date": "20170420", "value": 162.300003 },
					{ "name": "IBM", "date": "20170421", "value": 160.380005 },
					{ "name": "IBM", "date": "20170424", "value": 160.75 },
					{ "name": "IBM", "date": "20170425", "value": 160.389999 },
					{ "name": "IBM", "date": "20170426", "value": 160.059998 },
					{ "name": "IBM", "date": "20170427", "value": 160.320007 },
					{ "name": "IBM", "date": "20170428", "value": 160.289993 },
					{ "name": "IBM", "date": "20170501", "value": 158.839996 },
					{ "name": "IBM", "date": "20170502", "value": 159.100006 },
					{ "name": "IBM", "date": "20170503", "value": 158.630005 },
					{ "name": "IBM", "date": "20170504", "value": 159.050003 },
					{ "name": "IBM", "date": "20170505", "value": 155.050003 },
					{ "name": "IBM", "date": "20170508", "value": 153.029999 },
					{ "name": "IBM", "date": "20170509", "value": 152.110001 },
					{ "name": "IBM", "date": "20170510", "value": 151.25 },
					{ "name": "IBM", "date": "20170511", "value": 150.649994 },
					{ "name": "IBM", "date": "20170512", "value": 150.369995 },
					{ "name": "IBM", "date": "20170515", "value": 151.509995 },
					{ "name": "IBM", "date": "20170516", "value": 153.679993 },
					{ "name": "IBM", "date": "20170517", "value": 150.929993 },
					{ "name": "IBM", "date": "20170518", "value": 150.779999 },
					{ "name": "IBM", "date": "20170519", "value": 151.979996 },
					{ "name": "IBM", "date": "20170522", "value": 152.639999 },
					{ "name": "IBM", "date": "20170523", "value": 152.029999 },
					{ "name": "IBM", "date": "20170524", "value": 152.509995 },
					{ "name": "IBM", "date": "20170525", "value": 153.199997 },
					{ "name": "IBM", "date": "20170526", "value": 152.490005 },
					{ "name": "IBM", "date": "20170530", "value": 151.729996 },
					{ "name": "IBM", "date": "20170531", "value": 152.630005 },
					{ "name": "IBM", "date": "20170601", "value": 152.669998 },
					{ "name": "IBM", "date": "20170602", "value": 152.050003 },
					{ "name": "IBM", "date": "20170605", "value": 152.410004 },
					{ "name": "IBM", "date": "20170606", "value": 152.369995 },
					{ "name": "IBM", "date": "20170607", "value": 150.979996 },
					{ "name": "IBM", "date": "20170608", "value": 152.100006 },
					{ "name": "IBM", "date": "20170609", "value": 154.100006 },
					{ "name": "IBM", "date": "20170612", "value": 155.179993 },
					{ "name": "IBM", "date": "20170613", "value": 154.25 },
					{ "name": "IBM", "date": "20170614", "value": 153.809998 },
					{ "name": "IBM", "date": "20170615", "value": 154.220001 },
					{ "name": "IBM", "date": "20170616", "value": 155.380005 },
					{ "name": "IBM", "date": "20170619", "value": 154.839996 },
					{ "name": "IBM", "date": "20170620", "value": 154.949997 },
					{ "name": "IBM", "date": "20170621", "value": 153.789993 },
					{ "name": "IBM", "date": "20170622", "value": 154.399994 },
					{ "name": "IBM", "date": "20170623", "value": 154.110001 },
					{ "name": "IBM", "date": "20170626", "value": 155.229996 },
					{ "name": "IBM", "date": "20170627", "value": 154.75 },
					{ "name": "IBM", "date": "20170628", "value": 155.320007 },
					{ "name": "IBM", "date": "20170629", "value": 154.130005 },
					{ "name": "IBM", "date": "20170630", "value": 153.830002 },
					{ "name": "IBM", "date": "20170703", "value": 155.580002 },
					{ "name": "IBM", "date": "20170705", "value": 153.669998 },
					{ "name": "IBM", "date": "20170706", "value": 152.360001 },
					{ "name": "IBM", "date": "20170707", "value": 152.940002 },
					{ "name": "IBM", "date": "20170710", "value": 153.419998 },
					{ "name": "IBM", "date": "20170711", "value": 153.190002 },
					{ "name": "IBM", "date": "20170712", "value": 153.699997 },
					{ "name": "IBM", "date": "20170713", "value": 153.630005 },
					{ "name": "IBM", "date": "20170714", "value": 154.240005 },
					{ "name": "IBM", "date": "20170717", "value": 153.009995 },
					{ "name": "IBM", "date": "20170718", "value": 154 },
					{ "name": "IBM", "date": "20170719", "value": 147.529999 },
					{ "name": "IBM", "date": "20170720", "value": 147.660004 },
					{ "name": "IBM", "date": "20170721", "value": 147.080002 },
					{ "name": "IBM", "date": "20170724", "value": 145.990005 },
					{ "name": "IBM", "date": "20170725", "value": 146.190002 },
					{ "name": "IBM", "date": "20170726", "value": 145.360001 },
					{ "name": "IBM", "date": "20170727", "value": 145.070007 },
					{ "name": "IBM", "date": "20170728", "value": 144.289993 },
					{ "name": "IBM", "date": "20170731", "value": 144.669998 },
					{ "name": "IBM", "date": "20170801", "value": 145.300003 },
					{ "name": "IBM", "date": "20170802", "value": 144.449997 },
					{ "name": "IBM", "date": "20170803", "value": 144.940002 },
					{ "name": "IBM", "date": "20170804", "value": 145.160004 },
					{ "name": "IBM", "date": "20170807", "value": 143.470001 },
					{ "name": "IBM", "date": "20170808", "value": 142.110001 },
					{ "name": "IBM", "date": "20170809", "value": 141.770004 },
					{ "name": "IBM", "date": "20170810", "value": 141.839996 },
					{ "name": "IBM", "date": "20170811", "value": 141.839996 },
					{ "name": "IBM", "date": "20170814", "value": 142.320007 },
					{ "name": "IBM", "date": "20170815", "value": 142.070007 },
					{ "name": "IBM", "date": "20170816", "value": 142.5 },
					{ "name": "IBM", "date": "20170817", "value": 140.699997 },
					{ "name": "IBM", "date": "20170818", "value": 139.699997 },
					{ "name": "IBM", "date": "20170821", "value": 140.330002 },
					{ "name": "IBM", "date": "20170822", "value": 141.009995 },
					{ "name": "IBM", "date": "20170823", "value": 142.139999 },
					{ "name": "IBM", "date": "20170824", "value": 142.940002 },
					{ "name": "IBM", "date": "20170825", "value": 143.740005 },
					{ "name": "IBM", "date": "20170828", "value": 142.509995 },
					{ "name": "IBM", "date": "20170829", "value": 143.139999 },
					{ "name": "IBM", "date": "20170830", "value": 142.559998 },
					{ "name": "IBM", "date": "20170831", "value": 143.029999 },
					{ "name": "IBM", "date": "20170901", "value": 144.080002 },
					{ "name": "IBM", "date": "20170905", "value": 143.039993 },
					{ "name": "IBM", "date": "20170906", "value": 143.820007 },
					{ "name": "IBM", "date": "20170907", "value": 142.899994 },
					{ "name": "IBM", "date": "20170908", "value": 142.449997 },
					{ "name": "IBM", "date": "20170911", "value": 144.860001 },
					{ "name": "IBM", "date": "20170912", "value": 145.759995 },
					{ "name": "IBM", "date": "20170913", "value": 145.990005 },
					{ "name": "IBM", "date": "20170914", "value": 145.539993 },
					{ "name": "IBM", "date": "20170915", "value": 144.820007 },
					{ "name": "IBM", "date": "20170918", "value": 144.550003 },
					{ "name": "IBM", "date": "20170919", "value": 144.389999 },
					{ "name": "IBM", "date": "20170920", "value": 145.880005 },
					{ "name": "IBM", "date": "20170921", "value": 145.259995 },
					{ "name": "IBM", "date": "20170922", "value": 145.130005 },
					{ "name": "IBM", "date": "20170925", "value": 145.869995 },
					{ "name": "IBM", "date": "20170926", "value": 146.559998 },
					{ "name": "IBM", "date": "20170927", "value": 145.660004 },
					{ "name": "IBM", "date": "20170928", "value": 145.660004 },
					{ "name": "IBM", "date": "20170929", "value": 145.080002 },
					{ "name": "IBM", "date": "20171002", "value": 146.660004 },
					{ "name": "IBM", "date": "20171003", "value": 146.779999 },
					{ "name": "IBM", "date": "20171004", "value": 146.479996 },
					{ "name": "IBM", "date": "20171005", "value": 146.720001 },
					{ "name": "IBM", "date": "20171006", "value": 146.479996 },
					{ "name": "IBM", "date": "20171009", "value": 147.389999 },
					{ "name": "IBM", "date": "20171010", "value": 148.5 },
					{ "name": "IBM", "date": "20171011", "value": 147.619995 },
					{ "name": "IBM", "date": "20171012", "value": 147.029999 },
					{ "name": "IBM", "date": "20171013", "value": 147.100006 },
					{ "name": "IBM", "date": "20171016", "value": 146.830002 },
					{ "name": "IBM", "date": "20171017", "value": 146.539993 },
					{ "name": "IBM", "date": "20171018", "value": 159.529999 },
					{ "name": "IBM", "date": "20171019", "value": 160.899994 },
					{ "name": "IBM", "date": "20171020", "value": 162.070007 },
					{ "name": "IBM", "date": "20171023", "value": 159.550003 },
					{ "name": "IBM", "date": "20171024", "value": 155.880005 },
					{ "name": "IBM", "date": "20171025", "value": 153.5 },
					{ "name": "IBM", "date": "20171026", "value": 153.600006 },
					{ "name": "IBM", "date": "20171027", "value": 153.679993 },
					{ "name": "IBM", "date": "20171030", "value": 154.360001 },
					{ "name": "IBM", "date": "20171031", "value": 154.059998 },
					{ "name": "IBM", "date": "20171101", "value": 154.029999 },
					{ "name": "IBM", "date": "20171102", "value": 153.350006 },
					{ "name": "IBM", "date": "20171103", "value": 151.580002 },
					{ "name": "IBM", "date": "20171106", "value": 150.839996 },
					{ "name": "IBM", "date": "20171107", "value": 151.350006 },
					{ "name": "IBM", "date": "20171108", "value": 151.570007 },
					{ "name": "IBM", "date": "20171109", "value": 150.300003 },
					{ "name": "IBM", "date": "20171110", "value": 149.160004 },
					{ "name": "IBM", "date": "20171113", "value": 148.399994 },
					{ "name": "IBM", "date": "20171114", "value": 148.889999 },
					{ "name": "IBM", "date": "20171115", "value": 147.100006 },
					{ "name": "IBM", "date": "20171116", "value": 149.119995 },
					{ "name": "IBM", "date": "20171117", "value": 148.970001 },
					{ "name": "IBM", "date": "20171120", "value": 150.509995 },
					{ "name": "IBM", "date": "20171121", "value": 151.949997 },
					{ "name": "IBM", "date": "20171122", "value": 151.770004 },
					{ "name": "IBM", "date": "20171124", "value": 151.839996 },
					{ "name": "IBM", "date": "20171127", "value": 151.979996 },
					{ "name": "IBM", "date": "20171128", "value": 152.470001 },
					{ "name": "IBM", "date": "20171129", "value": 153.550003 },
					{ "name": "IBM", "date": "20171130", "value": 153.970001 },
					{ "name": "IBM", "date": "20171201", "value": 154.759995 },
					{ "name": "IBM", "date": "20171204", "value": 156.460007 },
					{ "name": "IBM", "date": "20171205", "value": 155.350006 },
					{ "name": "IBM", "date": "20171206", "value": 154.100006 },
					{ "name": "IBM", "date": "20171207", "value": 153.570007 },
					{ "name": "IBM", "date": "20171208", "value": 154.809998 },
					{ "name": "IBM", "date": "20171211", "value": 155.410004 },
					{ "name": "IBM", "date": "20171212", "value": 156.740005 },
					{ "name": "IBM", "date": "20171213", "value": 153.910004 },
					{ "name": "IBM", "date": "20171214", "value": 154 },
					{ "name": "IBM", "date": "20171215", "value": 152.5 },
					{ "name": "IBM", "date": "20171218", "value": 153.330002 },
					{ "name": "IBM", "date": "20171219", "value": 153.229996 },
					{ "name": "IBM", "date": "20171220", "value": 152.949997 },
					{ "name": "IBM", "date": "20171221", "value": 151.5 },
					{ "name": "IBM", "date": "20171222", "value": 152.5 },
					{ "name": "IBM", "date": "20171226", "value": 152.830002 },
					{ "name": "IBM", "date": "20171227", "value": 153.130005 },
					{ "name": "IBM", "date": "20171228", "value": 154.039993 },
					{ "name": "IBM", "date": "20171229", "value": 153.419998 },
					{ "name": "IBM", "date": "20180102", "value": 154.25 },
					{ "name": "IBM", "date": "20180103", "value": 158.490005 },
					{ "name": "IBM", "date": "20180104", "value": 161.699997 },
					{ "name": "IBM", "date": "20180105", "value": 162.490005 },
					{ "name": "IBM", "date": "20180108", "value": 163.470001 },
					{ "name": "IBM", "date": "20180109", "value": 163.830002 },
					{ "name": "IBM", "date": "20180110", "value": 164.179993 },
					{ "name": "IBM", "date": "20180111", "value": 164.199997 },
					{ "name": "IBM", "date": "20180112", "value": 163.139999 },
					{ "name": "IBM", "date": "20180116", "value": 163.850006 },
					{ "name": "IBM", "date": "20180117", "value": 168.649994 },
					{ "name": "IBM", "date": "20180118", "value": 169.119995 },
					{ "name": "IBM", "date": "20180119", "value": 162.369995 },
					{ "name": "IBM", "date": "20180122", "value": 162.600006 },
					{ "name": "IBM", "date": "20180123", "value": 166.25 },
					{ "name": "IBM", "date": "20180124", "value": 165.369995 },
					{ "name": "IBM", "date": "20180125", "value": 165.470001 },
					{ "name": "IBM", "date": "20180126", "value": 167.339996 },
					{ "name": "IBM", "date": "20180129", "value": 166.800003 },
					{ "name": "IBM", "date": "20180130", "value": 163.619995 },
					{ "name": "IBM", "date": "20180131", "value": 163.699997 },
					{ "name": "IBM", "date": "20180201", "value": 162.399994 },
					{ "name": "IBM", "date": "20180202", "value": 159.029999 },
					{ "name": "IBM", "date": "20180205", "value": 152.529999 },
					{ "name": "IBM", "date": "20180206", "value": 155.339996 },
					{ "name": "IBM", "date": "20180207", "value": 153.850006 },
					{ "name": "IBM", "date": "20180208", "value": 147.589996 },
					{ "name": "IBM", "date": "20180209", "value": 149.509995 },
					{ "name": "IBM", "date": "20180212", "value": 151.399994 },
					{ "name": "IBM", "date": "20180213", "value": 150.75 },
					{ "name": "IBM", "date": "20180214", "value": 154.759995 },
					{ "name": "IBM", "date": "20180215", "value": 156.009995 },
					{ "name": "IBM", "date": "20180216", "value": 156.179993 },
					{ "name": "IBM", "date": "20180220", "value": 155.160004 },
					{ "name": "IBM", "date": "20180221", "value": 153.960007 },
					{ "name": "IBM", "date": "20180222", "value": 153.179993 },
					{ "name": "IBM", "date": "20180223", "value": 155.520004 },
					{ "name": "IBM", "date": "20180226", "value": 158.580002 },
					{ "name": "IBM", "date": "20180227", "value": 156.550003 },
					{ "name": "IBM", "date": "20180228", "value": 155.830002 },
					{ "name": "IBM", "date": "20180301", "value": 153.809998 },
					{ "name": "IBM", "date": "20180302", "value": 154.490005 },
					{ "name": "IBM", "date": "20180305", "value": 156.949997 },
					{ "name": "IBM", "date": "20180306", "value": 155.720001 },
					{ "name": "IBM", "date": "20180307", "value": 158.320007 },
					{ "name": "IBM", "date": "20180308", "value": 156.210007 },
					{ "name": "IBM", "date": "20180309", "value": 159.309998 },
					{ "name": "IBM", "date": "20180312", "value": 160.259995 },
					{ "name": "IBM", "date": "20180313", "value": 159.320007 },
					{ "name": "IBM", "date": "20180314", "value": 158.119995 },
					{ "name": "IBM", "date": "20180315", "value": 159.610001 },
					{ "name": "IBM", "date": "20180316", "value": 160.259995 },
					{ "name": "IBM", "date": "20180319", "value": 157.350006 },
					{ "name": "IBM", "date": "20180320", "value": 156.199997 },
					{ "name": "IBM", "date": "20180321", "value": 156.690002 },
					{ "name": "IBM", "date": "20180322", "value": 152.089996 },
					{ "name": "IBM", "date": "20180323", "value": 148.889999 },
					{ "name": "IBM", "date": "20180326", "value": 153.369995 },
					{ "name": "IBM", "date": "20180327", "value": 151.910004 },
					{ "name": "IBM", "date": "20180328", "value": 152.520004 },
					{ "name": "IBM", "date": "20180329", "value": 153.429993 },
					{ "name": "IBM", "date": "20180402", "value": 150.070007 },
					{ "name": "IBM", "date": "20180403", "value": 149.850006 },
					{ "name": "IBM", "date": "20180404", "value": 154.119995 },
					{ "name": "IBM", "date": "20180405", "value": 154.029999 },
					{ "name": "IBM", "date": "20180406", "value": 150.570007 },
					{ "name": "IBM", "date": "20180409", "value": 152.690002 },
					{ "name": "IBM", "date": "20180410", "value": 155.389999 },
					{ "name": "IBM", "date": "20180411", "value": 155.360001 },
					{ "name": "IBM", "date": "20180412", "value": 158.070007 },
					{ "name": "IBM", "date": "20180413", "value": 156.710007 },
					{ "name": "IBM", "date": "20180416", "value": 157.889999 },
					{ "name": "IBM", "date": "20180417", "value": 160.910004 },
					{ "name": "IBM", "date": "20180418", "value": 148.789993 },
					{ "name": "IBM", "date": "20180419", "value": 147.699997 },
					{ "name": "IBM", "date": "20180420", "value": 144.899994 },
					{ "name": "IBM", "date": "20180423", "value": 145.860001 },
					{ "name": "IBM", "date": "20180424", "value": 145.559998 },
					{ "name": "IBM", "date": "20180425", "value": 145.940002 },
					{ "name": "IBM", "date": "20180426", "value": 146.720001 },
					{ "name": "IBM", "date": "20180427", "value": 146.479996 },
					{ "name": "IBM", "date": "20180430", "value": 144.960007 },
					{ "name": "IBM", "date": "20180501", "value": 145 },
					{ "name": "IBM", "date": "20180502", "value": 142.449997 },
					{ "name": "IBM", "date": "20180503", "value": 141.990005 },
					{ "name": "IBM", "date": "20180504", "value": 143.910004 },
					{ "name": "IBM", "date": "20180507", "value": 143.220001 },
					{ "name": "IBM", "date": "20180508", "value": 143 },
					{ "name": "IBM", "date": "20180509", "value": 142.610001 },
					{ "name": "IBM", "date": "20180510", "value": 144.240005 },
					{ "name": "IBM", "date": "20180511", "value": 144.139999 },
					{ "name": "MSFT", "date": "20130513", "value": 33.029999 },
					{ "name": "MSFT", "date": "20130514", "value": 33.529999 },
					{ "name": "MSFT", "date": "20130515", "value": 33.849998 },
					{ "name": "MSFT", "date": "20130516", "value": 34.080002 },
					{ "name": "MSFT", "date": "20130517", "value": 34.869999 },
					{ "name": "MSFT", "date": "20130520", "value": 35.080002 },
					{ "name": "MSFT", "date": "20130521", "value": 34.849998 },
					{ "name": "MSFT", "date": "20130522", "value": 34.610001 },
					{ "name": "MSFT", "date": "20130523", "value": 34.150002 },
					{ "name": "MSFT", "date": "20130524", "value": 34.27 },
					{ "name": "MSFT", "date": "20130528", "value": 35.02 },
					{ "name": "MSFT", "date": "20130529", "value": 34.880001 },
					{ "name": "MSFT", "date": "20130530", "value": 35.029999 },
					{ "name": "MSFT", "date": "20130531", "value": 34.900002 },
					{ "name": "MSFT", "date": "20130603", "value": 35.59 },
					{ "name": "MSFT", "date": "20130604", "value": 34.990002 },
					{ "name": "MSFT", "date": "20130605", "value": 34.779999 },
					{ "name": "MSFT", "date": "20130606", "value": 34.959999 },
					{ "name": "MSFT", "date": "20130607", "value": 35.669998 },
					{ "name": "MSFT", "date": "20130610", "value": 35.470001 },
					{ "name": "MSFT", "date": "20130611", "value": 34.84 },
					{ "name": "MSFT", "date": "20130612", "value": 35 },
					{ "name": "MSFT", "date": "20130613", "value": 34.720001 },
					{ "name": "MSFT", "date": "20130614", "value": 34.400002 },
					{ "name": "MSFT", "date": "20130617", "value": 35 },
					{ "name": "MSFT", "date": "20130618", "value": 34.98 },
					{ "name": "MSFT", "date": "20130619", "value": 34.59 },
					{ "name": "MSFT", "date": "20130620", "value": 33.490002 },
					{ "name": "MSFT", "date": "20130621", "value": 33.27 },
					{ "name": "MSFT", "date": "20130624", "value": 33.720001 },
					{ "name": "MSFT", "date": "20130625", "value": 33.669998 },
					{ "name": "MSFT", "date": "20130626", "value": 34.349998 },
					{ "name": "MSFT", "date": "20130627", "value": 34.619999 },
					{ "name": "MSFT", "date": "20130628", "value": 34.540001 },
					{ "name": "MSFT", "date": "20130701", "value": 34.360001 },
					{ "name": "MSFT", "date": "20130702", "value": 33.939999 },
					{ "name": "MSFT", "date": "20130703", "value": 34.009998 },
					{ "name": "MSFT", "date": "20130705", "value": 34.209999 },
					{ "name": "MSFT", "date": "20130708", "value": 34.330002 },
					{ "name": "MSFT", "date": "20130709", "value": 34.349998 },
					{ "name": "MSFT", "date": "20130710", "value": 34.700001 },
					{ "name": "MSFT", "date": "20130711", "value": 35.689999 },
					{ "name": "MSFT", "date": "20130712", "value": 35.669998 },
					{ "name": "MSFT", "date": "20130715", "value": 36.169998 },
					{ "name": "MSFT", "date": "20130716", "value": 36.27 },
					{ "name": "MSFT", "date": "20130717", "value": 35.740002 },
					{ "name": "MSFT", "date": "20130718", "value": 35.439999 },
					{ "name": "MSFT", "date": "20130719", "value": 31.4 },
					{ "name": "MSFT", "date": "20130722", "value": 32.009998 },
					{ "name": "MSFT", "date": "20130723", "value": 31.82 },
					{ "name": "MSFT", "date": "20130724", "value": 31.959999 },
					{ "name": "MSFT", "date": "20130725", "value": 31.389999 },
					{ "name": "MSFT", "date": "20130726", "value": 31.620001 },
					{ "name": "MSFT", "date": "20130729", "value": 31.540001 },
					{ "name": "MSFT", "date": "20130730", "value": 31.85 },
					{ "name": "MSFT", "date": "20130731", "value": 31.84 },
					{ "name": "MSFT", "date": "20130801", "value": 31.67 },
					{ "name": "MSFT", "date": "20130802", "value": 31.889999 },
					{ "name": "MSFT", "date": "20130805", "value": 31.700001 },
					{ "name": "MSFT", "date": "20130806", "value": 31.58 },
					{ "name": "MSFT", "date": "20130807", "value": 32.060001 },
					{ "name": "MSFT", "date": "20130808", "value": 32.889999 },
					{ "name": "MSFT", "date": "20130809", "value": 32.700001 },
					{ "name": "MSFT", "date": "20130812", "value": 32.869999 },
					{ "name": "MSFT", "date": "20130813", "value": 32.23 },
					{ "name": "MSFT", "date": "20130814", "value": 32.349998 },
					{ "name": "MSFT", "date": "20130815", "value": 31.790001 },
					{ "name": "MSFT", "date": "20130816", "value": 31.799999 },
					{ "name": "MSFT", "date": "20130819", "value": 31.389999 },
					{ "name": "MSFT", "date": "20130820", "value": 31.620001 },
					{ "name": "MSFT", "date": "20130821", "value": 31.610001 },
					{ "name": "MSFT", "date": "20130822", "value": 32.389999 },
					{ "name": "MSFT", "date": "20130823", "value": 34.75 },
					{ "name": "MSFT", "date": "20130826", "value": 34.150002 },
					{ "name": "MSFT", "date": "20130827", "value": 33.259998 },
					{ "name": "MSFT", "date": "20130828", "value": 33.02 },
					{ "name": "MSFT", "date": "20130829", "value": 33.549999 },
					{ "name": "MSFT", "date": "20130830", "value": 33.400002 },
					{ "name": "MSFT", "date": "20130903", "value": 31.879999 },
					{ "name": "MSFT", "date": "20130904", "value": 31.200001 },
					{ "name": "MSFT", "date": "20130905", "value": 31.23 },
					{ "name": "MSFT", "date": "20130906", "value": 31.15 },
					{ "name": "MSFT", "date": "20130909", "value": 31.66 },
					{ "name": "MSFT", "date": "20130910", "value": 32.389999 },
					{ "name": "MSFT", "date": "20130911", "value": 32.740002 },
					{ "name": "MSFT", "date": "20130912", "value": 32.689999 },
					{ "name": "MSFT", "date": "20130913", "value": 33.029999 },
					{ "name": "MSFT", "date": "20130916", "value": 32.799999 },
					{ "name": "MSFT", "date": "20130917", "value": 32.93 },
					{ "name": "MSFT", "date": "20130918", "value": 33.32 },
					{ "name": "MSFT", "date": "20130919", "value": 33.639999 },
					{ "name": "MSFT", "date": "20130920", "value": 32.790001 },
					{ "name": "MSFT", "date": "20130923", "value": 32.740002 },
					{ "name": "MSFT", "date": "20130924", "value": 32.450001 },
					{ "name": "MSFT", "date": "20130925", "value": 32.509998 },
					{ "name": "MSFT", "date": "20130926", "value": 32.77 },
					{ "name": "MSFT", "date": "20130927", "value": 33.27 },
					{ "name": "MSFT", "date": "20130930", "value": 33.279999 },
					{ "name": "MSFT", "date": "20131001", "value": 33.580002 },
					{ "name": "MSFT", "date": "20131002", "value": 33.919998 },
					{ "name": "MSFT", "date": "20131003", "value": 33.860001 },
					{ "name": "MSFT", "date": "20131004", "value": 33.880001 },
					{ "name": "MSFT", "date": "20131007", "value": 33.299999 },
					{ "name": "MSFT", "date": "20131008", "value": 33.009998 },
					{ "name": "MSFT", "date": "20131009", "value": 33.07 },
					{ "name": "MSFT", "date": "20131010", "value": 33.759998 },
					{ "name": "MSFT", "date": "20131011", "value": 34.130001 },
					{ "name": "MSFT", "date": "20131014", "value": 34.450001 },
					{ "name": "MSFT", "date": "20131015", "value": 34.490002 },
					{ "name": "MSFT", "date": "20131016", "value": 34.639999 },
					{ "name": "MSFT", "date": "20131017", "value": 34.919998 },
					{ "name": "MSFT", "date": "20131018", "value": 34.959999 },
					{ "name": "MSFT", "date": "20131021", "value": 34.990002 },
					{ "name": "MSFT", "date": "20131022", "value": 34.580002 },
					{ "name": "MSFT", "date": "20131023", "value": 33.759998 },
					{ "name": "MSFT", "date": "20131024", "value": 33.720001 },
					{ "name": "MSFT", "date": "20131025", "value": 35.73 },
					{ "name": "MSFT", "date": "20131028", "value": 35.57 },
					{ "name": "MSFT", "date": "20131029", "value": 35.52 },
					{ "name": "MSFT", "date": "20131030", "value": 35.540001 },
					{ "name": "MSFT", "date": "20131031", "value": 35.41 },
					{ "name": "MSFT", "date": "20131101", "value": 35.529999 },
					{ "name": "MSFT", "date": "20131104", "value": 35.939999 },
					{ "name": "MSFT", "date": "20131105", "value": 36.639999 },
					{ "name": "MSFT", "date": "20131106", "value": 38.18 },
					{ "name": "MSFT", "date": "20131107", "value": 37.5 },
					{ "name": "MSFT", "date": "20131108", "value": 37.779999 },
					{ "name": "MSFT", "date": "20131111", "value": 37.59 },
					{ "name": "MSFT", "date": "20131112", "value": 37.360001 },
					{ "name": "MSFT", "date": "20131113", "value": 38.16 },
					{ "name": "MSFT", "date": "20131114", "value": 38.02 },
					{ "name": "MSFT", "date": "20131115", "value": 37.84 },
					{ "name": "MSFT", "date": "20131118", "value": 37.200001 },
					{ "name": "MSFT", "date": "20131119", "value": 36.740002 },
					{ "name": "MSFT", "date": "20131120", "value": 37.080002 },
					{ "name": "MSFT", "date": "20131121", "value": 37.400002 },
					{ "name": "MSFT", "date": "20131122", "value": 37.57 },
					{ "name": "MSFT", "date": "20131125", "value": 37.639999 },
					{ "name": "MSFT", "date": "20131126", "value": 37.349998 },
					{ "name": "MSFT", "date": "20131127", "value": 37.599998 },
					{ "name": "MSFT", "date": "20131129", "value": 38.130001 },
					{ "name": "MSFT", "date": "20131202", "value": 38.450001 },
					{ "name": "MSFT", "date": "20131203", "value": 38.310001 },
					{ "name": "MSFT", "date": "20131204", "value": 38.939999 },
					{ "name": "MSFT", "date": "20131205", "value": 38 },
					{ "name": "MSFT", "date": "20131206", "value": 38.360001 },
					{ "name": "MSFT", "date": "20131209", "value": 38.709999 },
					{ "name": "MSFT", "date": "20131210", "value": 38.110001 },
					{ "name": "MSFT", "date": "20131211", "value": 37.610001 },
					{ "name": "MSFT", "date": "20131212", "value": 37.220001 },
					{ "name": "MSFT", "date": "20131213", "value": 36.689999 },
					{ "name": "MSFT", "date": "20131216", "value": 36.889999 },
					{ "name": "MSFT", "date": "20131217", "value": 36.52 },
					{ "name": "MSFT", "date": "20131218", "value": 36.580002 },
					{ "name": "MSFT", "date": "20131219", "value": 36.25 },
					{ "name": "MSFT", "date": "20131220", "value": 36.799999 },
					{ "name": "MSFT", "date": "20131223", "value": 36.619999 },
					{ "name": "MSFT", "date": "20131224", "value": 37.080002 },
					{ "name": "MSFT", "date": "20131226", "value": 37.439999 },
					{ "name": "MSFT", "date": "20131227", "value": 37.290001 },
					{ "name": "MSFT", "date": "20131230", "value": 37.290001 },
					{ "name": "MSFT", "date": "20131231", "value": 37.41 },
					{ "name": "MSFT", "date": "20140102", "value": 37.16 },
					{ "name": "MSFT", "date": "20140103", "value": 36.91 },
					{ "name": "MSFT", "date": "20140106", "value": 36.130001 },
					{ "name": "MSFT", "date": "20140107", "value": 36.41 },
					{ "name": "MSFT", "date": "20140108", "value": 35.759998 },
					{ "name": "MSFT", "date": "20140109", "value": 35.529999 },
					{ "name": "MSFT", "date": "20140110", "value": 36.040001 },
					{ "name": "MSFT", "date": "20140113", "value": 34.98 },
					{ "name": "MSFT", "date": "20140114", "value": 35.779999 },
					{ "name": "MSFT", "date": "20140115", "value": 36.759998 },
					{ "name": "MSFT", "date": "20140116", "value": 36.889999 },
					{ "name": "MSFT", "date": "20140117", "value": 36.380001 },
					{ "name": "MSFT", "date": "20140121", "value": 36.169998 },
					{ "name": "MSFT", "date": "20140122", "value": 35.93 },
					{ "name": "MSFT", "date": "20140123", "value": 36.060001 },
					{ "name": "MSFT", "date": "20140124", "value": 36.810001 },
					{ "name": "MSFT", "date": "20140127", "value": 36.029999 },
					{ "name": "MSFT", "date": "20140128", "value": 36.27 },
					{ "name": "MSFT", "date": "20140129", "value": 36.66 },
					{ "name": "MSFT", "date": "20140130", "value": 36.860001 },
					{ "name": "MSFT", "date": "20140131", "value": 37.84 },
					{ "name": "MSFT", "date": "20140203", "value": 36.48 },
					{ "name": "MSFT", "date": "20140204", "value": 36.349998 },
					{ "name": "MSFT", "date": "20140205", "value": 35.82 },
					{ "name": "MSFT", "date": "20140206", "value": 36.18 },
					{ "name": "MSFT", "date": "20140207", "value": 36.560001 },
					{ "name": "MSFT", "date": "20140210", "value": 36.799999 },
					{ "name": "MSFT", "date": "20140211", "value": 37.169998 },
					{ "name": "MSFT", "date": "20140212", "value": 37.470001 },
					{ "name": "MSFT", "date": "20140213", "value": 37.610001 },
					{ "name": "MSFT", "date": "20140214", "value": 37.619999 },
					{ "name": "MSFT", "date": "20140218", "value": 37.419998 },
					{ "name": "MSFT", "date": "20140219", "value": 37.509998 },
					{ "name": "MSFT", "date": "20140220", "value": 37.75 },
					{ "name": "MSFT", "date": "20140221", "value": 37.98 },
					{ "name": "MSFT", "date": "20140224", "value": 37.689999 },
					{ "name": "MSFT", "date": "20140225", "value": 37.540001 },
					{ "name": "MSFT", "date": "20140226", "value": 37.470001 },
					{ "name": "MSFT", "date": "20140227", "value": 37.860001 },
					{ "name": "MSFT", "date": "20140228", "value": 38.310001 },
					{ "name": "MSFT", "date": "20140303", "value": 37.779999 },
					{ "name": "MSFT", "date": "20140304", "value": 38.41 },
					{ "name": "MSFT", "date": "20140305", "value": 38.110001 },
					{ "name": "MSFT", "date": "20140306", "value": 38.150002 },
					{ "name": "MSFT", "date": "20140307", "value": 37.900002 },
					{ "name": "MSFT", "date": "20140310", "value": 37.82 },
					{ "name": "MSFT", "date": "20140311", "value": 38.02 },
					{ "name": "MSFT", "date": "20140312", "value": 38.27 },
					{ "name": "MSFT", "date": "20140313", "value": 37.889999 },
					{ "name": "MSFT", "date": "20140314", "value": 37.700001 },
					{ "name": "MSFT", "date": "20140317", "value": 38.049999 },
					{ "name": "MSFT", "date": "20140318", "value": 39.549999 },
					{ "name": "MSFT", "date": "20140319", "value": 39.27 },
					{ "name": "MSFT", "date": "20140320", "value": 40.330002 },
					{ "name": "MSFT", "date": "20140321", "value": 40.16 },
					{ "name": "MSFT", "date": "20140324", "value": 40.5 },
					{ "name": "MSFT", "date": "20140325", "value": 40.34 },
					{ "name": "MSFT", "date": "20140326", "value": 39.790001 },
					{ "name": "MSFT", "date": "20140327", "value": 39.360001 },
					{ "name": "MSFT", "date": "20140328", "value": 40.299999 },
					{ "name": "MSFT", "date": "20140331", "value": 40.990002 },
					{ "name": "MSFT", "date": "20140401", "value": 41.419998 },
					{ "name": "MSFT", "date": "20140402", "value": 41.349998 },
					{ "name": "MSFT", "date": "20140403", "value": 41.009998 },
					{ "name": "MSFT", "date": "20140404", "value": 39.869999 },
					{ "name": "MSFT", "date": "20140407", "value": 39.799999 },
					{ "name": "MSFT", "date": "20140408", "value": 39.82 },
					{ "name": "MSFT", "date": "20140409", "value": 40.470001 },
					{ "name": "MSFT", "date": "20140410", "value": 39.360001 },
					{ "name": "MSFT", "date": "20140411", "value": 39.209999 },
					{ "name": "MSFT", "date": "20140414", "value": 39.18 },
					{ "name": "MSFT", "date": "20140415", "value": 39.75 },
					{ "name": "MSFT", "date": "20140416", "value": 40.400002 },
					{ "name": "MSFT", "date": "20140417", "value": 40.009998 },
					{ "name": "MSFT", "date": "20140421", "value": 39.939999 },
					{ "name": "MSFT", "date": "20140422", "value": 39.990002 },
					{ "name": "MSFT", "date": "20140423", "value": 39.689999 },
					{ "name": "MSFT", "date": "20140424", "value": 39.860001 },
					{ "name": "MSFT", "date": "20140425", "value": 39.91 },
					{ "name": "MSFT", "date": "20140428", "value": 40.869999 },
					{ "name": "MSFT", "date": "20140429", "value": 40.509998 },
					{ "name": "MSFT", "date": "20140430", "value": 40.400002 },
					{ "name": "MSFT", "date": "20140501", "value": 40 },
					{ "name": "MSFT", "date": "20140502", "value": 39.689999 },
					{ "name": "MSFT", "date": "20140505", "value": 39.43 },
					{ "name": "MSFT", "date": "20140506", "value": 39.060001 },
					{ "name": "MSFT", "date": "20140507", "value": 39.419998 },
					{ "name": "MSFT", "date": "20140508", "value": 39.639999 },
					{ "name": "MSFT", "date": "20140509", "value": 39.540001 },
					{ "name": "MSFT", "date": "20140512", "value": 39.970001 },
					{ "name": "MSFT", "date": "20140513", "value": 40.419998 },
					{ "name": "MSFT", "date": "20140514", "value": 40.240002 },
					{ "name": "MSFT", "date": "20140515", "value": 39.599998 },
					{ "name": "MSFT", "date": "20140516", "value": 39.830002 },
					{ "name": "MSFT", "date": "20140519", "value": 39.75 },
					{ "name": "MSFT", "date": "20140520", "value": 39.68 },
					{ "name": "MSFT", "date": "20140521", "value": 40.349998 },
					{ "name": "MSFT", "date": "20140522", "value": 40.099998 },
					{ "name": "MSFT", "date": "20140523", "value": 40.119999 },
					{ "name": "MSFT", "date": "20140527", "value": 40.189999 },
					{ "name": "MSFT", "date": "20140528", "value": 40.009998 },
					{ "name": "MSFT", "date": "20140529", "value": 40.34 },
					{ "name": "MSFT", "date": "20140530", "value": 40.939999 },
					{ "name": "MSFT", "date": "20140602", "value": 40.790001 },
					{ "name": "MSFT", "date": "20140603", "value": 40.290001 },
					{ "name": "MSFT", "date": "20140604", "value": 40.32 },
					{ "name": "MSFT", "date": "20140605", "value": 41.209999 },
					{ "name": "MSFT", "date": "20140606", "value": 41.48 },
					{ "name": "MSFT", "date": "20140609", "value": 41.27 },
					{ "name": "MSFT", "date": "20140610", "value": 41.110001 },
					{ "name": "MSFT", "date": "20140611", "value": 40.860001 },
					{ "name": "MSFT", "date": "20140612", "value": 40.580002 },
					{ "name": "MSFT", "date": "20140613", "value": 41.23 },
					{ "name": "MSFT", "date": "20140616", "value": 41.5 },
					{ "name": "MSFT", "date": "20140617", "value": 41.68 },
					{ "name": "MSFT", "date": "20140618", "value": 41.650002 },
					{ "name": "MSFT", "date": "20140619", "value": 41.509998 },
					{ "name": "MSFT", "date": "20140620", "value": 41.68 },
					{ "name": "MSFT", "date": "20140623", "value": 41.990002 },
					{ "name": "MSFT", "date": "20140624", "value": 41.75 },
					{ "name": "MSFT", "date": "20140625", "value": 42.029999 },
					{ "name": "MSFT", "date": "20140626", "value": 41.720001 },
					{ "name": "MSFT", "date": "20140627", "value": 42.25 },
					{ "name": "MSFT", "date": "20140630", "value": 41.700001 },
					{ "name": "MSFT", "date": "20140701", "value": 41.869999 },
					{ "name": "MSFT", "date": "20140702", "value": 41.900002 },
					{ "name": "MSFT", "date": "20140703", "value": 41.799999 },
					{ "name": "MSFT", "date": "20140707", "value": 41.990002 },
					{ "name": "MSFT", "date": "20140708", "value": 41.779999 },
					{ "name": "MSFT", "date": "20140709", "value": 41.669998 },
					{ "name": "MSFT", "date": "20140710", "value": 41.689999 },
					{ "name": "MSFT", "date": "20140711", "value": 42.09 },
					{ "name": "MSFT", "date": "20140714", "value": 42.139999 },
					{ "name": "MSFT", "date": "20140715", "value": 42.450001 },
					{ "name": "MSFT", "date": "20140716", "value": 44.080002 },
					{ "name": "MSFT", "date": "20140717", "value": 44.529999 },
					{ "name": "MSFT", "date": "20140718", "value": 44.689999 },
					{ "name": "MSFT", "date": "20140721", "value": 44.84 },
					{ "name": "MSFT", "date": "20140722", "value": 44.830002 },
					{ "name": "MSFT", "date": "20140723", "value": 44.869999 },
					{ "name": "MSFT", "date": "20140724", "value": 44.400002 },
					{ "name": "MSFT", "date": "20140725", "value": 44.5 },
					{ "name": "MSFT", "date": "20140728", "value": 43.970001 },
					{ "name": "MSFT", "date": "20140729", "value": 43.889999 },
					{ "name": "MSFT", "date": "20140730", "value": 43.580002 },
					{ "name": "MSFT", "date": "20140731", "value": 43.16 },
					{ "name": "MSFT", "date": "20140801", "value": 42.860001 },
					{ "name": "MSFT", "date": "20140804", "value": 43.369999 },
					{ "name": "MSFT", "date": "20140805", "value": 43.080002 },
					{ "name": "MSFT", "date": "20140806", "value": 42.740002 },
					{ "name": "MSFT", "date": "20140807", "value": 43.23 },
					{ "name": "MSFT", "date": "20140808", "value": 43.200001 },
					{ "name": "MSFT", "date": "20140811", "value": 43.200001 },
					{ "name": "MSFT", "date": "20140812", "value": 43.52 },
					{ "name": "MSFT", "date": "20140813", "value": 44.080002 },
					{ "name": "MSFT", "date": "20140814", "value": 44.27 },
					{ "name": "MSFT", "date": "20140815", "value": 44.790001 },
					{ "name": "MSFT", "date": "20140818", "value": 45.110001 },
					{ "name": "MSFT", "date": "20140819", "value": 45.330002 },
					{ "name": "MSFT", "date": "20140820", "value": 44.950001 },
					{ "name": "MSFT", "date": "20140821", "value": 45.220001 },
					{ "name": "MSFT", "date": "20140822", "value": 45.150002 },
					{ "name": "MSFT", "date": "20140825", "value": 45.169998 },
					{ "name": "MSFT", "date": "20140826", "value": 45.009998 },
					{ "name": "MSFT", "date": "20140827", "value": 44.869999 },
					{ "name": "MSFT", "date": "20140828", "value": 44.880001 },
					{ "name": "MSFT", "date": "20140829", "value": 45.43 },
					{ "name": "MSFT", "date": "20140902", "value": 45.09 },
					{ "name": "MSFT", "date": "20140903", "value": 44.959999 },
					{ "name": "MSFT", "date": "20140904", "value": 45.259998 },
					{ "name": "MSFT", "date": "20140905", "value": 45.91 },
					{ "name": "MSFT", "date": "20140908", "value": 46.470001 },
					{ "name": "MSFT", "date": "20140909", "value": 46.759998 },
					{ "name": "MSFT", "date": "20140910", "value": 46.84 },
					{ "name": "MSFT", "date": "20140911", "value": 47 },
					{ "name": "MSFT", "date": "20140912", "value": 46.700001 },
					{ "name": "MSFT", "date": "20140915", "value": 46.240002 },
					{ "name": "MSFT", "date": "20140916", "value": 46.759998 },
					{ "name": "MSFT", "date": "20140917", "value": 46.52 },
					{ "name": "MSFT", "date": "20140918", "value": 46.68 },
					{ "name": "MSFT", "date": "20140919", "value": 47.52 },
					{ "name": "MSFT", "date": "20140922", "value": 47.060001 },
					{ "name": "MSFT", "date": "20140923", "value": 46.560001 },
					{ "name": "MSFT", "date": "20140924", "value": 47.080002 },
					{ "name": "MSFT", "date": "20140925", "value": 46.040001 },
					{ "name": "MSFT", "date": "20140926", "value": 46.41 },
					{ "name": "MSFT", "date": "20140929", "value": 46.439999 },
					{ "name": "MSFT", "date": "20140930", "value": 46.360001 },
					{ "name": "MSFT", "date": "20141001", "value": 45.900002 },
					{ "name": "MSFT", "date": "20141002", "value": 45.759998 },
					{ "name": "MSFT", "date": "20141003", "value": 46.09 },
					{ "name": "MSFT", "date": "20141006", "value": 46.09 },
					{ "name": "MSFT", "date": "20141007", "value": 45.529999 },
					{ "name": "MSFT", "date": "20141008", "value": 46.779999 },
					{ "name": "MSFT", "date": "20141009", "value": 45.849998 },
					{ "name": "MSFT", "date": "20141010", "value": 44.029999 },
					{ "name": "MSFT", "date": "20141013", "value": 43.650002 },
					{ "name": "MSFT", "date": "20141014", "value": 43.73 },
					{ "name": "MSFT", "date": "20141015", "value": 43.220001 },
					{ "name": "MSFT", "date": "20141016", "value": 42.740002 },
					{ "name": "MSFT", "date": "20141017", "value": 43.630001 },
					{ "name": "MSFT", "date": "20141020", "value": 44.080002 },
					{ "name": "MSFT", "date": "20141021", "value": 44.880001 },
					{ "name": "MSFT", "date": "20141022", "value": 44.380001 },
					{ "name": "MSFT", "date": "20141023", "value": 45.02 },
					{ "name": "MSFT", "date": "20141024", "value": 46.130001 },
					{ "name": "MSFT", "date": "20141027", "value": 45.91 },
					{ "name": "MSFT", "date": "20141028", "value": 46.490002 },
					{ "name": "MSFT", "date": "20141029", "value": 46.619999 },
					{ "name": "MSFT", "date": "20141030", "value": 46.049999 },
					{ "name": "MSFT", "date": "20141031", "value": 46.950001 },
					{ "name": "MSFT", "date": "20141103", "value": 47.439999 },
					{ "name": "MSFT", "date": "20141104", "value": 47.57 },
					{ "name": "MSFT", "date": "20141105", "value": 47.860001 },
					{ "name": "MSFT", "date": "20141106", "value": 48.700001 },
					{ "name": "MSFT", "date": "20141107", "value": 48.68 },
					{ "name": "MSFT", "date": "20141110", "value": 48.889999 },
					{ "name": "MSFT", "date": "20141111", "value": 48.869999 },
					{ "name": "MSFT", "date": "20141112", "value": 48.779999 },
					{ "name": "MSFT", "date": "20141113", "value": 49.610001 },
					{ "name": "MSFT", "date": "20141114", "value": 49.580002 },
					{ "name": "MSFT", "date": "20141117", "value": 49.459999 },
					{ "name": "MSFT", "date": "20141118", "value": 48.740002 },
					{ "name": "MSFT", "date": "20141119", "value": 48.220001 },
					{ "name": "MSFT", "date": "20141120", "value": 48.700001 },
					{ "name": "MSFT", "date": "20141121", "value": 47.98 },
					{ "name": "MSFT", "date": "20141124", "value": 47.59 },
					{ "name": "MSFT", "date": "20141125", "value": 47.470001 },
					{ "name": "MSFT", "date": "20141126", "value": 47.75 },
					{ "name": "MSFT", "date": "20141128", "value": 47.810001 },
					{ "name": "MSFT", "date": "20141201", "value": 48.619999 },
					{ "name": "MSFT", "date": "20141202", "value": 48.459999 },
					{ "name": "MSFT", "date": "20141203", "value": 48.080002 },
					{ "name": "MSFT", "date": "20141204", "value": 48.84 },
					{ "name": "MSFT", "date": "20141205", "value": 48.419998 },
					{ "name": "MSFT", "date": "20141208", "value": 47.700001 },
					{ "name": "MSFT", "date": "20141209", "value": 47.59 },
					{ "name": "MSFT", "date": "20141210", "value": 46.900002 },
					{ "name": "MSFT", "date": "20141211", "value": 47.169998 },
					{ "name": "MSFT", "date": "20141212", "value": 46.950001 },
					{ "name": "MSFT", "date": "20141215", "value": 46.669998 },
					{ "name": "MSFT", "date": "20141216", "value": 45.16 },
					{ "name": "MSFT", "date": "20141217", "value": 45.740002 },
					{ "name": "MSFT", "date": "20141218", "value": 47.52 },
					{ "name": "MSFT", "date": "20141219", "value": 47.66 },
					{ "name": "MSFT", "date": "20141222", "value": 47.98 },
					{ "name": "MSFT", "date": "20141223", "value": 48.450001 },
					{ "name": "MSFT", "date": "20141224", "value": 48.139999 },
					{ "name": "MSFT", "date": "20141226", "value": 47.880001 },
					{ "name": "MSFT", "date": "20141229", "value": 47.450001 },
					{ "name": "MSFT", "date": "20141230", "value": 47.02 },
					{ "name": "MSFT", "date": "20141231", "value": 46.450001 },
					{ "name": "MSFT", "date": "20150102", "value": 46.759998 },
					{ "name": "MSFT", "date": "20150105", "value": 46.330002 },
					{ "name": "MSFT", "date": "20150106", "value": 45.650002 },
					{ "name": "MSFT", "date": "20150107", "value": 46.23 },
					{ "name": "MSFT", "date": "20150108", "value": 47.59 },
					{ "name": "MSFT", "date": "20150109", "value": 47.189999 },
					{ "name": "MSFT", "date": "20150112", "value": 46.599998 },
					{ "name": "MSFT", "date": "20150113", "value": 46.360001 },
					{ "name": "MSFT", "date": "20150114", "value": 45.959999 },
					{ "name": "MSFT", "date": "20150115", "value": 45.48 },
					{ "name": "MSFT", "date": "20150116", "value": 46.240002 },
					{ "name": "MSFT", "date": "20150120", "value": 46.389999 },
					{ "name": "MSFT", "date": "20150121", "value": 45.919998 },
					{ "name": "MSFT", "date": "20150122", "value": 47.130001 },
					{ "name": "MSFT", "date": "20150123", "value": 47.18 },
					{ "name": "MSFT", "date": "20150126", "value": 47.009998 },
					{ "name": "MSFT", "date": "20150127", "value": 42.66 },
					{ "name": "MSFT", "date": "20150128", "value": 41.189999 },
					{ "name": "MSFT", "date": "20150129", "value": 42.009998 },
					{ "name": "MSFT", "date": "20150130", "value": 40.400002 },
					{ "name": "MSFT", "date": "20150202", "value": 41.279999 },
					{ "name": "MSFT", "date": "20150203", "value": 41.599998 },
					{ "name": "MSFT", "date": "20150204", "value": 41.84 },
					{ "name": "MSFT", "date": "20150205", "value": 42.450001 },
					{ "name": "MSFT", "date": "20150206", "value": 42.41 },
					{ "name": "MSFT", "date": "20150209", "value": 42.360001 },
					{ "name": "MSFT", "date": "20150210", "value": 42.599998 },
					{ "name": "MSFT", "date": "20150211", "value": 42.380001 },
					{ "name": "MSFT", "date": "20150212", "value": 43.09 },
					{ "name": "MSFT", "date": "20150213", "value": 43.869999 },
					{ "name": "MSFT", "date": "20150217", "value": 43.580002 },
					{ "name": "MSFT", "date": "20150218", "value": 43.529999 },
					{ "name": "MSFT", "date": "20150219", "value": 43.5 },
					{ "name": "MSFT", "date": "20150220", "value": 43.860001 },
					{ "name": "MSFT", "date": "20150223", "value": 44.150002 },
					{ "name": "MSFT", "date": "20150224", "value": 44.09 },
					{ "name": "MSFT", "date": "20150225", "value": 43.990002 },
					{ "name": "MSFT", "date": "20150226", "value": 44.060001 },
					{ "name": "MSFT", "date": "20150227", "value": 43.849998 },
					{ "name": "MSFT", "date": "20150302", "value": 43.880001 },
					{ "name": "MSFT", "date": "20150303", "value": 43.279999 },
					{ "name": "MSFT", "date": "20150304", "value": 43.060001 },
					{ "name": "MSFT", "date": "20150305", "value": 43.110001 },
					{ "name": "MSFT", "date": "20150306", "value": 42.360001 },
					{ "name": "MSFT", "date": "20150309", "value": 42.849998 },
					{ "name": "MSFT", "date": "20150310", "value": 42.029999 },
					{ "name": "MSFT", "date": "20150311", "value": 41.98 },
					{ "name": "MSFT", "date": "20150312", "value": 41.02 },
					{ "name": "MSFT", "date": "20150313", "value": 41.380001 },
					{ "name": "MSFT", "date": "20150316", "value": 41.560001 },
					{ "name": "MSFT", "date": "20150317", "value": 41.700001 },
					{ "name": "MSFT", "date": "20150318", "value": 42.5 },
					{ "name": "MSFT", "date": "20150319", "value": 42.290001 },
					{ "name": "MSFT", "date": "20150320", "value": 42.880001 },
					{ "name": "MSFT", "date": "20150323", "value": 42.860001 },
					{ "name": "MSFT", "date": "20150324", "value": 42.900002 },
					{ "name": "MSFT", "date": "20150325", "value": 41.459999 },
					{ "name": "MSFT", "date": "20150326", "value": 41.209999 },
					{ "name": "MSFT", "date": "20150327", "value": 40.970001 },
					{ "name": "MSFT", "date": "20150330", "value": 40.959999 },
					{ "name": "MSFT", "date": "20150331", "value": 40.66 },
					{ "name": "MSFT", "date": "20150401", "value": 40.720001 },
					{ "name": "MSFT", "date": "20150402", "value": 40.290001 },
					{ "name": "MSFT", "date": "20150406", "value": 41.549999 },
					{ "name": "MSFT", "date": "20150407", "value": 41.529999 },
					{ "name": "MSFT", "date": "20150408", "value": 41.419998 },
					{ "name": "MSFT", "date": "20150409", "value": 41.48 },
					{ "name": "MSFT", "date": "20150410", "value": 41.720001 },
					{ "name": "MSFT", "date": "20150413", "value": 41.759998 },
					{ "name": "MSFT", "date": "20150414", "value": 41.650002 },
					{ "name": "MSFT", "date": "20150415", "value": 42.259998 },
					{ "name": "MSFT", "date": "20150416", "value": 42.16 },
					{ "name": "MSFT", "date": "20150417", "value": 41.619999 },
					{ "name": "MSFT", "date": "20150420", "value": 42.91 },
					{ "name": "MSFT", "date": "20150421", "value": 42.639999 },
					{ "name": "MSFT", "date": "20150422", "value": 42.990002 },
					{ "name": "MSFT", "date": "20150423", "value": 43.34 },
					{ "name": "MSFT", "date": "20150424", "value": 47.869999 },
					{ "name": "MSFT", "date": "20150427", "value": 48.029999 },
					{ "name": "MSFT", "date": "20150428", "value": 49.16 },
					{ "name": "MSFT", "date": "20150429", "value": 49.060001 },
					{ "name": "MSFT", "date": "20150430", "value": 48.639999 },
					{ "name": "MSFT", "date": "20150501", "value": 48.66 },
					{ "name": "MSFT", "date": "20150504", "value": 48.240002 },
					{ "name": "MSFT", "date": "20150505", "value": 47.599998 },
					{ "name": "MSFT", "date": "20150506", "value": 46.279999 },
					{ "name": "MSFT", "date": "20150507", "value": 46.700001 },
					{ "name": "MSFT", "date": "20150508", "value": 47.75 },
					{ "name": "MSFT", "date": "20150511", "value": 47.369999 },
					{ "name": "MSFT", "date": "20150512", "value": 47.349998 },
					{ "name": "MSFT", "date": "20150513", "value": 47.630001 },
					{ "name": "MSFT", "date": "20150514", "value": 48.720001 },
					{ "name": "MSFT", "date": "20150515", "value": 48.299999 },
					{ "name": "MSFT", "date": "20150518", "value": 48.009998 },
					{ "name": "MSFT", "date": "20150519", "value": 47.580002 },
					{ "name": "MSFT", "date": "20150520", "value": 47.580002 },
					{ "name": "MSFT", "date": "20150521", "value": 47.419998 },
					{ "name": "MSFT", "date": "20150522", "value": 46.900002 },
					{ "name": "MSFT", "date": "20150526", "value": 46.59 },
					{ "name": "MSFT", "date": "20150527", "value": 47.610001 },
					{ "name": "MSFT", "date": "20150528", "value": 47.450001 },
					{ "name": "MSFT", "date": "20150529", "value": 46.860001 },
					{ "name": "MSFT", "date": "20150601", "value": 47.23 },
					{ "name": "MSFT", "date": "20150602", "value": 46.919998 },
					{ "name": "MSFT", "date": "20150603", "value": 46.849998 },
					{ "name": "MSFT", "date": "20150604", "value": 46.360001 },
					{ "name": "MSFT", "date": "20150605", "value": 46.139999 },
					{ "name": "MSFT", "date": "20150608", "value": 45.73 },
					{ "name": "MSFT", "date": "20150609", "value": 45.650002 },
					{ "name": "MSFT", "date": "20150610", "value": 46.610001 },
					{ "name": "MSFT", "date": "20150611", "value": 46.439999 },
					{ "name": "MSFT", "date": "20150612", "value": 45.970001 },
					{ "name": "MSFT", "date": "20150615", "value": 45.48 },
					{ "name": "MSFT", "date": "20150616", "value": 45.830002 },
					{ "name": "MSFT", "date": "20150617", "value": 45.970001 },
					{ "name": "MSFT", "date": "20150618", "value": 46.720001 },
					{ "name": "MSFT", "date": "20150619", "value": 46.099998 },
					{ "name": "MSFT", "date": "20150622", "value": 46.23 },
					{ "name": "MSFT", "date": "20150623", "value": 45.91 },
					{ "name": "MSFT", "date": "20150624", "value": 45.639999 },
					{ "name": "MSFT", "date": "20150625", "value": 45.650002 },
					{ "name": "MSFT", "date": "20150626", "value": 45.259998 },
					{ "name": "MSFT", "date": "20150629", "value": 44.369999 },
					{ "name": "MSFT", "date": "20150630", "value": 44.150002 },
					{ "name": "MSFT", "date": "20150701", "value": 44.450001 },
					{ "name": "MSFT", "date": "20150702", "value": 44.400002 },
					{ "name": "MSFT", "date": "20150706", "value": 44.389999 },
					{ "name": "MSFT", "date": "20150707", "value": 44.299999 },
					{ "name": "MSFT", "date": "20150708", "value": 44.240002 },
					{ "name": "MSFT", "date": "20150709", "value": 44.52 },
					{ "name": "MSFT", "date": "20150710", "value": 44.610001 },
					{ "name": "MSFT", "date": "20150713", "value": 45.540001 },
					{ "name": "MSFT", "date": "20150714", "value": 45.619999 },
					{ "name": "MSFT", "date": "20150715", "value": 45.759998 },
					{ "name": "MSFT", "date": "20150716", "value": 46.66 },
					{ "name": "MSFT", "date": "20150717", "value": 46.619999 },
					{ "name": "MSFT", "date": "20150720", "value": 46.919998 },
					{ "name": "MSFT", "date": "20150721", "value": 47.279999 },
					{ "name": "MSFT", "date": "20150722", "value": 45.540001 },
					{ "name": "MSFT", "date": "20150723", "value": 46.110001 },
					{ "name": "MSFT", "date": "20150724", "value": 45.939999 },
					{ "name": "MSFT", "date": "20150727", "value": 45.349998 },
					{ "name": "MSFT", "date": "20150728", "value": 45.34 },
					{ "name": "MSFT", "date": "20150729", "value": 46.290001 },
					{ "name": "MSFT", "date": "20150730", "value": 46.880001 },
					{ "name": "MSFT", "date": "20150731", "value": 46.700001 },
					{ "name": "MSFT", "date": "20150803", "value": 46.810001 },
					{ "name": "MSFT", "date": "20150804", "value": 47.540001 },
					{ "name": "MSFT", "date": "20150805", "value": 47.580002 },
					{ "name": "MSFT", "date": "20150806", "value": 46.619999 },
					{ "name": "MSFT", "date": "20150807", "value": 46.740002 },
					{ "name": "MSFT", "date": "20150810", "value": 47.330002 },
					{ "name": "MSFT", "date": "20150811", "value": 46.41 },
					{ "name": "MSFT", "date": "20150812", "value": 46.740002 },
					{ "name": "MSFT", "date": "20150813", "value": 46.73 },
					{ "name": "MSFT", "date": "20150814", "value": 47 },
					{ "name": "MSFT", "date": "20150817", "value": 47.32 },
					{ "name": "MSFT", "date": "20150818", "value": 47.27 },
					{ "name": "MSFT", "date": "20150819", "value": 46.610001 },
					{ "name": "MSFT", "date": "20150820", "value": 45.66 },
					{ "name": "MSFT", "date": "20150821", "value": 43.07 },
					{ "name": "MSFT", "date": "20150824", "value": 41.68 },
					{ "name": "MSFT", "date": "20150825", "value": 40.470001 },
					{ "name": "MSFT", "date": "20150826", "value": 42.709999 },
					{ "name": "MSFT", "date": "20150827", "value": 43.900002 },
					{ "name": "MSFT", "date": "20150828", "value": 43.93 },
					{ "name": "MSFT", "date": "20150831", "value": 43.52 },
					{ "name": "MSFT", "date": "20150901", "value": 41.82 },
					{ "name": "MSFT", "date": "20150902", "value": 43.360001 },
					{ "name": "MSFT", "date": "20150903", "value": 43.5 },
					{ "name": "MSFT", "date": "20150904", "value": 42.610001 },
					{ "name": "MSFT", "date": "20150908", "value": 43.889999 },
					{ "name": "MSFT", "date": "20150909", "value": 43.07 },
					{ "name": "MSFT", "date": "20150910", "value": 43.290001 },
					{ "name": "MSFT", "date": "20150911", "value": 43.48 },
					{ "name": "MSFT", "date": "20150914", "value": 43.040001 },
					{ "name": "MSFT", "date": "20150915", "value": 43.98 },
					{ "name": "MSFT", "date": "20150916", "value": 44.299999 },
					{ "name": "MSFT", "date": "20150917", "value": 44.25 },
					{ "name": "MSFT", "date": "20150918", "value": 43.48 },
					{ "name": "MSFT", "date": "20150921", "value": 44.110001 },
					{ "name": "MSFT", "date": "20150922", "value": 43.900002 },
					{ "name": "MSFT", "date": "20150923", "value": 43.869999 },
					{ "name": "MSFT", "date": "20150924", "value": 43.91 },
					{ "name": "MSFT", "date": "20150925", "value": 43.939999 },
					{ "name": "MSFT", "date": "20150928", "value": 43.290001 },
					{ "name": "MSFT", "date": "20150929", "value": 43.439999 },
					{ "name": "MSFT", "date": "20150930", "value": 44.259998 },
					{ "name": "MSFT", "date": "20151001", "value": 44.610001 },
					{ "name": "MSFT", "date": "20151002", "value": 45.57 },
					{ "name": "MSFT", "date": "20151005", "value": 46.630001 },
					{ "name": "MSFT", "date": "20151006", "value": 46.75 },
					{ "name": "MSFT", "date": "20151007", "value": 46.799999 },
					{ "name": "MSFT", "date": "20151008", "value": 47.450001 },
					{ "name": "MSFT", "date": "20151009", "value": 47.110001 },
					{ "name": "MSFT", "date": "20151012", "value": 47 },
					{ "name": "MSFT", "date": "20151013", "value": 46.889999 },
					{ "name": "MSFT", "date": "20151014", "value": 46.68 },
					{ "name": "MSFT", "date": "20151015", "value": 47.009998 },
					{ "name": "MSFT", "date": "20151016", "value": 47.509998 },
					{ "name": "MSFT", "date": "20151019", "value": 47.619999 },
					{ "name": "MSFT", "date": "20151020", "value": 47.77 },
					{ "name": "MSFT", "date": "20151021", "value": 47.200001 },
					{ "name": "MSFT", "date": "20151022", "value": 48.029999 },
					{ "name": "MSFT", "date": "20151023", "value": 52.869999 },
					{ "name": "MSFT", "date": "20151026", "value": 54.25 },
					{ "name": "MSFT", "date": "20151027", "value": 53.689999 },
					{ "name": "MSFT", "date": "20151028", "value": 53.98 },
					{ "name": "MSFT", "date": "20151029", "value": 53.360001 },
					{ "name": "MSFT", "date": "20151030", "value": 52.639999 },
					{ "name": "MSFT", "date": "20151102", "value": 53.240002 },
					{ "name": "MSFT", "date": "20151103", "value": 54.150002 },
					{ "name": "MSFT", "date": "20151104", "value": 54.400002 },
					{ "name": "MSFT", "date": "20151105", "value": 54.380001 },
					{ "name": "MSFT", "date": "20151106", "value": 54.919998 },
					{ "name": "MSFT", "date": "20151109", "value": 54.16 },
					{ "name": "MSFT", "date": "20151110", "value": 53.509998 },
					{ "name": "MSFT", "date": "20151111", "value": 53.650002 },
					{ "name": "MSFT", "date": "20151112", "value": 53.32 },
					{ "name": "MSFT", "date": "20151113", "value": 52.84 },
					{ "name": "MSFT", "date": "20151116", "value": 53.77 },
					{ "name": "MSFT", "date": "20151117", "value": 52.970001 },
					{ "name": "MSFT", "date": "20151118", "value": 53.849998 },
					{ "name": "MSFT", "date": "20151119", "value": 53.939999 },
					{ "name": "MSFT", "date": "20151120", "value": 54.189999 },
					{ "name": "MSFT", "date": "20151123", "value": 54.189999 },
					{ "name": "MSFT", "date": "20151124", "value": 54.25 },
					{ "name": "MSFT", "date": "20151125", "value": 53.689999 },
					{ "name": "MSFT", "date": "20151127", "value": 53.93 },
					{ "name": "MSFT", "date": "20151130", "value": 54.349998 },
					{ "name": "MSFT", "date": "20151201", "value": 55.220001 },
					{ "name": "MSFT", "date": "20151202", "value": 55.209999 },
					{ "name": "MSFT", "date": "20151203", "value": 54.200001 },
					{ "name": "MSFT", "date": "20151204", "value": 55.91 },
					{ "name": "MSFT", "date": "20151207", "value": 55.810001 },
					{ "name": "MSFT", "date": "20151208", "value": 55.790001 },
					{ "name": "MSFT", "date": "20151209", "value": 54.98 },
					{ "name": "MSFT", "date": "20151210", "value": 55.27 },
					{ "name": "MSFT", "date": "20151211", "value": 54.060001 },
					{ "name": "MSFT", "date": "20151214", "value": 55.139999 },
					{ "name": "MSFT", "date": "20151215", "value": 55.200001 },
					{ "name": "MSFT", "date": "20151216", "value": 56.130001 },
					{ "name": "MSFT", "date": "20151217", "value": 55.700001 },
					{ "name": "MSFT", "date": "20151218", "value": 54.130001 },
					{ "name": "MSFT", "date": "20151221", "value": 54.830002 },
					{ "name": "MSFT", "date": "20151222", "value": 55.349998 },
					{ "name": "MSFT", "date": "20151223", "value": 55.82 },
					{ "name": "MSFT", "date": "20151224", "value": 55.669998 },
					{ "name": "MSFT", "date": "20151228", "value": 55.950001 },
					{ "name": "MSFT", "date": "20151229", "value": 56.549999 },
					{ "name": "MSFT", "date": "20151230", "value": 56.310001 },
					{ "name": "MSFT", "date": "20151231", "value": 55.48 },
					{ "name": "MSFT", "date": "20160104", "value": 54.799999 },
					{ "name": "MSFT", "date": "20160105", "value": 55.049999 },
					{ "name": "MSFT", "date": "20160106", "value": 54.049999 },
					{ "name": "MSFT", "date": "20160107", "value": 52.169998 },
					{ "name": "MSFT", "date": "20160108", "value": 52.330002 },
					{ "name": "MSFT", "date": "20160111", "value": 52.299999 },
					{ "name": "MSFT", "date": "20160112", "value": 52.779999 },
					{ "name": "MSFT", "date": "20160113", "value": 51.639999 },
					{ "name": "MSFT", "date": "20160114", "value": 53.110001 },
					{ "name": "MSFT", "date": "20160115", "value": 50.990002 },
					{ "name": "MSFT", "date": "20160119", "value": 50.560001 },
					{ "name": "MSFT", "date": "20160120", "value": 50.790001 },
					{ "name": "MSFT", "date": "20160121", "value": 50.48 },
					{ "name": "MSFT", "date": "20160122", "value": 52.290001 },
					{ "name": "MSFT", "date": "20160125", "value": 51.790001 },
					{ "name": "MSFT", "date": "20160126", "value": 52.169998 },
					{ "name": "MSFT", "date": "20160127", "value": 51.220001 },
					{ "name": "MSFT", "date": "20160128", "value": 52.060001 },
					{ "name": "MSFT", "date": "20160129", "value": 55.09 },
					{ "name": "MSFT", "date": "20160201", "value": 54.709999 },
					{ "name": "MSFT", "date": "20160202", "value": 53 },
					{ "name": "MSFT", "date": "20160203", "value": 52.16 },
					{ "name": "MSFT", "date": "20160204", "value": 52 },
					{ "name": "MSFT", "date": "20160205", "value": 50.16 },
					{ "name": "MSFT", "date": "20160208", "value": 49.41 },
					{ "name": "MSFT", "date": "20160209", "value": 49.279999 },
					{ "name": "MSFT", "date": "20160210", "value": 49.709999 },
					{ "name": "MSFT", "date": "20160211", "value": 49.689999 },
					{ "name": "MSFT", "date": "20160212", "value": 50.5 },
					{ "name": "MSFT", "date": "20160216", "value": 51.09 },
					{ "name": "MSFT", "date": "20160217", "value": 52.419998 },
					{ "name": "MSFT", "date": "20160218", "value": 52.189999 },
					{ "name": "MSFT", "date": "20160219", "value": 51.82 },
					{ "name": "MSFT", "date": "20160222", "value": 52.650002 },
					{ "name": "MSFT", "date": "20160223", "value": 51.18 },
					{ "name": "MSFT", "date": "20160224", "value": 51.360001 },
					{ "name": "MSFT", "date": "20160225", "value": 52.099998 },
					{ "name": "MSFT", "date": "20160226", "value": 51.299999 },
					{ "name": "MSFT", "date": "20160229", "value": 50.880001 },
					{ "name": "MSFT", "date": "20160301", "value": 52.580002 },
					{ "name": "MSFT", "date": "20160302", "value": 52.950001 },
					{ "name": "MSFT", "date": "20160303", "value": 52.349998 },
					{ "name": "MSFT", "date": "20160304", "value": 52.029999 },
					{ "name": "MSFT", "date": "20160307", "value": 51.029999 },
					{ "name": "MSFT", "date": "20160308", "value": 51.650002 },
					{ "name": "MSFT", "date": "20160309", "value": 52.84 },
					{ "name": "MSFT", "date": "20160310", "value": 52.049999 },
					{ "name": "MSFT", "date": "20160311", "value": 53.07 },
					{ "name": "MSFT", "date": "20160314", "value": 53.169998 },
					{ "name": "MSFT", "date": "20160315", "value": 53.59 },
					{ "name": "MSFT", "date": "20160316", "value": 54.349998 },
					{ "name": "MSFT", "date": "20160317", "value": 54.66 },
					{ "name": "MSFT", "date": "20160318", "value": 53.490002 },
					{ "name": "MSFT", "date": "20160321", "value": 53.860001 },
					{ "name": "MSFT", "date": "20160322", "value": 54.07 },
					{ "name": "MSFT", "date": "20160323", "value": 53.970001 },
					{ "name": "MSFT", "date": "20160324", "value": 54.209999 },
					{ "name": "MSFT", "date": "20160328", "value": 53.540001 },
					{ "name": "MSFT", "date": "20160329", "value": 54.709999 },
					{ "name": "MSFT", "date": "20160330", "value": 55.049999 },
					{ "name": "MSFT", "date": "20160331", "value": 55.23 },
					{ "name": "MSFT", "date": "20160401", "value": 55.57 },
					{ "name": "MSFT", "date": "20160404", "value": 55.43 },
					{ "name": "MSFT", "date": "20160405", "value": 54.560001 },
					{ "name": "MSFT", "date": "20160406", "value": 55.119999 },
					{ "name": "MSFT", "date": "20160407", "value": 54.459999 },
					{ "name": "MSFT", "date": "20160408", "value": 54.419998 },
					{ "name": "MSFT", "date": "20160411", "value": 54.310001 },
					{ "name": "MSFT", "date": "20160412", "value": 54.650002 },
					{ "name": "MSFT", "date": "20160413", "value": 55.349998 },
					{ "name": "MSFT", "date": "20160414", "value": 55.360001 },
					{ "name": "MSFT", "date": "20160415", "value": 55.650002 },
					{ "name": "MSFT", "date": "20160418", "value": 56.459999 },
					{ "name": "MSFT", "date": "20160419", "value": 56.389999 },
					{ "name": "MSFT", "date": "20160420", "value": 55.59 },
					{ "name": "MSFT", "date": "20160421", "value": 55.779999 },
					{ "name": "MSFT", "date": "20160422", "value": 51.779999 },
					{ "name": "MSFT", "date": "20160425", "value": 52.110001 },
					{ "name": "MSFT", "date": "20160426", "value": 51.439999 },
					{ "name": "MSFT", "date": "20160427", "value": 50.939999 },
					{ "name": "MSFT", "date": "20160428", "value": 49.900002 },
					{ "name": "MSFT", "date": "20160429", "value": 49.869999 },
					{ "name": "MSFT", "date": "20160502", "value": 50.610001 },
					{ "name": "MSFT", "date": "20160503", "value": 49.779999 },
					{ "name": "MSFT", "date": "20160504", "value": 49.869999 },
					{ "name": "MSFT", "date": "20160505", "value": 49.939999 },
					{ "name": "MSFT", "date": "20160506", "value": 50.389999 },
					{ "name": "MSFT", "date": "20160509", "value": 50.07 },
					{ "name": "MSFT", "date": "20160510", "value": 51.02 },
					{ "name": "MSFT", "date": "20160511", "value": 51.049999 },
					{ "name": "MSFT", "date": "20160512", "value": 51.509998 },
					{ "name": "MSFT", "date": "20160513", "value": 51.080002 },
					{ "name": "MSFT", "date": "20160516", "value": 51.830002 },
					{ "name": "MSFT", "date": "20160517", "value": 50.509998 },
					{ "name": "MSFT", "date": "20160518", "value": 50.810001 },
					{ "name": "MSFT", "date": "20160519", "value": 50.32 },
					{ "name": "MSFT", "date": "20160520", "value": 50.619999 },
					{ "name": "MSFT", "date": "20160523", "value": 50.029999 },
					{ "name": "MSFT", "date": "20160524", "value": 51.59 },
					{ "name": "MSFT", "date": "20160525", "value": 52.119999 },
					{ "name": "MSFT", "date": "20160526", "value": 51.889999 },
					{ "name": "MSFT", "date": "20160527", "value": 52.32 },
					{ "name": "MSFT", "date": "20160531", "value": 53 },
					{ "name": "MSFT", "date": "20160601", "value": 52.849998 },
					{ "name": "MSFT", "date": "20160602", "value": 52.48 },
					{ "name": "MSFT", "date": "20160603", "value": 51.790001 },
					{ "name": "MSFT", "date": "20160606", "value": 52.130001 },
					{ "name": "MSFT", "date": "20160607", "value": 52.099998 },
					{ "name": "MSFT", "date": "20160608", "value": 52.040001 },
					{ "name": "MSFT", "date": "20160609", "value": 51.619999 },
					{ "name": "MSFT", "date": "20160610", "value": 51.48 },
					{ "name": "MSFT", "date": "20160613", "value": 50.139999 },
					{ "name": "MSFT", "date": "20160614", "value": 49.830002 },
					{ "name": "MSFT", "date": "20160615", "value": 49.689999 },
					{ "name": "MSFT", "date": "20160616", "value": 50.389999 },
					{ "name": "MSFT", "date": "20160617", "value": 50.130001 },
					{ "name": "MSFT", "date": "20160620", "value": 50.07 },
					{ "name": "MSFT", "date": "20160621", "value": 51.189999 },
					{ "name": "MSFT", "date": "20160622", "value": 50.990002 },
					{ "name": "MSFT", "date": "20160623", "value": 51.91 },
					{ "name": "MSFT", "date": "20160624", "value": 49.830002 },
					{ "name": "MSFT", "date": "20160627", "value": 48.43 },
					{ "name": "MSFT", "date": "20160628", "value": 49.439999 },
					{ "name": "MSFT", "date": "20160629", "value": 50.540001 },
					{ "name": "MSFT", "date": "20160630", "value": 51.169998 },
					{ "name": "MSFT", "date": "20160701", "value": 51.16 },
					{ "name": "MSFT", "date": "20160705", "value": 51.169998 },
					{ "name": "MSFT", "date": "20160706", "value": 51.380001 },
					{ "name": "MSFT", "date": "20160707", "value": 51.380001 },
					{ "name": "MSFT", "date": "20160708", "value": 52.299999 },
					{ "name": "MSFT", "date": "20160711", "value": 52.59 },
					{ "name": "MSFT", "date": "20160712", "value": 53.209999 },
					{ "name": "MSFT", "date": "20160713", "value": 53.509998 },
					{ "name": "MSFT", "date": "20160714", "value": 53.740002 },
					{ "name": "MSFT", "date": "20160715", "value": 53.700001 },
					{ "name": "MSFT", "date": "20160718", "value": 53.959999 },
					{ "name": "MSFT", "date": "20160719", "value": 53.09 },
					{ "name": "MSFT", "date": "20160720", "value": 55.91 },
					{ "name": "MSFT", "date": "20160721", "value": 55.799999 },
					{ "name": "MSFT", "date": "20160722", "value": 56.57 },
					{ "name": "MSFT", "date": "20160725", "value": 56.73 },
					{ "name": "MSFT", "date": "20160726", "value": 56.759998 },
					{ "name": "MSFT", "date": "20160727", "value": 56.189999 },
					{ "name": "MSFT", "date": "20160728", "value": 56.209999 },
					{ "name": "MSFT", "date": "20160729", "value": 56.68 },
					{ "name": "MSFT", "date": "20160801", "value": 56.580002 },
					{ "name": "MSFT", "date": "20160802", "value": 56.580002 },
					{ "name": "MSFT", "date": "20160803", "value": 56.970001 },
					{ "name": "MSFT", "date": "20160804", "value": 57.389999 },
					{ "name": "MSFT", "date": "20160805", "value": 57.959999 },
					{ "name": "MSFT", "date": "20160808", "value": 58.060001 },
					{ "name": "MSFT", "date": "20160809", "value": 58.200001 },
					{ "name": "MSFT", "date": "20160810", "value": 58.02 },
					{ "name": "MSFT", "date": "20160811", "value": 58.299999 },
					{ "name": "MSFT", "date": "20160812", "value": 57.939999 },
					{ "name": "MSFT", "date": "20160815", "value": 58.119999 },
					{ "name": "MSFT", "date": "20160816", "value": 57.439999 },
					{ "name": "MSFT", "date": "20160817", "value": 57.560001 },
					{ "name": "MSFT", "date": "20160818", "value": 57.599998 },
					{ "name": "MSFT", "date": "20160819", "value": 57.619999 },
					{ "name": "MSFT", "date": "20160822", "value": 57.669998 },
					{ "name": "MSFT", "date": "20160823", "value": 57.889999 },
					{ "name": "MSFT", "date": "20160824", "value": 57.950001 },
					{ "name": "MSFT", "date": "20160825", "value": 58.169998 },
					{ "name": "MSFT", "date": "20160826", "value": 58.029999 },
					{ "name": "MSFT", "date": "20160829", "value": 58.099998 },
					{ "name": "MSFT", "date": "20160830", "value": 57.889999 },
					{ "name": "MSFT", "date": "20160831", "value": 57.459999 },
					{ "name": "MSFT", "date": "20160901", "value": 57.59 },
					{ "name": "MSFT", "date": "20160902", "value": 57.669998 },
					{ "name": "MSFT", "date": "20160906", "value": 57.610001 },
					{ "name": "MSFT", "date": "20160907", "value": 57.66 },
					{ "name": "MSFT", "date": "20160908", "value": 57.43 },
					{ "name": "MSFT", "date": "20160909", "value": 56.209999 },
					{ "name": "MSFT", "date": "20160912", "value": 57.049999 },
					{ "name": "MSFT", "date": "20160913", "value": 56.529999 },
					{ "name": "MSFT", "date": "20160914", "value": 56.259998 },
					{ "name": "MSFT", "date": "20160915", "value": 57.189999 },
					{ "name": "MSFT", "date": "20160916", "value": 57.25 },
					{ "name": "MSFT", "date": "20160919", "value": 56.93 },
					{ "name": "MSFT", "date": "20160920", "value": 56.810001 },
					{ "name": "MSFT", "date": "20160921", "value": 57.759998 },
					{ "name": "MSFT", "date": "20160922", "value": 57.82 },
					{ "name": "MSFT", "date": "20160923", "value": 57.43 },
					{ "name": "MSFT", "date": "20160926", "value": 56.900002 },
					{ "name": "MSFT", "date": "20160927", "value": 57.950001 },
					{ "name": "MSFT", "date": "20160928", "value": 58.029999 },
					{ "name": "MSFT", "date": "20160929", "value": 57.400002 },
					{ "name": "MSFT", "date": "20160930", "value": 57.599998 },
					{ "name": "MSFT", "date": "20161003", "value": 57.419998 },
					{ "name": "MSFT", "date": "20161004", "value": 57.240002 },
					{ "name": "MSFT", "date": "20161005", "value": 57.639999 },
					{ "name": "MSFT", "date": "20161006", "value": 57.740002 },
					{ "name": "MSFT", "date": "20161007", "value": 57.799999 },
					{ "name": "MSFT", "date": "20161010", "value": 58.040001 },
					{ "name": "MSFT", "date": "20161011", "value": 57.189999 },
					{ "name": "MSFT", "date": "20161012", "value": 57.110001 },
					{ "name": "MSFT", "date": "20161013", "value": 56.919998 },
					{ "name": "MSFT", "date": "20161014", "value": 57.419998 },
					{ "name": "MSFT", "date": "20161017", "value": 57.220001 },
					{ "name": "MSFT", "date": "20161018", "value": 57.66 },
					{ "name": "MSFT", "date": "20161019", "value": 57.529999 },
					{ "name": "MSFT", "date": "20161020", "value": 57.25 },
					{ "name": "MSFT", "date": "20161021", "value": 59.66 },
					{ "name": "MSFT", "date": "20161024", "value": 61 },
					{ "name": "MSFT", "date": "20161025", "value": 60.990002 },
					{ "name": "MSFT", "date": "20161026", "value": 60.630001 },
					{ "name": "MSFT", "date": "20161027", "value": 60.099998 },
					{ "name": "MSFT", "date": "20161028", "value": 59.869999 },
					{ "name": "MSFT", "date": "20161031", "value": 59.919998 },
					{ "name": "MSFT", "date": "20161101", "value": 59.799999 },
					{ "name": "MSFT", "date": "20161102", "value": 59.43 },
					{ "name": "MSFT", "date": "20161103", "value": 59.209999 },
					{ "name": "MSFT", "date": "20161104", "value": 58.709999 },
					{ "name": "MSFT", "date": "20161107", "value": 60.419998 },
					{ "name": "MSFT", "date": "20161108", "value": 60.470001 },
					{ "name": "MSFT", "date": "20161109", "value": 60.169998 },
					{ "name": "MSFT", "date": "20161110", "value": 58.700001 },
					{ "name": "MSFT", "date": "20161111", "value": 59.02 },
					{ "name": "MSFT", "date": "20161114", "value": 58.119999 },
					{ "name": "MSFT", "date": "20161115", "value": 58.869999 },
					{ "name": "MSFT", "date": "20161116", "value": 59.650002 },
					{ "name": "MSFT", "date": "20161117", "value": 60.639999 },
					{ "name": "MSFT", "date": "20161118", "value": 60.349998 },
					{ "name": "MSFT", "date": "20161121", "value": 60.860001 },
					{ "name": "MSFT", "date": "20161122", "value": 61.119999 },
					{ "name": "MSFT", "date": "20161123", "value": 60.400002 },
					{ "name": "MSFT", "date": "20161125", "value": 60.529999 },
					{ "name": "MSFT", "date": "20161128", "value": 60.610001 },
					{ "name": "MSFT", "date": "20161129", "value": 61.09 },
					{ "name": "MSFT", "date": "20161130", "value": 60.259998 },
					{ "name": "MSFT", "date": "20161201", "value": 59.200001 },
					{ "name": "MSFT", "date": "20161202", "value": 59.25 },
					{ "name": "MSFT", "date": "20161205", "value": 60.220001 },
					{ "name": "MSFT", "date": "20161206", "value": 59.950001 },
					{ "name": "MSFT", "date": "20161207", "value": 61.369999 },
					{ "name": "MSFT", "date": "20161208", "value": 61.009998 },
					{ "name": "MSFT", "date": "20161209", "value": 61.970001 },
					{ "name": "MSFT", "date": "20161212", "value": 62.169998 },
					{ "name": "MSFT", "date": "20161213", "value": 62.98 },
					{ "name": "MSFT", "date": "20161214", "value": 62.68 },
					{ "name": "MSFT", "date": "20161215", "value": 62.580002 },
					{ "name": "MSFT", "date": "20161216", "value": 62.299999 },
					{ "name": "MSFT", "date": "20161219", "value": 63.619999 },
					{ "name": "MSFT", "date": "20161220", "value": 63.540001 },
					{ "name": "MSFT", "date": "20161221", "value": 63.540001 },
					{ "name": "MSFT", "date": "20161222", "value": 63.549999 },
					{ "name": "MSFT", "date": "20161223", "value": 63.240002 },
					{ "name": "MSFT", "date": "20161227", "value": 63.279999 },
					{ "name": "MSFT", "date": "20161228", "value": 62.990002 },
					{ "name": "MSFT", "date": "20161229", "value": 62.900002 },
					{ "name": "MSFT", "date": "20161230", "value": 62.139999 },
					{ "name": "MSFT", "date": "20170103", "value": 62.580002 },
					{ "name": "MSFT", "date": "20170104", "value": 62.299999 },
					{ "name": "MSFT", "date": "20170105", "value": 62.299999 },
					{ "name": "MSFT", "date": "20170106", "value": 62.84 },
					{ "name": "MSFT", "date": "20170109", "value": 62.639999 },
					{ "name": "MSFT", "date": "20170110", "value": 62.619999 },
					{ "name": "MSFT", "date": "20170111", "value": 63.189999 },
					{ "name": "MSFT", "date": "20170112", "value": 62.610001 },
					{ "name": "MSFT", "date": "20170113", "value": 62.700001 },
					{ "name": "MSFT", "date": "20170117", "value": 62.529999 },
					{ "name": "MSFT", "date": "20170118", "value": 62.5 },
					{ "name": "MSFT", "date": "20170119", "value": 62.299999 },
					{ "name": "MSFT", "date": "20170120", "value": 62.740002 },
					{ "name": "MSFT", "date": "20170123", "value": 62.959999 },
					{ "name": "MSFT", "date": "20170124", "value": 63.52 },
					{ "name": "MSFT", "date": "20170125", "value": 63.68 },
					{ "name": "MSFT", "date": "20170126", "value": 64.269997 },
					{ "name": "MSFT", "date": "20170127", "value": 65.779999 },
					{ "name": "MSFT", "date": "20170130", "value": 65.129997 },
					{ "name": "MSFT", "date": "20170131", "value": 64.650002 },
					{ "name": "MSFT", "date": "20170201", "value": 63.580002 },
					{ "name": "MSFT", "date": "20170202", "value": 63.169998 },
					{ "name": "MSFT", "date": "20170203", "value": 63.68 },
					{ "name": "MSFT", "date": "20170206", "value": 63.639999 },
					{ "name": "MSFT", "date": "20170207", "value": 63.43 },
					{ "name": "MSFT", "date": "20170208", "value": 63.34 },
					{ "name": "MSFT", "date": "20170209", "value": 64.059998 },
					{ "name": "MSFT", "date": "20170210", "value": 64 },
					{ "name": "MSFT", "date": "20170213", "value": 64.720001 },
					{ "name": "MSFT", "date": "20170214", "value": 64.57 },
					{ "name": "MSFT", "date": "20170215", "value": 64.529999 },
					{ "name": "MSFT", "date": "20170216", "value": 64.519997 },
					{ "name": "MSFT", "date": "20170217", "value": 64.620003 },
					{ "name": "MSFT", "date": "20170221", "value": 64.489998 },
					{ "name": "MSFT", "date": "20170222", "value": 64.360001 },
					{ "name": "MSFT", "date": "20170223", "value": 64.620003 },
					{ "name": "MSFT", "date": "20170224", "value": 64.620003 },
					{ "name": "MSFT", "date": "20170227", "value": 64.230003 },
					{ "name": "MSFT", "date": "20170228", "value": 63.98 },
					{ "name": "MSFT", "date": "20170301", "value": 64.940002 },
					{ "name": "MSFT", "date": "20170302", "value": 64.010002 },
					{ "name": "MSFT", "date": "20170303", "value": 64.25 },
					{ "name": "MSFT", "date": "20170306", "value": 64.269997 },
					{ "name": "MSFT", "date": "20170307", "value": 64.400002 },
					{ "name": "MSFT", "date": "20170308", "value": 64.989998 },
					{ "name": "MSFT", "date": "20170309", "value": 64.730003 },
					{ "name": "MSFT", "date": "20170310", "value": 64.93 },
					{ "name": "MSFT", "date": "20170313", "value": 64.709999 },
					{ "name": "MSFT", "date": "20170314", "value": 64.410004 },
					{ "name": "MSFT", "date": "20170315", "value": 64.75 },
					{ "name": "MSFT", "date": "20170316", "value": 64.639999 },
					{ "name": "MSFT", "date": "20170317", "value": 64.870003 },
					{ "name": "MSFT", "date": "20170320", "value": 64.93 },
					{ "name": "MSFT", "date": "20170321", "value": 64.209999 },
					{ "name": "MSFT", "date": "20170322", "value": 65.029999 },
					{ "name": "MSFT", "date": "20170323", "value": 64.870003 },
					{ "name": "MSFT", "date": "20170324", "value": 64.980003 },
					{ "name": "MSFT", "date": "20170327", "value": 65.099998 },
					{ "name": "MSFT", "date": "20170328", "value": 65.290001 },
					{ "name": "MSFT", "date": "20170329", "value": 65.470001 },
					{ "name": "MSFT", "date": "20170330", "value": 65.709999 },
					{ "name": "MSFT", "date": "20170331", "value": 65.860001 },
					{ "name": "MSFT", "date": "20170403", "value": 65.550003 },
					{ "name": "MSFT", "date": "20170404", "value": 65.730003 },
					{ "name": "MSFT", "date": "20170405", "value": 65.559998 },
					{ "name": "MSFT", "date": "20170406", "value": 65.730003 },
					{ "name": "MSFT", "date": "20170407", "value": 65.68 },
					{ "name": "MSFT", "date": "20170410", "value": 65.529999 },
					{ "name": "MSFT", "date": "20170411", "value": 65.480003 },
					{ "name": "MSFT", "date": "20170412", "value": 65.230003 },
					{ "name": "MSFT", "date": "20170413", "value": 64.949997 },
					{ "name": "MSFT", "date": "20170417", "value": 65.480003 },
					{ "name": "MSFT", "date": "20170418", "value": 65.389999 },
					{ "name": "MSFT", "date": "20170419", "value": 65.040001 },
					{ "name": "MSFT", "date": "20170420", "value": 65.5 },
					{ "name": "MSFT", "date": "20170421", "value": 66.400002 },
					{ "name": "MSFT", "date": "20170424", "value": 67.529999 },
					{ "name": "MSFT", "date": "20170425", "value": 67.919998 },
					{ "name": "MSFT", "date": "20170426", "value": 67.830002 },
					{ "name": "MSFT", "date": "20170427", "value": 68.269997 },
					{ "name": "MSFT", "date": "20170428", "value": 68.459999 },
					{ "name": "MSFT", "date": "20170501", "value": 69.410004 },
					{ "name": "MSFT", "date": "20170502", "value": 69.300003 },
					{ "name": "MSFT", "date": "20170503", "value": 69.080002 },
					{ "name": "MSFT", "date": "20170504", "value": 68.809998 },
					{ "name": "MSFT", "date": "20170505", "value": 69 },
					{ "name": "MSFT", "date": "20170508", "value": 68.940002 },
					{ "name": "MSFT", "date": "20170509", "value": 69.040001 },
					{ "name": "MSFT", "date": "20170510", "value": 69.309998 },
					{ "name": "MSFT", "date": "20170511", "value": 68.459999 },
					{ "name": "MSFT", "date": "20170512", "value": 68.379997 },
					{ "name": "MSFT", "date": "20170515", "value": 68.43 },
					{ "name": "MSFT", "date": "20170516", "value": 69.410004 },
					{ "name": "MSFT", "date": "20170517", "value": 67.480003 },
					{ "name": "MSFT", "date": "20170518", "value": 67.709999 },
					{ "name": "MSFT", "date": "20170519", "value": 67.690002 },
					{ "name": "MSFT", "date": "20170522", "value": 68.449997 },
					{ "name": "MSFT", "date": "20170523", "value": 68.68 },
					{ "name": "MSFT", "date": "20170524", "value": 68.769997 },
					{ "name": "MSFT", "date": "20170525", "value": 69.620003 },
					{ "name": "MSFT", "date": "20170526", "value": 69.959999 },
					{ "name": "MSFT", "date": "20170530", "value": 70.410004 },
					{ "name": "MSFT", "date": "20170531", "value": 69.839996 },
					{ "name": "MSFT", "date": "20170601", "value": 70.099998 },
					{ "name": "MSFT", "date": "20170602", "value": 71.760002 },
					{ "name": "MSFT", "date": "20170605", "value": 72.279999 },
					{ "name": "MSFT", "date": "20170606", "value": 72.519997 },
					{ "name": "MSFT", "date": "20170607", "value": 72.389999 },
					{ "name": "MSFT", "date": "20170608", "value": 71.949997 },
					{ "name": "MSFT", "date": "20170609", "value": 70.32 },
					{ "name": "MSFT", "date": "20170612", "value": 69.779999 },
					{ "name": "MSFT", "date": "20170613", "value": 70.650002 },
					{ "name": "MSFT", "date": "20170614", "value": 70.269997 },
					{ "name": "MSFT", "date": "20170615", "value": 69.900002 },
					{ "name": "MSFT", "date": "20170616", "value": 70 },
					{ "name": "MSFT", "date": "20170619", "value": 70.870003 },
					{ "name": "MSFT", "date": "20170620", "value": 69.910004 },
					{ "name": "MSFT", "date": "20170621", "value": 70.269997 },
					{ "name": "MSFT", "date": "20170622", "value": 70.260002 },
					{ "name": "MSFT", "date": "20170623", "value": 71.209999 },
					{ "name": "MSFT", "date": "20170626", "value": 70.529999 },
					{ "name": "MSFT", "date": "20170627", "value": 69.209999 },
					{ "name": "MSFT", "date": "20170628", "value": 69.800003 },
					{ "name": "MSFT", "date": "20170629", "value": 68.489998 },
					{ "name": "MSFT", "date": "20170630", "value": 68.93 },
					{ "name": "MSFT", "date": "20170703", "value": 68.169998 },
					{ "name": "MSFT", "date": "20170705", "value": 69.080002 },
					{ "name": "MSFT", "date": "20170706", "value": 68.57 },
					{ "name": "MSFT", "date": "20170707", "value": 69.459999 },
					{ "name": "MSFT", "date": "20170710", "value": 69.980003 },
					{ "name": "MSFT", "date": "20170711", "value": 69.989998 },
					{ "name": "MSFT", "date": "20170712", "value": 71.150002 },
					{ "name": "MSFT", "date": "20170713", "value": 71.769997 },
					{ "name": "MSFT", "date": "20170714", "value": 72.779999 },
					{ "name": "MSFT", "date": "20170717", "value": 73.349998 },
					{ "name": "MSFT", "date": "20170718", "value": 73.300003 },
					{ "name": "MSFT", "date": "20170719", "value": 73.860001 },
					{ "name": "MSFT", "date": "20170720", "value": 74.220001 },
					{ "name": "MSFT", "date": "20170721", "value": 73.790001 },
					{ "name": "MSFT", "date": "20170724", "value": 73.599998 },
					{ "name": "MSFT", "date": "20170725", "value": 74.190002 },
					{ "name": "MSFT", "date": "20170726", "value": 74.050003 },
					{ "name": "MSFT", "date": "20170727", "value": 73.160004 },
					{ "name": "MSFT", "date": "20170728", "value": 73.040001 },
					{ "name": "MSFT", "date": "20170731", "value": 72.699997 },
					{ "name": "MSFT", "date": "20170801", "value": 72.580002 },
					{ "name": "MSFT", "date": "20170802", "value": 72.260002 },
					{ "name": "MSFT", "date": "20170803", "value": 72.150002 },
					{ "name": "MSFT", "date": "20170804", "value": 72.68 },
					{ "name": "MSFT", "date": "20170807", "value": 72.400002 },
					{ "name": "MSFT", "date": "20170808", "value": 72.790001 },
					{ "name": "MSFT", "date": "20170809", "value": 72.470001 },
					{ "name": "MSFT", "date": "20170810", "value": 71.410004 },
					{ "name": "MSFT", "date": "20170811", "value": 72.5 },
					{ "name": "MSFT", "date": "20170814", "value": 73.589996 },
					{ "name": "MSFT", "date": "20170815", "value": 73.220001 },
					{ "name": "MSFT", "date": "20170816", "value": 73.650002 },
					{ "name": "MSFT", "date": "20170817", "value": 72.400002 },
					{ "name": "MSFT", "date": "20170818", "value": 72.489998 },
					{ "name": "MSFT", "date": "20170821", "value": 72.150002 },
					{ "name": "MSFT", "date": "20170822", "value": 73.160004 },
					{ "name": "MSFT", "date": "20170823", "value": 72.720001 },
					{ "name": "MSFT", "date": "20170824", "value": 72.690002 },
					{ "name": "MSFT", "date": "20170825", "value": 72.82 },
					{ "name": "MSFT", "date": "20170828", "value": 72.830002 },
					{ "name": "MSFT", "date": "20170829", "value": 73.050003 },
					{ "name": "MSFT", "date": "20170830", "value": 74.010002 },
					{ "name": "MSFT", "date": "20170831", "value": 74.769997 },
					{ "name": "MSFT", "date": "20170901", "value": 73.940002 },
					{ "name": "MSFT", "date": "20170905", "value": 73.610001 },
					{ "name": "MSFT", "date": "20170906", "value": 73.400002 },
					{ "name": "MSFT", "date": "20170907", "value": 74.339996 },
					{ "name": "MSFT", "date": "20170908", "value": 73.980003 },
					{ "name": "MSFT", "date": "20170911", "value": 74.760002 },
					{ "name": "MSFT", "date": "20170912", "value": 74.68 },
					{ "name": "MSFT", "date": "20170913", "value": 75.209999 },
					{ "name": "MSFT", "date": "20170914", "value": 74.769997 },
					{ "name": "MSFT", "date": "20170915", "value": 75.309998 },
					{ "name": "MSFT", "date": "20170918", "value": 75.160004 },
					{ "name": "MSFT", "date": "20170919", "value": 75.440002 },
					{ "name": "MSFT", "date": "20170920", "value": 74.940002 },
					{ "name": "MSFT", "date": "20170921", "value": 74.209999 },
					{ "name": "MSFT", "date": "20170922", "value": 74.410004 },
					{ "name": "MSFT", "date": "20170925", "value": 73.260002 },
					{ "name": "MSFT", "date": "20170926", "value": 73.260002 },
					{ "name": "MSFT", "date": "20170927", "value": 73.849998 },
					{ "name": "MSFT", "date": "20170928", "value": 73.870003 },
					{ "name": "MSFT", "date": "20170929", "value": 74.489998 },
					{ "name": "MSFT", "date": "20171002", "value": 74.610001 },
					{ "name": "MSFT", "date": "20171003", "value": 74.260002 },
					{ "name": "MSFT", "date": "20171004", "value": 74.690002 },
					{ "name": "MSFT", "date": "20171005", "value": 75.970001 },
					{ "name": "MSFT", "date": "20171006", "value": 76 },
					{ "name": "MSFT", "date": "20171009", "value": 76.290001 },
					{ "name": "MSFT", "date": "20171010", "value": 76.290001 },
					{ "name": "MSFT", "date": "20171011", "value": 76.419998 },
					{ "name": "MSFT", "date": "20171012", "value": 77.120003 },
					{ "name": "MSFT", "date": "20171013", "value": 77.489998 },
					{ "name": "MSFT", "date": "20171016", "value": 77.650002 },
					{ "name": "MSFT", "date": "20171017", "value": 77.589996 },
					{ "name": "MSFT", "date": "20171018", "value": 77.610001 },
					{ "name": "MSFT", "date": "20171019", "value": 77.910004 },
					{ "name": "MSFT", "date": "20171020", "value": 78.809998 },
					{ "name": "MSFT", "date": "20171023", "value": 78.830002 },
					{ "name": "MSFT", "date": "20171024", "value": 78.860001 },
					{ "name": "MSFT", "date": "20171025", "value": 78.629997 },
					{ "name": "MSFT", "date": "20171026", "value": 78.760002 },
					{ "name": "MSFT", "date": "20171027", "value": 83.809998 },
					{ "name": "MSFT", "date": "20171030", "value": 83.889999 },
					{ "name": "MSFT", "date": "20171031", "value": 83.18 },
					{ "name": "MSFT", "date": "20171101", "value": 83.18 },
					{ "name": "MSFT", "date": "20171102", "value": 84.050003 },
					{ "name": "MSFT", "date": "20171103", "value": 84.139999 },
					{ "name": "MSFT", "date": "20171106", "value": 84.470001 },
					{ "name": "MSFT", "date": "20171107", "value": 84.269997 },
					{ "name": "MSFT", "date": "20171108", "value": 84.559998 },
					{ "name": "MSFT", "date": "20171109", "value": 84.089996 },
					{ "name": "MSFT", "date": "20171110", "value": 83.870003 },
					{ "name": "MSFT", "date": "20171113", "value": 83.93 },
					{ "name": "MSFT", "date": "20171114", "value": 84.050003 },
					{ "name": "MSFT", "date": "20171115", "value": 82.980003 },
					{ "name": "MSFT", "date": "20171116", "value": 83.199997 },
					{ "name": "MSFT", "date": "20171117", "value": 82.400002 },
					{ "name": "MSFT", "date": "20171120", "value": 82.529999 },
					{ "name": "MSFT", "date": "20171121", "value": 83.720001 },
					{ "name": "MSFT", "date": "20171122", "value": 83.110001 },
					{ "name": "MSFT", "date": "20171124", "value": 83.260002 },
					{ "name": "MSFT", "date": "20171127", "value": 83.870003 },
					{ "name": "MSFT", "date": "20171128", "value": 84.879997 },
					{ "name": "MSFT", "date": "20171129", "value": 83.339996 },
					{ "name": "MSFT", "date": "20171130", "value": 84.169998 },
					{ "name": "MSFT", "date": "20171201", "value": 84.260002 },
					{ "name": "MSFT", "date": "20171204", "value": 81.080002 },
					{ "name": "MSFT", "date": "20171205", "value": 81.589996 },
					{ "name": "MSFT", "date": "20171206", "value": 82.779999 },
					{ "name": "MSFT", "date": "20171207", "value": 82.489998 },
					{ "name": "MSFT", "date": "20171208", "value": 84.160004 },
					{ "name": "MSFT", "date": "20171211", "value": 85.230003 },
					{ "name": "MSFT", "date": "20171212", "value": 85.580002 },
					{ "name": "MSFT", "date": "20171213", "value": 85.349998 },
					{ "name": "MSFT", "date": "20171214", "value": 84.690002 },
					{ "name": "MSFT", "date": "20171215", "value": 86.849998 },
					{ "name": "MSFT", "date": "20171218", "value": 86.379997 },
					{ "name": "MSFT", "date": "20171219", "value": 85.830002 },
					{ "name": "MSFT", "date": "20171220", "value": 85.519997 },
					{ "name": "MSFT", "date": "20171221", "value": 85.5 },
					{ "name": "MSFT", "date": "20171222", "value": 85.510002 },
					{ "name": "MSFT", "date": "20171226", "value": 85.400002 },
					{ "name": "MSFT", "date": "20171227", "value": 85.709999 },
					{ "name": "MSFT", "date": "20171228", "value": 85.720001 },
					{ "name": "MSFT", "date": "20171229", "value": 85.540001 },
					{ "name": "MSFT", "date": "20180102", "value": 85.949997 },
					{ "name": "MSFT", "date": "20180103", "value": 86.349998 },
					{ "name": "MSFT", "date": "20180104", "value": 87.110001 },
					{ "name": "MSFT", "date": "20180105", "value": 88.190002 },
					{ "name": "MSFT", "date": "20180108", "value": 88.279999 },
					{ "name": "MSFT", "date": "20180109", "value": 88.220001 },
					{ "name": "MSFT", "date": "20180110", "value": 87.82 },
					{ "name": "MSFT", "date": "20180111", "value": 88.080002 },
					{ "name": "MSFT", "date": "20180112", "value": 89.599998 },
					{ "name": "MSFT", "date": "20180116", "value": 88.349998 },
					{ "name": "MSFT", "date": "20180117", "value": 90.139999 },
					{ "name": "MSFT", "date": "20180118", "value": 90.099998 },
					{ "name": "MSFT", "date": "20180119", "value": 90 },
					{ "name": "MSFT", "date": "20180122", "value": 91.610001 },
					{ "name": "MSFT", "date": "20180123", "value": 91.900002 },
					{ "name": "MSFT", "date": "20180124", "value": 91.82 },
					{ "name": "MSFT", "date": "20180125", "value": 92.330002 },
					{ "name": "MSFT", "date": "20180126", "value": 94.059998 },
					{ "name": "MSFT", "date": "20180129", "value": 93.919998 },
					{ "name": "MSFT", "date": "20180130", "value": 92.739998 },
					{ "name": "MSFT", "date": "20180131", "value": 95.010002 },
					{ "name": "MSFT", "date": "20180201", "value": 94.260002 },
					{ "name": "MSFT", "date": "20180202", "value": 91.779999 },
					{ "name": "MSFT", "date": "20180205", "value": 88 },
					{ "name": "MSFT", "date": "20180206", "value": 91.330002 },
					{ "name": "MSFT", "date": "20180207", "value": 89.610001 },
					{ "name": "MSFT", "date": "20180208", "value": 85.010002 },
					{ "name": "MSFT", "date": "20180209", "value": 88.18 },
					{ "name": "MSFT", "date": "20180212", "value": 89.129997 },
					{ "name": "MSFT", "date": "20180213", "value": 89.830002 },
					{ "name": "MSFT", "date": "20180214", "value": 90.809998 },
					{ "name": "MSFT", "date": "20180215", "value": 92.660004 },
					{ "name": "MSFT", "date": "20180216", "value": 92 },
					{ "name": "MSFT", "date": "20180220", "value": 92.720001 },
					{ "name": "MSFT", "date": "20180221", "value": 91.489998 },
					{ "name": "MSFT", "date": "20180222", "value": 91.730003 },
					{ "name": "MSFT", "date": "20180223", "value": 94.059998 },
					{ "name": "MSFT", "date": "20180226", "value": 95.419998 },
					{ "name": "MSFT", "date": "20180227", "value": 94.199997 },
					{ "name": "MSFT", "date": "20180228", "value": 93.769997 },
					{ "name": "MSFT", "date": "20180301", "value": 92.849998 },
					{ "name": "MSFT", "date": "20180302", "value": 93.050003 },
					{ "name": "MSFT", "date": "20180305", "value": 93.639999 },
					{ "name": "MSFT", "date": "20180306", "value": 93.32 },
					{ "name": "MSFT", "date": "20180307", "value": 93.860001 },
					{ "name": "MSFT", "date": "20180308", "value": 94.43 },
					{ "name": "MSFT", "date": "20180309", "value": 96.540001 },
					{ "name": "MSFT", "date": "20180312", "value": 96.769997 },
					{ "name": "MSFT", "date": "20180313", "value": 94.410004 },
					{ "name": "MSFT", "date": "20180314", "value": 93.849998 },
					{ "name": "MSFT", "date": "20180315", "value": 94.18 },
					{ "name": "MSFT", "date": "20180316", "value": 94.599998 },
					{ "name": "MSFT", "date": "20180319", "value": 92.889999 },
					{ "name": "MSFT", "date": "20180320", "value": 93.129997 },
					{ "name": "MSFT", "date": "20180321", "value": 92.480003 },
					{ "name": "MSFT", "date": "20180322", "value": 89.790001 },
					{ "name": "MSFT", "date": "20180323", "value": 87.18 },
					{ "name": "MSFT", "date": "20180326", "value": 93.779999 },
					{ "name": "MSFT", "date": "20180327", "value": 89.470001 },
					{ "name": "MSFT", "date": "20180328", "value": 89.389999 },
					{ "name": "MSFT", "date": "20180329", "value": 91.269997 },
					{ "name": "MSFT", "date": "20180402", "value": 88.519997 },
					{ "name": "MSFT", "date": "20180403", "value": 89.709999 },
					{ "name": "MSFT", "date": "20180404", "value": 92.330002 },
					{ "name": "MSFT", "date": "20180405", "value": 92.379997 },
					{ "name": "MSFT", "date": "20180406", "value": 90.230003 },
					{ "name": "MSFT", "date": "20180409", "value": 90.769997 },
					{ "name": "MSFT", "date": "20180410", "value": 92.879997 },
					{ "name": "MSFT", "date": "20180411", "value": 91.860001 },
					{ "name": "MSFT", "date": "20180412", "value": 93.580002 },
					{ "name": "MSFT", "date": "20180413", "value": 93.080002 },
					{ "name": "MSFT", "date": "20180416", "value": 94.169998 },
					{ "name": "MSFT", "date": "20180417", "value": 96.07 },
					{ "name": "MSFT", "date": "20180418", "value": 96.440002 },
					{ "name": "MSFT", "date": "20180419", "value": 96.110001 },
					{ "name": "MSFT", "date": "20180420", "value": 95 },
					{ "name": "MSFT", "date": "20180423", "value": 95.349998 },
					{ "name": "MSFT", "date": "20180424", "value": 93.120003 },
					{ "name": "MSFT", "date": "20180425", "value": 92.309998 },
					{ "name": "MSFT", "date": "20180426", "value": 94.260002 },
					{ "name": "MSFT", "date": "20180427", "value": 95.82 },
					{ "name": "MSFT", "date": "20180430", "value": 93.519997 },
					{ "name": "MSFT", "date": "20180501", "value": 95 },
					{ "name": "MSFT", "date": "20180502", "value": 93.510002 },
					{ "name": "MSFT", "date": "20180503", "value": 94.07 },
					{ "name": "MSFT", "date": "20180504", "value": 95.160004 },
					{ "name": "MSFT", "date": "20180507", "value": 96.220001 },
					{ "name": "MSFT", "date": "20180508", "value": 95.809998 },
					{ "name": "MSFT", "date": "20180509", "value": 96.940002 },
					{ "name": "MSFT", "date": "20180510", "value": 97.910004 },
					{ "name": "MSFT", "date": "20180511", "value": 97.699997 }
				];

		renderConfig.dataBuckets.depth = 1;
		renderConfig.moonbeamInstance.getSeries(0).color = grey;
		renderConfig.moonbeamInstance.getSeries(1).color = pv.color(grey).lighter(0.18).color;
		renderCallback(renderConfig);
	}

	// Optional: if defined, is invoked once at the very beginning of each chart engine draw cycle
	// Optional: 定義している場合は、各チャートの描画サイクルの最初の一度だけ呼び出す

	// Use this to configure a specific chart engine instance before rendering.
	// この定義を使用して、レンダリング前に特定のチャートエンジンのインスタンスを設定する

	// Arguments:
	// 引数:

	//  - preRenderConfig: the standard callback argument object
	//  - preRenderConfig: 標準コールバックの引数オブジェクト

	function preRenderCallback(preRenderConfig) {
		var chart = preRenderConfig.moonbeamInstance;

		// Example of manually loading a file in this extension's folder path and using it.
		// 拡張機能のフォルダパスにあるファイルを手動で読み込んで使用する例

		var info = tdgchart.util.ajax(preRenderConfig.loadPath + 'lib/extra_properties.json', {asJSON: true});

		/* Logic before CHART-1935 NFR
		// CHART-1935のNFR以前のロジック

			// Example of using the chart engine's built in title properties
			// チャートエンジンに組み込まれたタイトルプロパティの使用例
			chart.title.visible = true;
			chart.title.text = info.custom_title;
			chart.footnote.visible = true;
			chart.footnote.text = 'footnote';
			chart.footnote.align = 'right';
		*/
		
		//Start CHART-1935 NFR
		//CHART-1935のNFRを開始

			if (!chart.title.visible){    //Developer has not set HEADING in GRAPH request; so use custom title found in: preRenderConfig.loadPath + 'lib/extra_properties.json'
						      //開発者がグラフリクエストでHEADINGを指定しないため、'lib/extra_properties.json'でカスタムタイトルを指定する
				// Example of using the chart engine's built in title properties
				// チャートエンジンのタイトルプロパティへの組み込み例

				chart.title.visible = false;
				chart.title.text = info.custom_title;	
			} // if (!chart.title.visible) //Developer has not set FOOTING in GRAPH request; so use 'footnote' text to illustrate how custom programmatic footing can be assinged to chart
						       //開発者がグラフリクエストでFOOTINGを指定しないため、'footnote'を使用して説明する
			
			if (!chart.footnote.visible) {
				chart.footnote.visible = false;
				chart.footnote.text = '';
				chart.footnote.align = 'right';			
				
			} //if (!chart.footnote.visible)
		
		
		//End CHART-1935 NFR
		//CHART-1935のNFRを終了
		
	}

	// Required: Invoked during each chart engine draw cycle
	// 必須： チャートエンジンの描画サイクル毎に呼び出される

	// This is where your extension should be rendered
	// ここは拡張機能がレンダリングする箇所

	// Arguments:
	// 引数:

	//  - renderConfig: the standard callback argument object, including additional properties width, height, etc
	//  - renderConfig: 標準コールバックの引数オブジェクト (including additional properties width, height, など)

	function renderCallback(renderConfig) {

		var chart = renderConfig.moonbeamInstance;
		var data = renderConfig.data;
		var w = renderConfig.width;
		var h = renderConfig.height;

//		var formatDate = d3.timeFormat("%Y-%m-%d");
//		var formatDate = d3.timeFormat("%Y-%m");
		var formatDate = d3.timeFormat(renderConfig.properties.xAxisFormat);

		for (key in data) {
		//	parseDate = d3.timeParse("%Y%m");
			parseDate = d3.timeParse(renderConfig.properties.dataFormat);
		        data[key].date = parseDate(data[key].date);
		}

		var container = d3.select('#' + renderConfig.rootContainer.id + ' svg')
			.attr('class', 'jp_co_ashisuto_index_chart')
			.style("-webkit-tap-highlight-color", "transparent")
			.on("mousemove", moved)
			.on("touchmove", movedtouch);

		var width = container.node().clientWidth - 30;
		var height = container.node().clientHeight - 30;

		var margin = ({top: 20, right: 40, bottom: 10, left: 50});

		var k = d3.max(d3.group(data, d => d.name), ([, group]) => d3.max(group, d => d.value) / d3.min(group, d => d.value))

		var x = d3.scaleTime()
			.domain(d3.extent(data, d => d.date))
			.range([margin.left, width - margin.right])
			.clamp(true)

		var y = d3.scaleLog()
			.domain([1 / k, k])
			.rangeRound([height - margin.bottom, margin.top])

		var z = d3.scaleOrdinal(d3.schemeCategory10).domain(data.map(d => d.name))

		var xAxis = g => g
			.attr("transform", `translate(0,${height - margin.bottom})`)
			.call(d3.axisBottom(x).ticks(width / 80).tickSizeOuter(0).tickFormat(formatDate))
			.call(g => g.select(".domain").remove())

		var t = Math.sqrt(k);
		if(t > 4) { t = 4 };
		var yAxis = g => g
			.attr("transform", `translate(${margin.left},0)`)
			.call(d3.axisLeft(y)
//		      	.ticks(null, x => +x.toFixed(6) + "×"))
		    	.ticks(t, x => +x.toFixed(6) + "×"))
			.call(g => g.selectAll(".tick line").clone()
				.attr("stroke-opacity", d => d === 1 ? null : 0.2)
				.attr("x2", width - margin.left - margin.right))
			.call(g => g.select(".domain").remove())

		var line = d3.line()
			.x(d => x(d.date))
			.y(d => y(d.value))

		var bisect = d3.bisector(d => d.date).left

		var series = d3.groups(data, d => d.name).map(([key, values]) => {
			const v = values[0].value;
			return {key, values: values.map(({date, value}) => ({date, value: value / v}))};
		})

		container.append("g")
			.call(xAxis);

		container.append("g")
			.call(yAxis);

		const rule = container.append("g")
			.append("line")
				.attr("y1", height)
				.attr("y2", 0)
				.attr("stroke", "#008BBB");

		const serie = container.append("g")
			.style("font", "bold 10px sans-serif")
				.selectAll("g")
				.data(series)
				.join("g");

		serie.append("path")
		    .attr("fill", "none")
		    .attr("stroke-width", 1.5)
		    .attr("stroke-linejoin", "round")
		    .attr("stroke-linecap", "round")
		    .attr("stroke", d => z(d.key))
		    .attr("d", d => line(d.values));

		serie.append("text")
				.datum(d => ({key: d.key, value: d.values[d.values.length - 1].value}))
				.attr("fill", "none")
				.attr("stroke", "white")
				.attr("stroke-width", 3)
				.attr("x", x.range()[1] + 3)
				.attr("y", d => y(d.value))
				.attr("dy", "0.35em")
				.text(d => d.key)
			.clone(true)
				.attr("fill", d => z(d.key))
				.attr("stroke", null);

			d3.transition()
				.ease(d3.easeCubicOut)
				.duration(1500)
				.tween("date", () => {
					const i = d3.interpolateDate(x.domain()[1], x.domain()[0]);
			  		return t => update(i(t));
				});

		update(x.domain()[0]);

		function update(date) {
//			date = d3.utcDay.round(date);
			date = d3.timeDay.round(date);
			rule.attr("transform", `translate(${x(date) + 0.5},0)`);
			serie.attr("transform", ({values}) => {
				const i = bisect(values, date, 0, values.length - 1);
				return `translate(0,${y(1) - y(values[i].value / values[0].value)})`;
			});
			container.property("value", date).dispatch("input");
		}

		function moved(event) {
			update(x.invert(d3.pointer(event, this)[0]));
			event.preventDefault();
			event.stopPropagation();
		}

		function movedtouch(event) {
			var touchObject = event.changedTouches[0] ;
			var tx = touchObject.pageX;
			update(x.invert(tx));
			event.preventDefault();
			event.stopPropagation();
		}

		renderConfig.renderComplete();
	}

	// Your extension's configuration
	// 拡張機能の設定

	var config = {
		id: 'jp.co.ashisuto.index_chart',     // string that uniquely identifies this extension
						      // 拡張機能を一意に識別する文字列
		containerType: 'svg',  // either 'html' or 'svg' (default)
				       // 'html' か 'svg' のいずれか (default)
		initCallback: initCallback,
		preRenderCallback: preRenderCallback,  // reference to a function that is called right *before* your extension is rendered.  Will be passed one 'preRenderConfig' object, defined below.  Use this to configure a Monbeam instance as needed
						       // 拡張機能がレンダリングする直前に呼び出す関数への参照。'preRenderConfig' として定義されているオブジェクトが渡される。必要に応じて、Monbeamインスタンスを使用する。
		renderCallback: renderCallback,  // reference to a function that will draw the actual chart.  Will be passed one 'renderConfig' object, defined below
						 // 実際のチャートを描画する関数への参照。'renderConfig' として定義されているオブジェクトが渡される。
		noDataPreRenderCallback: noDataPreRenderCallback,
		noDataRenderCallback: noDataRenderCallback,
		resources: {  // Additional external resources (CSS & JS) required by this extension
			      // 拡張機能で必要な追加外部リソース（CSS と JS）
//			script: ['lib/d3.min.js', 'lib/index_chart.js'],
/*
			script: ['lib/d3.min.js'],
			css: ['css/extension.css']
				// Example of using a function callback to dynamically define an external library to be loaded
				// ロードされる外部ライブラリを動的に定義するためのコールバック関数の定義例

				// callbackArg is the standard callback argument object which contains 'properties'.
				// callbackArg は、'properties' を含む標準のコールバック用引数オブジェクト

				// This is called during library load time, so a chart instance is not yet available.
				// この関数は、ライブラリのロード時に呼び出されるため、チャートのインスタンスはまだ利用できない
				// function(callbackArg) {
				//	return callbackArg.properties.external_library;
				// }
*/
			script: (function() {
				var scripts = [];
				if (!window.jQuery) {
					var tdgchartPath = tdgchart.getScriptPath();
						jqueryPath = tdgchartPath.substr(0, tdgchartPath.indexOf('tdg')) + 'jquery/js/jquery.js';
						
					scripts.push(jqueryPath);
				}
				
				var customScripts = [
					'lib/d3.min.js'//, 'lib/moment.js'
				];
				
				return scripts.concat(customScripts);
			}()),
			css: [
				'css/extension.css'
			]
		},
		modules: {
			dataSelection: {
				supported: true,  // Set this true if your extension wants to enable data selection
						  // 拡張機能でデータ選択を有効にしたい場合は、trueを設定
				needSVGEventPanel: false, // if you're using an HTML container or altering the SVG container, set this to true and the chart engine will insert the necessary SVG elements to capture user interactions
							  // HTMLコンテナか、SVGコンテナを変更している場合、trueに設定すると、チャートエンジンはユーザー対話をキャプチャするために必要なSVG要素を挿入する
				svgNode: function() {}  // if you're using an HTML container or altering the SVG container, return a reference to your root SVG node here.
							// HTMLコンテナを使用する場合や、SVGコンテナを変更している場合は、ここでルートSVGノードの参照を返す
			},
			eventHandler: {
				supported: true
			},
			tooltip: {
				supported: true,  // Set this true if your extension wants to enable HTML tooltips
						  // HTMLツールチップを有効にする場合はtrueを設定する
				// This callback is called when no default tooltip content is passed into the chart.
				// このコールバックは、デフォルトのツールチップがチャートに渡されていない場合に発生

				// Use this to define 'nice' default tooltips for the given target, ids & data.
				// 'nice' 定義を使用して、idやdata、指定されたターゲットへデフォルトのツールチップを渡す

				// Return value can be a string (including HTML), or HTML nodes, or any Moonbeam tooltip API object.
				// 戻り値へ、文字列（HTMLタグを含む）か、HTMLノードか、任意のMoonbeamツールチップのAPIオブジェクトを指定

				autoContent: function(target, s, g, d) {
					if (d.hasOwnProperty('color')) {
						return 'Line Value: ' + d.value + '<br />Line Color: ' + d.color;
					}
					return 'Line Value: ' + d.value;
				}
			}
			// Not used in this extension; here for documentation purposes.
			// この拡張モジュールでは使用しない
//			colorScale: {
//				supported: true,
//				minMax: function(arg){}  // Optional: return a {min, max} object to use for the color scale min & max.
//			}
//			sizeScale: {
//				supported: false,
//				minMax: function(arg){}  // Optional: return a {min, max} object to use for the size scale min & max.
//			},
//			legend: {
//				colorMode: function(arg){}, // Return either 'data' or 'series'.  If implemented, force the chart engine to use this color mode legend
//				sizeMode: function(arg){},  // return either 'size' or falsey.  If implemented, force the chart engine to use this size legend
//			}
		}
	};

	// Required: this call will register your extension with the chart engine
	tdgchart.extensionManager.register(config);

})();
