﻿(function() {

	// All extension callback functions are passed a standard 'renderConfig' argument:
	// すべての拡張機能のコールバック関数は「renderConfig」へ引数を渡します。


	// Properties that are always available:
	// 常に有効なプロパティ

	//   moonbeamInstance: the chart instance currently being rendered
	//   moonbeamInstance: 現在レンダリングしているインスタンス

	//   data: the data set being rendered
	//   data: レンダリングされるデータセット

	//   properties: the block of your extension's properties, as they've been set by the user
	//   properties: ユーザーが設定した拡張機能のプロパティをブロック

	//   modules: the 'modules' object from your extension's config, along with additional API methods
	//   modules: 拡張機能設定の「modules」オブジェクトの追加APIメソッド


	// Properties available during render callback:
	// レンダーコールバックに利用できるプロパティ

	//   width: width of the container your extension renders into, in px
	//   width: 拡張機能がレンダリングするコンテナの幅（px）


	//   height: height of the container your extension renders into, in px
	//   height: 拡張機能がレンダリングするコンテナの高さ（px）

	//   containerIDPrefix:  the ID of the DOM container your extension renders into.  Prepend this to *all* IDs your extension generates, to ensure multiple copies of your extension work on one page.
	//   containerIDPrefix:  拡張機能がレンダリングするDOMコンテナのID。  拡張機能が生成する「*all*」より前へ指定することで、複数のコピーが1ページで動作します

	//   container: DOM node for your extension to render into;
	//   container: 拡張機能をレンダリングするDOMノード

	//   rootContainer: DOM node containing the specific chart engine instance being rendered.
	//   rootContainer: レンダリングする特定のチャートエンジンのインスタンスが含まれるDOMノード


	// Optional: if defined, is called exactly *once* during chart engine initialization
	// Optional: 定義している場合は、チャートエンジンの初期化中に「*once*」が呼ばれます

	// Arguments:
	// 引数:

	//  - successCallback: a function that you must call when your extension is fully
	//  - successCallback: 拡張機能が正常に動作した場合に呼び出す関数

	//     initialized - pass in true if init is successful, false otherwise.
	//     initialized - 初期化が成功した場合は「true」、その他は「false」を渡す

	// - initConfig: the standard callback argument object (moonbeamInstance, data, properties, etc)
	// - initConfig: 標準コールバックの引数オブジェクト（moonbeamInstance, data, properties, など）

	function initCallback(successCallback, initConfig) {
		successCallback(true);
	}

	// Optional: if defined, is called once before each draw that does not include any data
	// 定義している場合は、データが含まれない描画処理の前に一度だけ呼び出される

	// Arguments:
	// 引数:

	//  - preRenderConfig: the standard callback argument object (moonbeamInstance, data, properties, etc)
	//  - preRenderConfig: 標準コールバックの引数オブジェクト (moonbeamInstance, data, properties, など)

	function noDataPreRenderCallback(preRenderConfig) {
		var chart = preRenderConfig.moonbeamInstance;
		chart.legend.visible = false;
		chart.dataArrayMap = undefined;
		chart.dataSelection.enabled = false;

		preRenderConfig.properties.percent = '80';
		preRenderConfig.properties.min = '0';
		preRenderConfig.properties.used = '256';
		preRenderConfig.properties.total = '1024';
		preRenderConfig.properties.size = '200';
		preRenderConfig.properties.prepend = '';
		preRenderConfig.properties.append = '%';
		preRenderConfig.properties.theme = 'Red-Gold-Green';
		preRenderConfig.properties.color = '#2c94e0';
		preRenderConfig.properties.back = '#ccc';
		preRenderConfig.properties.width = '3';
		preRenderConfig.properties.style = 'Full';
		preRenderConfig.properties.stripe = '0';
		preRenderConfig.properties.animationstep  = '2';
		preRenderConfig.properties.animate_gauge_colors = 'false';
		preRenderConfig.properties.animate_text_colors = 'false';
		preRenderConfig.properties.label = 'Sample';
		preRenderConfig.properties.label_color = '#888';
		preRenderConfig.properties.text = '';
		preRenderConfig.properties.text_color = '';
		preRenderConfig.properties.text_size = '0';
		preRenderConfig.properties.fill = '#fff';
		preRenderConfig.properties.showvalue = 'false';
		preRenderConfig.properties.round = '2';
		preRenderConfig.properties.flex = 'center';

	}

	// Optional: if defined, is called whenever this extension must be drawn but doesn't yet have any data.
	// Optional: 定義している場合は、拡張機能が描画する必要があるが、データを持っていない場合に呼び出す

	// Use this to define the extensions' initial 'grey state' appearance.
	// この定義を使用して、拡張機能の初期時に'grey state'の外観を表示する

	// Arguments:
	// 引数:

	//  - renderConfig: the standard callback argument object (moonbeamInstance, data, properties, etc)
	//  - renderConfig: 標準コールバックの引数オブジェクト (moonbeamInstance, data, properties, など)

	function noDataRenderCallback(renderConfig) {
		var container = renderConfig.container;

		renderConfig.data = [ { "percent": "80", "label": "サンプル" } ];
/*
		renderConfig.properties.percent = '80';
		renderConfig.properties.min = '0';
		renderConfig.properties.used = '256';
		renderConfig.properties.total = '1024';
		renderConfig.properties.size = '200';
		renderConfig.properties.prepend = '';
		renderConfig.properties.append = '%';
		renderConfig.properties.theme = 'Red-Gold-Green';
		renderConfig.properties.color = '#2c94e0';
		renderConfig.properties.back = '#ccc';
		renderConfig.properties.width = '3';
		renderConfig.properties.style = 'Full';
		renderConfig.properties.stripe = '0';
		renderConfig.properties.animationstep  = '2';
		renderConfig.properties.animate_gauge_colors = 'false';
		renderConfig.properties.animate_text_colors = 'false';
		renderConfig.properties.label = 'Sample';
		renderConfig.properties.label_color = '#888';
		renderConfig.properties.text = '';
		renderConfig.properties.text_color = '';
		renderConfig.properties.text_size = '0';
		renderConfig.properties.fill = '#fff';
		renderConfig.properties.showvalue = 'false';
		renderConfig.properties.round = '2';
		renderConfig.properties.flex = 'center';
*/
		renderConfig.dataBuckets.depth = 1;
		renderCallback(renderConfig);

		//$(container).append('<div class="placeholder">Add measures or dimensions</div>');

	}

	// Optional: if defined, is invoked once at the very beginning of each chart engine draw cycle
	// Optional: 定義している場合は、各チャートの描画サイクルの最初の一度だけ呼び出す

	// Use this to configure a specific chart engine instance before rendering.
	// この定義を使用して、レンダリング前に特定のチャートエンジンのインスタンスを設定する

	// Arguments:
	// 引数:

	//  - preRenderConfig: the standard callback argument object
	//  - preRenderConfig: 標準コールバックの引数オブジェクト

	function preRenderCallback(preRenderConfig) {
		var chart = preRenderConfig.moonbeamInstance;

		// Example of manually loading a file in this extension's folder path and using it.
		// 拡張機能のフォルダパスにあるファイルを手動で読み込んで使用する例

		var info = tdgchart.util.ajax(preRenderConfig.loadPath + 'lib/extra_properties.json', {asJSON: true});

		/* Logic before CHART-1935 NFR
		// CHART-1935のNFR以前のロジック

			// Example of using the chart engine's built in title properties
			// チャートエンジンに組み込まれたタイトルプロパティの使用例
			chart.title.visible = true;
			chart.title.text = info.custom_title;
			chart.footnote.visible = true;
			chart.footnote.text = 'footnote';
			chart.footnote.align = 'right';
		*/
		
		//Start CHART-1935 NFR
		//CHART-1935のNFRを開始

			if (!chart.title.visible){    //Developer has not set HEADING in GRAPH request; so use custom title found in: preRenderConfig.loadPath + 'lib/extra_properties.json'
						      //開発者がグラフリクエストでHEADINGを指定しないため、'lib/extra_properties.json'でカスタムタイトルを指定する
				// Example of using the chart engine's built in title properties
				// チャートエンジンのタイトルプロパティへの組み込み例

				chart.title.visible = false;
				chart.title.text = info.custom_title;	
			} // if (!chart.title.visible) //Developer has not set FOOTING in GRAPH request; so use 'footnote' text to illustrate how custom programmatic footing can be assinged to chart
						       //開発者がグラフリクエストでFOOTINGを指定しないため、'footnote'を使用して説明する
			
			if (!chart.footnote.visible) {
			chart.footnote.visible = false;
			chart.footnote.text = '';
			chart.footnote.align = 'right';			
				
			} //if (!chart.footnote.visible)
		
		
		//End CHART-1935 NFR
		//CHART-1935のNFRを終了
		
	}

	// Required: Invoked during each chart engine draw cycle
	// 必須： チャートエンジンの描画サイクル毎に呼び出される

	// This is where your extension should be rendered
	// ここは拡張機能がレンダリングする箇所

	// Arguments:
	// 引数:

	//  - renderConfig: the standard callback argument object, including additional properties width, height, etc
	//  - renderConfig: 標準コールバックの引数オブジェクト (including additional properties width, height, など)

	function renderCallback(renderConfig) {

		i = renderConfig.rootContainer.id;
		if($('#GaugeMeter_' + i).length > 0) $('#wrap').remove();

	        var container = $('#' + renderConfig.rootContainer.id + ' .chartHolder_relative_container');
	        container.css('display', 'block').css('height',renderConfig.height+'px');

		var chart = renderConfig.moonbeamInstance;
		var data = renderConfig.data;

		$(container).html('');

		var percent = data[0].percent;
		var min = data[0].min;
		var used = data[0].used;
		var total = data[0].total;
		var label = data[0].label;
		var text = data[0].text;
		var size = renderConfig.properties.size;
		var prepend = renderConfig.properties.prepend;
		var append = renderConfig.properties.append;
		var theme = renderConfig.properties.theme;
		var color = renderConfig.properties.color;
		var back = renderConfig.properties.back;
		var width = renderConfig.properties.width;
		var style = renderConfig.properties.style;
		var stripe = renderConfig.properties.stripe;
		var animationstep = renderConfig.properties.animationstep;
		var animate_gauge_colors = renderConfig.properties.animate_gauge_colors;
		var animate_text_colors = renderConfig.properties.animate_text_colors;
		var label_color = renderConfig.properties.label_color;
		var label_size = renderConfig.properties.label_size;
		var text_size = renderConfig.properties.text_size;
		var fill = renderConfig.properties.fill;
		var showvalue = renderConfig.properties.showvalue;
		var round = renderConfig.properties.round;
		var flex = renderConfig.properties.flex;
		var bgcolor = renderConfig.properties.bgcolor;

		var div = '<div class="GaugeMeter" id="GaugeMeter_' + i + '"';

		if(used !== undefined && total === undefined) {
			total = parseInt(Number(used) * 1.1);
			text = used;
			if(append == '%') append = '';
		}
		if(size == 0) {
			var outerwidth = $(container).outerWidth();
			var outerheight = $(container).outerHeight();
			size = outerwidth;
			if(outerwidth >= outerheight) size = outerheight;
		}
		if(size_o == 0) {
			size_o = size;
		} else {
			size = size_o;
		}
		if(bgcolor == '') bgcolor = '#fff';

		if(text_size == 0) text_size = Math.sqrt(size) / 100;
		if(label_size == 0) label_size = (text_size * 10) + 'em';

		if(percent !== undefined) div = div + ' ' + 'data-percent="' + percent + '"';
		if(min !== undefined) div = div + ' ' + 'data-min="' + min + '"';
		if(used !== undefined) div = div + ' ' + 'data-used="' + used + '"';
		if(total !== undefined) div = div + ' ' + 'data-total="' + total + '"';
		if(size != 0) div = div + ' ' + 'data-size="' + size + '"';
		if(prepend !== '') div = div + ' ' + 'data-prepend="' + prepend + '"';
		if(append !== '') div = div + ' ' + 'data-append="' + append + '"';
		if(theme !== '') div = div + ' ' + 'data-theme="' + theme + '"';
		if(color !== '') div = div + ' ' + 'data-color="' + color + '"';
		if(back !== '') div = div + ' ' + 'data-back="' + back + '"';
		if(width !== '') div = div + ' ' + 'data-width="' + width + '"';
		if(style !== '') div = div + ' ' + 'data-style="' + style + '"';
		if(stripe !== '') div = div + ' ' + 'data-stripe="' + stripe + '"';
		if(animationstep !== '') div = div + ' ' + 'data-animationstep="' + animationstep + '"';
		if(animate_gauge_colors !== '') div = div + ' ' + 'data-animate_gauge_colors="' + animate_gauge_colors + '"';
		if(animate_text_colors !== '') div = div + ' ' + 'data-animate_text_colors="' + animate_text_colors + '"';
		if(label !== undefined) div = div + ' ' + 'data-label="' + label + '"';
		if(label_color !== '') div = div + ' ' + 'data-label_color="' + label_color + '"';
		if(text !== undefined) div = div + ' ' + 'data-text="' + text + '"';
		if(text_size != 0) div = div + ' ' + 'data-text_size="' + text_size + '"';
		if(fill !== '') div = div + ' ' + 'data-fill="' + fill + '"';
		if(showvalue !== '') div = div + ' ' + 'data-showvalue="' + showvalue + '"';
		div = div + '></div>';

		$(container).append(div);
		$(container).width(size);
		$(container).height(size);

		$('#GaugeMeter_' + i).gaugeMeter();

		$('#GaugeMeter_' + i + ' b').css({'font-size': label_size});

		if(label_color !== '') $('#GaugeMeter_' + i + ' span').css({'color': label_color});

		var o = $('#GaugeMeter_' + i + ' span').html();

		var s = o;
		var n = s.indexOf('</s>');
		if(n > 0) s = s.slice(n + 4);
		var n = s.indexOf('<u>');
		if(n > 0) s = s.slice(0, n);
		s = Number(s);

		if(round !== '') r = s.toFixed(round);
		$('#GaugeMeter_' + i + ' span').html(o.replace(s, r));

		var len = $('#GaugeMeter_' + i + ' span').text();
		var ls = Number(size) / (len.length - 1);
		if(len.length > 4) $('#GaugeMeter_' + i + ' span').css({'font-size': ls});

		var lenb = $('#GaugeMeter_' + i + ' b').text();
		var lsb = Number(size) / (lenb.length * 1.6);
		if(lenb.length > 4) $('#GaugeMeter_' + i + ' b').css({'font-size': lsb});

		$(container).parent().parent().css({'display': 'flex', 'flex-wrap': 'wrap', 'margin': '0 auto', 'justify-content': flex, 'text-align': 'center', 'background': bgcolor});
		renderConfig.renderComplete();
	}

	// Your extension's configuration
	// 拡張機能の設定
	var config = {
		id: 'jp.co.ashisuto.gaugemeter',     // string that uniquely identifies this extension
						     // 拡張機能を一意に識別する文字列
		containerType: 'html',  // either 'html' or 'svg' (default)
				        // 'html' か 'svg' のいずれか (default)
		initCallback: initCallback,
		preRenderCallback: preRenderCallback,  // reference to a function that is called right *before* your extension is rendered.  Will be passed one 'preRenderConfig' object, defined below.  Use this to configure a Monbeam instance as needed
						       // 拡張機能がレンダリングする直前に呼び出す関数への参照。'preRenderConfig' として定義されているオブジェクトが渡される。必要に応じて、Monbeamインスタンスを使用する。
		renderCallback: renderCallback,  // reference to a function that will draw the actual chart.  Will be passed one 'renderConfig' object, defined below
						 // 実際のチャートを描画する関数への参照。'renderConfig' として定義されているオブジェクトが渡される。
		noDataPreRenderCallback: noDataPreRenderCallback,
		noDataRenderCallback: noDataRenderCallback,
		resources: {  // Additional external resources (CSS & JS) required by this extension
			      // 拡張機能で必要な追加外部リソース（CSS と JS）
				// Example of using a function callback to dynamically define an external library to be loaded
				// ロードされる外部ライブラリを動的に定義するためのコールバック関数の定義例

				// callbackArg is the standard callback argument object which contains 'properties'.
				// callbackArg は、'properties' を含む標準のコールバック用引数オブジェクト

				// This is called during library load time, so a chart instance is not yet available.
				// この関数は、ライブラリのロード時に呼び出されるため、チャートのインスタンスはまだ利用できない
			script: (function() {
				var scripts = [];
				if (!window.jQuery) {
					var tdgchartPath = tdgchart.getScriptPath();
						jqueryPath = tdgchartPath.substr(0, tdgchartPath.indexOf('tdg')) + 'jquery/js/jquery.js';
						
					scripts.push(jqueryPath);
				}
				
				var customScripts = [
					'lib/GaugeMeter.js'
				];
				
				return scripts.concat(customScripts);
			}()),
			css: [
				'css/extension.css'
			]
		},
		modules: {
			eventHandler: {
				supported: true
			},
			tooltip: {
				supported: true,  // Set this true if your extension wants to enable HTML tooltips
						  // HTMLツールチップを有効にする場合はtrueを設定する
				// This callback is called when no default tooltip content is passed into the chart.
				// このコールバックは、デフォルトのツールチップがチャートに渡されていない場合に発生

				// Use this to define 'nice' default tooltips for the given target, ids & data.
				// 'nice' 定義を使用して、idやdata、指定されたターゲットへデフォルトのツールチップを渡す

				// Return value can be a string (including HTML), or HTML nodes, or any Moonbeam tooltip API object.
				// 戻り値へ、文字列（HTMLタグを含む）か、HTMLノードか、任意のMoonbeamツールチップのAPIオブジェクトを指定

				autoContent: function(target, s, g, d) {
					if (d.hasOwnProperty('color')) {
						return 'Line Value: ' + d.value + '<br />Line Color: ' + d.color;
					}
					return 'Line Value: ' + d.value;
				}
			}
			// Not used in this extension; here for documentation purposes.
			// この拡張モジュールでは使用しない
//			colorScale: {
//				supported: true,
//				minMax: function(arg){}  // Optional: return a {min, max} object to use for the color scale min & max.
//			}
//			sizeScale: {
//				supported: false,
//				minMax: function(arg){}  // Optional: return a {min, max} object to use for the size scale min & max.
//			},
//			legend: {
//				colorMode: function(arg){}, // Return either 'data' or 'series'.  If implemented, force the chart engine to use this color mode legend
//				sizeMode: function(arg){},  // return either 'size' or falsey.  If implemented, force the chart engine to use this size legend
//			}
		}
	};

	var size_o = 0;
	// Required: this call will register your extension with the chart engine
	tdgchart.extensionManager.register(config);

})();
