#!/bin/sh
EDA=/home/webfocus/ibi/srv82/wfs/bin/edastart
SHOWAGENTS=`${EDA} -showagents | \
awk 'BEGIN {
  FIELDWIDTHS="2 1 2 1 4 1 12 4 200"
  flg1 = 0; flg2 = 0; flg3 = 0; header == "";
} {
  datetime = $5 "/" $1 "/" $3 " " $7
  split($NF, col, ":");
  if(col[1] == "Tscomid" && flg1 == 0 && flg2 == 0) {
    flg1 = 1;
    header = "\"DateTime\",\"" col[1] "\"";
    body = "";
  } else if(col[1] == "Tscomid" && flg1 == 1 && flg2 == 0) {
    flg2 = 1;
    body = body "\n";
    body = body "\"" datetime "\""
  } else if(col[1] == "Tscomid" && flg1 == 1 && flg2 == 1) {
    flg3 = 0;
    body = body "\n";
  } else if(flg1 == 1 && flg2 == 0) {
    if(col[1] != "") header = header ",\"" col[1] "\"";
  }
  for (i in col) {
    if(i == 2) {
      value = substr(col[2], 2);
    } else {
      value = value ":" col[i];
    }
  }
  if(flg1 == 1) {
    if(value != "" && value != ":") {
      if(flg3 == 0) {
        body = body "\"" datetime "\""
        flg3 = 1;
      }
      if(value != "---" && value != "--") {
        body = body ",\"" value "\"";
      } else {
        body = body ",\"" "\"";
      }
    }
  }
  value = "";
} END {
  print header;
  print body;
}'`

### コマンド実行結果の整形後に期待する動作を追加 ###

# 結果をテンポラリファイルへ出力
TMP=/tmp/eda_showagents.${$}
echo -e "${SHOWAGENTS}" | head -1>${TMP} # ヘッダ書き込み
echo -e "${SHOWAGENTS}" | tail -n +1>>${TMP} # ボディ追記
echo -e "${SHOWAGENTS}">${TMP} # すべて書き込み

# 条件に一致するエージェント情報をシスログへ書き込み
DBMSIO=1000000
echo -e "${SHOWAGENTS}" | tail -n +1 | \
awk 'BEGIN { FS = ","; }
  function getindex(name) {
    headindex = "";
    for(i in headname) {
      headval = substr(headname[i], 2, length(headname[i]) - 2);
      if(headval == name) headindex = i;
    }
    return headindex;
  }
  function getvalue(name) {
    nameval = ""
    indexval = getindex(name);
    if(indexval != "") nameval = substr($indexval, 2, length($indexval) - 2);
    return nameval;
  }
  {
  if(NR == 1) {
    for(i = 1; i <= NF; i++) {
      headname[i] = $i;
    }
  } else {
    tscomid = getvalue("Tscomid");
    service = getvalue("Service");
    state = getvalue("State");
    dbmsio = getvalue("DBMS I/O");
    processid = getvalue("Process ID");
    if(service == "DEFAULT" && state == "idle" && int(dbmsio) >= int('${DBMSIO}')) {
      msg = "Tscomid: " tscomid " / " "Service: " service " / " "State: " state " / ";
      msg = msg "DBMS I/O: " dbmsio " / " "Process ID: " processid;
      logger = "logger -t eda_showagents " msg
      system(logger);

      ## 条件に一致するエージェントを終了するコマンドを発行
      cmd = "'${EDA}' -kill " tscomid " >'/tmp/eda_kill.${$}'";
      system(cmd);
    }
  }
}'

