/***********************************************************************************/
/* グローバル変数の宣言                                                            */
/***********************************************************************************/
const logo = '/ibi_apps/rs/ibfs/WFC/Repository/Designer_JS_Sample/originalMyPagePortal/wf_djs_portal_logo.gif'; // ロゴ用画像のパス
const icon = '/ibi_apps/rs/ibfs/WFC/Repository/Designer_JS_Sample/originalMyPagePortal/wf_djs_portal_icon.png'; // アイコン用画像のパス
const backGroundColor = '#4b0082';         // 背景色(タイトル、コンテナのタイトルバー)
const fontColor = '#ffffff';               // フォント色(タイトル、コンテナのタイトルバー)
const pageTitle = 'オリジナルマイページ';  // ページのタイトル
const max = 20;                            // 配置可能なコンテンツ数の上限
var page = null;                           // ページオブジェクト格納用変数
var flg = 0;                               // コンテナ位置制御用フラグ

/***********************************************************************************/
/* 処理の記述                                                                      */
/***********************************************************************************/

// ショートカットキー(「F5」、「Ctrl」+「R」)での更新防止処理
document.onkeydown = function() {
    
    if((event.keyCode === 116) || (event.ctrlKey && (event.keyCode === 82))){
        // 更新処理の回避
        event.keyCode = null;
        event.ctrlKey = null;
        return false;
    }
    
};


// ページロード時のイベントを設定
window.addEventListener('iba_pageloading', function (e){
    
    // ポータル画面上の設定を実施
    portalEdit();
    
});


// ページロード直後のイベントを設定
window.addEventListener('iba_pageloaded', function (e){
    
    // 画面の再読み込み等で「iba_pageloaded」が呼ばれる度にボタンが追加されることを回避する為、
    // 既に追加したクラスの要素が存在する（要素数が 0 ではない）場合は何もせず処理を抜ける
    // ※ここでは代表として「exButton1」クラスで判定。
    if( document.querySelectorAll('.exButton1').length != 0 ){
        return;
    }
    
    // クラス名を使用して、ページオブジェクトを取得
    page = document.querySelector('.samplepage').ibaObject;
    page.title(pageTitle);
    
    // タイトルバーの文字色、背景色を設定
    var titleBar = document.querySelector('[data-ibx-name="_title"]');
    titleBar.style.color = fontColor;
    titleBar.style.backgroundColor = backGroundColor;

    // アイコン用のimg要素を定義（画像パス、横サイズ（px）、縦サイズ（px））
    let imgElem = document.createElement('img');
    imgElem.src = icon;
    imgElem.width = 50;
    imgElem.height = 50;
    imgElem.title = '[説明]' + '\n' +'右側のボタンでコンテンツの操作が可能です。';
    
    // タイトルバーにimg要素を挿入
    titleBar.after(imgElem);

    // ページ上部に[+]ボタンを追加
    var addBtn = page.addButton({"tooltip": "コンテンツを追加", "glyphClasses": "fa fa-plus", "class": "exButton1"}, ".pd-header-button-refresh", true);
    addBtn.addEventListener("click", addContent);
    
    // ページ上部に[ゴミ箱]ボタンを追加
    var allDelBtn = page.addButton({"tooltip": "コンテンツを全て削除", "glyphClasses": "fa fa-trash-alt", "class": "exButton2"}, ".pd-header-button-refresh", true);
    allDelBtn.addEventListener("click", deleteAllContent);
    
    // ページ上部に[停止]ボタンを追加
    var stopBtn = page.addButton({"tooltip": "リクエストを停止", "glyphClasses": "fa fa-ban", "class": "exButton3"}, ".pd-header-button-refresh", true);
    stopBtn.addEventListener('click', stopRequest);
    
    // ページ上部の[リフレッシュ]ボタンにイベント、説明文を設定
    var refBtn = document.querySelector('.pd-header-button-refresh');
    refBtn.addEventListener('click', disableRefresh);
    refBtn.title = 'リフレッシュ' + '\n' + '(5秒間隔で実行可能)';
    
    // ページ上部の[フィルターの表示]ボタンを削除
    page.removeButton('.pd-header-button-filter');
    
    // ページ上部のボタンの押下/離脱時のイベントを設定    
    document.querySelectorAll('.pd-header-button').forEach(e => e.addEventListener('mousedown', pushButton));
    document.querySelectorAll('.pd-header-button').forEach(e => e.addEventListener('mouseup', upButton));
    
});

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ページ上部の[リフレッシュ]ボタンを5秒間非活性化する
//////////////////////////////////////////////////////////////////////////
function disableRefresh(e){

    // イベントが発生した要素(ボタン)のIDを取得
    var elm = document.querySelector(`#${e.currentTarget.id}`);

    // 見た目上も透過度を上げ、ボタンの機能を非活性化
    elm.style.opacity = 0.1;
    elm.style.pointerEvents = 'none';
    
    // 5秒後に活性化処理を呼び出す
    setTimeout(enableRefresh, 5000, elm);
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ページ上部の[リフレッシュ]ボタンを活性化にする
//////////////////////////////////////////////////////////////////////////
function enableRefresh(elm){
    
    // イベントが発生した要素(ボタン)のIDを取得
    elm.style.opacity = 1;
    elm.style.pointerEvents = 'auto';
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ページ上にコンテンツを追加する
//////////////////////////////////////////////////////////////////////////
function addContent(e){

    // ページセクション(配列の1番目)を取得
    var section = page.sections()[0].ibaObject;

    // セクションを開閉可能に設定
    section.collapsible(true);
    
    // 存在するコンテナの要素を取得
    var elms = document.querySelectorAll('.pd-container');
    
    // 配置可能なコンテンツ数をチェック(上限に達している場合はここで処理終了)
    if(maxCheck(elms.length) == true){
        alert(`このページ上に配置可能なコンテンツ数は ${max} 個です。`);
        return;
    }
    
    // セクションに新しいコンテナを追加(コンテンツ数、フラグにより表示位置が交互になるように制御)
    // ※addContainerの第3引数は「挿入位置(列)、挿入位置(行)、幅(列数)、高さ(行数)を」指定。
    if(elms.length == 0 || flg == 0){
        var tabPanel = section.addContainer('tab', null, 2, 0, 4, 6).ibaObject;
        
        // フラグをセット
        flg = 1;
    }else{
        var tabPanel = section.addContainer('tab', null, 6, 0, 4, 6).ibaObject;
        
        // フラグをセット
        flg = 0;
    }
    
    // 生成したコンテナのオプションメニューボタンを削除
    tabPanel.removeButton('.pd-container-title-button-menu');
    
    // 生成したコンテナのクラスIDを取得
    var tabPaneClass = tabPanel.classId();

    // 生成したコンテナのstyle属性を削除(要素の特定にクラスID(変数)、タイトル(固定値)を使用)
    document.querySelectorAll(`.${tabPaneClass} [title='コンテンツの追加']`).forEach(e => e.removeAttribute('style'));

    // 生成したコンテナ内に[-]ボタンを追加
    var delBtn = tabPanel.addButton({"tooltip": "削除", "glyphClasses": "fa fa-minus", "class": "delete-button"}, ".pd-container-title-button-resize", true);
    delBtn.addEventListener("click", deleteTabContent);
    
    // 生成したコンテナのタブ名を空白に設定
    document.querySelector(`.${tabPaneClass} .ibx-tab-button .ibx-label-text`).textContent = null;

    // 生成したコンテナのタイトルバーの背景色を設定
    var titleBar = document.querySelector(`.${tabPaneClass} .fbx-child-sizing-content-box`);
    titleBar.style.backgroundColor = backGroundColor;

    // 生成したコンテナのタイトルバーのフォント色を設定    
    document.querySelectorAll(`.${tabPaneClass} .pd-container-title-button .ibx-label-glyph`).forEach(e => e.style.color = fontColor);

    // コンテンツ数をタイトルに反映
    titleValueChange();
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ページ上のコンテンツを削除する
//////////////////////////////////////////////////////////////////////////
function deleteTabContent(e){    
    
    // イベントが発生した要素(ボタン)のIDを取得
    var id = e.currentTarget.id;
    
    // 上記IDを元に親要素を遡り、大元のコンテナのクラスを取得し、サイズ変更ボタンの状態(title)を取得
    var parent = document.querySelector(`#${id}`).parentNode.parentNode;
    var parentClass = parent.ibaObject.classId();
    var title = document.querySelector(`.${parentClass} .pd-container-title-button-resize`).title;
    
    // サイズ変更ボタンの状態(title)を判定し、最大化済みの場合は削除不可
    if(title != '最大化'){
        alert('コンテナを最大化した状態では削除できません。');
        return;
    }

    // 大元のコンテナを削除
    parent.remove();

    // コンテンツ数をタイトルに反映
    titleValueChange();
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ページ上のコンテンツを全て削除する
//////////////////////////////////////////////////////////////////////////
function deleteAllContent(e){
    
    // コンテンツの要素を全て取得
    var elms = document.querySelectorAll('.pd-container');

    // コンテンツが存在していれば、全て削除(実行確認あり)
    if (elms.length > 0) {
        if (confirm('現在表示されているコンテンツを全て削除しますか？')){
            for (let i = 0; i < elms.length; i++){
                var target = elms[i].parentNode.parentNode.remove();
            }
        }
    }else{
        alert('削除対象がありません。');
    }
    
    // コンテンツ数をタイトルに反映
    titleValueChange();
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// 配置済みコンテンツ上で実行中のリクエストに対し、停止を行う
//////////////////////////////////////////////////////////////////////////
function stopRequest(){
    
    // 停止リクエストの実行を行いXMLレスポンスを取得
    var contentType = 'application/x-www-form-urlencoded; charset=utf-8';
    var webMethod   = '/ibi_apps/stopreq.bip';
    var parameters  = encodeURIComponent('BIP_REQUEST_TYPE') 
                      + '=' 
                      + encodeURIComponent('BIP_STOP_REQUEST');
    $.ajax({
        type: 'get',
        url: webMethod,
        data: parameters,
        dataType: 'xml',
        xhrFields: {
            withCredentials: true
        },
        crossDomain: true,
        contentType: contentType,
    })

    .done(function(data) {
        // 停止リクエストのレスポンスからメッセージを取得し、アラートを出力
        $(data).find('status').each(function() {
            var returndesc = $(this).attr('message');
            alert(returndesc);
        });
    })

    .fail(function(XMLHttpRequest, textStatus, errorThrown){
        // エラーの場合にもアラートを出力
        console(errorThrown);
    });
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// 配置済みコンテンツ数をチェックし、数に応じてタイトルの表示を変更する
//////////////////////////////////////////////////////////////////////////
function titleValueChange(){

    // 存在するコンテナの要素を取得
    var elmsLen = document.querySelectorAll('.pd-container').length;
    
    // [+]ボタンの要素を取得
    var btn = document.querySelector('.exButton1');
    
    // レイアウト用の空白
    var space = '  　　　　　　　　　　　　';
    
    // 配置済みコンテンツ数に応じてタイトル、[+]ボタンの表示を変更(コンテンツの上限の場合は[+]ボタンを赤に変更)
    if(elmsLen == 0){
        page.title(`${pageTitle}`);
        btn.style.backgroundColor = '#ffffff';
    }else if (elmsLen < max){
        page.title(`${pageTitle} ${space} < 配置済みコンテンツ数：${elmsLen} >`);
        btn.style.backgroundColor = '#ffffff';
    }else{
        page.title(`${pageTitle} ${space} < 配置済みコンテンツ数：${elmsLen} >`);
        btn.style.backgroundColor = '#ff0000';
    }
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// 配置済みコンテンツ数(引数)をチェックし、数に応じて真偽値を返却する
//////////////////////////////////////////////////////////////////////////
function maxCheck(elmsLen){
    
    // 存在するコンテナの要素数が上限に達しているかどうかをチェック
    if(elmsLen >= max){

        return true;
    }
    return false;
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ボタンが押下された場合に色を変更する
//////////////////////////////////////////////////////////////////////////
function pushButton(e){
    
    // イベントが発生した要素(ボタン)の色をグレーに変更
    e.currentTarget.style.color = '#dcdcdc';
    
}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ボタンの押下が離れた場合に色を変更する
//////////////////////////////////////////////////////////////////////////
function upButton(e){
    
    // イベントが発生した要素(ボタン)の色を黒に変更
    e.currentTarget.style.color = '#333333';

}

//////////////////////////////////////////////////////////////////////////
// ＜関数の概要＞
// ポータル画面上の修飾関連の操作を行う
//////////////////////////////////////////////////////////////////////////
function portalEdit(){

    // ポータル画面上のバナータイトルを設定（テキスト内容、リンク、色、a要素の書き換え）
    var url = ' https://www.ashisuto.co.jp/webfocus/ '; // WebFOCUSの紹介サイト
    var target = document.querySelector('.pvd-portal-title .ibx-label-text');
    target.textContent = '...about';
    target.style.color = '#69e';
    target.outerHTML ='<a href=' + url + ' target="_blank" title="WebFOCUSについて">' +  target.outerHTML  + '</a>';
    
    // ロゴ用のimg要素を定義（画像パス、横サイズ（px）、縦サイズ（px））
    let imgElem = document.createElement('img');
    imgElem.src = logo;
    imgElem.width = 264;
    imgElem.height = 58;
    
    // 指定した要素にimg要素を挿入
    let parent = document.querySelector('.pvd-banner-logo');
    parent.before(imgElem);
    
    // 不要な要素（元のロゴ）を削除
    parent.remove();
    
}
